/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.eCircuitSize;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.Optics.xFeatureUnsupported;
import cerent.cms.idl.ServerTrail.StsTrailCTP;
import cerent.cms.idl.ServerTrail.Trail;
import cerent.cms.idl.ServerTrail.TrailCTP;
import cerent.cms.idl.ServerTrail.VtTrailCTP;
import cerent.cms.idl.ServerTrail.eServerTrailProtection;
import cerent.cms.idl.ServerTrail.sServerTrailId;
import cerent.cms.idl.SonetMedia.sStsPathDef;
import cerent.cms.idl.SonetTopology.sVtDef;
import cerent.cms.idl.SonetTopology.xInvalidPath;
import cerent.cms.idl.SonetTopology.xPathInUse;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsCommFailException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.HoPathDefModelFactory;
import cerent.cms.model.HoServerTrailEnd;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IHoServerTrailEnd;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.ILoServerTrailEnd;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IServerTrailEnd;
import cerent.cms.model.IServerTrailLinkId;
import cerent.cms.model.IServerTrailsManager;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.LoDefModelFactory;
import cerent.cms.model.LoServerTrailEnd;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PathInUse;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ServerTrailEnd;
import cerent.cms.model.ServerTrailLinkId;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.UserException;

public class ServerTrailsManager
extends Model
implements IServerTrailsManager,
Observer {
    private StsServerTrailCreator stsServerTrailCreator;
    private VtServerTrailCreator vtServerTrailCreator;
    private StsServerTrailRetriever stsServerTrailRetriever;
    private VtServerTrailRetriever vtServerTrailRetriever;
    private ServerTrailEditor serverTrailEditor;
    private ArrayList stsTrailCache = new ArrayList();
    private ArrayList vtTrailCache = new ArrayList();
    private Object masterTrailLock;
    private NodeModelDelegate nmd;
    private EventDispatcher dispatcher;
    protected ObservableManager stsTrailObservableManager;
    protected ObservableManager vtTrailObservableManager;
    private static NodeSingletonFactory<ServerTrailsManager> sfactory = new NodeSingletonFactory<ServerTrailsManager>(ServerTrailsManager.class);

    public static ServerTrailsManager getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private ServerTrailsManager(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(ServerTrailsManager.class));
        this.nmd = nodeModelDelegate;
        this.stsServerTrailCreator = new StsServerTrailCreator("StsServerTrailCreator", nodeModelDelegate);
        this.vtServerTrailCreator = new VtServerTrailCreator("VtServerTrailCreator", nodeModelDelegate);
        this.stsServerTrailRetriever = new StsServerTrailRetriever("StsServerTrailRetriever", nodeModelDelegate);
        this.vtServerTrailRetriever = new VtServerTrailRetriever("VtServerTrailRetriever", nodeModelDelegate);
        this.serverTrailEditor = new ServerTrailEditor("ServerTrailEditor", nodeModelDelegate);
        this.stsTrailObservableManager = new ObservableManager(this, false);
        this.vtTrailObservableManager = new ObservableManager(this, false);
        this.masterTrailLock = new Object();
    }

    public void init() {
        super.init0();
        this.db.fine("init()");
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectStsTrailCTPList, 0, (Observer)this);
            this.dispatcher.addObserver(ObjectType.ObjectVtTrailCTPList, 0, (Observer)this);
        }
        this.stsTrailObservableManager.setPassing(true);
        this.vtTrailObservableManager.setPassing(true);
    }

    public void dispose() {
        this.db.fine("dispose(): entry");
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectStsTrailCTPList, 0, (Observer)this);
            this.dispatcher.deleteObserver(ObjectType.ObjectVtTrailCTPList, 0, (Observer)this);
        }
        this.stsTrailObservableManager.setPassing(false);
        this.vtTrailObservableManager.setPassing(false);
        this.stsServerTrailRetriever.dispose();
        this.vtServerTrailRetriever.dispose();
        this.clearHoCache();
        this.clearLoCache();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Observable observable, Object object) {
        this.db.fine("update from " + observable + " regarding " + object);
        if (observable instanceof IHoServerTrailEnd) {
            if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.DELETED)) {
                IHoServerTrailEnd iHoServerTrailEnd = (IHoServerTrailEnd)observable;
                Object object2 = this.masterTrailLock;
                synchronized (object2) {
                    this.cacheDelete(this.stsTrailCache, iHoServerTrailEnd.getServerTrailLinkId().getUniqueId());
                }
                this.stsServerTrailRetriever.update();
                this.setChanged();
                this.notifyObservers(ModelUpdateType.CHANGED);
            }
        } else if (observable instanceof ILoServerTrailEnd) {
            if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.DELETED)) {
                ILoServerTrailEnd iLoServerTrailEnd = (ILoServerTrailEnd)observable;
                Object object3 = this.masterTrailLock;
                synchronized (object3) {
                    this.cacheDelete(this.vtTrailCache, iLoServerTrailEnd.getServerTrailLinkId().getUniqueId());
                }
                this.vtServerTrailRetriever.update();
                this.setChanged();
                this.notifyObservers(ModelUpdateType.CHANGED);
            }
        } else if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            int n2 = ((IObjectMessageInfo)object).getObjectType();
            switch (n) {
                case 2: {
                    this.db.fine("\tObjectAdded");
                    if (n2 == ObjectType.ObjectStsTrailCTPList.value()) {
                        this.stsServerTrailRetriever.update();
                    } else if (n2 == ObjectType.ObjectVtTrailCTPList.value()) {
                        this.vtServerTrailRetriever.update();
                    }
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.ADDED);
                    break;
                }
                case 1: {
                    this.db.fine("\tObjectChanged");
                    if (n2 == ObjectType.ObjectStsTrailCTPList.value()) {
                        this.stsServerTrailRetriever.update();
                    } else if (n2 == ObjectType.ObjectVtTrailCTPList.value()) {
                        this.vtServerTrailRetriever.update();
                    }
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServerTrailEnd[] getServerTrails() {
        IServerTrailEnd[] iServerTrailEndArray = null;
        Object object = this.masterTrailLock;
        synchronized (object) {
            if (!this.isInited()) {
                this.db.fine("getServerTrails invoked on uninitialized model for " + this.nmd.getName());
                return null;
            }
            this.updateCache();
            iServerTrailEndArray = this.getCombinedCache().toArray(new IServerTrailEnd[0]);
        }
        return iServerTrailEndArray;
    }

    public void deleteServerTrail(IServerTrailLinkId iServerTrailLinkId) {
        this.updateCache();
        ServerTrailEnd serverTrailEnd = this.getTrailById(iServerTrailLinkId);
        if (serverTrailEnd != null) {
            serverTrailEnd.delete();
        }
    }

    public IServerTrailLinkId createHoServerTrail(IHoPathDefModel iHoPathDefModel, IHoPathDefModel iHoPathDefModel2, String string, IServerTrailLinkId iServerTrailLinkId, String string2, int n, int n2, int n3) throws PathInUse, InvalidPath, ProvisionError {
        sStsPathDef sStsPathDef2 = HoPathDefModelFactory.getStsPathDef(iHoPathDefModel);
        sStsPathDef sStsPathDef3 = HoPathDefModelFactory.getStsPathDef(iHoPathDefModel2);
        String string3 = string;
        sServerTrailId sServerTrailId2 = new sServerTrailId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId());
        String string4 = string2;
        eServerTrailProtection eServerTrailProtection2 = eServerTrailProtection.from_int(n);
        eCircuitSize eCircuitSize2 = eCircuitSize.from_int(n2);
        Integer n4 = new Integer(n3);
        try {
            StsTrailCTP stsTrailCTP = (StsTrailCTP)this.stsServerTrailCreator.get(new Object[]{sStsPathDef2, sStsPathDef3, string3, sServerTrailId2, string4, eServerTrailProtection2, eCircuitSize2, n4});
            sServerTrailId sServerTrailId3 = stsTrailCTP.getTrailCTPData().trailId;
            ServerTrailLinkId serverTrailLinkId = new ServerTrailLinkId(sServerTrailId3.nodeId, sServerTrailId3.uniqueId);
            return serverTrailLinkId;
        }
        catch (xPathInUse xPathInUse2) {
            throw new PathInUse((UserException)xPathInUse2);
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.nmd.getPlatform());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            throw new ProvisionError("An error occurred while creating the server trail.");
        }
    }

    public boolean changePeerIpAddress(String string, String string2, IServerTrailLinkId iServerTrailLinkId) throws ProvisionError {
        String string3 = string;
        String string4 = string2;
        sServerTrailId sServerTrailId2 = new sServerTrailId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId());
        try {
            Boolean bl = (Boolean)this.serverTrailEditor.get(new Object[]{string3, string4, sServerTrailId2});
            return bl;
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.nmd.getPlatform());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            throw new ProvisionError("An error occurred while changing the peer ip address of the server trail.");
        }
    }

    public IServerTrailLinkId createLoServerTrail(ILoDefModel iLoDefModel, ILoDefModel iLoDefModel2, String string, IServerTrailLinkId iServerTrailLinkId, String string2, int n, int n2, int n3) throws PathInUse, InvalidPath, ProvisionError {
        sVtDef sVtDef2 = LoDefModelFactory.getVtDef(iLoDefModel);
        sVtDef sVtDef3 = LoDefModelFactory.getVtDef(iLoDefModel2);
        String string3 = string;
        sServerTrailId sServerTrailId2 = new sServerTrailId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId());
        String string4 = string2;
        eServerTrailProtection eServerTrailProtection2 = eServerTrailProtection.from_int(n);
        eCircuitSize eCircuitSize2 = eCircuitSize.from_int(n2);
        Integer n4 = new Integer(n3);
        try {
            VtTrailCTP vtTrailCTP = (VtTrailCTP)this.vtServerTrailCreator.get(new Object[]{sVtDef2, sVtDef3, string3, sServerTrailId2, string4, eServerTrailProtection2, eCircuitSize2, n4});
            sServerTrailId sServerTrailId3 = vtTrailCTP.getTrailCTPData().trailId;
            ServerTrailLinkId serverTrailLinkId = new ServerTrailLinkId(sServerTrailId3.nodeId, sServerTrailId3.uniqueId);
            return serverTrailLinkId;
        }
        catch (xPathInUse xPathInUse2) {
            throw new PathInUse((UserException)xPathInUse2);
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.nmd.getPlatform());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            throw new ProvisionError("The server trail creation failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getCombinedCache() {
        ArrayList arrayList = new ArrayList();
        Object object = this.masterTrailLock;
        synchronized (object) {
            arrayList.addAll(this.stsTrailCache);
            arrayList.addAll(this.vtTrailCache);
        }
        return arrayList;
    }

    private ServerTrailEnd getTrailById(IServerTrailLinkId iServerTrailLinkId) {
        ServerTrailEnd serverTrailEnd = null;
        ArrayList arrayList = this.getCombinedCache();
        for (ServerTrailEnd serverTrailEnd2 : arrayList) {
            if (!serverTrailEnd2.getServerTrailLinkId().equals(iServerTrailLinkId)) continue;
            serverTrailEnd = serverTrailEnd2;
            break;
        }
        return serverTrailEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearHoCache() {
        Object object = this.masterTrailLock;
        synchronized (object) {
            this.stsTrailObservableManager.reset();
            this.stsTrailCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLoCache() {
        Object object = this.masterTrailLock;
        synchronized (object) {
            this.vtTrailObservableManager.reset();
            this.vtTrailCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stsCacheAdd(HoServerTrailEnd hoServerTrailEnd) {
        Object object = this.masterTrailLock;
        synchronized (object) {
            this.stsTrailObservableManager.addObservable((Observable)((Object)hoServerTrailEnd));
            this.stsTrailCache.add(hoServerTrailEnd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void vtCacheAdd(LoServerTrailEnd loServerTrailEnd) {
        Object object = this.masterTrailLock;
        synchronized (object) {
            this.vtTrailObservableManager.addObservable((Observable)((Object)loServerTrailEnd));
            this.vtTrailCache.add(loServerTrailEnd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheDelete(ArrayList arrayList, int n) {
        Object object = this.masterTrailLock;
        synchronized (object) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ServerTrailEnd serverTrailEnd = (ServerTrailEnd)iterator.next();
                if (serverTrailEnd.getServerTrailLinkId().getUniqueId() != n) continue;
                if (serverTrailEnd instanceof HoServerTrailEnd) {
                    this.stsTrailObservableManager.removeObservable((Observable)((Object)serverTrailEnd));
                } else if (serverTrailEnd instanceof LoServerTrailEnd) {
                    this.vtTrailObservableManager.removeObservable((Observable)((Object)serverTrailEnd));
                }
                iterator.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache() {
        Object object = this.masterTrailLock;
        synchronized (object) {
            ServerTrailEnd serverTrailEnd;
            int n;
            TrailCTP[] trailCTPArray;
            boolean bl = true;
            if (!this.stsServerTrailRetriever.isClean()) {
                while (bl) {
                    this.clearHoCache();
                    try {
                        trailCTPArray = (StsTrailCTP[])this.stsServerTrailRetriever.get();
                        if (trailCTPArray != null) {
                            for (n = 0; n < trailCTPArray.length; ++n) {
                                serverTrailEnd = new HoServerTrailEnd(this.nmd, (StsTrailCTP)trailCTPArray[n]);
                                this.stsCacheAdd((HoServerTrailEnd)serverTrailEnd);
                            }
                            this.stsTrailObservableManager.setActive(true);
                        }
                        bl = false;
                    }
                    catch (xFeatureUnsupported xFeatureUnsupported2) {
                        if (this.db.on()) {
                            SDebug.printStackTrace((Throwable)((Object)xFeatureUnsupported2));
                        }
                        this.clearHoCache();
                        break;
                    }
                    catch (CmsCommFailException cmsCommFailException) {
                        if (this.db.on()) {
                            SDebug.printStackTrace((Throwable)((Object)cmsCommFailException));
                        }
                        this.clearHoCache();
                        break;
                    }
                    catch (CmsObjectNotExistException cmsObjectNotExistException) {
                        if (this.db.on()) {
                            SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
                        }
                        this.clearHoCache();
                        break;
                    }
                    catch (UserException userException) {
                        if (this.db.on()) {
                            SDebug.printStackTrace((Throwable)userException);
                        }
                        this.clearHoCache();
                        break;
                    }
                    catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                        StsServerTrailRetriever stsServerTrailRetriever = this.stsServerTrailRetriever;
                        synchronized (stsServerTrailRetriever) {
                            this.stsServerTrailRetriever.changeState((short)1);
                        }
                        if (!this.db.on()) continue;
                        SDebug.printStackTrace((Throwable)oBJECT_NOT_EXIST);
                    }
                }
            }
            bl = true;
            if (!this.vtServerTrailRetriever.isClean()) {
                while (bl) {
                    this.clearLoCache();
                    try {
                        trailCTPArray = (VtTrailCTP[])this.vtServerTrailRetriever.get();
                        if (trailCTPArray != null) {
                            for (n = 0; n < trailCTPArray.length; ++n) {
                                serverTrailEnd = new LoServerTrailEnd(this.nmd, (VtTrailCTP)trailCTPArray[n]);
                                this.vtCacheAdd((LoServerTrailEnd)serverTrailEnd);
                            }
                            this.vtTrailObservableManager.setActive(true);
                        }
                        bl = false;
                    }
                    catch (xFeatureUnsupported xFeatureUnsupported3) {
                        if (this.db.on()) {
                            SDebug.printStackTrace((Throwable)((Object)xFeatureUnsupported3));
                        }
                        this.clearLoCache();
                        break;
                    }
                    catch (CmsCommFailException cmsCommFailException) {
                        if (this.db.on()) {
                            SDebug.printStackTrace((Throwable)((Object)cmsCommFailException));
                        }
                        this.clearLoCache();
                        break;
                    }
                    catch (CmsObjectNotExistException cmsObjectNotExistException) {
                        if (this.db.on()) {
                            SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
                        }
                        this.clearLoCache();
                        break;
                    }
                    catch (UserException userException) {
                        if (this.db.on()) {
                            SDebug.printStackTrace((Throwable)userException);
                        }
                        this.clearLoCache();
                        break;
                    }
                    catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                        VtServerTrailRetriever vtServerTrailRetriever = this.vtServerTrailRetriever;
                        synchronized (vtServerTrailRetriever) {
                            this.vtServerTrailRetriever.changeState((short)1);
                        }
                        if (!this.db.on()) continue;
                        SDebug.printStackTrace((Throwable)oBJECT_NOT_EXIST);
                    }
                }
            }
        }
    }

    public String toString() {
        return "ServerTrailsManager";
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    private Trail getServerTrailRef() {
        return this.nmd.getIorRepository().getServerTrailRef();
    }

    private class ServerTrailEditor
    extends NonCachedValue {
        public ServerTrailEditor(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xProvisionError {
            Object[] objectArray = (Object[])object;
            String string = (String)objectArray[0];
            String string2 = (String)objectArray[1];
            sServerTrailId sServerTrailId2 = (sServerTrailId)objectArray[2];
            boolean bl = ServerTrailsManager.this.getServerTrailRef().changePeerIpAddress(string, string2, sServerTrailId2);
            return new Boolean(bl);
        }

        public Object outer() {
            return ServerTrailsManager.this;
        }
    }

    private class VtServerTrailRetriever
    extends CachedValue {
        public VtServerTrailRetriever(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return ServerTrailsManager.this.getServerTrailRef().getVtTrailCTPs();
        }

        public Object outer() {
            return ServerTrailsManager.this;
        }
    }

    private class StsServerTrailRetriever
    extends CachedValue {
        public StsServerTrailRetriever(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return ServerTrailsManager.this.getServerTrailRef().getStsTrailCTPs();
        }

        public Object outer() {
            return ServerTrailsManager.this;
        }
    }

    private class VtServerTrailCreator
    extends NonCachedValue {
        public VtServerTrailCreator(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xPathInUse, xInvalidPath, xProvisionError {
            Object[] objectArray = (Object[])object;
            sVtDef sVtDef2 = (sVtDef)objectArray[0];
            sVtDef sVtDef3 = (sVtDef)objectArray[1];
            String string = (String)objectArray[2];
            sServerTrailId sServerTrailId2 = (sServerTrailId)objectArray[3];
            String string2 = (String)objectArray[4];
            eServerTrailProtection eServerTrailProtection2 = (eServerTrailProtection)objectArray[5];
            eCircuitSize eCircuitSize2 = (eCircuitSize)objectArray[6];
            short s = ((Integer)objectArray[7]).shortValue();
            VtTrailCTP vtTrailCTP = ServerTrailsManager.this.getServerTrailRef().createVtTrailCTP(sVtDef2, sVtDef3, string, sServerTrailId2, string2, eServerTrailProtection2, eCircuitSize2, s);
            return vtTrailCTP;
        }

        public Object outer() {
            return ServerTrailsManager.this;
        }
    }

    private class StsServerTrailCreator
    extends NonCachedValue {
        public StsServerTrailCreator(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xPathInUse, xInvalidPath, xProvisionError {
            Object[] objectArray = (Object[])object;
            sStsPathDef sStsPathDef2 = (sStsPathDef)objectArray[0];
            sStsPathDef sStsPathDef3 = (sStsPathDef)objectArray[1];
            String string = (String)objectArray[2];
            sServerTrailId sServerTrailId2 = (sServerTrailId)objectArray[3];
            String string2 = (String)objectArray[4];
            eServerTrailProtection eServerTrailProtection2 = (eServerTrailProtection)objectArray[5];
            eCircuitSize eCircuitSize2 = (eCircuitSize)objectArray[6];
            short s = ((Integer)objectArray[7]).shortValue();
            StsTrailCTP stsTrailCTP = ServerTrailsManager.this.getServerTrailRef().createStsTrailCTP(sStsPathDef2, sStsPathDef3, string, sServerTrailId2, string2, eServerTrailProtection2, eCircuitSize2, s);
            return stsTrailCTP;
        }

        public Object outer() {
            return ServerTrailsManager.this;
        }
    }
}

