/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.EtherL2Media.SvlanCircuits;
import cerent.cms.idl.EtherL2Media.sSvlanConnectionItem;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.Vlan.sVlanRangeInfo;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.Connections;
import cerent.cms.model.ISvlanConnectionModel;
import cerent.cms.model.ISvlanPathDefModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.SvlanCircuitModelsDelegate;
import cerent.cms.model.SvlanConnectionModel;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.SvlanRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvlanConnections
extends Connections
implements Observer {
    private static final String MY_DEBUG_KEY = "SvlanConnections";
    private ConnectionModelsDelegate container;
    private SvlanCircuitModelsDelegate cont;
    private NodeModelDelegate node;
    private GetSvlanConnectionsList getSvlanConnectionsList;
    private SvlanConnDebug db;

    public SvlanConnections(ConnectionModelsDelegate connectionModelsDelegate) {
        this.container = connectionModelsDelegate;
        this.node = connectionModelsDelegate.node;
        this.db = new SvlanConnDebug(this.node.db);
        this.getSvlanConnectionsList = new GetSvlanConnectionsList(this.node, "SvlanConnections.getSvlanConnectionsList");
    }

    public SvlanConnections(SvlanCircuitModelsDelegate svlanCircuitModelsDelegate) {
        this.cont = svlanCircuitModelsDelegate;
        this.node = svlanCircuitModelsDelegate.node;
        this.db = new SvlanConnDebug(this.node.db);
        this.getSvlanConnectionsList = new GetSvlanConnectionsList(this.node, "SvlanConnections.getSvlanConnectionsList");
    }

    public SvlanCircuits getSvlanCircuitRef() {
        return this.node.getIorRepository().getSvlanCircuitsRef();
    }

    public void init() {
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void update(Observable observable, Object object) {
    }

    public List getConnectionModels(SvlanRange[] svlanRangeArray) {
        ArrayList<SvlanConnectionModel> arrayList = new ArrayList<SvlanConnectionModel>();
        this.connectionModels.clear();
        this.discover(this.connectionModels, svlanRangeArray);
        for (SvlanConnectionModel svlanConnectionModel : this.connectionModels.values()) {
            svlanConnectionModel.init();
            arrayList.add(svlanConnectionModel);
        }
        return arrayList;
    }

    public List getConnectionModels(int n) {
        ArrayList<SvlanConnectionModel> arrayList = new ArrayList<SvlanConnectionModel>();
        block0: for (SvlanConnectionModel svlanConnectionModel : this.connectionModels.values()) {
            ISvlanPathDefModel[] iSvlanPathDefModelArray = svlanConnectionModel.getPaths();
            for (int i = 0; i < iSvlanPathDefModelArray.length; ++i) {
                if (iSvlanPathDefModelArray[i].getPortEntityIdx() != n) continue;
                arrayList.add(svlanConnectionModel);
                continue block0;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SvlanConnectionModel add(sSvlanConnectionItem sSvlanConnectionItem2) {
        SvlanConnectionModel svlanConnectionModel = null;
        if (sSvlanConnectionItem2 == null) {
            return null;
        }
        SvlanConnections svlanConnections = this;
        synchronized (svlanConnections) {
            block7: {
                try {
                    svlanConnectionModel = new SvlanConnectionModel(this.node, sSvlanConnectionItem2, this);
                    Integer n = new Integer(svlanConnectionModel.getObjIndex());
                    svlanConnectionModel.init();
                    this.connectionModels.put(n, svlanConnectionModel);
                    this.setChanged();
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (this.db.on()) {
                        this.db.println("Exception in add-SvlanConn " + (Object)((Object)abstractCmsIOException));
                        this.printStackTrace((Exception)((Object)abstractCmsIOException));
                    }
                    if (svlanConnectionModel == null) break block7;
                    svlanConnectionModel.dispose();
                    svlanConnectionModel = null;
                }
            }
        }
        this.notifyObservers(ModelUpdateType.ADDED);
        return svlanConnectionModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(ISvlanConnectionModel iSvlanConnectionModel) {
        if (this.db.on()) {
            this.db.println("Removing SvlanConn");
        }
        if (iSvlanConnectionModel == null) {
            return;
        }
        SvlanConnections svlanConnections = this;
        synchronized (svlanConnections) {
            this.connectionModels.remove(iSvlanConnectionModel.getIndex());
            iSvlanConnectionModel.dispose();
            iSvlanConnectionModel = null;
            if (this.db.on()) {
                this.db.println("SvlanConn removed and disposed");
            }
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.DELETED);
    }

    @Override
    protected boolean updateStructure() {
        return true;
    }

    private synchronized void discover(Map<Integer, ConnectionModel> map, SvlanRange[] svlanRangeArray) {
        sSvlanConnectionItem[] sSvlanConnectionItemArray = null;
        sSvlanConnectionItemArray = this.getSvlanConnectionItems(svlanRangeArray);
        if (sSvlanConnectionItemArray == null) {
            this.db.println("Error in getting SvlanConnections (null) SvlanConnections::discover");
            return;
        }
        for (int i = 0; i < sSvlanConnectionItemArray.length; ++i) {
            if (sSvlanConnectionItemArray[i] == null) continue;
            SvlanConnectionModel svlanConnectionModel = new SvlanConnectionModel(this.node, sSvlanConnectionItemArray[i], this);
            Integer n = new Integer(svlanConnectionModel.getObjIndex());
            map.put(n, svlanConnectionModel);
        }
    }

    private sSvlanConnectionItem[] getSvlanConnectionItems(SvlanRange[] svlanRangeArray) {
        sSvlanConnectionItem[] sSvlanConnectionItemArray = new sSvlanConnectionItem[]{};
        try {
            sVlanRangeInfo[] sVlanRangeInfoArray = new sVlanRangeInfo[svlanRangeArray.length];
            for (int i = 0; i < svlanRangeArray.length; ++i) {
                sVlanRangeInfoArray[i] = new sVlanRangeInfo();
                sVlanRangeInfoArray[i].minVlanId = svlanRangeArray[i].low;
                sVlanRangeInfoArray[i].maxVlanId = svlanRangeArray[i].high;
            }
            sSvlanConnectionItemArray = (sSvlanConnectionItem[])this.getSvlanConnectionsList.get(sVlanRangeInfoArray);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.println("Error in getting SvlanConnections " + (Object)((Object)abstractCmsIOException));
            SvlanConnDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        catch (UserException userException) {
            SvlanConnDebug.printStackTrace((Throwable)userException);
        }
        return sSvlanConnectionItemArray;
    }

    public class SvlanConnDebug
    extends SDebug {
        SvlanConnDebug(KDebug kDebug) {
            super(kDebug, SvlanConnections.MY_DEBUG_KEY);
        }

        public final void printConnections() {
            SvlanConnections.this.db.println("Printing List of SVLAN Connections \n");
            SvlanConnections.this.printConnectionString(this);
        }
    }

    private class GetSvlanConnectionsList
    extends NonCachedValue {
        public GetSvlanConnectionsList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xProvisionError {
            return SvlanConnections.this.getSvlanCircuitRef().getSvlanConnections((sVlanRangeInfo[])object);
        }
    }
}

