/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Circuits.xInvalidCircuitName;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eTrafficDirection;
import cerent.cms.idl.SonetTopology.VcatTerm;
import cerent.cms.idl.SonetTopology.xBusy;
import cerent.cms.idl.SonetTopology.xInvalidOperation;
import cerent.cms.idl.SonetTopology.xInvalidParms;
import cerent.cms.idl.SonetTopology.xVcatMemberInvalidState;
import cerent.cms.idl.SonetTopology.xVcatMemberNotOutOfGroup;
import cerent.cms.idl.SonetTopology.xVcatNotReconfigurable;
import cerent.cms.model.AbstractVcatTermsMap;
import cerent.cms.model.Busy;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IVcatTermMember;
import cerent.cms.model.IVcatTermModel;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.InvalidOperation;
import cerent.cms.model.InvalidParms;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.VcatMemberInvalidState;
import cerent.cms.model.VcatMemberNotOutOfGroup;
import cerent.cms.model.VcatNotReconfigurable;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.ComparisonUtil;
import cerent.util.SDebug;
import java.util.Comparator;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public abstract class VcatTermModel
extends Model
implements Comparator,
IVcatTermModel {
    private VcatTerm vcatTermRef = null;
    protected NodeModelDelegate nmd;
    protected AbstractVcatTermsMap parent;
    protected EventDispatcher dispatcher;
    private String myString;
    private AdminState adminState = null;
    private AvailableVcatMemNums availableVcatMemNums = null;
    private NumberOfMembers numberOfMembers = null;
    private CircuitId circuitId = null;
    private VcatName vcatName = null;
    private Destroy destroy = null;
    private NumOfNewMemsAllowed numOfNewMemsAllowed = null;

    public VcatTermModel(NodeModelDelegate nodeModelDelegate, VcatTerm vcatTerm, AbstractVcatTermsMap abstractVcatTermsMap, SDebug sDebug) {
        super(sDebug);
        this.nmd = nodeModelDelegate;
        this.vcatTermRef = vcatTerm;
        this.parent = abstractVcatTermsMap;
        this.dispatcher = null;
        this.myString = null;
        this.adminState = new AdminState(nodeModelDelegate, "VcatTermModel.AdminState");
        this.availableVcatMemNums = new AvailableVcatMemNums(nodeModelDelegate, "VcatTermModel.AvailableVcatMemNums");
        this.numberOfMembers = new NumberOfMembers(nodeModelDelegate, "VcatTermModel.NumberOfMembers");
        this.circuitId = new CircuitId(nodeModelDelegate, "VcatTermModel.CircuitId");
        this.vcatName = new VcatName(nodeModelDelegate, "VcatTermModel.vcatName");
        this.destroy = new Destroy(nodeModelDelegate, "VcatTermModel.Destroy");
        this.numOfNewMemsAllowed = new NumOfNewMemsAllowed(nodeModelDelegate, "VcatTermModel.NumOfNewMemesAlloewd");
    }

    public void init() {
        super.init0();
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(this.getObjectType(), this.index, (Observer)this);
        }
    }

    public VcatTerm getVcatTermRef() {
        if (this.vcatTermRef == null) {
            throw new CmsObjectNotExistException("An attempt was made to access a VT connection that has been destroyed.");
        }
        return this.vcatTermRef;
    }

    public int getAdminState() {
        try {
            return ((eAdminState)this.adminState.get()).value();
        }
        catch (UserException userException) {
            this.db.println("VcatTermModel: user exception in setAdminState");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public void setAdminState(int n) throws InvalidParms {
        try {
            this.adminState.set(eAdminState.from_int(n));
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParms((UserException)xInvalidParms2);
        }
        catch (UserException userException) {
            this.db.println("VcatTermModel: user exception in setAdminState");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public Short[] getAvailableVcatMemNums() {
        try {
            return (Short[])this.availableVcatMemNums.get();
        }
        catch (UserException userException) {
            this.db.println("VcatTermModel: user exception in setAdminState");
            SDebug.printStackTrace((Throwable)userException);
            return new Short[0];
        }
    }

    public abstract short getNumberOfMembers(int var1) throws InvalidParms;

    public void setNumberOfMembers(short s, int n) throws InvalidOperation, InvalidParms {
        Object[] objectArray = new Object[]{new Short(s), eTrafficDirection.from_int(n)};
        try {
            this.numberOfMembers.set(objectArray);
        }
        catch (xInvalidOperation xInvalidOperation2) {
            throw new InvalidOperation((UserException)xInvalidOperation2);
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParms((UserException)xInvalidParms2);
        }
        catch (UserException userException) {
            this.db.println("VcatTermModel: user exception in setAdminState");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public abstract String getVcatName();

    public void setVcatName(String string) throws InvalidCircuitName {
        try {
            this.vcatName.set(string);
        }
        catch (xInvalidCircuitName xInvalidCircuitName2) {
            throw new InvalidCircuitName((UserException)xInvalidCircuitName2);
        }
        catch (UserException userException) {
            this.db.println("UserException caught in LoVcatTermModel::setName");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void localDestroy() throws Busy {
    }

    public void localDestroy(boolean bl) throws Busy, VcatMemberNotOutOfGroup, VcatMemberInvalidState {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl)};
            this.destroy.get(objectArray);
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (xVcatMemberNotOutOfGroup xVcatMemberNotOutOfGroup2) {
            throw new VcatMemberNotOutOfGroup((UserException)xVcatMemberNotOutOfGroup2);
        }
        catch (xVcatMemberInvalidState xVcatMemberInvalidState2) {
            throw new VcatMemberInvalidState((UserException)xVcatMemberInvalidState2);
        }
        catch (UserException userException) {
            this.db.println("VcatTermModel: user exception in destroy");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    protected abstract ObjectType getObjectType();

    public abstract ICircuitId getCircuitId();

    public void setCircuitId(ICircuitId iCircuitId) {
        try {
            this.circuitId.set(CircuitIdFactory.getCircuitId(iCircuitId));
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in setCircuitId");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public abstract int getPortIndex();

    public short getNumOfNewMemsAllowed() throws VcatNotReconfigurable {
        Short s = new Short(0);
        try {
            s = (Short)this.numOfNewMemsAllowed.get();
        }
        catch (xVcatNotReconfigurable xVcatNotReconfigurable2) {
            throw new VcatNotReconfigurable((UserException)xVcatNotReconfigurable2);
        }
        catch (UserException userException) {
            this.db.println("VcatTermModel: user exception in getNumOfNewMemsAllowed");
            SDebug.printStackTrace((Throwable)userException);
        }
        return s;
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public boolean equals(Object object) {
        if (object instanceof VcatTermModel) {
            VcatTermModel vcatTermModel = (VcatTermModel)object;
            return vcatTermModel.getObjectType() == this.getObjectType() && vcatTermModel.getIndex() == this.getIndex() && vcatTermModel.getNodeModel().getNodeId() == this.getNodeModel().getNodeId();
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.getObjectType().value();
        n = 37 * n + this.getIndex();
        return n;
    }

    public int compare(Object object, Object object2) {
        if (object instanceof VcatTermModel && object2 instanceof VcatTermModel) {
            VcatTermModel vcatTermModel = (VcatTermModel)object;
            VcatTermModel vcatTermModel2 = (VcatTermModel)object2;
            if (vcatTermModel.getObjectType() != vcatTermModel2.getObjectType()) {
                return ComparisonUtil.compare((int)vcatTermModel.getObjectType().value(), (int)vcatTermModel2.getObjectType().value());
            }
            if (vcatTermModel.getIndex() != vcatTermModel2.getIndex()) {
                return ComparisonUtil.compare((int)vcatTermModel.getIndex(), (int)vcatTermModel2.getIndex());
            }
            return 0;
        }
        return -1;
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 0: {
                    if (this.db.on()) {
                        this.db.println(this.getClass().getName() + "::update():    this DELETED");
                    }
                    this.delete();
                    break;
                }
                case 1: {
                    if (this.db.on()) {
                        this.db.println("VcatTerm Model update():    this CHANGED");
                    }
                    this.updateLocal();
                    break;
                }
                case 2: {
                    if (!this.db.on()) break;
                    this.db.println("VcatTermModel update():    ADDED");
                    break;
                }
                default: {
                    if (!this.db.on()) break;
                    this.db.println("VcatTermModel update():    UNKNOWN NE UPDATE TYPE" + n);
                }
            }
        }
    }

    protected void updateLocal() {
        this.setChanged();
        super.updateLocal();
    }

    protected void delete() {
        if (this.db.on()) {
            this.db.println("Received Delete for vcatTermModel ");
        }
        this.dispose();
        this.parent.remove(this.getIndex());
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(this.getObjectType(), this.index, (Observer)this);
            this.dispatcher = null;
        }
        this.myString = null;
        super.dispose();
    }

    public void destroy() {
        super.destroy();
        this.vcatTermRef = null;
    }

    protected String prettyString(ICircuitId iCircuitId) {
        if (iCircuitId == null || iCircuitId.getUniquePart() == null) {
            return "<null>";
        }
        return Integer.toHexString(iCircuitId.getNodeId()) + "::" + iCircuitId.getUniquePart().getUniqueId();
    }

    public String toString() {
        if (this.myString == null) {
            try {
                this.myString = "VcatTerm class = " + this.getClass().getName() + " CircuitName (UniqueId) = " + this.getVcatName() + "\n";
            }
            catch (Exception exception) {
                return this.getClass().getName() + ": The circuit ID cannot be found.";
            }
        }
        return this.myString;
    }

    protected void printString(SDebug sDebug) {
        sDebug.println("VcatTermModel[Index = " + Integer.toHexString(this.getIndex()) + "] : " + "Port Index=" + Integer.toHexString(this.getPortIndex()));
        sDebug.println("Circuit Name : " + this.getVcatName());
        sDebug.println("CktId = " + this.prettyString(this.getCircuitId()));
        sDebug.println("Observers are :");
        this.printObservers();
    }

    public abstract IVcatTermMember[] getMembersOfTheVcatTerm(int var1) throws InvalidParms;

    private class VcatName
    extends NonCachedValue {
        public VcatName(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            VcatTermModel.this.getVcatTermRef().setVcatName((String)object);
        }
    }

    private class NumOfNewMemsAllowed
    extends NonCachedValue {
        public NumOfNewMemsAllowed(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            short s = VcatTermModel.this.getVcatTermRef().findNumOfNewMemsAllowedInVcat();
            Short s2 = new Short(s);
            return s2;
        }
    }

    private class Destroy
    extends NonCachedValue {
        public Destroy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            VcatTermModel.this.getVcatTermRef().destroy((Boolean)objectArray[0]);
            return null;
        }
    }

    private class CircuitId
    extends NonCachedValue {
        public CircuitId(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            VcatTermModel.this.getVcatTermRef().setCircuitId((sCircuitId)object);
        }
    }

    private class AvailableVcatMemNums
    extends NonCachedValue {
        public AvailableVcatMemNums(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            short[] sArray = VcatTermModel.this.getVcatTermRef().getAvailableVcatMemNums();
            Short[] shortArray = new Short[sArray.length];
            for (int i = 0; i < sArray.length; ++i) {
                shortArray[i] = new Short(sArray[i]);
            }
            return shortArray;
        }
    }

    private class AdminState
    extends NonCachedValue {
        public AdminState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return VcatTermModel.this.getVcatTermRef().getAdminState();
        }

        protected void setValue(Object object) throws UserException {
            VcatTermModel.this.getVcatTermRef().setAdminState((eAdminState)object);
        }
    }

    private class NumberOfMembers
    extends NonCachedValue {
        public NumberOfMembers(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            VcatTermModel.this.getVcatTermRef().setNumOfMems((Short)objectArray[0], (eTrafficDirection)objectArray[1]);
        }
    }
}

