/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Epos.eBridgePortState;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.EtherL2Media.General;
import cerent.cms.idl.EtherL2Media.eAISActionType;
import cerent.cms.idl.EtherL2Media.eMRouter;
import cerent.cms.idl.EtherL2Media.eNiValue;
import cerent.cms.idl.EtherL2Media.eProtActionType;
import cerent.cms.idl.EtherL2Media.eQinQMode;
import cerent.cms.idl.EtherL2Media.sBasicL2Info;
import cerent.cms.idl.EtherL2Media.sEgressInfo;
import cerent.cms.idl.EtherL2Media.sMacInfo;
import cerent.cms.idl.EtherL2Media.sQinQInfo;
import cerent.cms.idl.EtherL2Media.sVlanCrossInfoData;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.IXPLLayer2LineModel;
import cerent.cms.model.InvalidData;
import cerent.cms.model.InvalidOperation;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.QinQSettings;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.xpl2.XPL2QinQSvlanTableModel;
import java.util.ArrayList;
import org.omg.CORBA.UserException;

public class XPL2Layer2LineModel
extends EtherLineModel
implements IXPLLayer2LineModel {
    private EgressQOS egressQOS;
    private EgressQOSInfo egressQOSInfoTable;
    private MacAddrInfo macAddrInfoTable;
    private BridgePortState bridgePortState;
    private ActualBridgePortState actualBridgePortState;
    private EtherBasicL2Info etherBasicL2Info;
    private QinQInfo qInQInfo;
    private VlanCrossInfoList vlanCrossInfoList;
    private VlanListOnNNIPort vlanListOnNNIPort;
    private IgmpMrouter igmpMrouter;
    private AisAction aisAction;
    private ProtectionAction protAction;
    private Bpdu bpdu;

    public XPL2Layer2LineModel(NodeModelDelegate nodeModelDelegate, int n) {
        super(nodeModelDelegate, n);
        this.index = n;
        this.etherBasicL2Info = new EtherBasicL2Info(nodeModelDelegate, "XPL2Layer2LineModel.EtherBasicL2Info");
        this.qInQInfo = new QinQInfo(nodeModelDelegate, "XPL2Layer2LineModel.QinQInfo");
        this.vlanCrossInfoList = new VlanCrossInfoList(nodeModelDelegate, "XPL2Layer2LineModel.VlanCrossInfoList");
        this.egressQOS = new EgressQOS(nodeModelDelegate, "EXPL2Layer2LineModel.EgressQOS");
        this.egressQOSInfoTable = new EgressQOSInfo(nodeModelDelegate, "EXPL2Layer2LineModel.EgressQOS");
        this.macAddrInfoTable = new MacAddrInfo(nodeModelDelegate, "EXPL2Layer2LineModel.MacAddrInfo");
        this.bridgePortState = new BridgePortState(nodeModelDelegate, "XPL2Layer2LineModel.BridgePortState");
        this.actualBridgePortState = new ActualBridgePortState(nodeModelDelegate, "XPL2Layer2LineModel.ActualBridgePortState");
        this.vlanListOnNNIPort = new VlanListOnNNIPort(nodeModelDelegate, "XPL2Layer2LineModel.VlanListOnNNIPort");
        this.bpdu = new Bpdu(nodeModelDelegate, "XPL2Layer2LineModel.Bpdu");
        this.igmpMrouter = new IgmpMrouter(nodeModelDelegate, "XPL2Layer2LineModel.IgmpMrouter");
        this.aisAction = new AisAction(nodeModelDelegate, "XPL2Layer2LineModel.AisAction");
        this.protAction = new ProtectionAction(nodeModelDelegate, "XPL2Layer2LineModel.ProtectionAction");
    }

    public sBasicL2Info getEtherBasicL2Info() throws NoSuchInterface, InvalidOperation {
        if (this.db.on()) {
            this.db.println("XPL2LineModel::getEtherBasicL2Info");
        }
        try {
            return (sBasicL2Info)this.etherBasicL2Info.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getEtherBasicL2Info", userException);
        }
    }

    public void setEtherBasicL2Info(sBasicL2Info sBasicL2Info2) throws NoSuchInterface, InvalidOperation, EMCProvisionError, WrongInterfaceType {
        if (this.db.on()) {
            this.db.println("XPL2LineModel.getEtherBasicL2Info");
        }
        try {
            this.etherBasicL2Info.set(sBasicL2Info2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setEtherBasicL2Info", userException);
        }
    }

    public short[] getVlanList() throws NoSuchInterface, WrongInterfaceType {
        try {
            return this.getEtherL2Ref().getVlanListOnNNIPort(this.index);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
    }

    public void setVlanList(short[] sArray) throws EMCProvisionError, NoSuchInterface, WrongInterfaceType {
        try {
            this.getEtherL2Ref().setSvlanListOnNNIPort(this.index, sArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
    }

    public void setVlanList(int[] nArray) throws EMCProvisionError, NoSuchInterface, WrongInterfaceType {
        short[] sArray = new short[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            sArray[i] = (short)nArray[i];
        }
        this.setVlanList(sArray);
    }

    public eBridgePortState getActualBridgePortState() throws NoSuchInterface, WrongInterfaceType, AbstractCmsNoSuchEntityException {
        if (this.getModuleModel().getState() == eEqState.NOT_PRESENT) {
            return eBridgePortState.PORT_STATE_UNKNOWN;
        }
        try {
            return (eBridgePortState)this.actualBridgePortState.get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getActualBridgePortState", userException);
        }
    }

    public eBridgePortState getBridgePortState() throws NoSuchInterface, WrongInterfaceType, AbstractCmsNoSuchEntityException {
        try {
            return (eBridgePortState)this.bridgePortState.get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getBridgePortState", userException);
        }
    }

    public eMRouter getIgmpMrouter() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eMRouter)this.igmpMrouter.get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getIgmpMrouter", userException);
        }
    }

    public void setIgmpMrouter(eMRouter eMRouter2) throws NoSuchInterface, WrongInterfaceType {
        try {
            this.igmpMrouter.set(eMRouter2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setIgmpMrouter", userException);
        }
    }

    public eAISActionType getAisAction() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eAISActionType)this.aisAction.get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getAisAction", userException);
        }
    }

    public void setAisAction(eAISActionType eAISActionType2) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.aisAction.set(eAISActionType2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setAisAction", userException);
        }
    }

    public eProtActionType getProtAction() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eProtActionType)this.protAction.get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getProtAction", userException);
        }
    }

    public void setProtAction(eProtActionType eProtActionType2) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.protAction.set(eProtActionType2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setProtAction", userException);
        }
    }

    public void setBridgePortState(eBridgePortState eBridgePortState2) throws EMCProvisionError, NoSuchInterface, WrongInterfaceType {
        try {
            this.bridgePortState.set(eBridgePortState2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setBridgePortState", userException);
        }
    }

    public sEgressInfo getEgressInfo() throws NoSuchInterface, InvalidOperation {
        if (this.db.on()) {
            this.db.println("XPL2LineModel::getEgressInfo");
        }
        try {
            return (sEgressInfo)this.egressQOSInfoTable.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getEgressInfo", userException);
        }
    }

    public void setEgressInfo(sEgressInfo sEgressInfo2) throws EMCProvisionError, NoSuchInterface, WrongInterfaceType {
        if (this.db.on()) {
            this.db.println("XPL2LineModel::setEgressInfo");
        }
        try {
            this.egressQOSInfoTable.set(sEgressInfo2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setEgressInfo", userException);
        }
    }

    public Boolean getEgressQOS() throws NoSuchInterface, InvalidOperation, WrongInterfaceType {
        try {
            return (Boolean)this.egressQOS.get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getEgressQOS", userException);
        }
    }

    public void setEgressQOS(Boolean bl) throws EMCProvisionError, NoSuchInterface, WrongInterfaceType {
        try {
            this.egressQOS.set(bl);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setEgressQOS", userException);
        }
    }

    public sMacInfo getMacInfoFromModel() throws NoSuchInterface, WrongInterfaceType {
        if (this.db.on()) {
            this.db.println("XPL2LineModel::getMacInfoFromModel");
        }
        try {
            return (sMacInfo)this.macAddrInfoTable.get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getMacInfoFromModel", userException);
        }
    }

    public void setMacInfoFromModel(sMacInfo sMacInfo2) throws EMCProvisionError, NoSuchInterface, WrongInterfaceType {
        if (this.db.on()) {
            this.db.println("XPL2LineModel::setMacInfoFromModel");
        }
        try {
            this.macAddrInfoTable.set(sMacInfo2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setMacInfoFromModel", userException);
        }
    }

    protected General getEtherL2Ref() {
        return this.getNodeModelDelegate().getIorRepository().getEtherL2Ref();
    }

    public sQinQInfo getQinQInfo() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sQinQInfo)this.qInQInfo.get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getQinQInfo", userException);
        }
    }

    public void setQinQInfo(sQinQInfo sQinQInfo2) throws EMCProvisionError, NoSuchInterface, WrongInterfaceType {
        try {
            this.qInQInfo.set(sQinQInfo2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setQinQInfo", userException);
        }
    }

    public void setQinQInfoFromNet(QinQSettings qinQSettings) throws ProvisionError, NoSuchInterface, WrongInterfaceType, InvalidOperation, InvalidData {
        this.setBpdu(new Boolean(qinQSettings.getQinQBPDU()));
        if (qinQSettings.getQinQMode() == 1) {
            sQinQInfo sQinQInfo2 = new sQinQInfo(eQinQMode.TRASPARENT_MODE, qinQSettings.getSvlan());
            this.setQinQInfo(sQinQInfo2);
        } else {
            sQinQInfo sQinQInfo3 = new sQinQInfo(eQinQMode.SELECTIVE_MODE, qinQSettings.getSvlan());
            this.setQinQInfo(sQinQInfo3);
            this.setVlanCrossInfoList(((XPL2QinQSvlanTableModel)qinQSettings.getQinQTable()).getVlanCrossInfoList());
        }
    }

    public sVlanCrossInfoData[] getVlanCrossInfoList() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sVlanCrossInfoData[])this.vlanCrossInfoList.get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getVlanCrossInfoList", userException);
        }
    }

    public void setVlanCrossInfoList(sVlanCrossInfoData[] sVlanCrossInfoDataArray) throws EMCProvisionError, NoSuchInterface, WrongInterfaceType {
        try {
            this.vlanCrossInfoList.set(sVlanCrossInfoDataArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setVlanCrossInfoList", userException);
        }
    }

    public short[] getVlanListOnNNIPort() throws NoSuchInterface, InvalidOperation {
        try {
            return (short[])this.vlanListOnNNIPort.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getVlanListOnNNIPort", userException);
        }
    }

    public void setBpdu(Boolean bl) throws InvalidOperation, InvalidData, NoSuchInterface {
        try {
            this.bpdu.set(bl);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setBpdu", userException);
        }
    }

    public Boolean getBpdu() throws InvalidOperation, NoSuchInterface {
        try {
            return (Boolean)this.bpdu.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getBpdu", userException);
        }
    }

    public boolean isNNI() throws NoSuchInterface, InvalidOperation {
        sBasicL2Info sBasicL2Info2 = this.getEtherBasicL2Info();
        return sBasicL2Info2.niMode == eNiValue.NNI_MODE;
    }

    public void removeSvlanFromQinQ(short s) throws ProvisionError, NoSuchInterface, WrongInterfaceType {
        sQinQInfo sQinQInfo2 = this.getQinQInfo();
        if (sQinQInfo2.qinqMode == eQinQMode.TRASPARENT_MODE) {
            if (sQinQInfo2.trasparentSvlanId == s) {
                if (this.db.on()) {
                    this.db.println("Removing QinQ transparent");
                }
                sQinQInfo2.qinqMode = eQinQMode.SELECTIVE_MODE;
                this.setQinQInfo(sQinQInfo2);
                if (this.db.on()) {
                    this.db.println("QinQ reset");
                }
            }
        } else {
            sVlanCrossInfoData[] sVlanCrossInfoDataArray = this.getVlanCrossInfoList();
            ArrayList<sVlanCrossInfoData> arrayList = new ArrayList<sVlanCrossInfoData>();
            for (int i = 0; i < sVlanCrossInfoDataArray.length; ++i) {
                if (sVlanCrossInfoDataArray[i].sVlan == s) continue;
                arrayList.add(sVlanCrossInfoDataArray[i]);
            }
            if (sVlanCrossInfoDataArray.length != arrayList.size()) {
                if (this.db.on()) {
                    this.db.println("Removing QinQ selective setting for SVLAN " + s);
                }
                sVlanCrossInfoData[] sVlanCrossInfoDataArray2 = arrayList.toArray(new sVlanCrossInfoData[0]);
                this.setVlanCrossInfoList(sVlanCrossInfoDataArray2);
                if (this.db.on()) {
                    this.db.println("QinQ setting removed");
                }
            } else if (this.db.on()) {
                this.db.println("No change in QinQ setting");
            }
        }
    }

    protected void updateLocal(long l) {
        this.etherBasicL2Info.update();
        this.egressQOS.update();
        this.egressQOSInfoTable.update();
        this.macAddrInfoTable.update();
        this.qInQInfo.update();
        this.vlanCrossInfoList.update();
        this.bridgePortState.update();
        this.actualBridgePortState.update();
        this.vlanListOnNNIPort.update();
        this.bpdu.update();
        super.updateLocal(l);
    }

    public void dispose() {
        this.etherBasicL2Info.dispose();
        this.egressQOS.dispose();
        this.egressQOSInfoTable.dispose();
        this.macAddrInfoTable.dispose();
        this.qInQInfo.dispose();
        this.vlanCrossInfoList.dispose();
        this.bridgePortState.dispose();
        this.actualBridgePortState.dispose();
        this.vlanListOnNNIPort.dispose();
        this.bpdu.dispose();
        super.dispose();
    }

    public void destroy() {
        super.destroy();
    }

    private class Bpdu
    extends CachedValue {
        public Bpdu(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getBpdu(XPL2Layer2LineModel.this.getIndex());
        }

        protected void setValue(Object object) throws UserException {
            XPL2Layer2LineModel.this.getEtherL2Ref().setBpdu(XPL2Layer2LineModel.this.getIndex(), (Boolean)object);
        }
    }

    private class VlanListOnNNIPort
    extends CachedValue {
        public VlanListOnNNIPort(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getVlanListOnNNIPort(XPL2Layer2LineModel.this.getIndex());
        }
    }

    private class VlanCrossInfoList
    extends CachedValue {
        public VlanCrossInfoList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getSelectiveQinQInfoData(XPL2Layer2LineModel.this.getIndex());
        }

        protected void setValue(Object object) throws UserException {
            XPL2Layer2LineModel.this.getEtherL2Ref().setSelectiveQinQInfoData(XPL2Layer2LineModel.this.getIndex(), (sVlanCrossInfoData[])object);
        }
    }

    private class QinQInfo
    extends CachedValue {
        public QinQInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getQinQInfo(XPL2Layer2LineModel.this.getIndex());
        }

        protected void setValue(Object object) throws UserException {
            XPL2Layer2LineModel.this.getEtherL2Ref().setQinQInfo(XPL2Layer2LineModel.this.getIndex(), (sQinQInfo)object);
        }

        protected Object cloneValue() {
            sQinQInfo sQinQInfo2 = (sQinQInfo)this.value;
            sQinQInfo sQinQInfo3 = new sQinQInfo(sQinQInfo2.qinqMode, sQinQInfo2.trasparentSvlanId);
            return sQinQInfo3;
        }
    }

    private class EtherBasicL2Info
    extends CachedValue {
        public EtherBasicL2Info(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            XPL2Layer2LineModel.this.getEtherL2Ref().setBasicL2Info(XPL2Layer2LineModel.this.getIndex(), (sBasicL2Info)object);
        }

        protected Object getValue() throws UserException {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getBasicL2Info(XPL2Layer2LineModel.this.getIndex());
        }

        protected Object cloneValue() {
            sBasicL2Info sBasicL2Info2 = (sBasicL2Info)this.value;
            sBasicL2Info sBasicL2Info3 = new sBasicL2Info(sBasicL2Info2.macLearningState, sBasicL2Info2.niMode, sBasicL2Info2.sIngressCOS, sBasicL2Info2.cEtherType, sBasicL2Info2.sEtherType, sBasicL2Info2.policyId);
            return sBasicL2Info3;
        }

        public Object outer() {
            return XPL2Layer2LineModel.this;
        }
    }

    private class MacAddrInfo
    extends CachedValue {
        public MacAddrInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            XPL2Layer2LineModel.this.getEtherL2Ref().setMacInfo(XPL2Layer2LineModel.this.getIndex(), (sMacInfo)object);
        }

        protected Object getValue() throws UserException {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getMacInfo(XPL2Layer2LineModel.this.getIndex());
        }

        protected Object cloneValue() {
            sMacInfo sMacInfo2 = (sMacInfo)this.value;
            sMacInfo sMacInfo3 = new sMacInfo(sMacInfo2.macAddrFilterMode, sMacInfo2.macAddrFilterTable);
            return sMacInfo3;
        }

        public Object outer() {
            return XPL2Layer2LineModel.this;
        }
    }

    private class EgressQOSInfo
    extends CachedValue {
        public EgressQOSInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            XPL2Layer2LineModel.this.getEtherL2Ref().setEgressInfo(XPL2Layer2LineModel.this.getIndex(), (sEgressInfo)object);
        }

        protected Object getValue() throws UserException {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getEgressInfo(XPL2Layer2LineModel.this.getIndex());
        }

        protected Object cloneValue() {
            sEgressInfo sEgressInfo2 = (sEgressInfo)this.value;
            sEgressInfo sEgressInfo3 = new sEgressInfo(sEgressInfo2.egressQOSState, sEgressInfo2.egressQOSInfoTable, sEgressInfo2.policyId);
            return sEgressInfo3;
        }

        public Object outer() {
            return XPL2Layer2LineModel.this;
        }
    }

    private class BridgePortState
    extends CachedValue {
        public BridgePortState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            XPL2Layer2LineModel.this.getEtherL2Ref().setBridgePortState(XPL2Layer2LineModel.this.getIndex(), (eBridgePortState)object);
        }

        protected Object getValue() throws UserException {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getBridgePortState(XPL2Layer2LineModel.this.getIndex());
        }

        protected Object cloneValue() {
            eBridgePortState eBridgePortState2 = (eBridgePortState)this.value;
            eBridgePortState eBridgePortState3 = eBridgePortState.from_int(eBridgePortState2.value());
            return eBridgePortState3;
        }

        public Object outer() {
            return XPL2Layer2LineModel.this;
        }
    }

    private class ProtectionAction
    extends NonCachedValue {
        public ProtectionAction(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xNoSuchInterface, xProvisionError {
            XPL2Layer2LineModel.this.getEtherL2Ref().setProtAction(XPL2Layer2LineModel.this.getIndex(), (eProtActionType)object);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getProtAction(XPL2Layer2LineModel.this.getIndex());
        }
    }

    private class AisAction
    extends NonCachedValue {
        public AisAction(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xNoSuchInterface, xProvisionError {
            XPL2Layer2LineModel.this.getEtherL2Ref().setAISAction(XPL2Layer2LineModel.this.getIndex(), (eAISActionType)object);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getAISAction(XPL2Layer2LineModel.this.getIndex());
        }
    }

    private class IgmpMrouter
    extends NonCachedValue {
        public IgmpMrouter(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            XPL2Layer2LineModel.this.getEtherL2Ref().setIGMPMrouter(XPL2Layer2LineModel.this.getIndex(), (eMRouter)object);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getIGMPMRouter(XPL2Layer2LineModel.this.getIndex());
        }
    }

    private class ActualBridgePortState
    extends NonCachedValue {
        public ActualBridgePortState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getActualBridgePortState(XPL2Layer2LineModel.this.getIndex());
        }

        public Object outer() {
            return XPL2Layer2LineModel.this;
        }
    }

    private class EgressQOS
    extends CachedValue {
        public EgressQOS(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            XPL2Layer2LineModel.this.getEtherL2Ref().setEgressQOSState(XPL2Layer2LineModel.this.getIndex(), (Boolean)object);
        }

        protected Object getValue() throws UserException {
            return new Boolean(XPL2Layer2LineModel.this.getEtherL2Ref().getEgressQOSState(XPL2Layer2LineModel.this.getIndex()));
        }

        protected Object cloneValue() {
            Boolean bl = (Boolean)this.value;
            Boolean bl2 = new Boolean(bl);
            return bl2;
        }

        public Object outer() {
            return XPL2Layer2LineModel.this;
        }
    }
}

