/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ucp;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Ucp.sUcpInterface;
import cerent.cms.idl.Ucp.xInvalidParams;
import cerent.cms.idl.Ucp.xNoMoreUcpInterfaces;
import cerent.cms.idl.Ucp.xObjDuplicate;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InvalidParams;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoMoreUcpInterfaces;
import cerent.cms.model.NoSuchUcpInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ObjDuplicate;
import cerent.cms.model.ucp.AbstractUcpContainers;
import cerent.cms.model.ucp.IUcpLinkModel;
import cerent.cms.model.ucp.IUcpLinks;
import cerent.cms.model.ucp.UcpInterfaceModel;
import cerent.cms.model.ucp.UcpLinkModel;
import cerent.cms.model.ucp.UcpNodeModel;
import cerent.util.AnnotatedException;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.omg.CORBA.UserException;

public class UcpInterfaces
extends AbstractUcpContainers
implements IUcpLinks {
    private static final String MY_DEBUG_KEY = "UcpInterfaces";
    private InterfacesList interfacesList;
    private CreateInterface createInterface;
    private UcpNodeModel parent;
    private Map linksByIndex;
    private static NodeSingletonFactory<UcpInterfaces> sfactory = new NodeSingletonFactory<UcpInterfaces>(UcpInterfaces.class);

    public static UcpInterfaces getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private UcpInterfaces(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate, nodeModelDelegate.getDebug());
        this.parent = nodeModelDelegate.getUcpNodeModel();
        this.interfacesList = new InterfacesList(nodeModelDelegate, "UcpInterfaces::interfacesList");
        this.createInterface = new CreateInterface(nodeModelDelegate, "UcpInterfaces::createInterface");
        this.linksByIndex = Collections.synchronizedMap(new HashMap());
        this.db = new UcpInterfacesDebug(nodeModelDelegate.getDebug());
    }

    public INodeModel getNodeModel() {
        return this.node;
    }

    public void create(sUcpInterface sUcpInterface2) throws ObjDuplicate, InvalidParams, NoMoreUcpInterfaces {
        try {
            Object[] objectArray = new Object[]{sUcpInterface2};
            this.createInterface.set(objectArray);
        }
        catch (xObjDuplicate xObjDuplicate2) {
            throw new ObjDuplicate(AnnotatedException.getString((Exception)((Object)xObjDuplicate2)));
        }
        catch (xInvalidParams xInvalidParams2) {
            throw new InvalidParams(AnnotatedException.getString((Exception)((Object)xInvalidParams2)));
        }
        catch (xNoMoreUcpInterfaces xNoMoreUcpInterfaces2) {
            throw new NoMoreUcpInterfaces(AnnotatedException.getString((Exception)((Object)xNoMoreUcpInterfaces2)));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        if (this.db.on()) {
            this.db.println("UcpInterfaceModel created with index = " + sUcpInterface2.index);
        }
        this.createProcessed = true;
    }

    public boolean isUcpInterface(int n) {
        UcpInterfaceModel ucpInterfaceModel = (UcpInterfaceModel)this.itemsByIndex.get(new Integer(n));
        return ucpInterfaceModel != null;
    }

    public UcpInterfaceModel getByIndex(int n) throws NoSuchUcpInterface {
        Object var2_2 = null;
        UcpInterfaceModel ucpInterfaceModel = (UcpInterfaceModel)this.itemsByIndex.get(new Integer(n));
        if (ucpInterfaceModel == null) {
            throw new NoSuchUcpInterface("ifIndex = " + n + " not found.");
        }
        return ucpInterfaceModel;
    }

    public UcpInterfaceModel[] getInterfacesList() {
        UcpInterfaceModel[] ucpInterfaceModelArray = new UcpInterfaceModel[this.itemsByIndex.values().size()];
        ucpInterfaceModelArray = this.itemsByIndex.values().toArray(ucpInterfaceModelArray);
        return ucpInterfaceModelArray;
    }

    public IUcpLinkModel[] getLinks() {
        IUcpLinkModel[] iUcpLinkModelArray = new UcpLinkModel[this.linksByIndex.values().size()];
        iUcpLinkModelArray = this.linksByIndex.values().toArray(iUcpLinkModelArray);
        return iUcpLinkModelArray;
    }

    public void init() {
        super.init();
        this.discover(this.itemsByIndex, this.linksByIndex);
        Iterator iterator = this.itemsByIndex.values().iterator();
        while (iterator.hasNext()) {
            ((UcpInterfaceModel)iterator.next()).init();
        }
        iterator = this.linksByIndex.values().iterator();
        while (iterator.hasNext()) {
            ((UcpLinkModel)iterator.next()).init();
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
    }

    private void discover(Map map, Map map2) {
        sUcpInterface[] sUcpInterfaceArray = null;
        sUcpInterfaceArray = this.getUcpInterfaces();
        if (sUcpInterfaceArray == null) {
            this.db.println("Error in getting UcpInterfaces (null) UcpInterfaces::discover");
            return;
        }
        for (int i = 0; i < sUcpInterfaceArray.length; ++i) {
            if (sUcpInterfaceArray[i] == null) continue;
            Integer n = new Integer(sUcpInterfaceArray[i].index);
            map.put(n, new UcpInterfaceModel(this.node, this, sUcpInterfaceArray[i], null));
            map2.put(n, new UcpLinkModel(this.node, this, sUcpInterfaceArray[i], null));
        }
    }

    private sUcpInterface[] getUcpInterfaces() {
        sUcpInterface[] sUcpInterfaceArray = new sUcpInterface[]{};
        try {
            sUcpInterfaceArray = (sUcpInterface[])this.interfacesList.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
        return sUcpInterfaceArray;
    }

    private void discoverInterfaces(HashMap hashMap) {
        sUcpInterface[] sUcpInterfaceArray = this.getUcpInterfaces();
        if (sUcpInterfaceArray == null) {
            return;
        }
        for (int i = 0; i < sUcpInterfaceArray.length; ++i) {
            hashMap.put(new Integer(sUcpInterfaceArray[i].index), sUcpInterfaceArray[i]);
        }
    }

    protected ObjectType getObjectType() {
        return ObjectType.ObjectUcpInterfaceList;
    }

    protected boolean updateStructure() {
        UcpLinkModel ucpLinkModel;
        UcpInterfaceModel ucpInterfaceModel;
        Object object;
        Object object2;
        HashMap hashMap = new HashMap();
        boolean bl = false;
        this.discoverInterfaces(hashMap);
        Collection collection = UcpInterfaces.getAddedObjects(hashMap.keySet(), this.itemsByIndex.keySet());
        Iterator iterator = collection.iterator();
        if (collection.size() > 0) {
            while (iterator.hasNext()) {
                object2 = (Integer)iterator.next();
                object = (sUcpInterface)hashMap.get(object2);
                ucpInterfaceModel = new UcpInterfaceModel(this.node, this, (sUcpInterface)object, null);
                ucpLinkModel = new UcpLinkModel(this.node, this, (sUcpInterface)object, null);
                this.itemsByIndex.put(object2, ucpInterfaceModel);
                this.linksByIndex.put(object2, ucpLinkModel);
                ucpInterfaceModel.init();
                ucpLinkModel.init();
            }
            bl = true;
        }
        if (this.createProcessed) {
            bl = true;
            this.createProcessed = false;
        }
        if ((object2 = UcpInterfaces.getDeletedObjects(hashMap.keySet(), this.itemsByIndex.keySet())).size() > 0) {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (Integer)iterator.next();
                ucpInterfaceModel = (UcpInterfaceModel)this.itemsByIndex.get(object);
                ucpLinkModel = (UcpLinkModel)this.linksByIndex.get(object);
                if (ucpInterfaceModel != null) {
                    this.itemsByIndex.remove(object);
                }
                if (ucpLinkModel == null) continue;
                this.linksByIndex.remove(object);
            }
        }
        return bl;
    }

    public void remove(UcpInterfaceModel ucpInterfaceModel) {
        this.itemsByIndex.remove(new Integer(ucpInterfaceModel.getIndex()));
        this.linksByIndex.remove(new Integer(ucpInterfaceModel.getIndex()));
    }

    public void removeLink(UcpLinkModel ucpLinkModel) {
        this.linksByIndex.remove(new Integer(ucpLinkModel.getIndex()));
    }

    public boolean isUcpPortIndex(int n) {
        UcpLinkModel ucpLinkModel = (UcpLinkModel)this.linksByIndex.get(new Integer(n));
        return ucpLinkModel != null;
    }

    protected void disposeItems(ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                ((UcpInterfaceModel)iterator.next()).dispose();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("UcpInterfaces dispose called");
        }
        ArrayList arrayList = new ArrayList(this.linksByIndex.values());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                ((UcpLinkModel)iterator.next()).dispose();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.linksByIndex.clear();
        super.dispose();
    }

    protected void printUcpInterfaceString(SDebug sDebug) {
        if (this.itemsByIndex == null || this.itemsByIndex.size() == 0) {
            sDebug.println("No UcpInterfaceModel's contained in UcpInterfaces");
            return;
        }
        sDebug.println("UCPINTERFACES total size: " + this.itemsByIndex.values().size());
        Iterator iterator = this.itemsByIndex.values().iterator();
        while (iterator.hasNext()) {
            try {
                UcpInterfaceModel ucpInterfaceModel = (UcpInterfaceModel)iterator.next();
                sDebug.println("===============================================\n");
                ucpInterfaceModel.printString(sDebug);
            }
            catch (Exception exception) {
                sDebug.println("Got Exception " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected void printUcpLinkString(SDebug sDebug) {
        if (this.linksByIndex == null || this.linksByIndex.size() == 0) {
            sDebug.println("No UcpLinkModel's contained in UcpInterfaces");
            return;
        }
        sDebug.println("UCPLINKS total size: " + this.linksByIndex.values().size());
        Iterator iterator = this.linksByIndex.values().iterator();
        while (iterator.hasNext()) {
            try {
                UcpLinkModel ucpLinkModel = (UcpLinkModel)iterator.next();
                sDebug.println("===============================================\n");
                ucpLinkModel.printString(sDebug);
            }
            catch (Exception exception) {
                sDebug.println("Got Exception " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public class UcpInterfacesDebug
    extends SDebug {
        UcpInterfacesDebug(KDebug kDebug) {
            super(kDebug, UcpInterfaces.MY_DEBUG_KEY);
        }

        public final void dumpAllUcpInterfaceModels() {
            UcpInterfaces.this.printUcpInterfaceString(this);
        }

        public final void dumpAllUcpLinkModels() {
            UcpInterfaces.this.printUcpLinkString(this);
        }
    }

    private class CreateInterface
    extends NonCachedValue {
        public CreateInterface(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            this.node.getIorRepository().getUcpInterfacesRef().create((sUcpInterface)objectArray[0]);
        }

        public Object outer() {
            return UcpInterfaces.this;
        }
    }

    private class InterfacesList
    extends NonCachedValue {
        public InterfacesList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getUcpInterfacesRef().getUcpInterfaces();
        }

        public Object outer() {
            return UcpInterfaces.this;
        }
    }
}

