/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.ConfigError;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractPmTableModel;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.PmCellRenderer;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public abstract class AbstractPmPane
extends AbstractPane
implements ActionListener,
PropertyChangeListener {
    public static final String IGNORABLE_AUTO_REFRESH_MSG = "The selected auto-refresh value will be applied to all\nperformance monitoring for the current user. ";
    public static final String IGNORABLE_AUTO_REFRESH_TITLE = "Notice";
    public static final String IGNORABLE_AUTO_REFRESH_PREF = "IgnoreAutoRefreshMessage";
    public static final String IGNORABLE_AUTO_REFRESH_DESCR = "Warn auto refresh affects all performance monitoring for user";
    private TableColumnModel dataColumnModel;
    protected AbstractPmTableModel model;
    protected int interval;
    protected int indexOfFirstCB;
    private TableColumn[] saveColumns;
    private boolean tableHasAllColumns;
    private static final String LONGEST_PARAM_NAME = "Transceiver Voltage (Unit)";
    public static final String REFRESH = "Refresh";
    public static final String ZERO = "Clear";
    public static final String ZERO_TOOLTIP = "Initializes current registers to zero";
    protected JPanel controlBar;
    protected JRadioButton dayRB;
    protected JRadioButton minuteRB;
    protected JRadioButton oneMinuteRB;
    protected JRadioButton hourRB;
    private JButton refreshPB;
    protected JButton zeroPB;
    protected JLabel dateLB;
    private JButton baselinePB;
    private Timer refreshTimer;
    private RefreshTimerListener refreshTimerListener;
    private boolean isCurrentPmPane = false;
    private static final String[] rateStrs = new String[]{"None", "15 Seconds", "30 Seconds", "1 Minute", "3 Minutes", "5 Minutes"};
    private static final int[] rates = new int[]{86400000, 15000, 30000, 60000, 180000, 300000};
    private JComboBox refreshComboBox;
    private boolean enteringPage = false;
    protected static final String autoRefreshPrefPath = "ctc";
    protected static final String autoRefreshPrefKey = "PM-auto-refresh-rate";
    private TableColumn colZero = null;
    protected JTable table2 = null;

    public AbstractPmPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    protected void init() {
        this.refreshTimerListener = new RefreshTimerListener();
        this.setDefaultPrivilegeLevel(SecurityLevel.MAINTENANCE);
        this.tableHasAllColumns = true;
        this.interval = 0;
        this.setLayout(new BorderLayout());
        this.model = this.getDataModel();
        this.isCurrentPmPane = this.getName().startsWith("Current");
        this.add(this.createButtonBar(), "South");
        this.add(this.createTable(), "Center");
    }

    protected abstract AbstractPmTableModel getDataModel();

    public void actionPerformed(ActionEvent actionEvent) {
        this.setCursor(3);
        Object object = actionEvent.getSource();
        if (object == this.dayRB) {
            if (this.interval != 1) {
                this.interval = 1;
                this.model.setIntervalType(this.interval);
            }
        } else if (object == this.minuteRB) {
            if (this.interval != 0) {
                this.interval = 0;
                this.model.setIntervalType(this.interval);
            }
        } else if (object == this.oneMinuteRB) {
            if (this.interval != 2) {
                this.interval = 2;
                this.model.setIntervalType(this.interval);
            }
        } else if (object == this.hourRB) {
            if (this.interval != 3) {
                this.interval = 3;
                this.model.setIntervalType(this.interval);
            }
        } else if (object == this.refreshPB) {
            if (db.isFineEnabled()) {
                db.fine("class name = " + this.getClass().getName());
            }
            this.refreshNow();
        } else if (object == this.zeroPB) {
            this.clearStats();
        } else if (object == this.baselinePB) {
            this.setBaseline();
        } else {
            this.localActionPerformed(actionEvent);
        }
        this.setCursor(0);
    }

    private void setBaseline() {
        try {
            this.refreshNow();
            this.model.setBaseline();
            this.table.revalidate();
            this.table.repaint();
        }
        catch (Exception exception) {
            if (db.isSevereEnabled()) {
                db.severe("Caught exception in setBaseline.");
                SDebug.printStackTrace((Throwable)exception);
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_FAIL_BASELINE_SET);
        }
    }

    protected void localActionPerformed(ActionEvent actionEvent) {
    }

    protected void clearStats() {
        try {
            db.info("AbstractPmPane.clearStats()");
            this.maybeClearCurrentStats();
        }
        catch (Exception exception) {
            db.severe("Caught exception in clearStats.");
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_FAIL_CLEAR_STATS);
        }
    }

    protected void maybeClearCurrentStats() throws NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, UnsupportedOperation {
        if (CerentDialog.yesNoDialog((Component)((Object)this), (String)("Proceeding will clear these statistics on the card\nand cannot be undone.  Do you really want to initialize\nall " + (this.interval == 0 ? "15-minute" : (this.interval == 1 ? "1-day" : (this.interval == 2 ? "1-minute" : (this.interval == 3 ? "1-hour" : "!ERROR!")))) + " registers in the Curr column to zero?"), (String)"Zero Data")) {
            this.model.clearStats();
            this.model.tossData();
            this.reDraw();
            this.updateTimeLabel();
        }
    }

    private JComponent createTable() {
        this.table = new UTable((TableModel)this.model);
        this.table.getTableHeader().setUpdateTableInRealTime(true);
        this.table.setDefaultRenderer(this.model.getColumnClass(1), this.getPmCellRenderer());
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table2 = new UTable((TableModel)this.model);
        ((UTable)this.table2).setExportable(false);
        this.table2.getTableHeader().setUpdateTableInRealTime(false);
        this.dataColumnModel = this.table.getColumnModel();
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        this.colZero = this.dataColumnModel.getColumn(0);
        Font font = this.table.getTableHeader().getFont();
        FontMetrics fontMetrics = this.table.getTableHeader().getFontMetrics(font);
        int n = fontMetrics.stringWidth(LONGEST_PARAM_NAME) + 20;
        this.colZero.setPreferredWidth(n);
        this.colZero.setMinWidth(n);
        int n2 = this.getSaveColumnsIndex();
        int n3 = this.model.getColumnCount() - n2;
        if (n3 > 0) {
            this.saveColumns = new TableColumn[n3];
            for (int i = 0; i < n3; ++i) {
                this.saveColumns[i] = this.dataColumnModel.getColumn(i + n2);
            }
        }
        this.dataColumnModel.removeColumn(this.colZero);
        defaultTableColumnModel.addColumn(this.colZero);
        this.table2.setColumnModel(defaultTableColumnModel);
        this.table2.setPreferredScrollableViewportSize(new Dimension(this.colZero.getPreferredWidth() + this.table2.getColumnModel().getColumnMargin(), 0));
        this.table2.getTableHeader().setReorderingAllowed(false);
        uScrollPane.setRowHeaderView((Component)this.table2);
        uScrollPane.setCorner("UPPER_LEFT_CORNER", (Component)this.table2.getTableHeader());
        this.table.setAutoCreateColumnsFromModel(false);
        this.table2.setAutoCreateColumnsFromModel(false);
        this.colZero.addPropertyChangeListener(this);
        return uScrollPane;
    }

    protected abstract int getSaveColumnsIndex();

    private JPanel createButtonBar() {
        db.fine("createButtonBar");
        JPanel jPanel = AbstractPmPane.createVerticalPanel(null);
        JPanel jPanel2 = AbstractPmPane.createHorizontalPanel(null);
        jPanel2.setLayout(new FlowLayout(0, 5, 5));
        this.controlBar = AbstractPmPane.createHorizontalPanel(null);
        this.controlBar.add(this.getEndIntervalBars());
        this.indexOfFirstCB = this.controlBar.getComponentCount();
        this.refreshPB = new JButton(REFRESH);
        this.refreshPB.addActionListener(this);
        this.refreshPB.setAlignmentY(0.5f);
        this.controlBar.add(Box.createHorizontalStrut(4));
        this.controlBar.add(this.refreshPB);
        this.refreshComboBox = new UComboBox((Object[])rateStrs);
        this.refreshComboBox.addItemListener(new RefreshComboBoxListener());
        this.controlBar.add(Box.createHorizontalGlue());
        this.controlBar.add(new JLabel("Auto-refresh:"));
        this.controlBar.add(Box.createHorizontalStrut(4));
        this.controlBar.add(this.refreshComboBox);
        this.controlBar.add(Box.createHorizontalGlue());
        this.baselinePB = this.createBaselineButton();
        this.zeroPB = new JButton(ZERO);
        this.zeroPB.setMinimumSize(new Dimension(75, this.zeroPB.getPreferredSize().height));
        this.zeroPB.addActionListener(this);
        this.zeroPB.setAlignmentY(0.5f);
        this.zeroPB.setToolTipText(ZERO_TOOLTIP);
        this.enableComponent(this.zeroPB);
        this.controlBar.add(this.zeroPB);
        this.controlBar.add(Box.createHorizontalStrut(4));
        CSHelpID cSHelpID = this.getHelpID();
        if (cSHelpID != null) {
            CSHelpButton cSHelpButton = new CSHelpButton(cSHelpID);
            cSHelpButton.setMinimumSize(new Dimension(75, cSHelpButton.getPreferredSize().height));
            cSHelpButton.setAlignmentY(0.5f);
            this.controlBar.add(cSHelpButton);
            this.controlBar.add(Box.createHorizontalStrut(4));
        }
        this.dateLB = new JLabel("");
        this.updateTimeLabel();
        jPanel2.add(this.dateLB);
        jPanel.add(this.controlBar);
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected JButton createBaselineButton() {
        JButton jButton = new JButton("Baseline");
        jButton.setMinimumSize(new Dimension(75, jButton.getPreferredSize().height));
        jButton.addActionListener(this);
        jButton.setToolTipText("Sets a baseline for the current values - gets reset if the path through the PM data is changed at all.");
        this.controlBar.add(jButton);
        this.controlBar.add(Box.createHorizontalStrut(4));
        return jButton;
    }

    protected JPanel getEndIntervalBars() {
        JPanel jPanel = AbstractPmPane.createHorizontalPanel(null);
        JPanel jPanel2 = AbstractPmPane.createVerticalPanel(null);
        jPanel2.setBorder(BorderFactory.createTitledBorder(" Intervals "));
        jPanel2.setPreferredSize(new Dimension(90, 77));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.minuteRB = new JRadioButton("15 min", true);
        buttonGroup.add(this.minuteRB);
        this.dayRB = new JRadioButton("1 day");
        buttonGroup.add(this.dayRB);
        this.minuteRB.addActionListener(this);
        this.dayRB.addActionListener(this);
        jPanel2.add(this.minuteRB);
        jPanel2.add(this.dayRB);
        JPanel jPanel3 = this.getEndBar();
        if (jPanel3 != null) {
            jPanel3.setBorder(BorderFactory.createTitledBorder(" Directions "));
            jPanel3.setPreferredSize(new Dimension(90, 77));
            jPanel.add(Box.createHorizontalStrut(4));
            jPanel.add(jPanel3);
        }
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected JPanel getEndBar() {
        return null;
    }

    public void reDraw() {
        db.fine("reDraw");
        if (this.tableHasAllColumns != (this.interval == 0)) {
            int n;
            if (this.interval == 0) {
                for (n = 0; n < this.saveColumns.length; ++n) {
                    this.dataColumnModel.addColumn(this.saveColumns[n]);
                }
                this.tableHasAllColumns = true;
            } else {
                for (n = 0; n < this.saveColumns.length; ++n) {
                    this.dataColumnModel.removeColumn(this.saveColumns[n]);
                }
                this.tableHasAllColumns = false;
            }
        }
        TableModelEvent tableModelEvent = new TableModelEvent(this.model);
        this.table.tableChanged(tableModelEvent);
        if (this.table2 != null) {
            this.table2.tableChanged(tableModelEvent);
        }
    }

    protected void updateTimeLabel() {
        String string = DateFormat.getDateTimeInstance(1, 1).format(new Date());
        String string2 = (this.interval == 0 ? "15-minute" : "1-day") + ", registers at " + string;
        this.dateLB.setText(string2);
    }

    protected PmCellRenderer getPmCellRenderer() {
        return new PmCellRenderer();
    }

    private int getIndexForMillis(int n) {
        int n2 = 0;
        for (int i = 0; i < rates.length; ++i) {
            if (rates[i] != n) continue;
            n2 = i;
        }
        return n2;
    }

    private void saveAutoRefreshPref() {
        if (null != this.refreshComboBox) {
            int n = this.refreshComboBox.getSelectedIndex();
            int n2 = rates[n];
            Preferences.instance().setInt(autoRefreshPrefPath, autoRefreshPrefKey, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() throws Exception {
        this.enteringPage = true;
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            int n = Preferences.instance().getInt(autoRefreshPrefPath, autoRefreshPrefKey, 0);
            if (null != this.refreshComboBox) {
                int n2 = this.getIndexForMillis(n);
                this.refreshComboBox.setSelectedIndex(n2);
                if (null != this.refreshTimer) {
                    if (0 == n2) {
                        db.fine("Stopping auto-refresh timer : A");
                        this.refreshTimer.stop();
                    } else if (!this.refreshTimer.isRunning()) {
                        if (db.isFineEnabled()) {
                            db.fine("Starting auto-refresh timer.B delay = " + this.refreshTimer.getDelay());
                        }
                        this.refreshTimer.start();
                    } else if (db.isFineEnabled()) {
                        db.fine("refreshTimer was already running with delay = " + this.refreshTimer.getDelay());
                    }
                }
            }
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
            this.refreshNow();
            Preferences.instance().addPropertyChangeListener((PropertyChangeListener)this);
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
            this.enteringPage = false;
        }
    }

    public void leavingPage() throws Exception {
        db.fine("AbstractPmPane.leavingPage()");
        if (null != this.refreshTimer) {
            db.fine("Stopping auto-refresh timer : B");
            this.refreshTimer.stop();
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        Preferences.instance().removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void dispose() {
        db.fine("AbstractPmPane.dispose()");
        try {
            this.leavingPage();
        }
        catch (Exception exception) {
            db.finer("Exception in dispose(): " + exception);
        }
        if (this.table2 != null) {
            this.table2 = null;
        }
        if (this.colZero != null) {
            this.colZero = null;
        }
        if (this.model != null) {
            this.model.destroy();
            this.model = null;
        }
        super.dispose();
    }

    public void refresh() {
    }

    protected void refreshNow() {
        this.model.tossData();
        this.reDraw();
        this.updateTimeLabel();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.table2 == null || this.colZero == null) {
            db.severe("propertyChange() : on disposed table model");
        } else {
            this.table2.setPreferredScrollableViewportSize(new Dimension(this.colZero.getWidth() + this.table2.getColumnModel().getColumnMargin(), 0));
        }
    }

    private class RefreshTimerListener
    implements ActionListener {
        private RefreshTimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractPmPane.this.refreshNow();
        }
    }

    private class RefreshComboBoxListener
    implements ItemListener {
        private RefreshComboBoxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (1 == itemEvent.getStateChange()) {
                int n = AbstractPmPane.this.refreshComboBox.getSelectedIndex();
                if (!AbstractPmPane.this.enteringPage) {
                    IgnorableDialog.infoDialog((Component)AbstractPmPane.this.getParentView(), (String)AbstractPmPane.IGNORABLE_AUTO_REFRESH_MSG, (String)AbstractPmPane.IGNORABLE_AUTO_REFRESH_TITLE, (String)AbstractPmPane.IGNORABLE_AUTO_REFRESH_PREF, (String)AbstractPmPane.IGNORABLE_AUTO_REFRESH_DESCR);
                }
                if (n == 0) {
                    if (AbstractPmPane.this.refreshTimer.isRunning()) {
                        if (AbstractPane.db.on()) {
                            AbstractPane.db.println("Stopping auto-refresh timer.C");
                        }
                        AbstractPmPane.this.refreshTimer.stop();
                    }
                } else if (n > 0 && n < rates.length) {
                    if (null != AbstractPmPane.this.refreshTimer) {
                        if (AbstractPane.db.on()) {
                            AbstractPane.db.println("Stopping auto-refresh timer.D");
                        }
                        AbstractPmPane.this.refreshTimer.stop();
                    }
                    AbstractPmPane.this.refreshTimer = null;
                    AbstractPmPane.this.refreshTimer = new Timer(rates[n], AbstractPmPane.this.refreshTimerListener);
                    if (AbstractPane.db.on()) {
                        AbstractPane.db.println("Starting auto-refresh timer.A");
                    }
                    AbstractPmPane.this.refreshTimer.start();
                } else {
                    if (AbstractPane.db.on()) {
                        AbstractPane.db.println("Stopping auto-refresh timer.E");
                    }
                    AbstractPmPane.this.refreshTimer.stop();
                }
                AbstractPmPane.this.saveAutoRefreshPref();
            }
        }
    }
}

