/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.idl.If.eALSMode;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.intpatch.IntPatchHelper;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class AlsTableModel
extends AbstractTableModel {
    protected boolean[][] isDirty = null;
    protected Attribute[] alsModeVal = null;
    protected Integer[] alsRecIntVal = null;
    protected Float[] alsPulseWidthVal = null;
    protected Boolean[] laserShutdownVal = null;
    protected Boolean[] restartLaserVal = null;
    public static final String[] columnNames = new String[]{"Port ", "ALS Mode", "Recovery Pulse Duration (sec)", "Recovery Pulse Interval (sec)", "Currently Shutdown", "Request Laser Restart"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int ALSMODE_INDEX = 1;
    public static final int ALSPULWID_INDEX = 2;
    public static final int ALSRECINT_INDEX = 3;
    public static final int LASER_SHUTDOWN_INDEX = 4;
    public static final int RESTART_LASER_INDEX = 5;
    protected int numLines;
    protected InterfaceModel[] model;
    protected EntityCellRenderer myPortRenderer;
    protected String[] portNames;
    protected ModuleModel eqpmtModel;
    private static final SDebug db = new SDebug("AlsTableModel");

    public AlsTableModel(ModuleModel moduleModel, InterfaceModel[] interfaceModelArray) {
        this.eqpmtModel = moduleModel;
        this.model = interfaceModelArray;
        this.myPortRenderer = new EntityCellRenderer(false);
        this.init();
    }

    private void init() {
        this.numLines = this.model.length;
        this.portNames = new String[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.alsModeVal = new Attribute[this.numLines];
        this.alsRecIntVal = new Integer[this.numLines];
        this.alsPulseWidthVal = new Float[this.numLines];
        this.laserShutdownVal = new Boolean[this.numLines];
        this.restartLaserVal = new Boolean[this.numLines];
        this.resetDirtyBits();
    }

    public void refreshMyLines(InterfaceModel[] interfaceModelArray) {
        this.model = interfaceModelArray;
        this.init();
        this.fireTableDataChanged();
        if (db.on()) {
            db.println("Refreshing the table lines...");
            db.println("New models = " + this.model);
        }
    }

    protected Attribute getAlsMode(int n) {
        if (this.alsModeVal[n] == null) {
            try {
                int n2 = this.model[n].getALSMode();
                this.alsModeVal[n] = ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeForVal("AlsMode", n2);
            }
            catch (NoSuchInterface noSuchInterface) {
                db.severe("Error in getting ALS Mode:" + noSuchInterface.toString());
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                db.severe("Error in getting ALS Mode:" + wrongInterfaceType.toString());
            }
        }
        db.fine("ALS Mode is " + this.alsModeVal[n].toString());
        return this.alsModeVal[n];
    }

    protected Integer getAlsRecoveryInt(int n) {
        if (this.alsRecIntVal[n] == null) {
            try {
                this.alsRecIntVal[n] = new Integer(this.model[n].getALSRecoveryInterval());
            }
            catch (NoSuchInterface noSuchInterface) {
                db.severe("Error in getting ALS Pulse Interval:" + noSuchInterface.toString());
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                db.severe("Error in getting ALS Pulse Interval:" + wrongInterfaceType.toString());
            }
        }
        db.fine("ALS Recovery Interval is " + this.alsRecIntVal[n].toString());
        return this.alsRecIntVal[n];
    }

    protected Float getAlsPulseWidth(int n) {
        if (this.alsPulseWidthVal[n] == null) {
            try {
                this.alsPulseWidthVal[n] = new Float(this.model[n].getALSRecoveryPulseWidth());
            }
            catch (NoSuchInterface noSuchInterface) {
                db.severe("Error in getting ALS Pulse Width:" + noSuchInterface.toString());
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                db.severe("Error in getting ALS Mode:" + wrongInterfaceType.toString());
            }
        }
        db.fine("ALS Pulse Width is " + this.alsPulseWidthVal[n].toString());
        return this.alsPulseWidthVal[n];
    }

    protected Boolean getHasLaserBeenShutdown(int n) throws Exception {
        if (this.laserShutdownVal[n] == null) {
            this.laserShutdownVal[n] = this.model[n].hasLaserBeenShutdown() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.laserShutdownVal[n];
    }

    protected Boolean getRestartLaser(int n) {
        if (this.restartLaserVal[n] == null) {
            this.restartLaserVal[n] = Boolean.FALSE;
        }
        db.fine("Restart laser is " + this.restartLaserVal[n].toString());
        return this.restartLaserVal[n];
    }

    private boolean alsRISanityCheck(int n, Integer n2) {
        int n3;
        int n4;
        int n5;
        boolean bl;
        block18: {
            bl = true;
            n5 = 60;
            n4 = 300;
            n3 = n2;
            ModuleModel moduleModel = null;
            try {
                moduleModel = this.model[n].getModuleModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.fine(abstractCmsNoSuchEntityException.toString());
                bl = false;
            }
            if (!bl || moduleModel == null) {
                bl = false;
            } else {
                int n6 = moduleModel.getEqType();
                if (n6 == 182 || n6 == 276 || n6 == 181 || n6 == 274 || n6 == 275 || n6 == 243 || n6 == 282 || n6 == 271 || n6 == 293 || n6 == 272) {
                    try {
                        if (this.isTrunkPort(n)) {
                            n5 = 200;
                            n4 = 2000;
                            break block18;
                        }
                        n5 = 100;
                        n4 = 2000;
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        db.fine(abstractCmsNoSuchEntityException.toString());
                        bl = false;
                    }
                } else if (n6 == 273) {
                    try {
                        if (this.isTrunkPort(n)) {
                            n5 = 200;
                            n4 = 2000;
                        } else if (this.isInterlinkPort(n)) {
                            n5 = 60;
                            n4 = 300;
                        } else {
                            n5 = 100;
                            n4 = 2000;
                        }
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        db.fine(abstractCmsNoSuchEntityException.toString());
                        bl = false;
                    }
                }
            }
        }
        if (bl) {
            boolean bl2 = bl = n3 >= n5 && n3 <= n4;
        }
        if (!bl) {
            ErrorMsg.displayError(this.getFrame(), EMC.EID_ALS_RECOVERY_INT_RANGE_PARM_2, Integer.toString(n5), Integer.toString(n4));
        }
        return bl;
    }

    private boolean alsPWSanityCheck(int n, Float f) {
        boolean bl = true;
        float f2 = 2.0f;
        float f3 = 100.0f;
        float f4 = f.floatValue();
        System.err.println("value " + f4 + " val " + f);
        if (this.alsModeVal[n].getIntValue() == 3) {
            f2 = 80.0f;
            f3 = 100.0f;
        } else {
            ModuleModel moduleModel = null;
            try {
                moduleModel = this.model[n].getModuleModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                bl = false;
                db.fine(abstractCmsNoSuchEntityException.toString());
            }
            if (!bl || moduleModel == null) {
                bl = false;
            } else {
                int n2 = moduleModel.getEqType();
                if (n2 == 182 || n2 == 276 || n2 == 181 || n2 == 274 || n2 == 275 || n2 == 243 || n2 == 282 || n2 == 271 || n2 == 293 || n2 == 272) {
                    try {
                        if (this.isTrunkPort(n)) {
                            f2 = 60.0f;
                            f3 = 200.0f;
                        }
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        db.fine(abstractCmsNoSuchEntityException.toString());
                        bl = false;
                    }
                } else if (n2 == 273) {
                    try {
                        if (this.isTrunkPort(n)) {
                            f2 = 60.0f;
                            f3 = 200.0f;
                        } else {
                            f2 = 2.0f;
                            f3 = 100.0f;
                        }
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        db.fine(abstractCmsNoSuchEntityException.toString());
                        bl = false;
                    }
                }
            }
        }
        if (bl) {
            boolean bl2 = bl = !(f4 < f2) && !(f4 > f3);
        }
        if (!bl) {
            ErrorMsg.displayError(this.getFrame(), EMC.EID_ALS_RECOVERY_PULSE_WIDTH_RANGE_PARM_2, Float.toString(f2), Float.toString(f3));
        }
        return bl;
    }

    public void setValueAt(Object object, int n, int n2) {
        db.fine("Change in value " + n + " " + n2);
        switch (n2) {
            case 1: {
                Attribute attribute = (Attribute)object;
                if (attribute == this.alsModeVal[n]) {
                    return;
                }
                if (!this.model[n].supportsAutoALS() && eALSMode.from_int(attribute.getIntValue()) == eALSMode.AUTO) {
                    ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_AUTO_RESTART_NOT_SUPPORTED);
                    return;
                }
                if (this.model[n] instanceof DwdmTrkLineModel) {
                    try {
                        if (IntPatchHelper.isPortAlreadyUsed((IEntityModel)this.model[n].getPortModel()) && attribute.getIntValue() != 0 && !ErrorMsg.displayWarningYesNo(this.getFrame(), (EID)EMC.WID_ALS_FOR_DWDM_TRUNK, "ALS Mode")) {
                            return;
                        }
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        db.fine(abstractCmsNoSuchEntityException.toString());
                        return;
                    }
                }
                this.alsModeVal[n] = attribute;
                if (this.alsModeVal[n].getIntValue() == 2 || this.alsModeVal[n].getIntValue() == 3 || this.restartLaserVal[n] == Boolean.FALSE) break;
                this.restartLaserVal[n] = Boolean.FALSE;
                this.isDirty[n][5] = true;
                this.fireTableCellUpdated(n, 5);
                break;
            }
            case 3: {
                Integer n3;
                try {
                    n3 = Integer.valueOf((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    this.displayInvalidNumberDialog(3);
                    return;
                }
                if (this.alsRecIntVal[n].equals(n3) || !this.alsRISanityCheck(n, n3)) {
                    return;
                }
                this.alsRecIntVal[n] = n3;
                break;
            }
            case 2: {
                Float f;
                try {
                    f = Float.valueOf((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    this.displayInvalidNumberDialog(2);
                    return;
                }
                if (this.alsPulseWidthVal[n].equals(f) || !this.alsPWSanityCheck(n, f)) {
                    return;
                }
                this.alsPulseWidthVal[n] = f;
                break;
            }
            case 5: {
                Boolean bl = (Boolean)object;
                if (this.restartLaserVal[n].equals(bl)) {
                    return;
                }
                this.restartLaserVal[n] = bl;
                break;
            }
            default: {
                return;
            }
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    private void displayInvalidNumberDialog(int n) {
        JOptionPane.showMessageDialog(this.getFrame(), "An invalid number was entered in column " + this.getColumnName(n) + ".", "Invalid Number Entered", 0);
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public eALSMode getAlsModeValFor(int n) {
        return eALSMode.from_int(this.alsModeVal[n].getIntValue());
    }

    private boolean isAlsModeFormOfManual(int n) {
        return n == 2 || n == 3;
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.MAINTENANCE)) {
            if (n2 == 5) {
                try {
                    Boolean bl = this.getHasLaserBeenShutdown(n);
                    if (bl == null) {
                        bl = Boolean.FALSE;
                    }
                    return this.isAlsModeFormOfManual(this.getAlsMode(n).getIntValue()) && bl != false;
                }
                catch (Exception exception) {
                    db.severe("isCellEditable:  Error in getting laser status " + exception);
                }
            } else {
                return n2 != 0 && n2 != 4;
            }
        }
        return false;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 3: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 5: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException, NoSuchInterface, WrongInterfaceType {
        IPortModel iPortModel;
        if (this.model[n] instanceof AbstractDwdmLineModel) {
            iPortModel = ((AbstractDwdmLineModel)this.model[n]).getPayloadModel() != null ? ((AbstractDwdmLineModel)this.model[n]).getPayloadModel().getPortModel() : this.model[n].getPortModel();
        } else {
            if (this.model[n] instanceof AbstractOpticsLineModel) {
                AbstractOpticsLineModel abstractOpticsLineModel = (AbstractOpticsLineModel)this.model[n];
                IPortModel iPortModel2 = abstractOpticsLineModel.getPortModel();
                return PortHelper.getPortNumString((IPortModel)iPortModel2) + " (" + abstractOpticsLineModel.getOptPortTypeString() + ")";
            }
            iPortModel = this.model[n].getPortModel();
        }
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    protected boolean isTrunkPort(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.model[n].getPortModel();
        return iPortModel.getEqType() == 123;
    }

    protected boolean isInterlinkPort(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.model[n].getPortModel();
        return iPortModel.getEqType() == 280;
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return this.getAlsMode(n);
                }
                case 3: {
                    return this.getAlsRecoveryInt(n);
                }
                case 2: {
                    return this.getAlsPulseWidth(n);
                }
                case 4: {
                    return this.getHasLaserBeenShutdown(n) != false ? "YES" : "NO";
                }
                case 5: {
                    return this.getRestartLaser(n);
                }
            }
        }
        catch (Exception exception) {
            db.severe("getValueAt: Error in getting values " + exception);
        }
        return "N/A";
    }

    private void resetLineCache(int n) {
        this.alsModeVal[n] = null;
        this.alsRecIntVal[n] = null;
        this.alsPulseWidthVal[n] = null;
        this.laserShutdownVal[n] = null;
        this.restartLaserVal[n] = null;
        int n2 = this.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void refreshLineFromModel(int n) {
        db.fine("refreshing line " + n + " from model");
        this.resetLineCache(n);
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshFromModel() {
        db.fine("refreshing table from model");
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public boolean isDirty() {
        int n = this.getColumnCount();
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public void resetDirtyBits() {
        int n = this.getColumnCount();
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < n; ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void applyToModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.isDirty[i][1]) {
                this.model[i].setALSMode(this.getAlsMode(i).getIntValue());
                this.isDirty[i][1] = false;
            }
            if (this.isDirty[i][3]) {
                this.model[i].setALSRecoveryInterval(this.getAlsRecoveryInt(i).shortValue());
                this.isDirty[i][3] = false;
            }
            if (this.isDirty[i][2]) {
                this.model[i].setALSRecoveryPulseWidth(this.getAlsPulseWidth(i).floatValue());
                this.isDirty[i][2] = false;
            }
            if (!this.isDirty[i][5]) continue;
            db.fine("Restarting laser for " + (i + 1));
            boolean bl = this.getRestartLaser(i);
            if (bl) {
                this.model[i].restartLaser();
            }
            this.setValueAt(Boolean.FALSE, i, 5);
            this.isDirty[i][5] = false;
        }
    }

    protected Frame getFrame() {
        return this.eqpmtModel.getNodeModel().getUiToolkit().getApplicationFrame();
    }
}

