/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.idl.Equipment.sObflInfo;
import cerent.cms.model.CtcTimeZone;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.WindowHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ObflPane
extends AbstractPane
implements ActionListener,
Runnable {
    protected static final String OBFL_LABEL = "Start On Board Failure Logging";
    protected JButton button;
    protected boolean inited = false;
    private JLabel infoLabel;
    private Thread pollingT;
    private boolean disposed = false;
    protected static final SDebug db = new SDebug("OBFLPane");

    public ObflPane(String string, TabbedView tabbedView, OpticsModuleModel opticsModuleModel) {
        super(string, opticsModuleModel, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
        this.init();
    }

    protected void init() {
        if (db.on()) {
            db.println("init: start");
        }
        if (this.inited) {
            return;
        }
        this.inited = true;
        JPanel jPanel = ObflPane.createVerticalPanel(null);
        this.add(jPanel);
        jPanel.add(Box.createVerticalStrut(10));
        this.button = new JButton(OBFL_LABEL);
        this.button.addActionListener(this);
        this.button.setDefaultCapable(false);
        this.button.setAlignmentX(0.5f);
        jPanel.add(this.button);
        this.enableComponent(this.button, this.uiModel, SecurityLevel.SUPERUSER);
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        jPanel2.add(jPanel);
        this.setLayout(new BorderLayout());
        this.add(jPanel2, "North");
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.OBFLPane);
        this.infoLabel = this.fillobflInfoLabel();
        cSHelpButtonPane.addLeft(this.infoLabel);
        this.add(Box.createVerticalGlue(), "Center");
        this.add(cSHelpButtonPane, "South");
        if (db.on()) {
            db.println("init: finish");
        }
    }

    private JLabel fillobflInfoLabel() {
        JLabel jLabel = null;
        CtcTimeZone ctcTimeZone = ((NodeModelDelegate)this.getUiModel().getNodeModel()).getCtcTimeZone();
        SimpleDateFormat simpleDateFormat = ctcTimeZone.getDateTimeFormatter();
        sObflInfo sObflInfo2 = ((OpticsModuleModel)this.getUiModel()).getOBFLInfo();
        String string = new String("OBFL status: ");
        switch (sObflInfo2.status.value()) {
            case 2: {
                if (sObflInfo2.timeStamp != 0) {
                    Date date = new Date((long)sObflInfo2.timeStamp * 1000L);
                    jLabel = new JLabel(string + "Idle. Last On Board Failure Logging available: " + simpleDateFormat.format(date));
                }
                this.button.setEnabled(true);
                jLabel = new JLabel(" ");
                break;
            }
            case 3: {
                jLabel = new JLabel(string + "Running.");
                this.button.setEnabled(false);
                break;
            }
            default: {
                this.button.setEnabled(false);
                jLabel = new JLabel(" ");
            }
        }
        return jLabel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object object = actionEvent.getSource();
        if (object == this.button && (n = CerentDialog.questionDialog((Component)SwingUtilities.getWindowAncestor((Component)((Object)this)), (String)"Forcing on board failure log can cause unrecoverable flash erase.\nCisco recommends that you contact Cisco technical support before you proceed.\nDo you want to continue?", (String)"OBFL Info", (int)0)) == 0) {
            this.pollingT = new Thread(this);
            OpticsModuleModel opticsModuleModel = (OpticsModuleModel)this.getUiModel();
            opticsModuleModel.startOFBL();
            CerentDialog.infoDialog((Component)SwingUtilities.getWindowAncestor((Component)((Object)this)), (String)"The on board failure feature has been correctly launched.", (String)"OBFL Info");
            this.infoLabel = this.fillobflInfoLabel();
            WindowHelper.setLabelText((JLabel)this.infoLabel, (String)"");
            this.pollingT.start();
        }
    }

    public void enteringPage() {
        this.disposed = false;
    }

    public void leavingPage() throws Exception {
        this.disposed = true;
    }

    public void refresh() throws Exception {
    }

    public void run() {
        while (!this.disposed) {
            sObflInfo sObflInfo2 = ((OpticsModuleModel)this.getUiModel()).getOBFLInfo();
            this.waitForNextOBFLStatusPoll();
            if (sObflInfo2.status.value() != 2 && !this.disposed) continue;
            this.fillobflInfoLabel();
            return;
        }
    }

    private synchronized void waitForNextOBFLStatusPoll() {
        try {
            this.wait(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

