/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.idl.Ds123Media.eThresholdType;
import cerent.cms.idl.Ds123Media.sThresholds;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds123ModuleModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.GeneralPmThresholdsPane;
import cerent.cms.ui.PmThresholdsTableModel;
import cerent.cms.ui.ResettablePmThresholdsTableModel;
import cerent.cms.ui.TabbedView;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.gui.UTable;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class PmThresholdsPane
extends GeneralPmThresholdsPane
implements TableModelListener {
    protected Ds123LineModel[] lineModels = null;
    protected eThresholdType thresholdType = null;
    protected boolean nearEnd;
    protected PmThresholdsTableModel dataModel = null;
    protected int numLines = 0;
    protected Ds123ModuleModel eqpmtModel = null;
    private static final SDebug db = new SDebug("Pane.PmThresholdsPane");

    public PmThresholdsPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, eThresholdType eThresholdType2, boolean bl) {
        super(string, tabbedView);
        this.lineModels = ds123LineModelArray;
        this.thresholdType = eThresholdType2;
        this.nearEnd = bl;
        TableColumn tableColumn = null;
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        this.initialize();
        this.numLines = ds123LineModelArray != null && ds123LineModelArray.length > 0 ? ds123LineModelArray.length : 0;
        this.registerWithModel();
        this.add(jScrollPane);
    }

    protected abstract PmThresholdsTableModel getDataModel();

    protected ResettablePmThresholdsTableModel dataModel() {
        return this.dataModel;
    }

    protected void initialize() {
    }

    protected void registerWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    public void dispose() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    protected Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                PmThresholdsPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In PmThresholdsPane changeMessage cannot find Model " + observable);
        }
    }

    public void applyChangesToModel() throws Exception {
        int n = 0;
        try {
            for (n = 0; n < this.numLines; ++n) {
                if (db.on()) {
                    db.println("setting at iteration " + n);
                }
                if (!this.dataModel.isRowDirty(n)) continue;
                this.printThresholds(this.dataModel.getThresholdsVal(n));
                this.dataModel.setPmThreshold(this.lineModels[n], this.dataModel.getThresholdsVal(n));
            }
            this.dataModel.resetDirtyBits();
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1) + ".", exception);
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.lineModels == null) {
            return;
        }
        if (db.on()) {
            db.println("Got table changed");
        }
        int n = tableModelEvent.getLastRow() > this.numLines - 1 ? this.numLines - 1 : tableModelEvent.getLastRow();
        for (int i = tableModelEvent.getFirstRow(); i <= n; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            if (db.on()) {
                db.println("Setting dirty");
            }
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    public void enteringPage() {
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    protected void printThresholds(sThresholds sThresholds2) {
        if (db.on()) {
            db.println("===============================================");
            db.println("CV " + sThresholds2.cv);
            db.println("ES " + sThresholds2.es);
            db.println("SES " + sThresholds2.ses);
            db.println("LOSS " + sThresholds2.loss);
            db.println("SAS " + sThresholds2.sas);
            db.println("AIS " + sThresholds2.ais);
            db.println("UAS " + sThresholds2.uas);
            db.println("BBE " + sThresholds2.bbe);
            db.println("===============================================");
        }
    }
}

