/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.idl.OpticsTopology.eNodeSetupPortAttr;
import cerent.cms.idl.OpticsTopology.eNodeSetupResult;
import cerent.cms.idl.OpticsTopology.sNodeSetupPort;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Busy;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.DwdmOpticalSetupModel;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.MissingEquipment;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.WrongParameterValue;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AnsPathDataSource
extends AbstractRowDataSource {
    private DwdmOpticalSetupModel dwdmOpticalSetupModel;
    private List<AnsPathRow> unfilteredPathRowList = new ArrayList<AnsPathRow>();
    private List<AnsPathRow> filteredPathRowList = new ArrayList<AnsPathRow>();
    public static final int SLT_ID_INDEX = 1;
    public static final int PARAM_INDEX = 2;
    public static final int STAT_INDEX = 3;
    public static final int SIDE_INDEX = 0;
    public static final int COLUMN_NO = 4;
    private static final String ALL_SIDES = "All";
    private static final String NO_SIDE = "No side";
    private static final String N_A = "N/A";
    public static final String OLD_SUCCESS = "Regulated";
    private static final String[] nodeSetupOldResult = new String[]{"Not Regulated", "Regulated"};
    public static final String SUCCESS = "Success";
    public static final String FAIL = "Fail";
    public static final String[] nodeSetupResult = new String[]{"Success-Unchanged", "Success-Changed", "Fail-Out of Range", "Unchanged-Port in IS", "Not Applicable State", "Fail-Missing Input Parameter", "Fail-Missing Expected Input Power Parameter", "Fail-Missing Expected Output Power Parameter"};
    private static final String[] nodeSetupAttr = new String[]{"Unknown", "Working Mode", "Per Channel Power", "Gain", "Tilt", "LOS-P Thresold", "LOS-O Thresold", "Voa Target Attenuation", "Voa Target Power"};
    private static final SDebug db = new SDebug("AnsPathDataSource");

    public AnsPathDataSource(DwdmOpticalSetupModel dwdmOpticalSetupModel) {
        this.dwdmOpticalSetupModel = dwdmOpticalSetupModel;
        this.refresh();
    }

    public void startONS() throws MissingEquipment, FeatureUnsupported, Busy, CannotPerform, WrongParameterValue {
        this.dwdmOpticalSetupModel.ansSetUp();
    }

    public void getOpticalLinkList(String string) {
        if (db.on()) {
            db.println("Filtering with side = " + string);
        }
        if (string.equals(ALL_SIDES) || string.equals(NO_SIDE)) {
            this.filteredPathRowList.clear();
            this.filteredPathRowList.addAll(this.unfilteredPathRowList);
        } else {
            this.filteredPathRowList.clear();
            for (AnsPathRow ansPathRow : this.unfilteredPathRowList) {
                if (ansPathRow.getSide().equals(string)) {
                    this.filteredPathRowList.add(ansPathRow);
                }
                if (!DwdmSide.isRolePresent(string) || !ansPathRow.getSide().equals(DwdmSide.getLabelOf(string))) continue;
                this.filteredPathRowList.add(ansPathRow);
            }
        }
        this.fireDataSourceChanged();
    }

    public void dispose() {
        if (db.on()) {
            db.println("AnsPathDataSource Dispose");
        }
    }

    public Object getObjectAtRow(int n) {
        return this.filteredPathRowList.get(n);
    }

    public int getRowCount() {
        return this.filteredPathRowList.size();
    }

    public Collection getAllObjects() {
        return this.filteredPathRowList;
    }

    private String getSlotFromPort(int n) {
        try {
            OpticsPortModel opticsPortModel = (OpticsPortModel)this.getNodeModel().getEntityTable().getEntityModelByIndex(n);
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
            return entityCellRenderer.getFullPortString(opticsPortModel, false);
        }
        catch (Exception exception) {
            return N_A;
        }
    }

    private String getSetupAttr(sNodeSetupPort sNodeSetupPort2) {
        String string = "Unknown";
        try {
            string = sNodeSetupPort2.attr.value() == eNodeSetupPortAttr.PA_UNKNOWN.value() ? nodeSetupOldResult[sNodeSetupPort2.success ? 1 : 0] : nodeSetupAttr[sNodeSetupPort2.attr.value()];
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    private String getSetupResult(eNodeSetupResult eNodeSetupResult2) {
        String string = "Unknown";
        try {
            string = nodeSetupResult[eNodeSetupResult2.value()];
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    private String getSideFromPort(int n) {
        try {
            OpticsPortModel opticsPortModel = (OpticsPortModel)this.getNodeModel().getEntityTable().getEntityModelByIndex(n);
            int n2 = opticsPortModel.getSide();
            return DwdmSide.getSideFromOffset(n2);
        }
        catch (Exception exception) {
            return N_A;
        }
    }

    public NodeModelDelegate getNodeModel() {
        return (NodeModelDelegate)this.dwdmOpticalSetupModel.getNodeModel();
    }

    public void refresh() {
        block6: {
            if (db.on()) {
                db.println("Refreshing");
            }
            try {
                sNodeSetupPort[] sNodeSetupPortArray = this.dwdmOpticalSetupModel.getNodeSetupPorts();
                this.unfilteredPathRowList.clear();
                for (int i = 0; i < sNodeSetupPortArray.length; ++i) {
                    this.unfilteredPathRowList.add(new AnsPathRow(sNodeSetupPortArray[i]));
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (db.on()) {
                    db.println("Error while retrieving opt. link list: " + (Object)((Object)abstractCmsIOException));
                }
            }
            catch (CannotPerform cannotPerform) {
                if (!db.on()) break block6;
                db.println("Error while retrieving opt. link list: " + (Object)((Object)cannotPerform));
            }
        }
        this.fireDataSourceChanged();
    }

    public class AnsPathRow {
        private String[] content = new String[4];
        private sNodeSetupPort nsp;

        public AnsPathRow(sNodeSetupPort sNodeSetupPort2) {
            this.content[1] = AnsPathDataSource.this.getSlotFromPort(sNodeSetupPort2.port);
            this.content[2] = AnsPathDataSource.this.getSetupAttr(sNodeSetupPort2);
            this.content[3] = AnsPathDataSource.this.getSetupResult(sNodeSetupPort2.result);
            this.content[0] = AnsPathDataSource.this.getSideFromPort(sNodeSetupPort2.port);
            this.nsp = sNodeSetupPort2;
        }

        public String getSlot() {
            return this.content[1];
        }

        public String getParameter() {
            return this.content[2];
        }

        public String getStatus() {
            return this.content[3];
        }

        public String getSide() {
            return this.content[0];
        }

        public boolean getSuccess() {
            return this.nsp.success;
        }

        public int compareTo(AnsPathRow ansPathRow, int n) {
            if (n == 1) {
                return this.nsp.port - ansPathRow.nsp.port;
            }
            return this.content[n].compareTo(ansPathRow.content[n]);
        }
    }
}

