/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.RmonLineUpdate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.DwdmCardDualPane;
import cerent.cms.ui.dwdm.DwdmPayloadPmPane;
import cerent.cms.ui.dwdm.FECPmPane;
import cerent.cms.ui.dwdm.NAProtectPane;
import cerent.cms.ui.dwdm.OpticsPmHistPane;
import cerent.cms.ui.dwdm.OpticsPmStatPane;
import cerent.cms.ui.dwdm.OtnPmPane;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;

public class DwdmPerfPane
extends AbstractSubTabbedPane
implements ITabName {
    protected AbstractDwdmLineModel[] _lineModels;
    protected IRmonModel[] _rmonModels;
    protected TdmLineModel[] _sonetModels;
    protected boolean _supportsOTN;
    private AbstractPane _otnPmTab;
    private AbstractPane _payPmTab;
    private AbstractPane _optPmTab;

    public DwdmPerfPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
        this._lineModels = dwdmModuleModel.getAllDwdmLineModels();
        this._sonetModels = dwdmModuleModel.getSonetLines();
        this._rmonModels = dwdmModuleModel.getRmonModels();
        this._supportsOTN = dwdmModuleModel.supportsOTN();
        this.registerWithModel();
        if (dwdmModuleModel.getEqType() == 293) {
            this.registerLineModels(dwdmModuleModel);
        }
    }

    protected void registerLineModels(DwdmModuleModel dwdmModuleModel) {
        AbstractDwdmLineModel[] abstractDwdmLineModelArray = dwdmModuleModel.getDwdmLineModels();
        for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
            if (abstractDwdmLineModelArray[i] == null) continue;
            abstractDwdmLineModelArray[i].addObserver((Observer)((Object)this));
        }
    }

    protected void unregisterLineModels(DwdmModuleModel dwdmModuleModel) {
        AbstractDwdmLineModel[] abstractDwdmLineModelArray = dwdmModuleModel.getDwdmLineModels();
        for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
            if (abstractDwdmLineModelArray[i] == null) continue;
            abstractDwdmLineModelArray[i].deleteObserver((Observer)((Object)this));
        }
    }

    protected void changeMessage(Observable observable, Object object) {
        db.info("Got an Update Message for " + observable);
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(Observable observable) {
        return new Runnable(){

            public void run() {
                DwdmPerfPane.this.refreshTabs();
            }
        };
    }

    private void refreshTabs() {
        int n;
        int n2 = this.subTabs.indexOfTab("Payload PM");
        if (n2 > -1) {
            this.subTabs.removeTabAt(n2);
            this.subTabs.insertTab("Payload PM", null, (Component)((Object)this.getPayloadPmTab("Payload PM")), "", n2);
        }
        if ((n = this.subTabs.indexOfTab("OTN PM")) > -1) {
            this.subTabs.removeTabAt(n);
            this.subTabs.insertTab("OTN PM", null, (Component)((Object)this.getG709PmTab("OTN PM")), "", n);
        }
    }

    public void dispose() {
        db.info("Called dispose");
        this.unregisterLineModels((DwdmModuleModel)this.getUiModel());
        super.dispose();
    }

    protected void createSubTabs() {
        this._optPmTab = this.getOptPmTab("Optics PM");
        this._payPmTab = this.getPayloadPmTab("Payload PM");
        this.subTabs.addTab("Optics PM", (Component)((Object)this._optPmTab));
        this.subTabs.addTab("Payload PM", (Component)((Object)this._payPmTab));
        if (this._supportsOTN) {
            this._otnPmTab = this.getG709PmTab("OTN PM");
            this.subTabs.addTab("OTN PM", (Component)((Object)this._otnPmTab));
        }
        this.subTabs.setTabPlacement(2);
    }

    private AbstractPane getOptPmTab(String string) {
        return new AbstractSubTabbedPane(string, this.subTabs){

            public void createSubTabs() {
                this.subTabs.addTab("Current Values", (Component)((Object)new OpticsPmStatPane("Current Values", this.subTabs, DwdmPerfPane.this._lineModels)));
                this.subTabs.addTab("Historical PM", (Component)((Object)new OpticsPmHistPane("Historical PM", this.subTabs, DwdmPerfPane.this._lineModels)));
            }
        };
    }

    private AbstractPane getPayloadPmTab(String string) {
        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
        this._sonetModels = dwdmModuleModel.getSonetLines();
        this._rmonModels = dwdmModuleModel.getRmonModels();
        if (dwdmModuleModel.getEqType() == 293) {
            this._sonetModels = dwdmModuleModel.getNonRegenSonetModels(this._sonetModels);
            this._rmonModels = dwdmModuleModel.getNonRegenRmonModels(this._rmonModels);
        }
        return new DwdmPayloadPmPane("Payload PM", this.subTabs, dwdmModuleModel, this._sonetModels, this._rmonModels);
    }

    private AbstractPane getG709PmTab(String string) {
        return new AbstractSubTabbedPane(string, this.subTabs){
            private DwdmCardDualPane g709PmTab;
            private DwdmCardDualPane fecPmTab;
            private DwdmTrkLineModel[] _trunkModels;
            private DwdmModuleModel mm;

            protected void init() {
                this.mm = (DwdmModuleModel)this.getUiModel();
                this._trunkModels = this.mm.isADMCard() ? this.mm.getAdmDwdmTrkLineModels() : this.mm.getDwdmTrkLineModels();
                if (!this._inited) {
                    this.g709PmTab = this.getOtnPmTab("ITU-T G.709 PM", this._trunkModels);
                    this.fecPmTab = this.getFECPmTab("FEC PM", this._trunkModels);
                }
                if (this.mm.hasPluggableTrunk()) {
                    if (db.on()) {
                        db.println("Registering for pluggable trunk line update");
                    }
                    this.registerWithModel();
                }
                super.init();
            }

            protected void refreshMyLines(Object object) {
                if (object instanceof DwdmLineUpdate) {
                    DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
                    DwdmTrkLineModel[] dwdmTrkLineModelArray = this.mm.isADMCard() ? this.mm.removeIlkTrkLineModels(this.mm.getAdmDwdmTrkLineModels()) : this.mm.removeIlkTrkLineModels(dwdmLineUpdate.getDwdmTrkLineModels());
                    if (dwdmTrkLineModelArray.length != this._trunkModels.length) {
                        if (db.on()) {
                            db.println("Refreshing " + this.getFullName() + " pm subtabs for change in trunk number, from " + this._trunkModels.length + " to " + dwdmTrkLineModelArray.length);
                        }
                        this._trunkModels = dwdmTrkLineModelArray;
                        if (this.mm.getEqType() == 293) {
                            DwdmPerfPane.this.registerLineModels(this.mm);
                        }
                        this.subTabs.removeAll();
                        this.createSubTabs();
                    }
                }
            }

            public void createSubTabs() {
                if (this._trunkModels.length == 0) {
                    this.subTabs.add((Component)((Object)NAProtectPane.createPane(this.getParentView(), true)));
                } else {
                    this.subTabs.addTab("ITU-T G.709 PM", (Component)((Object)this.g709PmTab));
                    this.subTabs.addTab("FEC PM", (Component)((Object)this.fecPmTab));
                }
            }

            private DwdmCardDualPane getOtnPmTab(String string, DwdmTrkLineModel[] dwdmTrkLineModelArray) {
                return new DwdmCardDualPane(this.subTabs, dwdmTrkLineModelArray, new OtnPmPane(string, this.subTabs, dwdmTrkLineModelArray), 4);
            }

            private DwdmCardDualPane getFECPmTab(String string, DwdmTrkLineModel[] dwdmTrkLineModelArray) {
                return new DwdmCardDualPane(this.subTabs, dwdmTrkLineModelArray, new FECPmPane(string, this.subTabs, dwdmTrkLineModelArray), 4);
            }
        };
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof DwdmLineUpdate) {
            DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
            if (db.on()) {
                db.println("Received DwdmLineUpdate...");
            }
            this._lineModels = dwdmLineUpdate.getDwdmLineModels();
        } else if (object instanceof RmonLineUpdate) {
            RmonLineUpdate rmonLineUpdate = (RmonLineUpdate)object;
            this._rmonModels = rmonLineUpdate.getRmonModels();
        } else if (db.on()) {
            db.println("refreshMyLines received " + object);
        }
    }
}

