/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IOpticsPmModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.Operation;
import cerent.cms.model.PortModel;
import cerent.cms.model.SecurityModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.OpticsPmTableModel;
import cerent.util.ObservableManager;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.UComboBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public abstract class OpticsPmPane
extends AbstractPane
implements ActionListener {
    protected static SDebug db = new SDebug("OpticsPmPane");
    public static final String REFRESH = "Refresh";
    public static final String ZERO = "Clear...";
    public static final String ZERO_TOOLTIP = "Initialize current registers to zero";
    protected static final String INT_15_MIN = "15-minute";
    protected static final String INT_1_DAY = "1-day";
    protected JRadioButton minuteRB;
    protected JRadioButton dayRB;
    protected JLabel dateLB;
    protected JButton refreshPB;
    protected JButton clearPB;
    protected Timer refreshTimer;
    protected RefreshTimerListener refreshTimerListener;
    protected UComboBox refreshComboBox;
    protected boolean enteringPage = false;
    protected UComboBox portCB;
    protected int colZeroWidth = 150;
    protected int[] widths = new int[]{this.colZeroWidth, 80};
    protected IOpticsPmModel[] opticsModels;
    protected OpticsPmTableModel dataModel;
    protected NodeModelDelegate nmd;
    private ObservableManager _obsMgr;
    private SecurityModel secModel;
    private Observer pmClearObserver;
    private String[] rateStrs = new String[]{"None", "15 Seconds", "30 Seconds", "1 Minute", "3 Minutes", "5 Minutes"};
    private int[] rates = new int[]{86400000, 15000, 30000, 60000, 180000, 300000};
    protected String autoRefreshPrefPath;
    protected String autoRefreshPrefKey;

    protected OpticsPmPane(String string, TabbedView tabbedView, IOpticsPmModel[] iOpticsPmModelArray) {
        super(string, tabbedView);
        this.registerWithModel();
        this.opticsModels = iOpticsPmModelArray;
        this.nmd = ((ModuleModel)this.getUiModel()).getNodeModelDelegate();
        this.autoRefreshPrefPath = "ctc";
        this.autoRefreshPrefKey = "PM-auto-refresh-rate";
        this.refreshTimer = null;
        this.refreshTimerListener = new RefreshTimerListener();
    }

    protected final void init() {
        this.getObsMgr().addObservable((Observable[])this.opticsModels);
        this.dataModel = this.createDataModel();
        this.localInit();
    }

    protected abstract void localInit();

    private JPanel getEndIntervalBars() {
        JPanel jPanel = OpticsPmPane.createHorizontalPanel(null);
        jPanel.add(Box.createHorizontalStrut(4));
        jPanel.add(this.getEndBar());
        jPanel.add(this.getIntervalBar());
        return jPanel;
    }

    private JPanel getIntervalBar() {
        JPanel jPanel = OpticsPmPane.createVerticalPanel(null);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.minuteRB = new JRadioButton("15 min", true);
        buttonGroup.add(this.minuteRB);
        this.minuteRB.addActionListener(this);
        jPanel.add(this.minuteRB);
        this.dayRB = new JRadioButton("1 day");
        buttonGroup.add(this.dayRB);
        this.dayRB.addActionListener(this);
        jPanel.add(this.dayRB);
        jPanel.setBorder(BorderFactory.createTitledBorder(" Intervals "));
        jPanel.setPreferredSize(new Dimension(90, 77));
        return jPanel;
    }

    private JPanel getEndBar() {
        JPanel jPanel = OpticsPmPane.createVerticalPanel(null);
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton("Near End", true);
        buttonGroup.add(jRadioButton);
        JRadioButton jRadioButton2 = new JRadioButton("Far End");
        buttonGroup.add(jRadioButton2);
        jRadioButton.addActionListener(this);
        jRadioButton2.addActionListener(this);
        jPanel.add(jRadioButton);
        jPanel.add(jRadioButton2);
        jPanel.setBorder(BorderFactory.createTitledBorder(" Directions "));
        jPanel.setPreferredSize(new Dimension(90, 77));
        jRadioButton.setEnabled(false);
        jRadioButton2.setEnabled(false);
        return jPanel;
    }

    private JPanel getPortCB() {
        JPanel jPanel = OpticsPmPane.createHorizontalPanel(null);
        jPanel.add(Box.createHorizontalStrut(4));
        this.portCB = new UComboBox(this.getPortList());
        this.portCB.setRenderer((ListCellRenderer)new OpticsCardPortRenderer());
        this.portCB.setPreferredSize(new Dimension(150, 50));
        this.portCB.addActionListener((ActionListener)this);
        jPanel.add(new JLabel("Port:"));
        jPanel.add((Component)this.portCB);
        return jPanel;
    }

    protected JPanel createButtonBar(boolean bl) {
        JPanel jPanel = OpticsPmPane.createVerticalPanel(null);
        JPanel jPanel2 = OpticsPmPane.createHorizontalPanel(null);
        jPanel2.setLayout(new FlowLayout(0, 5, 5));
        JPanel jPanel3 = OpticsPmPane.createHorizontalPanel(null);
        jPanel3.add(this.getEndIntervalBars());
        if (bl) {
            jPanel3.add(this.getPortCB());
            if (this.portCB.getModel().getSize() > 0) {
                this.portCB.setSelectedIndex(0);
            }
        }
        this.refreshPB = new JButton(REFRESH);
        this.refreshPB.addActionListener(this);
        this.refreshPB.setAlignmentY(0.5f);
        jPanel3.add(Box.createHorizontalStrut(4));
        jPanel3.add(this.refreshPB);
        this.refreshComboBox = new UComboBox((Object[])this.rateStrs);
        this.refreshComboBox.addItemListener((ItemListener)new RefreshComboBoxListener());
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(new JLabel("Auto-refresh:"));
        jPanel3.add(Box.createHorizontalStrut(4));
        jPanel3.add((Component)this.refreshComboBox);
        this.secModel = (SecurityModel)this.nmd.getSecurityModel();
        if (bl) {
            this.clearPB = new JButton(ZERO);
            this.clearPB.addActionListener(this);
            this.clearPB.setAlignmentY(0.5f);
            this.clearPB.setToolTipText(ZERO_TOOLTIP);
            jPanel3.add(Box.createHorizontalStrut(4));
            jPanel3.add(this.clearPB);
            this.pmClearObserver = new Observer(){

                public void update(Observable observable, Object object) {
                    OpticsPmPane.this.enableZeroPB();
                }
            };
            this.enableZeroPB();
        }
        CSHelpButton cSHelpButton = new CSHelpButton(this.getHelpID());
        cSHelpButton.setMinimumSize(new Dimension(75, cSHelpButton.getPreferredSize().height));
        cSHelpButton.setAlignmentY(0.5f);
        jPanel3.add(Box.createHorizontalStrut(4));
        jPanel3.add(cSHelpButton);
        jPanel3.add(Box.createHorizontalStrut(4));
        this.dateLB = new JLabel("");
        jPanel2.add(this.dateLB);
        jPanel.add(jPanel3);
        jPanel.add(jPanel2);
        return jPanel;
    }

    public abstract CSHelpID getHelpID();

    protected abstract void refreshNow();

    protected abstract OpticsPmTableModel createDataModel();

    protected int getIndexForMillis(int n) {
        int n2 = 0;
        for (int i = 0; i < this.rates.length; ++i) {
            if (this.rates[i] != n) continue;
            n2 = i;
        }
        return n2;
    }

    public void enteringPage() throws Exception {
        this.enteringPage = true;
        if (this.dataModel == null) {
            this.init();
        }
        if (this.pmClearObserver != null) {
            this.enableZeroPB();
            this.secModel.addObserver(this.pmClearObserver);
        }
        this.getObsMgr().setPassing(true);
        this.enteringPage = false;
    }

    public void leavingPage() throws Exception {
        this.getObsMgr().setPassing(false);
        if (this.pmClearObserver != null) {
            this.secModel.deleteObserver(this.pmClearObserver);
        }
    }

    public void refresh() {
    }

    public void dispose() {
        db.info("Called dispose");
        if (this._obsMgr != null) {
            this._obsMgr.removeObservable((Observable[])this.opticsModels);
        }
        super.dispose();
    }

    protected void saveAutoRefreshPref() {
        if (null != this.refreshComboBox) {
            int n = this.refreshComboBox.getSelectedIndex();
            int n2 = this.rates[n];
            Preferences.instance().setInt(this.autoRefreshPrefPath, this.autoRefreshPrefKey, n2);
        }
    }

    protected Vector getPortList() {
        Vector<IPortModel> vector = new Vector<IPortModel>();
        for (int i = 0; i < this.opticsModels.length; ++i) {
            try {
                InterfaceModel interfaceModel = (InterfaceModel)((Object)this.opticsModels[i]);
                vector.add(interfaceModel.getPortModel());
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return vector;
    }

    protected String getPortName(IOpticsPmModel iOpticsPmModel) {
        String string = "?????";
        try {
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
            return entityCellRenderer.getPortString((IEntityModel)((InterfaceModel)((Object)iOpticsPmModel)).getPortModel(), false);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return string;
        }
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof DwdmLineUpdate) {
            final DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (db.on()) {
                        db.println("Received DwdmLineUpdate...");
                    }
                    OpticsPmPane.this.opticsModels = dwdmLineUpdate.getDwdmLineModels();
                    if (OpticsPmPane.this.portCB != null) {
                        OpticsPmPane.this.portCB.removeAllItems();
                        Iterator iterator = OpticsPmPane.this.getPortList().iterator();
                        while (iterator.hasNext()) {
                            OpticsPmPane.this.portCB.addItem(iterator.next());
                        }
                    }
                    if (OpticsPmPane.this.dataModel != null) {
                        OpticsPmPane.this.getObsMgr().setObservable((Observable[])OpticsPmPane.this.opticsModels);
                        OpticsPmPane.this.dataModel.refreshMyLines(OpticsPmPane.this.opticsModels);
                        OpticsPmPane.this.setupColumnHeader();
                    }
                }
            });
        } else {
            db.fine("refreshMyLines received " + object);
        }
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    protected void setupColumnHeader() {
    }

    protected abstract void updateTimeLabel();

    private void enableZeroPB() {
        super.enableComponent(this.clearPB, this.secModel, this.secModel.getOperationPrivilege(Operation.CLEAR_PM));
    }

    private class OpticsCardPortRenderer
    extends JLabel
    implements ListCellRenderer {
        public OpticsCardPortRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            try {
                if (object instanceof String) {
                    this.setText((String)object);
                } else if (object instanceof PortModel) {
                    PortModel portModel = (PortModel)object;
                    EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
                    this.setText(entityCellRenderer.getPortString(portModel, false));
                }
            }
            catch (Exception exception) {
                db.println("OpticsCardPortRenderer caught Exception: " + exception);
            }
            this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }

    private class RefreshTimerListener
    implements ActionListener {
        private RefreshTimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OpticsPmPane.this.refreshNow();
        }
    }

    private class RefreshComboBoxListener
    implements ItemListener {
        private RefreshComboBoxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (1 == itemEvent.getStateChange()) {
                int n;
                if (!OpticsPmPane.this.enteringPage) {
                    IgnorableDialog.infoDialog((Component)OpticsPmPane.this.getParentView(), (String)"The selected auto-refresh value will be applied to all\nperformance monitoring for the current user. ", (String)"Notice", (String)"IgnoreAutoRefreshMessage", (String)"Warn auto refresh affects all performance monitoring for user");
                }
                if ((n = OpticsPmPane.this.refreshComboBox.getSelectedIndex()) == 0) {
                    if (OpticsPmPane.this.refreshTimer.isRunning()) {
                        if (db.on()) {
                            db.println("Stopping auto-refresh timer.C");
                        }
                        OpticsPmPane.this.refreshTimer.stop();
                    }
                } else if (n > 0 && n < OpticsPmPane.this.rates.length) {
                    if (null != OpticsPmPane.this.refreshTimer) {
                        if (db.on()) {
                            db.println("Stopping auto-refresh timer.D");
                        }
                        OpticsPmPane.this.refreshTimer.stop();
                    }
                    OpticsPmPane.this.refreshTimer = null;
                    OpticsPmPane.this.refreshTimer = new Timer(OpticsPmPane.this.rates[n], OpticsPmPane.this.refreshTimerListener);
                    if (db.on()) {
                        db.println("Starting auto-refresh timer.A");
                    }
                    OpticsPmPane.this.refreshTimer.start();
                } else {
                    if (db.on()) {
                        db.println("Stopping auto-refresh timer.E");
                    }
                    OpticsPmPane.this.refreshTimer.stop();
                }
                OpticsPmPane.this.saveAutoRefreshPref();
            }
        }
    }
}

