/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional;

import cerent.cms.fv.IFvEditDialog;
import cerent.cms.fv.IFvSideModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.FunctionalViewButton;
import cerent.cms.ui.functional.FunctMenuBar;
import cerent.cms.ui.functional.FunctMenuToolListener;
import cerent.cms.ui.functional.FunctNodeManager;
import cerent.cms.ui.functional.FunctOpenActions;
import cerent.cms.ui.functional.FunctView;
import cerent.cms.ui.functional.FunctionalTabbedView;
import cerent.cms.ui.functional.FvInstances;
import cerent.cms.ui.functional.ViewManagerDelegate;
import cerent.util.DebugManager;
import cerent.util.IFvDebug;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.Preferences;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UFrame;
import cerent.util.gui.UToolBar;
import cerent.util.view.fv.IFunctDialog;
import cerent.util.view.fv.IViewManagerDelegate;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.FunctDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class FunctionalEditDialog
extends JFrame
implements IFvEditDialog {
    private static HashMap<String, FvInstances> allFunctionalDialog = new HashMap();
    private static final String FUNCTIONAL_VIEW_ICON = "/images/icons/CTC_icon.gif";
    private static final String PREF = "ctc.FunctEditDialog";
    private static final String XPOS = "x";
    private static final String YPOS = "y";
    private static final String WIDTH = "w";
    private static final String HEIGHT = "h";
    private static final Dimension INIT_DIM = new Dimension(800, 600);
    private static final Dimension TB_DIM = new Dimension(25, 25);
    private static final Insets TB_MARGIN = new Insets(2, 2, 2, 2);
    private INodeModel nm = null;
    private JSplitPane secondSplitPane = null;
    private JSplitPane mainSplitPane = null;
    private UToolBar toolBar = null;
    private FunctMenuBar menuBar;
    private ViewManagerDelegate viewmanager = null;
    private JPanel parent;
    private HashMap<Integer, FunctionalTabbedView> tabPane;
    private ConnectionObserver connectionObserver;
    private FunctNodeManager functNodeManager;
    private FunctView functView;

    public FunctionalEditDialog(JPanel jPanel, INodeModel iNodeModel) {
        super(iNodeModel.getName() + " - DWDM Functional View");
        URL uRL = UFrame.class.getResource(FUNCTIONAL_VIEW_ICON);
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        this.setIconImage(image);
        this.tabPane = new HashMap();
        this.parent = jPanel;
        this.nm = iNodeModel;
        this.initDialogUI();
        this.initContentPane();
        this.setDefaultCloseOperation(2);
        this.connectionObserver = new ConnectionObserver(iNodeModel, this);
    }

    protected void initContentPane() {
        FunctOpenActions functOpenActions = new FunctOpenActions();
        this.viewmanager = new ViewManagerDelegate(this.nm.getFvNodeModelDelegate(), this, functOpenActions);
        functOpenActions.addViewManager((IViewManagerDelegate)this.viewmanager);
        this.createMenuAndToolBar();
        Container container = this.getContentPane();
        container.add((Component)this.toolBar, "North");
        container.add(this.getMainSplitPane(), "Center");
    }

    private void createMenuAndToolBar() {
        FunctMenuToolListener functMenuToolListener = new FunctMenuToolListener(this, (Component)this.viewmanager.getViewTk());
        this.menuBar = new FunctMenuBar(functMenuToolListener);
        this.menuBar.createMenuBar(true, true);
        this.setJMenuBar(this.menuBar);
        this.toolBar = this.getToolBar();
        this.toolBar.setName("Funtional ToolBar");
    }

    private Component getMainSplitPane() {
        if (this.mainSplitPane == null) {
            this.mainSplitPane = new JSplitPane(0, this.getFunctionalPanel(), this.createTabView(null));
            this.mainSplitPane.setOneTouchExpandable(true);
            this.mainSplitPane.setContinuousLayout(true);
            this.mainSplitPane.setDividerLocation(350);
        }
        return this.mainSplitPane;
    }

    private JTabbedPane createTabView(IFvSideModel iFvSideModel) {
        FunctionalTabbedView functionalTabbedView = null;
        int n = iFvSideModel != null ? iFvSideModel.getId() : 0;
        if (this.tabPane.containsKey(n)) {
            functionalTabbedView = this.tabPane.get(n);
        } else {
            if (!this.nm.isMultishelf()) {
                IEntityModel[] iEntityModelArray = this.nm.getChassisModels();
                functionalTabbedView = new FunctionalTabbedView((IChassisModel)iEntityModelArray[0], this.viewmanager, iFvSideModel);
            } else {
                functionalTabbedView = new FunctionalTabbedView(this.nm, this.viewmanager, iFvSideModel);
            }
            this.tabPane.put(n, functionalTabbedView);
        }
        return functionalTabbedView;
    }

    public UToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = this.createToolBar();
        }
        return this.toolBar;
    }

    private UToolBar createToolBar() {
        UToolBar uToolBar = new UToolBar();
        uToolBar.setFloatable(false);
        uToolBar.addSeparator();
        uToolBar.setVisible(true);
        return uToolBar;
    }

    private void initDialogUI() {
        try {
            Preferences preferences = Preferences.instance();
            int n = preferences.getInt(PREF, XPOS, -1);
            int n2 = preferences.getInt(PREF, YPOS, 0);
            int n3 = preferences.getInt(PREF, WIDTH, FunctionalEditDialog.INIT_DIM.width);
            int n4 = preferences.getInt(PREF, HEIGHT, FunctionalEditDialog.INIT_DIM.height);
            if (n == -1) {
                this.setSize(new Dimension(n3, n4));
            } else {
                this.setBounds(n, n2, n3, n4);
            }
        }
        catch (Exception exception) {
            this.setSize(INIT_DIM);
        }
    }

    private JComponent getFunctionalPanel() {
        FunctView functView = (FunctView)this.viewmanager.getViewTk();
        functView.add(this.getButtonPanel(), "South");
        functView.setMinimumSize(new Dimension(200, 200));
        return functView.getGraphWindow();
    }

    private JComponent getButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 5, 5));
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    public JButton addToolbar(ActionListener actionListener, String string, String string2, Object object) {
        JButton jButton = new JButton(new ImageIcon(this.getClass().getResource(string)));
        jButton.addActionListener(actionListener);
        jButton.setToolTipText(string2);
        jButton.setMargin(TB_MARGIN);
        jButton.setMinimumSize(TB_DIM);
        jButton.setMaximumSize(TB_DIM);
        jButton.setActionCommand(string2);
        this.toolBar.add((Component)jButton, object);
        return jButton;
    }

    public void syncButton(String string, boolean bl) {
        Component[] componentArray = this.toolBar.getComponents();
        for (int i = 0; i <= componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JButton) || !((JButton)componentArray[i]).getActionCommand().equals(string)) continue;
            componentArray[i].setEnabled(bl);
            break;
        }
    }

    public FunctNodeManager getFunctNodeManager() {
        return this.functNodeManager;
    }

    public void setFunctNodeManager(FunctNodeManager functNodeManager) {
        this.functNodeManager = functNodeManager;
    }

    public FunctView getFunctView() {
        return this.functView;
    }

    public void setFunctView(FunctView functView) {
        this.functView = functView;
    }

    public void dispose() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FunctionalEditDialog.this.dispose();
                }
            });
            return;
        }
        String string = this.nm.getName();
        FvInstances fvInstances = allFunctionalDialog.get(string);
        fvInstances.removeFV();
        this.viewmanager.dispose();
        this.viewmanager = null;
        this.nm = null;
        this.secondSplitPane = null;
        this.toolBar = null;
        this.menuBar = null;
        this.parent = null;
        for (FunctionalTabbedView functionalTabbedView : this.tabPane.values()) {
            functionalTabbedView.destroy();
        }
        super.dispose();
    }

    public JPanel getParent() {
        return this.parent;
    }

    public void tryJumpSide(IFvSideModel iFvSideModel) {
        this.mainSplitPane.setRightComponent(this.createTabView(iFvSideModel));
    }

    public static FunctionalEditDialog internalInstance(JPanel jPanel, NodeModelDelegate nodeModelDelegate) {
        return new FunctionalEditDialog(jPanel, nodeModelDelegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FunctionalEditDialog instance(JPanel jPanel, INodeModel iNodeModel) {
        FvInstances fvInstances;
        FunctDebug.instance().init((IFvDebug)DebugManager.instance().getRoot());
        FunctDialog.init((IFunctDialog)new CerentDialog());
        HashMap<String, FvInstances> hashMap = allFunctionalDialog;
        synchronized (hashMap) {
            String string = iNodeModel.getName();
            fvInstances = allFunctionalDialog.get(string);
            if (fvInstances == null) {
                fvInstances = new FvInstances(new FunctionalEditDialog(jPanel, iNodeModel));
                allFunctionalDialog.put(string, fvInstances);
            }
            if (fvInstances.isEnable()) {
                if (fvInstances.getInstance() != null) {
                    return fvInstances.getInstance();
                }
                FunctionalEditDialog functionalEditDialog = new FunctionalEditDialog(jPanel, iNodeModel);
                fvInstances.setInstance(functionalEditDialog);
                return functionalEditDialog;
            }
        }
        return fvInstances.getInstance();
    }

    public static void storeButton(String string, FunctionalViewButton functionalViewButton) {
        FvInstances fvInstances = allFunctionalDialog.get(string);
        if (fvInstances == null) {
            fvInstances = new FvInstances(functionalViewButton);
            allFunctionalDialog.put(string, fvInstances);
        }
    }

    public static void disableRequest(String string) {
        FvInstances fvInstances = FunctionalEditDialog.getFvInstance(string);
        fvInstances.disableRequest();
    }

    public static void enableRequest(String string) {
        FvInstances fvInstances = FunctionalEditDialog.getFvInstance(string);
        fvInstances.enableRequest();
    }

    private static FvInstances getFvInstance(String string) {
        FvInstances fvInstances = allFunctionalDialog.get(string);
        if (fvInstances == null) {
            FunctionalViewButton functionalViewButton = FunctionalViewButton.getInstance();
            fvInstances = new FvInstances(functionalViewButton);
            allFunctionalDialog.put(string, fvInstances);
        }
        return fvInstances;
    }

    public static AbstractButton getButton(String string) {
        FvInstances fvInstances = allFunctionalDialog.get(string);
        if (fvInstances != null) {
            return fvInstances.getFViewButton();
        }
        return null;
    }

    public static boolean neNeedFv(String string) {
        FvInstances fvInstances = allFunctionalDialog.get(string);
        if (fvInstances != null) {
            return fvInstances.isEnable();
        }
        return false;
    }

    public boolean isPortPowerVisible() {
        return false;
    }

    private class ConnectionObserver
    implements IObserver {
        private FunctionalEditDialog frame;

        public ConnectionObserver(INodeModel iNodeModel, FunctionalEditDialog functionalEditDialog2) {
            iNodeModel.getConnectionNotifier().addObserver((IObserver)this);
            this.frame = functionalEditDialog2;
        }

        public void update(IObservable iObservable, Object object) {
            if (iObservable instanceof NodeModelDelegate.ConnectionNotifier) {
                NodeModelDelegate.ConnectionNotifier connectionNotifier = (NodeModelDelegate.ConnectionNotifier)iObservable;
                if (object == ModelUpdateType.CHANGED || object == ModelUpdateType.DELETED) {
                    this.frame.dispose();
                }
            }
        }
    }
}

