/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.intpatch;

import cerent.cms.idl.OpticsTopology.eConnectionPortsType;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.OpticalPatchCordModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.ans.AnsConnDataSource;
import cerent.cms.ui.intpatch.IntPatchCreationInfo;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;

public class IntPatchCreateOperator {
    private static final SDebug db = new SDebug("IntPatchCreateOperator");
    private OpticalPatchCordModel patchModel;
    private INodeModel currentNode;
    private IEntityModel currentPort;
    private EntityCellRenderer ecr = new EntityCellRenderer();

    public IntPatchCreateOperator(AnsConnDataSource ansConnDataSource, OpticalPatchCordModel opticalPatchCordModel) {
        this.patchModel = opticalPatchCordModel;
    }

    public void createPatchcord(IntPatchCreationInfo intPatchCreationInfo) throws CTCUserException, AnnotatedException {
        IntPatchCreationInfo.TermInfo[] termInfoArray = intPatchCreationInfo.getTermsInfo();
        for (int i = 0; i < termInfoArray.length; ++i) {
            if (termInfoArray[i] == null) continue;
            this.createPatchcord(termInfoArray[i], intPatchCreationInfo);
        }
    }

    private static eConnectionPortsType getType(IntPatchCreationInfo.TermInfo termInfo) {
        return termInfo.isMPOConnection() ? eConnectionPortsType.MPO_CONNECTOR : eConnectionPortsType.SINGLE_PORT;
    }

    public void createPatchcord(IntPatchCreationInfo.TermInfo termInfo, IntPatchCreationInfo intPatchCreationInfo) throws CTCUserException, AnnotatedException {
        if (db.on()) {
            db.println("create link");
        }
        this.currentNode = termInfo.getSrcPort().getNodeModel();
        this.currentPort = termInfo.getSrcPort();
        try {
            this.patchModel.addOpticalLink(termInfo.getDstPort().getEntityIndex(), this.currentPort.getEntityIndex(), IntPatchCreateOperator.getType(termInfo));
        }
        catch (CTCUserException cTCUserException) {
            throw new AnnotatedException("The error occurred while creating the following patchcord:\nSource: " + this.getPortDescription(termInfo.getSrcPort()) + "\nTermination: " + this.getPortDescription(termInfo.getDstPort()) + "\n", (Exception)((Object)cTCUserException));
        }
        if (intPatchCreationInfo.isBidi()) {
            try {
                this.patchModel.addOpticalLink(termInfo.getSecDstPort().getEntityIndex(), termInfo.getSecSrcPort().getEntityIndex(), IntPatchCreateOperator.getType(termInfo));
            }
            catch (CTCUserException cTCUserException) {
                try {
                    this.patchModel.deleteOpticalLink(termInfo.getDstPort().getEntityIndex(), termInfo.getSrcPort().getEntityIndex());
                }
                catch (CTCUserException cTCUserException2) {
                    SDebug.printStackTrace((Throwable)cTCUserException2);
                }
                throw new AnnotatedException("The error occurred while creating the following patchcord:\nSource: " + this.getPortDescription(termInfo.getSecSrcPort()) + "\nTermination: " + this.getPortDescription(termInfo.getSecDstPort()) + "\n", (Exception)((Object)cTCUserException));
            }
        }
    }

    public void deletePatchcord(IntPatchCreationInfo intPatchCreationInfo) throws CTCUserException, AnnotatedException {
        IntPatchCreationInfo.TermInfo[] termInfoArray;
        for (IntPatchCreationInfo.TermInfo termInfo : termInfoArray = intPatchCreationInfo.getActiveTermsInfo()) {
            if (termInfo == null || termInfo.getSrcPort() == null || termInfo.getDstPort() == null) continue;
            this.deletePatchcord(termInfo, intPatchCreationInfo);
        }
    }

    public void deletePatchcord(IntPatchCreationInfo.TermInfo termInfo, IntPatchCreationInfo intPatchCreationInfo) throws CTCUserException, AnnotatedException {
        if (db.on()) {
            db.println("delete link");
        }
        try {
            this.patchModel.deleteOpticalLink(termInfo.getDstPort().getEntityIndex(), termInfo.getSrcPort().getEntityIndex());
        }
        catch (CTCUserException cTCUserException) {
            throw new AnnotatedException("The error occurred while deleting the following patchcord:\nSource: " + this.getPortDescription(termInfo.getDstPort()) + "\nTermination: " + this.getPortDescription(termInfo.getSrcPort()) + "\n", (Exception)((Object)cTCUserException));
        }
    }

    public INodeModel getCurrentNode() {
        return this.currentNode;
    }

    public IEntityModel getCurrentPort() {
        return this.currentPort;
    }

    private String getPortDescription(IEntityModel iEntityModel) {
        return this.ecr.getFullPortString(iEntityModel, false);
    }
}

