/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.intpatch;

import cerent.cms.model.EntityTableModel;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.CombosCellRenderer;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.IntPatchCreationDialog;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.intpatch.IntPatchCreationInfo;
import cerent.cms.ui.intpatch.IntPatchPortSelectorAttr;
import cerent.util.gui.CerentDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntPatchcdSourcePane
extends WzPane {
    protected IntPatchPortSelectorAttr portSelectorAttr;
    protected IntPatchCreationInfo info;
    private IntPatchCreationInfo.TermInfo term;

    public IntPatchcdSourcePane(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string) {
        super(wzDialog, wzDiagDebug, string);
        this.info = ((IntPatchCreationDialog)wzDialog).getInfo();
        this.term = this.info.getActiveTerm();
    }

    protected boolean isSourcePane() {
        return true;
    }

    protected boolean isReversePane() {
        return false;
    }

    @Override
    public void validatePage() throws Exception {
        IntPatchCreationInfo.TermInfo termInfo = this.info.getActiveTerm();
        if (this.getPort() == null) {
            throw new Exception(this.portSelectorAttr.getPortLabel() + " must be selected.");
        }
        termInfo.setSrcPort(this.portSelectorAttr.getPort());
        switch (this.info.getPatchType()) {
            case TRK2OCH: {
                if (this.info.getPatchPortType(true, false) == IntPatchCreationInfo.eIntPatchPortType.TRK) {
                    termInfo.setSecDstPort(this.portSelectorAttr.getPort());
                    termInfo.setAutoRevDst(true);
                    break;
                }
            }
            case OCH2OCH: 
            case OTS2OTS: {
                if (!this.info.isBidi()) break;
                NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.info.getNodeModel();
                EntityTableModel entityTableModel = nodeModelDelegate.getEntityTableModel();
                int[] nArray = nodeModelDelegate.getOpticalPatchCordModel().getReversePort(this.portSelectorAttr.getPort().getIndex());
                if (nArray.length == 1 && nArray[0] != 0) {
                    termInfo.setSecDstPort(entityTableModel.getEntityModelByIndex(nArray[0]));
                    termInfo.setAutoRevDst(true);
                    break;
                }
                termInfo.setAutoRevDst(false);
                break;
            }
            case TRK2TRK: {
                termInfo.setAutoRevDst(false);
            }
        }
    }

    @Override
    public void enteringPane() {
        if (this.isInited() && !this.goingForward) {
            this.reloadData();
        }
        super.enteringPane();
        ((IntPatchCreationDialog)this.parent).nextButtonAutoRun(this, this.portSelectorAttr.fullOfInfo());
    }

    @Override
    public void revalidateData() {
        try {
            this.portSelectorAttr.init(this.isSourcePane(), this.isReversePane(), this.term != this.info.getActiveTerm());
            this.term = this.info.getActiveTerm();
        }
        catch (Exception exception) {
            CerentDialog.errorDialog((Component)this, (Exception)exception, (String)"Cannot init pane");
        }
    }

    protected void reloadData() {
        if (this.term != this.info.getActiveTerm()) {
            try {
                this.portSelectorAttr.init(this.isSourcePane(), this.isReversePane(), true);
                this.term = this.info.getActiveTerm();
            }
            catch (Exception exception) {
                CerentDialog.errorDialog((Component)this, (Exception)exception, (String)"Cannot init pane");
            }
        }
    }

    @Override
    protected String getNextPaneName() {
        return "Internal Patchcord Termination";
    }

    @Override
    protected void initPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        this.portSelectorAttr = new IntPatchPortSelectorAttr(this.info);
        jPanel.add((Component)this.portSelectorAttr, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.IntPatchcdSourcePane;
    }

    @Override
    public String getShortName() {
        return this.getStatusPrefix() + super.getShortName();
    }

    private String getStatusPrefix() {
        if (this.info.isPsmProtection()) {
            return "#" + Integer.toString(this.info.getActiveTermIdx()) + "-";
        }
        return "";
    }

    @Override
    public JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = this.formatCardPosition();
        return IntPatchcdSourcePane.getGridPanel(arrayList);
    }

    protected ArrayList<String[]> formatCardPosition() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        if (this.isPassivePort()) {
            arrayList.add(new String[]{"Unit: ", CombosCellRenderer.toString((IEntityModel)this.getPort().getModuleModel())});
        } else {
            if (this.isSideSelectorNeeded()) {
                arrayList.add(new String[]{"Side: ", DwdmSide.getSideFromOffset(this.getPort().getSide())});
            }
            if (this.isMultishelf(this.info.getNodeModel())) {
                arrayList.add(new String[]{"Shelf: ", Integer.toString(this.getPort().getShelfId())});
            }
            arrayList.add(new String[]{"Slot: ", CombosCellRenderer.toString((IEntityModel)this.getPort().getModuleModel())});
        }
        if (this.info.isMPOConnection()) {
            arrayList.add(new String[]{"MPO: ", ((OpticsPortModel)this.getPort()).getMPOString()});
        } else {
            arrayList.add(new String[]{this.portSelectorAttr.getPortLabel() + ": ", CombosCellRenderer.toString(this.getPort())});
        }
        return arrayList;
    }

    protected IEntityModel getPort() {
        return this.portSelectorAttr.getPort();
    }

    private boolean isPassivePort() {
        return this.portSelectorAttr.isPassivePort();
    }

    private boolean isSideSelectorNeeded() {
        return this.portSelectorAttr.isSideSelectorNeeded();
    }

    private boolean isMultishelf(INodeModel iNodeModel) {
        return iNodeModel.provides(Feature.MULTISHELF) && iNodeModel.isMultishelf();
    }

    public WzDialog getDialog() {
        return this.parent;
    }

    @Override
    public boolean handleBack() {
        boolean bl = super.handleBack();
        if (this.info.isAutorun()) {
            this.info.setAutorun(false);
        }
        if (this.info.isPsmProtection() && this.isSourcePane() && !this.isReversePane()) {
            this.info.pop();
        }
        return bl;
    }
}

