/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.idl.Epos.eRPRTopoEdge;
import cerent.cms.idl.Epos.sRPRSpanStateInfo;
import cerent.cms.idl.EtherMedia.ePosFramingType;
import cerent.cms.model.Attribute;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ML2PosLineModel;
import cerent.cms.model.ML2PosPortModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.enumeration.EtherEnumStrings;
import cerent.cms.ui.AbstractPane;
import cerent.util.SDebug;
import cerent.util.gui.SoakTimePropertyEditor;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class ML2RPRSpanInfoTableModel
extends AbstractTableModel
implements Observer {
    private ML2ModuleModel eqpmtModel = null;
    private ML2PosPortModel[] portModels = null;
    private EtherLineModel[] lineModels = null;
    private boolean[][] isDirty = null;
    private int numLines = 0;
    private int numPorts = 0;
    private sRPRSpanStateInfo[] ml2RPRSpanStateInfo = null;
    private String[] portName = null;
    private Boolean[] suppress = null;
    private int[] soakTime;
    public String[] columnNames = new String[]{"Interface", "Span Name", "Span", "PSAS", "Soak Time", "Admin State", "Edge", "Framing Type"};
    public static String[] columnToolTips = new String[]{null, null, null, "Pre-Service Alarm Suppression", "Alarm Soak Time", null, null, null, null};
    public static final int RPR_INTERFACE_NUMBER_INDEX = 0;
    public static final int RPR_SPAN_NAME_INDEX = 1;
    public static final int RPR_SPAN_INDEX = 2;
    public static final int RPR_PSAS_INDEX = 3;
    public static final int RPR_SOAK_TIME_INDEX = 4;
    public static final int RPR_ADMIN_STATE_INDEX = 5;
    public static final int RPR_EDGE_INDEX = 6;
    public static final int RPR_FRAMING_TYPE_INDEX = 7;
    private static final int RPR_SPAN_TYPE_NO_EDGE = 0;
    private static final SDebug db = new SDebug("ML2RPRSpanInfoTableModel");

    public ML2RPRSpanInfoTableModel(ML2ModuleModel mL2ModuleModel, ML2PosPortModel[] mL2PosPortModelArray, EtherLineModel[] etherLineModelArray) {
        this.eqpmtModel = mL2ModuleModel;
        this.portModels = mL2PosPortModelArray;
        this.lineModels = etherLineModelArray;
        this.numPorts = mL2PosPortModelArray == null ? 0 : mL2PosPortModelArray.length;
        this.numLines = etherLineModelArray == null ? 0 : etherLineModelArray.length;
        this.isDirty = new boolean[this.numPorts][this.getColumnCount()];
        this.ml2RPRSpanStateInfo = new sRPRSpanStateInfo[this.numPorts];
        this.portName = new String[this.numPorts];
        this.suppress = new Boolean[this.numPorts];
        this.soakTime = new int[this.numPorts];
        this.resetDirty();
        this.registerWithLineModels();
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (n2 == 1 || n2 == 3 || n2 == 4) {
            bl = AbstractPane.isUserAuthorized(this.eqpmtModel, SecurityLevel.PROVISIONING);
        }
        return bl;
    }

    public boolean isCellDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public sRPRSpanStateInfo getRPRSpanStateInfo(int n) throws ProvisionError {
        if (this.ml2RPRSpanStateInfo[n] == null && this.portModels[n] instanceof ML2PosPortModel) {
            ML2PosPortModel mL2PosPortModel = this.portModels[n];
            this.ml2RPRSpanStateInfo[n] = mL2PosPortModel.getRPRSpanStateInfo();
        }
        if (ML2RPRSpanInfoTableModel.db.on) {
            db.println("getL2scRPRSpanInfo(" + n + ") was called.");
            db.println("   StationIndex: " + this.ml2RPRSpanStateInfo[n].rprStationIndex);
            db.println("   adminState:" + this.ml2RPRSpanStateInfo[n].adminState);
            db.println("   Jumbo:" + this.ml2RPRSpanStateInfo[n].jumbo);
            db.println("   edge:" + this.ml2RPRSpanStateInfo[n].edge.value());
            db.println("   framing:" + this.ml2RPRSpanStateInfo[n].framingType);
        }
        return this.ml2RPRSpanStateInfo[n];
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public int getRowCount() {
        return this.numPorts;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 3: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    private String getPortName(int n) {
        String string = "";
        if (this.portName[n] == null) {
            if (null == this.lineModels[n]) {
                string = "Unknown";
            } else {
                try {
                    this.portName[n] = string = this.lineModels[n].getAlias();
                }
                catch (Exception exception) {
                    if (ML2RPRSpanInfoTableModel.db.on) {
                        db.println("Exception caught accessing port name: " + exception);
                    }
                    string = exception.toString();
                }
            }
        }
        return this.portName[n];
    }

    private void setPortName(int n, String string) {
        this.getPortName(n);
        try {
            if (null != this.lineModels[n] && null != string) {
                this.portName[n] = string;
                this.isDirty[n][1] = true;
            }
        }
        catch (Exception exception) {
            if (ML2RPRSpanInfoTableModel.db.on) {
                db.println("Exception caught setting port name: " + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private String getRPRStationIndex(int n) {
        String string = null;
        try {
            this.getRPRSpanStateInfo(n);
            int n2 = this.ml2RPRSpanStateInfo[n].rprStationIndex;
            string = String.valueOf(n2);
            return string;
        }
        catch (Exception exception) {
            if (ML2RPRSpanInfoTableModel.db.on) {
                db.println("Exception caught accessing RPR Station Index: " + exception);
            }
            return "Unknown";
        }
    }

    private String getRPRSpanIndex(int n) {
        String string = null;
        if (n == 0) {
            string = "RPR East";
        } else if (n == 1) {
            string = "RPR West";
        }
        return string;
    }

    private Boolean getPreServiceAlarmSuppress(int n) {
        block4: {
            this.suppress[n] = Boolean.valueOf("false");
            if (this.lineModels[n] instanceof ML2PosLineModel) {
                try {
                    this.suppress[n] = ((ML2PosLineModel)this.lineModels[n]).getPreServiceAlarmSuppress();
                    if (ML2RPRSpanInfoTableModel.db.on) {
                        db.println("getPSAS: row " + n + " suppress " + this.suppress[n]);
                    }
                }
                catch (Exception exception) {
                    if (!ML2RPRSpanInfoTableModel.db.on) break block4;
                    db.println("Exception caught accessing PSAS: " + exception);
                }
            }
        }
        return this.suppress[n];
    }

    private void setPreServiceAlarmSuppress(int n, Boolean bl) {
        this.suppress[n] = bl;
        this.isDirty[n][3] = true;
        if (ML2RPRSpanInfoTableModel.db.on) {
            db.println("setPSAS, row " + n + " newSuppress " + bl);
        }
    }

    private String getSoakTimeAsHHMM(int n) throws NoSuchInterface {
        return SoakTimePropertyEditor.toStringHHMM(this.soakTime[n]);
    }

    private String getRPRAdminState(int n) {
        boolean bl;
        String string;
        block2: {
            string = "";
            bl = false;
            try {
                this.getRPRSpanStateInfo(n);
                bl = this.ml2RPRSpanStateInfo[n].adminState;
            }
            catch (Exception exception) {
                if (!ML2RPRSpanInfoTableModel.db.on) break block2;
                db.println("Exception caught accessing RPR admin state: " + exception);
            }
        }
        string = bl ? "Up" : "Down";
        return string;
    }

    private String getRPREdgeState(int n) {
        eRPRTopoEdge eRPRTopoEdge2;
        String string;
        block2: {
            string = "";
            eRPRTopoEdge2 = eRPRTopoEdge.NO_EDGE;
            try {
                this.getRPRSpanStateInfo(n);
                eRPRTopoEdge2 = this.ml2RPRSpanStateInfo[n].edge;
            }
            catch (Exception exception) {
                if (!ML2RPRSpanInfoTableModel.db.on) break block2;
                db.println("Exception caught accessing RPR Edge state: " + exception);
            }
        }
        string = eRPRTopoEdge2.value() == 0 ? "No" : "Yes";
        return string;
    }

    private Attribute getRPRFramingType(int n) {
        Attribute attribute;
        block2: {
            attribute = null;
            ePosFramingType ePosFramingType2 = ePosFramingType.X86;
            try {
                this.getRPRSpanStateInfo(n);
                ePosFramingType2 = this.ml2RPRSpanStateInfo[n].framingType;
                attribute = EtherEnumStrings.get(ePosFramingType.class, ePosFramingType2.value());
            }
            catch (Exception exception) {
                if (!ML2RPRSpanInfoTableModel.db.on) break block2;
                db.println("Exception caught accessing RPR framingType: " + exception);
            }
        }
        return attribute;
    }

    public Object getValueAt(int n, int n2) {
        String string;
        block12: {
            string = "";
            try {
                switch (n2) {
                    case 0: {
                        return this.getRPRStationIndex(n);
                    }
                    case 2: {
                        return this.getRPRSpanIndex(n);
                    }
                    case 1: {
                        return this.getPortName(n);
                    }
                    case 3: {
                        return this.suppress[n];
                    }
                    case 4: {
                        return this.getSoakTimeAsHHMM(n);
                    }
                    case 5: {
                        return this.getRPRAdminState(n);
                    }
                    case 6: {
                        return this.getRPREdgeState(n);
                    }
                    case 7: {
                        return this.getRPRFramingType(n);
                    }
                }
            }
            catch (Exception exception) {
                if (!ML2RPRSpanInfoTableModel.db.on) break block12;
                db.println("Error in getValueAt in ML2RPRSpanInfoTableModel " + exception);
                SDebug.printStackTrace((Throwable)exception);
                string = exception.toString();
            }
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public void setValueAt(Object var1_1, int var2_2, int var3_3) {
        switch (var3_3) {
            case 0: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                return;
            }
            case 1: {
                if (!(var1_1 instanceof String)) break;
                var4_4 = (String)var1_1;
                this.setPortName(var2_2, var4_4);
                break;
            }
            case 3: {
                if (!(var1_1 instanceof Boolean)) break;
                var4_5 = (Boolean)var1_1;
                this.setPreServiceAlarmSuppress(var2_2, var4_5);
                break;
            }
            case 4: {
                var4_6 = this.soakTime[var2_2];
                try {
                    var4_6 = SoakTimePropertyEditor.toIntValue((String)var1_1);
                }
                catch (NumberFormatException var5_7) {
                    if (!ML2RPRSpanInfoTableModel.db.on) ** GOTO lbl22
                    ML2RPRSpanInfoTableModel.db.println("Number Format Exception on " + (String)var1_1);
                }
lbl22:
                // 3 sources

                if (this.soakTime[var2_2] == var4_6) {
                    return;
                }
                this.soakTime[var2_2] = var4_6;
                this.isDirty[var2_2][4] = true;
                break;
            }
            default: {
                return;
            }
        }
        this.isDirty[var2_2][var3_3] = true;
        this.fireTableCellUpdated(var2_2, var3_3);
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public void resetDirty() {
        for (int i = 0; i < this.numPorts; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshLineFromModel(int n) {
        block3: {
            this.ml2RPRSpanStateInfo[n] = null;
            this.portName[n] = null;
            this.suppress[n] = this.getPreServiceAlarmSuppress(n);
            if (ML2RPRSpanInfoTableModel.db.on) {
                db.println("refreshLineFromModel: line " + n + " suppress " + this.suppress[n]);
            }
            try {
                this.soakTime[n] = this.lineModels[n].getSoakTime();
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!ML2RPRSpanInfoTableModel.db.on) break block3;
                db.println("No Such Interface: " + (Object)((Object)noSuchInterface));
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    public void applyToModel() throws Exception {
        for (int i = 0; i < this.portModels.length; ++i) {
            if (this.isDirty[i][1]) {
                try {
                    this.lineModels[i].setAlias(this.portName[i]);
                }
                catch (Exception exception) {
                    if (ML2RPRSpanInfoTableModel.db.on) {
                        db.println("Exception caught trying to set port name : " + exception);
                    }
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (this.isDirty[i][3] && this.lineModels[i] instanceof ML2PosLineModel) {
                ((ML2PosLineModel)this.lineModels[i]).setPreServiceAlarmSuppress(this.suppress[i]);
                if (db.on()) {
                    db.println("applyToModel: row " + i + " setting PSAS " + this.suppress[i]);
                }
            }
            if (this.isDirty[i][4]) {
                if (db.on()) {
                    db.println("setting line soakTime " + this.soakTime[i]);
                }
                this.lineModels[i].setSoakTime(this.soakTime[i]);
            }
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refresh() {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
    }

    public void destroy() {
        this.unRegisterWithLineModels();
        this.portModels = null;
        this.lineModels = null;
        this.eqpmtModel = null;
        this.resetDirty();
        for (int i = 0; i < this.ml2RPRSpanStateInfo.length; ++i) {
            this.ml2RPRSpanStateInfo[i] = null;
            this.portName[i] = null;
            this.suppress[i] = null;
        }
        this.ml2RPRSpanStateInfo = null;
        this.portName = null;
    }

    private void registerWithLineModels() {
        if (this.lineModels != null) {
            for (int i = 0; i < this.numLines; ++i) {
                this.lineModels[i].addObserver(this);
            }
        }
    }

    private void unRegisterWithLineModels() {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].deleteObserver(this);
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            int n;
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            if ((n = Arrays.asList(this.lineModels).indexOf(observable)) != -1) {
                this.refreshLineFromModel(n);
            }
        }
    }
}

