/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.mrc;

import cerent.cms.model.EntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.event.StoreObservable;
import cerent.cms.ui.ppm.PpmSlot;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Observable;

public class MrcCard
extends CardGraphic {
    private PpmSlot[] ppmSlots = null;

    public MrcCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug) {
        super(entityModel, abstractShelfLayout, sDebug);
        this.createChildren();
        if (sDebug.on()) {
            sDebug.println("Card: " + entityModel.getEqLabel() + "\tNum of children: " + this.entityM.getChildren().size());
        }
    }

    private void createChildren() {
        block5: {
            try {
                List list = this.entityM.getChildren();
                this.ppmSlots = new PpmSlot[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    EntityModel entityModel = (EntityModel)list.get(i);
                    if (entityModel == null) {
                        if (!this.db.on()) continue;
                        this.db.println("Entity for PPM slot [" + i + "] is NULL");
                        continue;
                    }
                    PluggableSlotModel pluggableSlotModel = null;
                    if (entityModel instanceof PluggableSlotModel) {
                        pluggableSlotModel = (PluggableSlotModel)entityModel;
                        this.ppmSlots[i] = new PpmSlot(pluggableSlotModel, this.parent, this.db, this.getChildBounds(i));
                        continue;
                    }
                    if (!this.db.on()) continue;
                    this.db.println("Model is NOT PluggableSlotModel");
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block5;
                this.db.println("Exception while creating PPM slots");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public PpmSlot[] getChildren() {
        return this.ppmSlots;
    }

    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            for (int i = 0; i < this.ppmSlots.length; ++i) {
                if (!this.ppmSlots[i].contains(mouseEvent.getPoint())) continue;
                return this.ppmSlots[i].getTooltipText(mouseEvent);
            }
            return super.getTooltipText(mouseEvent);
        }
        catch (Exception exception) {
            this.db.println("exception in getTooltipText: " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void update(Observable observable, Object object) {
        Object[] objectArray;
        if (observable instanceof StoreObservable && object instanceof Object[] && (objectArray = (Object[])object)[0] == ModelUpdateType.DELETED) {
            return;
        }
        super.update(observable, object);
        if (this.db.on()) {
            this.db.println("MrcCard:update: END");
        }
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        super.paintIcon(component, graphics, n, n2);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.ppmSlots == null) {
            return;
        }
        for (int i = 0; i < this.ppmSlots.length; ++i) {
            if (this.ppmSlots[i] == null) continue;
            this.ppmSlots[i].draw(graphics2D);
        }
    }

    protected Rectangle getChildBounds(int n) {
        if (this.ppmSlots.length > 5) {
            return new Rectangle(this.getMiniPortX(n), this.getMiniPortY(n), this.cardPainter.getMiniPortWidth(), this.cardPainter.getMiniPortHeight());
        }
        return new Rectangle(this.cardPainter.getPortX(0, n), this.cardPainter.getPortY(0, n), this.cardPainter.getPortWidth(), this.cardPainter.getPortHeight());
    }

    private int getMiniPortX(int n) {
        int n2 = this.cardPainter.getMultiPortOpticonXOffset() - 6;
        int n3 = this.cardPainter.getMiniOpticonXSpacing();
        return n2 + n3 * n + n % 2 * 12;
    }

    private int getMiniPortY(int n) {
        int n2 = this.cardPainter.getMiniOpticonYOffset();
        int n3 = this.cardPainter.getMiniOpticonYSpacing();
        return (n2 += this.pci.is455() ? 5 : 10) + (n3 += this.pci.is455() ? -5 : -7) * 2 * (n / 2);
    }

    public void dispose() {
        for (int i = 0; i < this.ppmSlots.length; ++i) {
            if (this.ppmSlots[i] == null) continue;
            this.ppmSlots[i].dispose();
            this.ppmSlots[i] = null;
        }
        this.ppmSlots = null;
        super.dispose();
    }
}

