/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ms;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.IShelfViewModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ms.RackViewPanel;
import cerent.cms.ui.ms.ShelfBehavior;
import cerent.cms.ui.ms.ShelfTransferHandler;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import cerent.util.gui.ActionOrganizer;
import cerent.util.gui.GridBagPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class BayViewPanel
extends GridBagPanel
implements ActionListener,
IObserver {
    public static final int BAY_WIDTH = 210;
    public static final int BAY_HEIGHT = 10;
    private static final int BAY_TOP_BORDER = 1;
    private static final int BAY_BTM_BORDER = 0;
    private static final int BAY_VRT_BORDER = 2;
    private IShelfViewModel chassis = null;
    private AbstractShelfLayout asl = null;
    private RackViewPanel parent;
    private short bayNumber;
    private int bayOccupied = 1;
    private JPopupMenu popup;
    private JMenu addMenu;
    private ActionOrganizer actOrg;
    private ShelfBehavior behavior;
    private final boolean userPriv;
    protected static final SDebug db = new SDebug("BayViewPanel");

    public BayViewPanel(RackViewPanel rackViewPanel, short s) {
        this.bayNumber = s;
        this.parent = rackViewPanel;
        db.fine("<init>");
        this.behavior = new ShelfBehavior(rackViewPanel.getNodeModel(), db);
        this.userPriv = AbstractPane.isUserAuthorized(rackViewPanel.getNodeModel(), SecurityLevel.SUPERUSER);
        this.setBackground(Color.gray.brighter());
        this.setToolTipText("RU #" + s);
        this.setBorder(BorderFactory.createMatteBorder(1, 2, 0, 2, Color.black));
        this.setBayOccupied(1);
        this.gbl.setConstraints(this, this.gbc);
        this.popup = new JPopupMenu();
        this.actOrg = new ActionOrganizer(this);
        this.addMenu = new JMenu("Add Shelf");
        this.actOrg.addMenuItem((JComponent)this.popup, this.addMenu, null, "Add Shelf");
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
        this.setTransferHandler(new ShelfTransferHandler(rackViewPanel.getNodeModel().getChassisModelsInstance(), rackViewPanel.getMVP()));
    }

    public synchronized boolean isEmpty() {
        return this.chassis == null;
    }

    public RackViewPanel getRVP() {
        return this.parent;
    }

    public short getBayOccupied() {
        return (short)this.bayOccupied;
    }

    private void setBayOccupied(int n) {
        this.bayOccupied = n;
        int n2 = 10 * n;
        Dimension dimension = new Dimension(210, n2);
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setVisible(true);
    }

    public void showHideBay(boolean bl) {
        if (!bl && !this.isEmpty()) {
            this.bayRemoved();
        }
        this.setVisible(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (this.actOrg.getMenuItem(string) != null) {
            Object object;
            Object[] objectArray = this.behavior.getAvailableShelfIds(string);
            Object[] objectArray2 = this.behavior.getShelfSizes(string, this.parent.getBayFreeCount(this.getBayNum()));
            Object[] objectArray3 = this.behavior.getAvailableSlots(string);
            short s = -1;
            short s2 = -1;
            short s3 = 1;
            if (objectArray2.length > 1) {
                object = JOptionPane.showInputDialog(this, "Choose the Shelf dimension", "Number of RU Selection", 1, null, objectArray2, objectArray2[0]);
                if (object != null) {
                    s = ((Integer)object).shortValue();
                }
            } else {
                s = objectArray2[0].shortValue();
            }
            if (objectArray3.length > 1) {
                object = JOptionPane.showInputDialog(this, "Choose the Slot Number", "Slot Number Selection", 1, null, objectArray3, objectArray3[0]);
                s3 = object != null ? (short)((Integer)object).shortValue() : (short)-1;
            }
            if (objectArray.length > 0) {
                if (objectArray.length == 1 && objectArray[0] == 0) {
                    s2 = 0;
                } else {
                    object = JOptionPane.showInputDialog(this, "Choose a Shelf ID", "Shelf ID Selection", 1, null, objectArray, objectArray[0]);
                    if (object != null) {
                        s2 = ((Integer)object).shortValue();
                    }
                }
            } else {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_MAX_PROVISIONED_SHELVES);
            }
            if (s2 != -1 && s != -1 && s3 != -1) {
                this.behavior.addShelf(this, s2, this.parent.getRackNum(), this.bayNumber, s, s3, string);
            }
        }
    }

    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof IShelfViewModel) {
            IShelfViewModel iShelfViewModel = (IShelfViewModel)iObservable;
            if (object == ModelUpdateType.DELETED) {
                db.fine("update(" + iShelfViewModel + ", " + "DELETED");
                if (iShelfViewModel == this.chassis) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            BayViewPanel.this.bayRemoved();
                            BayViewPanel.this.repaint(BayViewPanel.this.getVisibleRect());
                        }
                    });
                } else {
                    db.severe("ERROR! Received DELETED update from wrong ChassisModel!");
                }
            } else if (object == ModelUpdateType.ADDED) {
                AbstractShelfLayout abstractShelfLayout;
                db.fine("update(" + iObservable + ", " + "ADDED");
                if (this.chassis != null) {
                    this.bayRemoved();
                }
                this.chassis = iShelfViewModel;
                this.asl = abstractShelfLayout = iShelfViewModel.getPlatform().getMsShelfLayout(iShelfViewModel, this.parent.getViewController(), this);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BayViewPanel.this.setBayOccupied(BayViewPanel.this.chassis.getRUOccupied());
                        BayViewPanel.this.getRVP().setBayOccupied(BayViewPanel.this.getBayNum(), false);
                        BayViewPanel.this.add((Component)abstractShelfLayout, 0, 0);
                        BayViewPanel.this.revalidate();
                    }
                });
                this.parent.update((IObservable)iShelfViewModel, ModelUpdateType.ADDED);
                this.chassis.addObserver(this);
            } else if (object != ModelUpdateType.CHANGED && object != ModelUpdateType.STRUCTURE_CHANGED) {
                db.warning("Received multipled ADDEDs for " + this.chassis);
            }
        }
    }

    void alertUserToChange() {
        if (this.asl != null) {
            this.asl.highlight();
        }
    }

    void bayRemoved() {
        if (this.asl != null) {
            this.removeAll();
            this.getRVP().setBayOccupied(this.getBayNum(), true);
            this.setBayOccupied(1);
            this.asl.destroy();
            this.asl = null;
            if (this.chassis != null) {
                this.chassis.deleteObserver(this);
                this.chassis = null;
            }
            this.parent.update((IObservable)this.chassis, ModelUpdateType.DELETED);
        }
    }

    IShelfViewModel getChassis() {
        return this.chassis;
    }

    public short getBayNum() {
        return this.bayNumber;
    }

    public String toString() {
        return "bay " + this.bayNumber + ", size " + this.bayOccupied + ", " + super.toString();
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
            BayViewPanel.this.parent.getMVP().setSelectedShelf(null);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                short s = BayViewPanel.this.parent.getBayFreeCount(BayViewPanel.this.getBayNum());
                int n = 65;
                if (s > 0) {
                    for (eEqType eEqType2 : BayViewPanel.this.behavior.getProvisionableShelves()) {
                        String string = BayViewPanel.this.behavior.getShelfName(eEqType2);
                        BayViewPanel.this.actOrg.removeMenuItem(BayViewPanel.this.addMenu, string);
                        if (s < ChassisModels.getChassisHeight(eEqType2)) continue;
                        eEqType[] eEqTypeArray = BayViewPanel.this.behavior.getProvisionableUnitsOnShelf(eEqType2);
                        if (eEqTypeArray != null) {
                            JMenu jMenu = new JMenu(string);
                            BayViewPanel.this.actOrg.addMenuItem((JComponent)BayViewPanel.this.addMenu, jMenu, null, string);
                            for (eEqType eEqType3 : eEqTypeArray) {
                                string = BayViewPanel.this.behavior.getShelfName(eEqType3);
                                if (s < ChassisModels.getChassisHeight(eEqType3)) continue;
                                BayViewPanel.this.actOrg.addMenuItem((JComponent)jMenu, null, string, n++);
                                BayViewPanel.this.actOrg.setEnabled(string, BayViewPanel.this.userPriv);
                            }
                            continue;
                        }
                        BayViewPanel.this.actOrg.addMenuItem((JComponent)BayViewPanel.this.addMenu, null, string, n++);
                        BayViewPanel.this.actOrg.setEnabled(string, BayViewPanel.this.userPriv);
                    }
                    BayViewPanel.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }
}

