/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.muxdemux;

import cerent.cms.idl.Optics.eSwitchablePortState;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.muxdemux.MuxDmuxParametersTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;

public class MuxDmuxMaintenanceTableModel
extends MuxDmuxParametersTableModel {
    private static final int ADD_PASS_32_OFFSET = 32;
    private static final int ADD_PASS_40_OFFSET = 40;
    public static final int LAMBDA_INDEX = 0;
    public static final int LAMBDA_N_METER = 1;
    public static final int PORTS_STATS_INDEX = 2;
    public static final int TYP_ADD = 0;
    public static final int TYP_PASS_TH = 1;
    public static final int TYP_HI_IMP = 2;
    public static final int ACTUAL_VAL = 0;
    public static final int OLD_VAL = 1;
    public static final String[] columnNames = new String[]{"Channel #", "OCHNC Wavelength", "Operating Mode"};
    public static final String[] AddPassStatusStrings = new String[]{"Add Drop", "Pass Through", "Not Assigned"};
    private final int[][] addPassStatus = new int[this.getRowCount()][2];
    private int offset;
    private static final SDebug db = new SDebug("MuxDmxMaintenanceTableModel");

    public MuxDmuxMaintenanceTableModel(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        super(abstractOpticsLineModelArray);
        this.isDirty = new boolean[this.getRowCount()][this.getColumnCount()];
        for (int i = 0; i < this.addPassStatus.length; ++i) {
            this.addPassStatus[i][0] = -1;
            this.addPassStatus[i][1] = -1;
        }
        this.offset = this.getRowCount() == 40 ? 40 : 32;
    }

    public int getRowCount() {
        return this.numLines / 2;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int n) {
        return Object.class;
    }

    private String getAddPassStatus(int n) {
        return AddPassStatusStrings[this.getAddPassStatFromModel(n)];
    }

    private int getAddPassStatFromModel(int n) {
        int n2 = -1;
        int n3 = -1;
        if (this.addPassStatus[n][0] < 0 && this.model[this.getAddId(n)] != null && this.model[this.getPtId(n)] != null && this.model[n] instanceof OpticsChannelModel) {
            try {
                n2 = this.model[this.getAddId(n)].getAddPTPortState();
                n3 = this.model[this.getPtId(n)].getAddPTPortState();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            if (!eSwitchablePortState.from_int(n2).equals(eSwitchablePortState.ACTIVE) || !eSwitchablePortState.from_int(n3).equals(eSwitchablePortState.ACTIVE)) {
                if (n2 == 1 && n3 == 0) {
                    this.addPassStatus[n][0] = 0;
                } else if (n2 == 0 && n3 == 1) {
                    this.addPassStatus[n][0] = 1;
                } else if (n2 == 0 && n3 == 0) {
                    this.addPassStatus[n][0] = 2;
                }
            }
        }
        return this.addPassStatus[n][0];
    }

    private int getAddId(int n) {
        return n;
    }

    private int getPtId(int n) {
        return n + this.offset;
    }

    public String[] getAddPassStatusStrings() {
        return AddPassStatusStrings;
    }

    public String[] getWavelengthStrings() {
        if (this.eqpmtModel.isWSS32_L_CARD()) {
            return MuxDmx32_L_WavelengthStrings;
        }
        if (this.eqpmtModel.isWSS40_LINE_CARD()) {
            return MuxDmx40_CEvenOdd_WavelengthStrings;
        }
        if (this.eqpmtModel.isWSS40_L_LINE_CARD()) {
            return MuxDmx40_L_WavelengthStrings;
        }
        return WavelengthStrings;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 2;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return new Integer(n + 1);
                }
                case 1: {
                    if (this.eqpmtModel.isWSS32_L_CARD()) {
                        return Wavelength.getOchncLWavelengthAttrs(32)[n].toString();
                    }
                    if (this.eqpmtModel.isWSS40_LINE_CARD()) {
                        if (((OpticsModuleModel)this.eqpmtModel).isEvenWavelengthCard()) {
                            return Wavelength.getOchncCEWavelengthAttrs(40)[n].toString();
                        }
                        return Wavelength.getOchncCWavelengthAttrs(40)[n].toString();
                    }
                    if (this.eqpmtModel.isWSS40_L_LINE_CARD()) {
                        return Wavelength.getOchncLWavelengthAttrs(40)[n].toString();
                    }
                    return Wavelength.getOchncCWavelengthAttrs(32)[n].toString();
                }
                case 2: {
                    return this.getAddPassStatus(n);
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("MuxDmuxMaintenanceTableModel: error in getValueAt" + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 2: {
                int n3 = 0;
                n3 = this.getIndexOf((String)object, AddPassStatusStrings);
                int n4 = this.addPassStatus[n][0];
                this.addPassStatus[n][0] = n3;
                this.addPassStatus[n][1] = n4;
                if (n3 == n4) break;
                this.isDirty[n][n2] = true;
                break;
            }
            default: {
                return;
            }
        }
        this.fireTableCellUpdated(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyToModel() throws Exception {
        int n = 0;
        boolean bl = false;
        try {
            for (n = 0; n < this.getRowCount(); ++n) {
                if (this.isDirty[n][2] && !this.FlgOkDialog) {
                    if (CerentDialog.yesNoDialog((Component)this.getFrame(), (String)"The selected operation could be service affecting. Is it OK to apply the changes anyway?", (String)"Confirmation Dialog")) {
                        this.FlgOkDialog = true;
                    } else {
                        this.refreshFromModel();
                        return;
                    }
                }
                if (!this.isDirty[n][2]) continue;
                this.setStatus(n, this.addPassStatus[n][0], this.addPassStatus[n][1]);
                this.addPassStatus[n][1] = -1;
            }
        }
        catch (FeatureUnsupported featureUnsupported) {
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_FEATURE_CANT_BE_USED_CKT);
            this.refreshFromModel();
        }
        catch (ProvisionError provisionError) {
            ErrorMsg.displayDetailed((Component)this.getFrame(), EMC.EID_ACTION_NOTALLOWED, provisionError.toString());
            this.refreshFromModel();
        }
        catch (Exception exception) {
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ACTION_NOTALLOWED);
            this.refreshFromModel();
        }
        finally {
            this.resetDirtyBits();
        }
    }

    private boolean setStatus(int n, int n2, int n3) throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType, ProvisionError {
        boolean bl = false;
        AbstractOpticsLineModel abstractOpticsLineModel = null;
        eSwitchablePortState eSwitchablePortState2 = null;
        if (n3 == 2) {
            eSwitchablePortState2 = eSwitchablePortState.ACTIVE;
            if (n2 == 0) {
                abstractOpticsLineModel = this.model[this.getAddId(n)];
            } else if (n2 == 1) {
                abstractOpticsLineModel = this.model[this.getPtId(n)];
            }
        } else if (n3 == 0 && n2 == 1) {
            abstractOpticsLineModel = this.model[this.getAddId(n)];
            eSwitchablePortState2 = eSwitchablePortState.STANDBY;
            bl = true;
        } else if (n3 == 1 && n2 == 0) {
            abstractOpticsLineModel = this.model[this.getPtId(n)];
            eSwitchablePortState2 = eSwitchablePortState.STANDBY;
            bl = true;
        } else if (n2 == 2) {
            eSwitchablePortState2 = eSwitchablePortState.STANDBY;
            if (n3 == 0) {
                abstractOpticsLineModel = this.model[this.getAddId(n)];
            } else if (n3 == 1) {
                abstractOpticsLineModel = this.model[this.getPtId(n)];
            }
        } else {
            return false;
        }
        abstractOpticsLineModel.setAddPTPortState(eSwitchablePortState2);
        if (bl) {
            return this.setStatus(n, n2, 2);
        }
        if (MuxDmuxMaintenanceTableModel.db.on) {
            db.println("setStatus: ACTUAL->" + AddPassStatusStrings[n2] + " OLD->" + AddPassStatusStrings[n3]);
            db.println("set status " + eSwitchablePortState2.value());
            db.println("on port:" + this.model[this.getAddId(n)].getPortName());
        }
        return true;
    }

    public void refreshLineFromModel(int n) {
        int n2 = 0;
        n2 = n >= this.offset ? n - this.offset : n;
        if (n2 < this.getRowCount()) {
            this.resetLineCache(n2);
            this.addPassStatus[n2][0] = this.getAddPassStatFromModel(n2);
            this.fireTableRowsUpdated(n2, this.getRowCount() - 1);
        } else if (MuxDmuxMaintenanceTableModel.db.on) {
            db.println("refreshLineFromModel error lineid=" + n);
        }
    }

    protected void resetLineCache(int n) {
        this.addPassStatus[n][0] = -1;
        this.addPassStatus[n][1] = -1;
        super.resetLineCache(n);
    }
}

