/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.ChassisModelUpdate;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.InvalidData;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.SlotModel;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.WzTask;
import cerent.util.SDebug;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class AnpManager
extends WzTask
implements Observer {
    private final short shelfId;
    private final short rackNum;
    private final short rackPos;
    private final boolean isRelative;
    private final String shType;
    private int pos;
    private ChassisModels cms;
    private IChassisModel[] ent = null;
    private EntityModel entS = null;
    private EntityModel backplane = null;
    private List lst = null;
    private List slots = null;
    private int cardCounter;
    private boolean searching = false;
    private Vector modelHandles = new Vector();
    private static final SDebug db = new SDebug("AnpManager");

    public AnpManager(NsdWizardInfo nsdWizardInfo, int n, NodeModelDelegate nodeModelDelegate) {
        super(nsdWizardInfo, nodeModelDelegate);
        NsdWizardInfo.NodeStructure nodeStructure = nsdWizardInfo.getAnp().elementAt(n);
        this.shelfId = Short.parseShort(nodeStructure.shelf);
        this.rackNum = Short.parseShort(nodeStructure.rackNum);
        this.rackPos = nodeStructure.RUPos != null ? Short.parseShort(nodeStructure.RUPos) : Short.parseShort(nodeStructure.rackPos);
        this.isRelative = nodeStructure.RUPos == null;
        this.shType = nodeStructure.shType;
        this.pos = n;
        this.cms = nodeModelDelegate.getChassisModelsInstance();
        this.cardCounter = nodeStructure.slot.size();
    }

    public synchronized void doTask() {
        this.setWorking();
        if (this.pos == 0) {
            this.wzInfo.logInfo(">> Starting Automatic Node Provisioning...\n");
            this.wzInfo.logInfo(">> Provisioning Shelf #" + this.shelfId + "..." + "\n");
        }
        if (this.prepare()) {
            if (this.pos != 0) {
                this.wzInfo.logInfo("\n>> Provisioning Shelf #" + this.shelfId + "..." + "\n");
            }
            this.provisionShelf();
            this.wzInfo.logInfo("------------------------------------------------");
        }
    }

    private boolean prepare() {
        if (this.node.isMultishelf()) {
            boolean bl = false;
            this.ent = (IChassisModel[])this.node.getChassisModels();
            for (int i = 0; i < this.ent.length && !bl; ++i) {
                if (this.ent[i].getShelfId() != this.shelfId) continue;
                this.lst = ((EntityModel)((Object)this.ent[i])).getChildrenOfType(eClass.BACKPLANE);
                bl = true;
                if (this.shelfId != 1 || this.ent[i].getRackPosition() == this.rackPos) continue;
                this.wzInfo.logInfo("\n>> Change position of Shelf #" + this.shelfId + "...");
                try {
                    this.cms.swapChassisPositions(this.ent[i], this.rackNum, this.rackPos);
                    continue;
                }
                catch (Exception exception) {
                    this.wzInfo.logError("\n>> Failed to change position for Shelf #" + this.shelfId + "...");
                }
            }
            if (!bl) {
                if (!this.searching) {
                    this.cms.addObserver(this);
                    try {
                        eEqType eEqType2 = EntityModel.name2EqType(this.node, this.shType);
                        this.cms.provisionShelf(this.shelfId, this.rackNum, this.rackPos, eEqType2, this.isRelative);
                        this.searching = true;
                    }
                    catch (Exception exception) {
                        this.cms.deleteObserver(this);
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)exception);
                        }
                        this.wzInfo.logError("\n>> Error Provisioning Shelf #" + this.shelfId + "...");
                        String string = "";
                        if (exception instanceof InvalidData) {
                            string = "InvalidData Exception";
                        } else if (exception instanceof NotSupportedOnEquipment) {
                            string = "NotSupportedOnEquipment Exception";
                        } else if (exception instanceof ProvisionError) {
                            string = "ProvisionError Exception";
                        }
                        this.wzInfo.logError("\n>> " + string + "..." + "\n");
                        this.setCompleted();
                    }
                    return false;
                }
                return false;
            }
        } else {
            this.entS = (EntityModel)((Object)this.node.getNcChassis());
            if (this.entS == null && db.on()) {
                db.println("no chassis found");
            }
            this.lst = this.entS.getChildrenOfType(eClass.BACKPLANE);
        }
        if (this.lst == null) {
            db.println("no backplanes found");
        }
        if (this.lst != null && this.lst.size() > 0) {
            this.backplane = (EntityModel)this.lst.get(0);
        }
        if (this.backplane == null && db.on()) {
            db.println("no backplane found");
        }
        this.slots = null;
        if (this.backplane != null) {
            this.slots = this.backplane.getChildren();
        }
        if (this.slots == null && db.on()) {
            db.println("no slots found");
        }
        return true;
    }

    private void provisionShelf() {
        NsdWizardInfo.NodeStructure nodeStructure = this.wzInfo.getAnp().elementAt(this.pos);
        int n = 0;
        String string = null;
        for (int i = 0; i < nodeStructure.slot.size(); ++i) {
            n = Integer.parseInt(nodeStructure.slot.elementAt(i));
            string = nodeStructure.eqType.elementAt(i);
            this.provisionSlot(n, string);
        }
    }

    private void provisionSlot(int n, String string) {
        Object object;
        int n2;
        this.wzInfo.logInfo(">> Provisioning Slot #" + n + " with " + string + " card...\n");
        EntityModel entityModel = (EntityModel)this.slots.get(n - 1);
        try {
            n2 = entityModel.getEntityIndex();
            object = EntityModel.name2EqType(this.node, string);
            entityModel.addObserver(this);
            this.modelHandles.add(entityModel);
            if (object != null) {
                this.entm.provisionModule(n2, (eEqType)object);
            }
            this.wzInfo.logInfo(">> Done...\n");
        }
        catch (ResourceInUse resourceInUse) {
            resourceInUse.printStackTrace();
            this.wzInfo.logError(">> Slot not empty...\n");
            --this.cardCounter;
        }
        catch (EMCProvisionError eMCProvisionError) {
            eMCProvisionError.printStackTrace();
            this.wzInfo.logError(">> Setting refused...\n");
            --this.cardCounter;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.wzInfo.logError(">> Generic error...\n");
        }
        if (this.cardCounter == 0) {
            for (n2 = 0; n2 < this.modelHandles.size(); ++n2) {
                object = (EntityModel)this.modelHandles.elementAt(n2);
                object.deleteObserver((Observer)this);
            }
            this.setCompleted();
        }
    }

    public void update(Observable observable, Object object) {
        block14: {
            int n;
            block13: {
                n = -1;
                if (!(observable instanceof ChassisModels)) break block13;
                n = object instanceof ChassisModelUpdate ? 2 : (Integer)object;
                switch (n) {
                    case 2: {
                        if (this.prepare()) {
                            if (this.pos != 0) {
                                this.wzInfo.logInfo("\n>> Provisioning Shelf #" + this.shelfId + "..." + "\n");
                            }
                            this.provisionShelf();
                            this.wzInfo.logInfo("------------------------------------------------");
                            this.cms.deleteObserver(this);
                        }
                        if (db.on()) {
                            db.println("updateObjectChanged(" + observable + ", " + object + ")");
                            break;
                        }
                        break block14;
                    }
                    default: {
                        if (db.on()) {
                            db.severe("Unknown update type " + n);
                            break;
                        }
                        break block14;
                    }
                }
                break block14;
            }
            if (observable instanceof SlotModel) {
                n = (Integer)object;
                switch (n) {
                    case 2: {
                        --this.cardCounter;
                        if (this.cardCounter == 0) {
                            for (int i = 0; i < this.modelHandles.size(); ++i) {
                                EntityModel entityModel = (EntityModel)this.modelHandles.elementAt(i);
                                entityModel.deleteObserver(this);
                            }
                            this.setCompleted();
                        }
                        if (!db.on()) break;
                        db.println("updateObjectChanged(" + observable + ", " + object + ")");
                        break;
                    }
                    default: {
                        if (!db.on()) break;
                        db.severe("Unknown update type " + n);
                    }
                }
            }
        }
    }
}

