/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ochterm;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsOchTermModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.PmPane;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ochterm.OchPmTableModel;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;

public class OchPmPane
extends PmPane {
    private OpticsOchTermModel[] models;
    private AbstractOpticsLineModel[] lowerInterfaces;
    private ObservableManager _obsMgr = null;
    private static final SDebug db = new SDebug("OchPmPane");

    public OchPmPane(String string, TabbedView tabbedView, AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        super(string, tabbedView);
        this.lowerInterfaces = abstractOpticsLineModelArray;
        this.models = this.getHO(abstractOpticsLineModelArray);
        this.registerWithModel();
        if (db.on()) {
            db.println("<init>");
        }
        this.init();
    }

    protected PmTableModel createDataModel() {
        if (db.on()) {
            db.println("createDataModel");
        }
        OchPmTableModel ochPmTableModel = new OchPmTableModel(this.lowerInterfaces, (NodeModelDelegate)this.getUiModel().getNodeModel());
        ochPmTableModel.addTableModelListener(this);
        return ochPmTableModel;
    }

    protected synchronized void updateHO() {
        if (this._obsMgr != null) {
            this._obsMgr.removeObservable((Observable[])this.models);
        }
        this.models = this.getHO(this.lowerInterfaces);
        if (this._obsMgr != null) {
            this._obsMgr.addObservable((Observable[])this.models);
        }
        ((PmTableModel)this.model).refreshMyLines(this.lowerInterfaces);
        this.setupControlBar(0, 0);
        this.refreshNow();
    }

    protected OpticsOchTermModel[] getHO(InterfaceModel[] interfaceModelArray) {
        Collection collection = InterfaceModel.getHigherLayerModels(interfaceModelArray, 1, this.getUiModel());
        return collection.toArray(new OpticsOchTermModel[0]);
    }

    protected void structureChangeMessage(Observable observable, Object object) {
        if (db.on()) {
            db.println("got an added message from " + observable);
        }
        this.updateHO();
    }

    protected void deleteMessage(Observable observable, Object object) {
        if (db.on()) {
            db.println("got a delete message from " + observable.getClass());
        }
        this.updateHO();
    }

    protected void registerWithModel() {
        this.registerForUpdates();
        super.registerWithModel();
    }

    protected void registerForUpdates() {
        this.getObsMgr().addObservable((Observable[])this.lowerInterfaces);
        this.getObsMgr().addObservable((Observable[])this.models);
    }

    protected void deregisterForUpdates() {
        if (this._obsMgr != null) {
            this._obsMgr.removeObservable((Observable[])this.lowerInterfaces);
            this._obsMgr.removeObservable((Observable[])this.models);
        }
    }

    protected ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
            this.getObsMgr().setPassing(true);
        }
        return this._obsMgr;
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
    }

    public void leavingPage() throws Exception {
        super.leavingPage();
    }

    public void destroy() {
        this.deregisterForUpdates();
        super.destroy();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.OchPmPane;
    }

    protected boolean needofWlCellRenderer() {
        return true;
    }
}

