/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oscm;

import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ampli.AmpliAlsTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class OscmMaintAlsPane
extends NodeProvPane
implements TableModelListener {
    protected OpticsModuleModel models;
    private InterfaceModel[] lineModels = null;
    private ModuleModel eqpmtModel = null;
    protected AmpliAlsTableModel dataModel;
    protected int numLines = 0;
    protected int thresholdLayer;
    private boolean notInited = true;
    private int ALSPort = 0;
    protected static final SDebug db = new SDebug("AmpliAlsPane");

    public OscmMaintAlsPane(String string, TabbedView tabbedView, OpticsModuleModel opticsModuleModel, int n) {
        super(string, tabbedView);
        this.models = opticsModuleModel;
        this.thresholdLayer = n;
    }

    protected void init() {
        this.eqpmtModel = (ModuleModel)this.getUiModel();
        this.ALSPort = 128 == this.eqpmtModel.getEqType() ? 6 : 2;
        this.lineModels = this.getLines();
        this.numLines = this.lineModels.length;
        this.dataModel = this.getDataModel(this.thresholdLayer);
        this.dataModel.addTableModelListener(this);
        this.table = new JTable(this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        TableColumn tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[0]);
        TableColumn tableColumn2 = this.table.getColumn(AmpliAlsTableModel.columnNames[7]);
        this.table.removeColumn(tableColumn);
        this.table.removeColumn(tableColumn2);
        TableColumn tableColumn3 = this.table.getColumn(AmpliAlsTableModel.columnNames[1]);
        tableColumn3.setCellEditor(new DefaultCellEditor(this.getComboBoxForOSRICommand()));
        tableColumn3.setPreferredWidth(70);
        tableColumn3 = this.table.getColumn(AmpliAlsTableModel.columnNames[2]);
        tableColumn3.setCellEditor(new DefaultCellEditor(this.getComboBoxForALSCommand()));
        tableColumn3.setPreferredWidth(200);
        tableColumn3 = this.table.getColumn(AmpliAlsTableModel.columnNames[3]);
        tableColumn3.setPreferredWidth(250);
        tableColumn3 = this.table.getColumn(AmpliAlsTableModel.columnNames[4]);
        tableColumn3.setPreferredWidth(250);
        tableColumn3 = this.table.getColumn(AmpliAlsTableModel.columnNames[5]);
        tableColumn3.setPreferredWidth(250);
        tableColumn3 = this.table.getColumn(AmpliAlsTableModel.columnNames[6]);
        tableColumn3.setPreferredWidth(250);
        this.registerWithModel();
        this.add((Component)uScrollPane, "Center");
        this.table.setAutoResizeMode(0);
        this.notInited = false;
    }

    protected void registerWithModel() {
        if (this.models != null) {
            this.models.addObserver((Observer)((Object)this));
        }
    }

    protected JComboBox getComboBoxForALSCommand() {
        JComboBox<String> jComboBox = new JComboBox<String>(this.dataModel.getALSCommandStrings());
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected JComboBox getComboBoxForOSRICommand() {
        JComboBox<String> jComboBox = new JComboBox<String>(this.dataModel.getOSRICommandStrings());
        jComboBox.setEditable(false);
        return jComboBox;
    }

    public void dispose() {
        if (this.models != null) {
            this.models.deleteObserver((Observer)((Object)this));
        }
    }

    public void leavingPage() throws Exception {
        if (this.table != null) {
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
        this.dataModel.refreshFromModel();
        super.leavingPage();
    }

    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
        this.dataModel.refreshFromModel();
    }

    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromReset();
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.notInited = true;
        super.destroy();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.dataModel.fireTableDataChanged();
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                OscmMaintAlsPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        try {
            this.dataModel.refreshLineFromModel(0);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_ROW_PARAM_1, (Object)"1");
        }
    }

    public void applyChangesToModel() throws Exception {
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    protected AmpliAlsTableModel getDataModel(int n) {
        return new AmpliAlsTableModel(this.models, this.lineModels);
    }

    protected InterfaceModel[] getLines() {
        PortModel[] portModelArray = this.eqpmtModel.getChildren().toArray(new PortModel[0]);
        if (db.on()) {
            db.println("number of Ports " + portModelArray.length);
        }
        InterfaceModel[] interfaceModelArray = new InterfaceModel[portModelArray.length];
        for (int i = 0; i < portModelArray.length; ++i) {
            interfaceModelArray[i] = (InterfaceModel)portModelArray[i].getInterfaceModel();
        }
        return interfaceModelArray;
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.OscmMaintAlsPane;
    }
}

