/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.EntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.OpticsPortGraphic;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Observable;

public abstract class AbstractOSCCard
extends CardGraphic {
    protected OpticsPortGraphic[] portGraphics = null;

    protected AbstractOSCCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug) {
        super(entityModel, abstractShelfLayout, sDebug, true);
        if (entityModel instanceof ModuleModel) {
            List list = entityModel.getChildren();
            int n = list.size();
            if (n > 4) {
                n = 5;
            }
            int n2 = this.cardPainter.getMiniPortHeight();
            int n3 = this.cardPainter.getMiniPortWidth();
            int n4 = this.cardPainter.getMultiPortOpticonXOffset();
            int n5 = this.cardPainter.getMiniOpticonYSpacing();
            int n6 = this.cardPainter.getMiniOpticonYOffset();
            int n7 = this.cardPainter.getOpticonXSpacing();
            this.portGraphics = new OpticsPortGraphic[n - 1];
            if (n < 4) {
                int n8;
                int n9 = 0;
                for (n8 = 0; n8 < n - 1; n8 += 2) {
                    this.portGraphics[n8] = new OpticsPortGraphic((CardGraphic)this, n4 + n7 * n8 - 6, n6 + 80 + ((n5 - 7) * n8 + n9), n3, n2, (OpticsPortModel)list.get(n8 + 1));
                }
                n9 = 0;
                n8 = 0;
                for (int i = 1; i < n - 1; i += 2) {
                    this.portGraphics[i] = new OpticsPortGraphic((CardGraphic)this, n4 + n7 * i + 6, n6 + 80 + ((n5 - 7) * n8 + n9), n3, n2, (OpticsPortModel)list.get(i + 1));
                    n8 += 2;
                }
            } else {
                int n10;
                int n11 = 0;
                for (n10 = 0; n10 < n - 1; n10 += 2) {
                    this.portGraphics[n10] = new OpticsPortGraphic((CardGraphic)this, n4 + n7 * n10 - 6, n6 + 80 + ((n5 - 7) * n10 + n11), n3, n2, (OpticsPortModel)list.get(n10 + 1));
                }
                n11 = 0;
                n10 = 0;
                for (int i = 1; i < n - 1; i += 2) {
                    this.portGraphics[i] = new OpticsPortGraphic((CardGraphic)this, n4 + n7 * i + 6, n6 + 80 + ((n5 - 7) * n10 + n11), n3, n2, (OpticsPortModel)list.get(i + 1));
                    n10 += 2;
                }
            }
            if (this.alarmStore != null) {
                this.update(this.alarmStore.getAlarmStatusObservable(), this.alarmStore.getAlarmStatus());
            }
        }
    }

    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (!this.portGraphics[i].contains(mouseEvent.getPoint())) continue;
                return this.portGraphics[i].getTooltipText();
            }
            return super.getTooltipText(mouseEvent);
        }
        catch (Exception exception) {
            this.db.println("exception in getTooltipText: " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (object instanceof AlarmStatus && this.portGraphics != null) {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (this.portGraphics[i] == null) continue;
                this.portGraphics[i].update(observable, this.alarmStore);
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.portGraphics != null) {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (this.portGraphics[i] == null) continue;
                this.portGraphics[i].dispose();
                this.portGraphics[i] = null;
            }
            this.portGraphics = null;
        }
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintIcon(component, graphics2D, n, n2);
        if (this.pci.is600()) {
            return;
        }
        for (int i = 0; i < this.portGraphics.length; ++i) {
            this.portGraphics[i].drawOnlyOneConnector(graphics2D, true, false);
        }
    }
}

