/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Synchronization.eRef;
import cerent.cms.idl.Synchronization.eResQualityLevel;
import cerent.cms.idl.Synchronization.eTimingMode;
import cerent.cms.idl.Synchronization.sSyncConfig;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.BadReference;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.InvalidClockSource;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SyncEntityModel;
import cerent.cms.model.SyncInvalidAisThreshold;
import cerent.cms.model.SyncInvalidCoding;
import cerent.cms.model.SyncInvalidExternalRefSource;
import cerent.cms.model.SyncInvalidFacility;
import cerent.cms.model.SyncInvalidFormat;
import cerent.cms.model.SyncInvalidProvisioningForMode;
import cerent.cms.model.SyncInvalidRefSource;
import cerent.cms.model.SyncProvBusy;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.SyncRefSourceCombinationMaximumExceeded;
import cerent.cms.model.SyncSourceAlreadyDefinedForSlot;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.RevertiveBehaviorPanel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TimingEntityComparator;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.WID;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class AbstractSppTimingPane
extends NodeProvPane {
    protected final int refCount = 3;
    protected static final String[] generationChoices = new String[]{"Generation 1", "Generation 2"};
    protected static final String[] g1ResAsChoices = new String[]{"PRS < RES", "STU < RES < PRS", "ST2 < RES < STU", "ST3 < RES < ST2", "SMC < RES < ST3", "ST4 < RES < SMC", "RES < ST4", "RES = DUS"};
    protected static final eResQualityLevel[] g1ResAsQuality = new eResQualityLevel[]{eResQualityLevel.abovePRS, eResQualityLevel.aboveSTU, eResQualityLevel.aboveST2, eResQualityLevel.aboveST3, eResQualityLevel.aboveSMC, eResQualityLevel.aboveST4, eResQualityLevel.belowST4, eResQualityLevel.sameAsDUS};
    protected static final String[] g2ResAsChoices = new String[]{"PRS < RES", "STU < RES < PRS", "ST2 < RES < STU", "TNC < RES < ST2", "ST3E < RES < TNC", "ST3 < RES < ST3E", "SMC < RES < ST3", "ST4 < RES < SMC", "RES < ST4", "RES = DUS"};
    protected static final eResQualityLevel[] g2ResAsQuality = new eResQualityLevel[]{eResQualityLevel.abovePRS, eResQualityLevel.aboveSTU, eResQualityLevel.aboveST2, eResQualityLevel.aboveTNC, eResQualityLevel.aboveST3E, eResQualityLevel.aboveST3, eResQualityLevel.aboveSMC, eResQualityLevel.aboveST4, eResQualityLevel.belowST4, eResQualityLevel.sameAsDUS};
    public static final int G1 = 1;
    public static final int G2 = 2;
    public static int generation;
    protected static final int g1ToG2Shift = 2;
    protected SynchronizationModel syncModel;
    private ElementModelsDelegate elementModels;
    protected JLabel tsLabel;
    protected JButton changeTS;
    protected JComboBox modeCB;
    protected JComboBox generationCB;
    protected JComboBox resAsCB;
    protected RevertiveBehaviorPanel syncRBP;
    protected sSyncConfig oldConfig;
    protected boolean lineTimed;
    protected SyncRefs neRef;
    protected SyncRefs ext1Ref;
    protected SyncRefs ext2Ref;
    protected eTimingMode timingMode;
    protected JPanel standardBox;
    private boolean _applyingChanges;
    private boolean _missedUpdate;
    protected Map timingModeAttributeMap;
    protected EntityCellRenderer entityCellRenderer;
    protected static final SDebug db;

    public synchronized void startApplyingChanges() {
        this._applyingChanges = true;
    }

    public synchronized boolean applyingChanges() {
        if (this._applyingChanges) {
            this._missedUpdate = true;
        }
        return this._applyingChanges;
    }

    public synchronized boolean stopApplyingChanges() {
        boolean bl = this._missedUpdate;
        this._applyingChanges = false;
        this._missedUpdate = false;
        return bl;
    }

    public AbstractSppTimingPane(String string, TabbedView tabbedView, SynchronizationModel synchronizationModel, ElementModelsDelegate elementModelsDelegate) {
        super(string, tabbedView);
        this.syncModel = synchronizationModel;
        this.elementModels = elementModelsDelegate;
        this._applyingChanges = false;
        this._missedUpdate = false;
    }

    public abstract JPanel createGeneralTimingBox();

    public JPanel createTimingStandardBox() {
        return null;
    }

    public void enteringPage() throws Exception {
        if (this.modeCB == null) {
            this.init();
        }
        super.enteringPage();
    }

    protected void init() {
        if (db.on()) {
            db.println("init: start");
        }
        this.timingModeAttributeMap = this.pci.getTimingModeAttributeMap();
        generation = 0;
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        JPanel jPanel = AbstractSppTimingPane.createVerticalPanel(null);
        this.standardBox = this.createTimingStandardBox();
        if (this.standardBox != null) {
            jPanel.add(this.standardBox);
        }
        jPanel.add(this.createGeneralTimingBox());
        jPanel.add(this.createRefListBox(this.parentTV));
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        uScrollPane.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
        this.add((Component)uScrollPane);
        this.syncModel.addObserver((Observer)((Object)this));
        this.addElementModelsObserver();
        if (db.on()) {
            db.println("init: finish");
        }
    }

    private void addElementModelsObserver() {
        block2: {
            try {
                this.elementModels.addObserver((Observer)((Object)this));
            }
            catch (Exception exception) {
                if (!AbstractSppTimingPane.db.on) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private void deleteElementModelsObserver() {
        if (this.elementModels != null) {
            this.elementModels.deleteObserver((Observer)((Object)this));
        }
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof ElementModelsDelegate) {
            SwingUtilities.invokeLater(new UpdateSelectors(this));
        } else if (observable instanceof SynchronizationModel) {
            this.requestRefresh((Object)this, null);
        }
    }

    protected JPanel createRefListBox(TabbedView tabbedView) {
        JPanel jPanel = new JPanel(null);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(BorderFactory.createTitledBorder("Reference Lists"));
        if (this.pci.getNumberOfTimingOutRef() > 1) {
            this.neRef = new SyncRefs(eRef.NE);
            this.ext1Ref = new SyncRefs(eRef.EXT_1);
        }
        if (this.pci.getNumberOfTimingOutRef() > 2) {
            this.ext2Ref = new SyncRefs(eRef.EXT_2);
        }
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.1;
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.3;
        jPanel.add((Component)new JLabel("NE Reference"), gridBagConstraints);
        if (this.pci.getNumberOfTimingOutRef() > 1) {
            gridBagConstraints.gridx += 3;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.weightx = 0.3;
            jPanel.add((Component)new JLabel("BITS-1 Out"), gridBagConstraints);
        }
        if (this.pci.getNumberOfTimingOutRef() > 2) {
            gridBagConstraints.gridx += 3;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.weightx = 0.3;
            jPanel.add((Component)new JLabel("BITS-2 Out"), gridBagConstraints);
        }
        for (int i = 0; i < 3; ++i) {
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.1;
            jPanel.add((Component)new JLabel("Ref-" + (i + 1) + ": "), gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.weightx = 0.3;
            jPanel.add((Component)this.neRef.getRefCB(i), gridBagConstraints);
            if (this.pci.getNumberOfTimingOutRef() > 1) {
                gridBagConstraints.gridx += 3;
                gridBagConstraints.gridwidth = 3;
                gridBagConstraints.weightx = 0.3;
                jPanel.add((Component)this.ext1Ref.getRefCB(i), gridBagConstraints);
            }
            if (this.pci.getNumberOfTimingOutRef() <= 2) continue;
            gridBagConstraints.gridx += 3;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.weightx = 0.3;
            jPanel.add((Component)this.ext2Ref.getRefCB(i), gridBagConstraints);
        }
        return jPanel;
    }

    public void destroy() {
        if (this.neRef != null) {
            this.syncModel.deleteObserver((Observer)((Object)this));
            this.deleteElementModelsObserver();
            this.neRef.destroy();
            this.neRef = null;
            if (this.ext1Ref != null) {
                this.ext1Ref.destroy();
                this.ext1Ref = null;
            }
            if (this.ext2Ref != null) {
                this.ext2Ref.destroy();
                this.ext2Ref = null;
            }
            this.removeAll();
            this.syncModel = null;
            this.elementModels = null;
        }
        super.destroy();
    }

    public void displayErrorDialog() {
        ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CANNOT_CHANGE_TIMING_WITH_FORCE);
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SppTimingGeneralPane;
    }

    static {
        db = new SDebug((KDebug)AbstractShelfProvPane.db, "AbstractSppTimingPane");
    }

    private static class UpdateSelectors
    implements Runnable {
        AbstractSppTimingPane _timing;

        UpdateSelectors(AbstractSppTimingPane abstractSppTimingPane) {
            this._timing = abstractSppTimingPane;
        }

        public void run() {
            if (this._timing.neRef != null) {
                this._timing.neRef.updateRefCBs();
            }
            if (this._timing.ext1Ref != null) {
                this._timing.ext1Ref.updateRefCBs();
            }
            if (this._timing.ext2Ref != null) {
                this._timing.ext2Ref.updateRefCBs();
            }
            this._timing = null;
        }
    }

    protected class SyncRefs
    implements ActionListener {
        protected eRef ref;
        protected JComboBox[] refCB;

        public SyncRefs(eRef eRef2) {
            if (db.on()) {
                db.println("constructor");
            }
            this.ref = eRef2;
            this.refCB = new JComboBox[3];
            AbstractSppTimingPane.this.entityCellRenderer = new EntityCellRenderer("slot ", true);
            for (int i = 0; i < 3; ++i) {
                this.refCB[i] = new JComboBox();
                this.refCB[i].setName(String.valueOf(i));
                this.refCB[i].addActionListener(this);
                this.refCB[i].setRenderer(AbstractSppTimingPane.this.entityCellRenderer);
                AbstractSppTimingPane.this.enableComponent(this.refCB[i]);
            }
        }

        public JComboBox getRefCB(int n) {
            return this.refCB[n];
        }

        private Object getDefaultRef(eRef eRef2) {
            SyncEntityModel syncEntityModel = null;
            syncEntityModel = eRef2 == eRef.NE ? AbstractSppTimingPane.this.syncModel.getInternalClockReference() : AbstractSppTimingPane.this.syncModel.getNoClockReference();
            return syncEntityModel;
        }

        public void updateRefCBs() {
            block8: {
                db.info("enter updateRefCBs");
                Object[] objectArray = null;
                try {
                    objectArray = AbstractSppTimingPane.this.syncModel.getRefCandidates(AbstractSppTimingPane.this.timingMode, this.ref);
                    Arrays.sort(objectArray, new TimingEntityComparator(AbstractSppTimingPane.this.syncModel));
                    Object object = this.getDefaultRef(this.ref);
                    int n = 0;
                    for (int i = 0; i < 3; ++i) {
                        if (AbstractSppTimingPane.this.pci.is600() && i == 2) {
                            objectArray = new Object[]{object};
                        }
                        this.refCB[i].removeActionListener(this);
                        if (n != i) {
                            this.refCB[n].removeActionListener(this);
                        }
                        Object object2 = this.refCB[i].getSelectedItem();
                        db.fine("Selected is : " + object2);
                        this.refCB[i].setModel(new DefaultComboBoxModel<IEntityModel>(objectArray));
                        if (object2 != null && !object2.equals(object)) {
                            db.fine("selecting for :  " + n + " " + object2);
                            this.refCB[n].setSelectedItem(object2);
                        }
                        Object object3 = this.refCB[n].getSelectedItem();
                        db.fine("new selection for :  " + n + " " + object3);
                        if (n != i && n < this.refCB.length) {
                            this.refCB[n].addActionListener(this);
                        }
                        this.refCB[i].addActionListener(this);
                        if (object3 != null && !object3.equals(object)) {
                            ++n;
                        }
                        db.info("ref=" + this.ref.value() + ", refCB[" + i + "]=" + this.refCB[i].getSelectedItem() + ", firstAvailable=" + n);
                    }
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (!db.on()) break block8;
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            Object object2 = this.getDefaultRef(this.ref);
            boolean bl = false;
            for (int i = 0; i < this.refCB.length; ++i) {
                if (bl) {
                    this.refCB[i].removeActionListener(this);
                    this.refCB[i].setSelectedItem(object2);
                    this.refCB[i].addActionListener(this);
                    continue;
                }
                if (!object2.equals(this.refCB[i].getSelectedItem())) continue;
                bl = true;
            }
            AbstractSppTimingPane.this.setDirty();
        }

        public void setRefSources() {
            block21: {
                int n;
                if (db.on()) {
                    db.println("enter setRefSources");
                }
                for (n = 0; n < 3 && this.refCB[n].getSelectedIndex() > 0; ++n) {
                }
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    EntityModel entityModel = (EntityModel)this.refCB[i].getSelectedItem();
                    nArray[i] = entityModel.getEntityIndex();
                    if (!db.on()) continue;
                    db.println("list[" + i + "]=" + Integer.toHexString(nArray[i]));
                }
                try {
                    AbstractSppTimingPane.this.syncModel.setRefSources(this.ref, nArray);
                }
                catch (BadReference badReference) {
                    if (AbstractSppTimingPane.this.timingMode == eTimingMode.EXT_TIME) {
                        ErrorMsg.displayWarning((Component)((Object)AbstractSppTimingPane.this), (WID)EMC.WID_EXT_TIMING_REF_UNUSABLE);
                    } else {
                        ErrorMsg.displayWarning((Component)((Object)AbstractSppTimingPane.this), (WID)EMC.WID_NONEXT_TIMING_REF_UNUSABLE);
                    }
                }
                catch (SyncProvBusy syncProvBusy) {
                    ErrorMsg.displayError((Component)((Object)AbstractSppTimingPane.this), (EID)EMC.EID_CANNOT_CHANGE_TIMING_WITH_FORCE);
                }
                catch (InvalidClockSource invalidClockSource) {
                    ErrorMsg.displayError((Component)((Object)AbstractSppTimingPane.this), (EID)EMC.EID_TIMING_INVALID_CLOCK);
                }
                catch (SyncInvalidAisThreshold syncInvalidAisThreshold) {
                    ErrorMsg.displayError((Component)((Object)AbstractSppTimingPane.this), (EID)EMC.EID_PROVISIONING_PARAM_1, (Object)"AIS threshold.");
                }
                catch (SyncInvalidCoding syncInvalidCoding) {
                    ErrorMsg.displayError((Component)((Object)AbstractSppTimingPane.this), (EID)EMC.EID_PROVISIONING_PARAM_1, (Object)"line coding.");
                }
                catch (SyncInvalidFacility syncInvalidFacility) {
                    ErrorMsg.displayError((Component)((Object)AbstractSppTimingPane.this), (EID)EMC.EID_PROVISIONING_PARAM_1, (Object)"facility type.");
                }
                catch (SyncInvalidFormat syncInvalidFormat) {
                    ErrorMsg.displayError((Component)((Object)AbstractSppTimingPane.this), (EID)EMC.EID_PROVISIONING_PARAM_1, (Object)"format or facility type/framing combination.");
                }
                catch (SyncInvalidExternalRefSource syncInvalidExternalRefSource) {
                    ErrorMsg.displayError((Component)((Object)AbstractSppTimingPane.this), (EID)EMC.EID_PROVISIONING_PARAM_1, (Object)"timing reference.\nInvalid external timing reference.");
                }
                catch (SyncRefSourceCombinationMaximumExceeded syncRefSourceCombinationMaximumExceeded) {
                    ErrorMsg.displayError((Component)((Object)AbstractSppTimingPane.this), (EID)EMC.EID_PROVISIONING_PARAM_1, (Object)"timing reference.\nThe maximum number of references allowed in a combination of timing reference types has been exceeded.\nFor example, the sum of BITS and DS1 timing sources might exceed the maximum allowed.");
                }
                catch (SyncSourceAlreadyDefinedForSlot syncSourceAlreadyDefinedForSlot) {
                    ErrorMsg.displayError((Component)((Object)AbstractSppTimingPane.this), (EID)EMC.EID_TIMING_REF_ALREADY_USED);
                }
                catch (SyncInvalidRefSource syncInvalidRefSource) {
                    ErrorMsg.displayError((Component)((Object)AbstractSppTimingPane.this), (EID)EMC.EID_PROVISIONING_PARAM_1, (Object)"timing reference.");
                }
                catch (SyncInvalidProvisioningForMode syncInvalidProvisioningForMode) {
                    ErrorMsg.displayError((Component)((Object)AbstractSppTimingPane.this), (EID)EMC.EID_PROVISIONING_PARAM_1, (Object)"timing mode.");
                }
                catch (SyncProvError syncProvError) {
                    ErrorMsg.displayError((Component)((Object)AbstractSppTimingPane.this), (EID)EMC.EID_GENERIC_PROV_ERROR);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (!db.on()) break block21;
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
            this.refreshFromModel();
            if (db.on()) {
                db.println("leave setRefSources");
            }
        }

        public void refreshFromModel() {
            if (AbstractSppTimingPane.this.applyingChanges()) {
                if (db.on()) {
                    db.println("ASTP skipped refresh while applying changes");
                }
            } else {
                int n;
                EntityModel[] entityModelArray;
                if (db.on()) {
                    db.println("enter ASTP.refreshFromModel");
                }
                try {
                    entityModelArray = AbstractSppTimingPane.this.syncModel.getRefEntities(this.ref);
                }
                catch (NoSuchInterface noSuchInterface) {
                    db.println("Caught unexpected exception in refreshFromModel");
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)noSuchInterface);
                    }
                    entityModelArray = new EntityModel[]{};
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                    entityModelArray = new EntityModel[]{};
                }
                int n2 = Math.min(3, entityModelArray.length);
                for (n = 0; n < n2; ++n) {
                    this.refCB[n].setSelectedItem(entityModelArray[n]);
                    if (!db.on()) continue;
                    db.println("list[" + n + "]=" + entityModelArray[n]);
                }
                for (n = entityModelArray.length; n < 3; ++n) {
                    this.refCB[n].setSelectedIndex(0);
                }
                if (db.on()) {
                    db.println("leave ASTP.refreshFromModel");
                }
            }
        }

        public void destroy() {
            AbstractSppTimingPane.this.entityCellRenderer = null;
            for (int i = 0; i < 3; ++i) {
                this.refCB[i].removeActionListener(this);
                ((DefaultComboBoxModel)this.refCB[i].getModel()).removeAllElements();
            }
        }
    }
}

