/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.OSI.sLapdTerm;
import cerent.cms.idl.OSI.sSubnet;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractTermConnectionModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InvalidState;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.NoLanAccess;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhTermModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfEditTablePane;
import cerent.cms.ui.shelf.AbstractTermCreationDialog;
import cerent.cms.ui.shelf.TermColumnRenderer;
import cerent.cms.ui.shelf.TermRowObject;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.InetUtil;
import cerent.util.IpSubnet;
import cerent.util.PluralisationUtil;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedDialog;
import cerent.util.gui.UDialog;
import cerent.util.gui.WindowHelper;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class AbstractTermPane
extends AbstractShelfEditTablePane {
    protected static final String GCC_TERM = "GCC";
    protected static final String OSC_TERM = "OSC";
    protected AbstractTermConnectionModel connTableModel;
    private final String ohTermType;
    protected TDMTerminology tdmTerm;
    private AbstractRoDataSourceControl dsc;
    private JDialog currentDialog = null;
    protected final SDebug db;

    protected AbstractTermPane(String string, AbstractTermConnectionModel abstractTermConnectionModel, TabbedView tabbedView, SDebug sDebug) {
        super(string, abstractTermConnectionModel, tabbedView);
        this.db = sDebug;
        this.connTableModel = abstractTermConnectionModel;
        this.ohTermType = this.getOhTermType();
        this.tdmTerm = abstractTermConnectionModel.getNodeModel().getTDMTerminology();
        this.setBorder(BorderFactory.createTitledBorder(this.ohTermType + " Terminations"));
    }

    protected void initModels() {
        TermColumnRenderer.eTCRendererType eTCRendererType2 = this.getOhTermType().equals(GCC_TERM) ? TermColumnRenderer.eTCRendererType.GCC : (this.getOhTermType().equals(OSC_TERM) ? TermColumnRenderer.eTCRendererType.OSC : TermColumnRenderer.eTCRendererType.NORMAL);
        TermRowDataSource termRowDataSource = new TermRowDataSource();
        this.model = new SortableRowTableModel((RowDataSource)termRowDataSource, TermColumnRenderer.createColumnRenderers(this.tdmTerm, eTCRendererType2));
    }

    protected void localInit() {
        super.localInit();
        this.table.setSelectionMode(2);
    }

    protected void createTableEntry() {
        this.currentDialog = this.getOhTermCreationDialog();
        this.currentDialog.show();
        this.currentDialog = null;
    }

    protected void editSelectedTableEntry(int n) {
        TermRowObject termRowObject = (TermRowObject)this.model.getValueAt(n, 0);
        this.currentDialog = new OhTermEditDialog(this, JOptionPane.getFrameForComponent((Component)((Object)this)), (OhTermModel)termRowObject.model);
        this.currentDialog.show();
        this.currentDialog = null;
    }

    protected void deleteSelectedTableEntry(int n) {
        int[] nArray = this.table.getSelectedRows();
        Object[] objectArray = new OhTermModel[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            n = nArray[i];
            TermRowObject termRowObject = (TermRowObject)this.model.getValueAt(n, 0);
            if (termRowObject == null) continue;
            objectArray[i] = (OhTermModel)termRowObject.model;
        }
        OhTermConfirmDialog ohTermConfirmDialog = new OhTermConfirmDialog(objectArray);
        ohTermConfirmDialog.show();
        if (ohTermConfirmDialog.isOk()) {
            this.deleteTerms((OhTermModel[])objectArray);
        }
    }

    protected abstract AbstractTermCreationDialog getOhTermCreationDialog();

    protected abstract String getOhTermType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateTableData() {
        IObservableManager iObservableManager = this.getObservableManager();
        iObservableManager.setActive(false);
        IConnectionModel[] iConnectionModelArray = this.connTableModel.getTermModels();
        List list = this.tableData;
        synchronized (list) {
            this.tableData.clear();
            for (int i = 0; i < iConnectionModelArray.length; ++i) {
                this.tableData.add(new TermRowObject(iConnectionModelArray[i]));
            }
            Collections.sort(this.tableData);
        }
        this.registerWithModels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerWithModels() {
        IObservableManager iObservableManager = this.getDataSourceControl().getObservableManager();
        iObservableManager.reset();
        iObservableManager.addObservable((Observable)((Object)this.connTableModel));
        List list = this.tableData;
        synchronized (list) {
            for (int i = 0; i < this.tableData.size(); ++i) {
                TermRowObject termRowObject = (TermRowObject)this.tableData.get(i);
                this.registerWithModel((OhTermModel)termRowObject.model, iObservableManager);
            }
        }
        iObservableManager.setActive(true);
    }

    protected void registerWithModel(OhTermModel ohTermModel, IObservableManager iObservableManager) {
        if (ohTermModel != null) {
            iObservableManager.addObservable((Observable)((Object)ohTermModel));
            iObservableManager.addObservable((Observable)((Object)ohTermModel.getNodeModelDelegate().getSubnetModel()));
            iObservableManager.addObservable((Observable)((Object)ohTermModel.getNodeModelDelegate().getLapdModel()));
            PortModel portModel = (PortModel)ohTermModel.getOpticalPortModel();
            if (portModel != null) {
                InterfaceModel interfaceModel;
                PortModel portModel2;
                InterfaceModel interfaceModel2 = (InterfaceModel)portModel.getInterfaceModel();
                if (interfaceModel2 != null) {
                    iObservableManager.addObservable((Observable)((Object)interfaceModel2));
                }
                if ((portModel2 = AbstractTermPane.getProtectPort(portModel, this.db)) != null && (interfaceModel = (InterfaceModel)portModel2.getInterfaceModel()) != null) {
                    iObservableManager.addObservable((Observable)((Object)interfaceModel));
                }
            }
        }
    }

    protected void deregisterWithModel(OhTermModel ohTermModel, IObservableManager iObservableManager) {
        if (ohTermModel != null) {
            iObservableManager.removeObservable((Observable)((Object)ohTermModel));
            iObservableManager.addObservable((Observable)((Object)ohTermModel.getNodeModelDelegate().getSubnetModel()));
            iObservableManager.addObservable((Observable)((Object)ohTermModel.getNodeModelDelegate().getLapdModel()));
            PortModel portModel = (PortModel)ohTermModel.getOpticalPortModel();
            if (portModel != null) {
                InterfaceModel interfaceModel;
                PortModel portModel2;
                InterfaceModel interfaceModel2 = (InterfaceModel)portModel.getInterfaceModel();
                if (interfaceModel2 != null) {
                    iObservableManager.removeObservable((Observable)((Object)interfaceModel2));
                }
                if ((portModel2 = AbstractTermPane.getProtectPort(portModel, this.db)) != null && (interfaceModel = (InterfaceModel)portModel2.getInterfaceModel()) != null) {
                    iObservableManager.removeObservable((Observable)((Object)interfaceModel));
                }
            }
        }
    }

    protected void setDataSourceControl() {
        this.setDataSourceControl(this.getDataSourceControl());
    }

    private AbstractRoDataSourceControl getDataSourceControl() {
        if (this.dsc == null) {
            this.dsc = this.createDataSourceControl();
        }
        return this.dsc;
    }

    protected abstract AbstractRoDataSourceControl createDataSourceControl();

    public void setEditDeleteEnabled(boolean bl) {
        super.setEditDeleteEnabled(bl);
        if (!bl) {
            this.clearTableSelection();
        } else if (!this.isUserAuthorized()) {
            bl = false;
        }
        int n = this.table.getSelectedRowCount();
        if (this.hasDuplicatedDcc()) {
            WindowHelper.setEnabled((JComponent)this.editButton, (boolean)false);
            String string = this.tdmTerm.getGeneralTerms(8);
            String string2 = this.tdmTerm.getGeneralTerms(10);
            if (n == 1) {
                WindowHelper.setEnabled((JComponent)this.deleteButton, (boolean)bl);
                ErrorMsg.displayWarning((Component)((Object)this), (EID)EMC.WID_LDCC_SDCC_ON_SAME_PORT_PARAM_3, string, string2, "Please remove one before edit.");
            } else {
                WindowHelper.setEnabled((JComponent)this.deleteButton, (boolean)false);
                ErrorMsg.displayWarning((Component)((Object)this), (EID)EMC.WID_LDCC_SDCC_ON_SAME_PORT_PARAM_3, string, string2, "Please edit or remove one at a time.");
            }
        } else {
            WindowHelper.setEnabled((JComponent)this.deleteButton, (bl && n > 0 ? 1 : 0) != 0);
            WindowHelper.setEnabled((JComponent)this.editButton, (bl && n == 1 ? 1 : 0) != 0);
        }
    }

    protected void enableEditOkButton() {
        if (this.currentDialog != null && this.currentDialog instanceof OhTermEditDialog) {
            ((OhTermEditDialog)((Object)this.currentDialog)).enableOk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void localDelete(OhTermModel ohTermModel) {
        List list = this.tableData;
        synchronized (list) {
            int n = this.tableData.indexOf(ohTermModel);
            if (n != -1) {
                this.tableData.remove(n);
            }
            this.deregisterWithModel(ohTermModel, this.getDataSourceControl().getObservableManager());
        }
    }

    public void dispose() {
        IObservableManager iObservableManager = this.getDataSourceControl().getObservableManager();
        iObservableManager.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDuplicatedDcc() {
        int[] nArray = this.table.getSelectedRows();
        OhTermModel ohTermModel = null;
        EntityModel entityModel = null;
        List list = this.tableData;
        synchronized (list) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n >= this.tableData.size()) {
                    return false;
                }
                TermRowObject termRowObject = (TermRowObject)this.tableData.get(n);
                ohTermModel = (OhTermModel)termRowObject.model;
                entityModel = (EntityModel)ohTermModel.getOpticalPortModel();
                if (!this.hasSdcc(entityModel) || !this.hasLdcc(entityModel)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasSdcc(EntityModel entityModel) {
        return entityModel.getNodeModelDelegate().getDccTermConnectionModel().entityExistsInTerminations((IEntityModel)entityModel);
    }

    private boolean hasLdcc(EntityModel entityModel) {
        return entityModel.getNodeModelDelegate().getLdccTermConnectionModel().entityExistsInTerminations((IEntityModel)entityModel);
    }

    protected static void maybeSetAdminState(PortModel portModel, int n, ArrayList arrayList, EntityCellRenderer entityCellRenderer, SDebug sDebug) {
        if (n != -1) {
            PortModel[] portModelArray = new PortModel[]{portModel, AbstractTermPane.getProtectPort(portModel, sDebug)};
            for (int i = 0; i < portModelArray.length && portModelArray[i] != null; ++i) {
                try {
                    boolean bl = portModelArray[i].maybeSetAdminState(n, 0, 0);
                    if (bl || !sDebug.on()) continue;
                    sDebug.println("Current state of port index = " + portModelArray[i].getEntityIndex() + " does not apply to port change request.  Port state unchanged.");
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    AbstractTermPane.addFailureReason(EMC.EID_NO_SUCHINTERFACE, portModel, entityCellRenderer, arrayList);
                    continue;
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    AbstractTermPane.addFailureReason(EMC.EID_UNSUPPORTED_OPERATION, portModel, entityCellRenderer, arrayList);
                    continue;
                }
                catch (LoopbackActive loopbackActive) {
                    AbstractTermPane.addFailureReason(EMC.EID_CANNOT_TRANSITION_STATE_WITH_LOOPBACK, portModel, entityCellRenderer, arrayList);
                    continue;
                }
                catch (SyncProvError syncProvError) {
                    AbstractTermPane.addFailureReason(EMC.EID_CANNOT_TRANSITION_STATE_WITH_SYNC, portModel, entityCellRenderer, arrayList);
                    continue;
                }
                catch (InvalidState invalidState) {
                    AbstractTermPane.addFailureReason(EMC.EID_CHANGE_ADMIN_STATE_NOTALLOWED, portModel, entityCellRenderer, arrayList);
                    continue;
                }
                catch (ProvisionError provisionError) {
                    EID eID = provisionError.getEID();
                    if (eID == null) continue;
                    AbstractTermPane.addFailureReason(eID, portModel, entityCellRenderer, arrayList);
                }
            }
        }
    }

    protected void deleteTerms(OhTermModel[] ohTermModelArray) {
        if (ohTermModelArray == null || ohTermModelArray.length == 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NO_TERM_TYPE_SELECTED_PARAM_1, (Object)this.ohTermType);
            return;
        }
        this.db.info("Deleting " + ohTermModelArray.length + " terms");
        ArrayList<PortModel> arrayList = new ArrayList<PortModel>();
        ArrayList arrayList2 = new ArrayList();
        EntityCellRenderer entityCellRenderer = this.connTableModel.getNodeModel().isMultishelf() ? new EntityCellRenderer("shelf ") : new EntityCellRenderer("slot ");
        boolean bl = false;
        for (int i = 0; i < ohTermModelArray.length; ++i) {
            OhTermModel ohTermModel = ohTermModelArray[i];
            PortModel portModel = (PortModel)ohTermModel.getOpticalPortModel();
            try {
                this.connTableModel.deleteTermination(ohTermModel);
                arrayList.add(portModel);
                continue;
            }
            catch (Busy busy) {
                AbstractTermPane.addFailureReason(EMC.EID_TERM_TYPE_IN_USE_PARAM_1, this.ohTermType, portModel, entityCellRenderer, arrayList2);
                bl = true;
                continue;
            }
            catch (NoLanAccess noLanAccess) {
                AbstractTermPane.addFailureReason(EMC.EID_FAIL_DELETE_LAST_DCC_PARAM_1, this.ohTermType, portModel, entityCellRenderer, arrayList2);
                bl = true;
                continue;
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                AbstractTermPane.addFailureReason(EMC.EID_TERM_TYPE_DELETE_FAIL_PARAM_2, this.ohTermType, "You attempted to delete an overhead termination that no longer exists.", portModel, entityCellRenderer, arrayList2);
                bl = true;
                continue;
            }
            catch (Exception exception) {
                AbstractTermPane.addFailureReason(EMC.EID_TERM_TYPE_DELETE_FAIL_PARAM_2, this.ohTermType, "You attempted to delete an overhead termination that is in use.", portModel, entityCellRenderer, arrayList2);
                bl = true;
            }
        }
        if (bl) {
            this.refresh();
        }
        this.db.info("Handling " + arrayList2.size() + " term deletion failures (" + arrayList.size() + " successes)");
        AbstractTermPane.handleFailures((Component)((Object)this), this.ohTermType, "delete", arrayList, arrayList2, null, entityCellRenderer);
    }

    private sIpAddr asIp(String string) {
        return IpAddrFactory.getIpAddr(InetUtil.makeIpAddr(string));
    }

    protected static void addFailureReason(EID eID, IEntityModel iEntityModel, EntityCellRenderer entityCellRenderer, ArrayList arrayList) {
        if (arrayList != null) {
            String string = iEntityModel.getNodeModel().isMultishelf() ? entityCellRenderer.getString(iEntityModel, "shelf ") : entityCellRenderer.getString(iEntityModel, "slot ");
            arrayList.add(string + ": " + ErrorMsg.getString((EID)eID));
        }
    }

    protected static void addFailureReason(EID eID, String string, IEntityModel iEntityModel, EntityCellRenderer entityCellRenderer, ArrayList arrayList) {
        if (arrayList != null) {
            String string2 = iEntityModel.getNodeModel().isMultishelf() ? entityCellRenderer.getString(iEntityModel, "shelf ") : entityCellRenderer.getString(iEntityModel, "slot ");
            arrayList.add(string2 + ": " + ErrorMsg.getString((EID)eID, (Object)string));
        }
    }

    protected static void addFailureReason(EID eID, String string, String string2, IEntityModel iEntityModel, EntityCellRenderer entityCellRenderer, ArrayList arrayList) {
        if (arrayList != null) {
            String string3 = iEntityModel.getNodeModel().isMultishelf() ? entityCellRenderer.getString(iEntityModel, "shelf ") : entityCellRenderer.getString(iEntityModel, "slot ");
            arrayList.add(string3 + ": " + ErrorMsg.getString((EID)eID, (Object)string, (Object)string2));
        }
    }

    protected static void handleFailures(Component component, String string, String string2, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, EntityCellRenderer entityCellRenderer) {
        if (arrayList2.size() > 0 || arrayList3 != null && arrayList3.size() > 0) {
            int n;
            int n2;
            ImageIcon imageIcon = CerentDialog.WARNING_ICON;
            String string3 = "";
            String string4 = "";
            if (arrayList2.size() > 0) {
                n2 = arrayList2.size();
                imageIcon = CerentDialog.FATAL_ICON;
                string4 = string4 + n2 + " " + string + " " + PluralisationUtil.s("termination", n2) + " " + PluralisationUtil.s("was", n2) + " not " + string2 + "d, as follows:\n";
                for (n = 0; n < arrayList2.size(); ++n) {
                    string4 = string4 + (String)arrayList2.get(n) + "\n";
                }
            } else {
                string4 = "All " + string + " terminations were " + string2 + "d successfully\n";
            }
            string4 = string4 + "\n";
            if (arrayList3 != null && arrayList3.size() > 0) {
                string3 = string3 + "Some port states were not able to be changed.\n";
                n2 = arrayList3.size();
                string4 = string4 + n2 + " port " + PluralisationUtil.s("state", n2) + " " + PluralisationUtil.s("was", n2) + " not set, as follows:\n";
                for (n = 0; n < arrayList3.size(); ++n) {
                    string4 = string4 + (String)arrayList3.get(n) + "\n";
                }
                string4 = string4 + "\n";
            }
            if (arrayList2.size() > 0 && arrayList.size() > 0) {
                n2 = arrayList.size();
                string4 = string4 + n2 + " " + string + " " + PluralisationUtil.s("termination", n2) + " " + PluralisationUtil.s("was", n2) + " " + string2 + "d as follows:\n";
                for (n = 0; n < arrayList.size(); ++n) {
                    EntityModel entityModel = (EntityModel)arrayList.get(n);
                    String string5 = entityModel.getNodeModel().isMultishelf() ? entityCellRenderer.getString(entityModel, "shelf ") : entityCellRenderer.getString(entityModel, "slot ");
                    string4 = string4 + string5 + "\n";
                }
            }
            DetailedDialog detailedDialog = DetailedDialog.instance((Frame)JOptionPane.getFrameForComponent(component), (String)("Error Processing " + string + " Termination"));
            if (arrayList2.size() > 0) {
                detailedDialog.setText(ErrorMsg.getString((EID)EMC.EID_TERM_PROCESS, (Object)string, (Object)string2, (Object)string3), imageIcon);
            } else {
                detailedDialog.setText(ErrorMsg.getString((EID)EMC.WID_TERM_PROCESS, (Object)string, (Object)string2, (Object)string3), imageIcon);
            }
            detailedDialog.append(string4);
            detailedDialog.setSize(500, detailedDialog.getHeight());
            detailedDialog.show();
        }
    }

    protected static PortModel getProtectPort(PortModel portModel, SDebug sDebug) {
        PortModel portModel2 = null;
        int n = -1;
        if (portModel instanceof TdmPortModel) {
            n = ((TdmPortModel)portModel).getOnePlusOneProtectEntityIndex();
        } else if (portModel instanceof DwdmPortModel) {
            n = ((DwdmPortModel)portModel).getYCableProtectEntityIndex();
        }
        if (n > 0 & n != portModel.getEntityIndex()) {
            sDebug.info("Protect entity " + Integer.toHexString(n) + " exists");
            try {
                portModel2 = (PortModel)portModel.getNodeModelDelegate().getEntityTableModel().getEntityModelByIndex(n);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                sDebug.severe("Failed to get protectPort " + Integer.toHexString(n));
            }
        }
        return portModel2;
    }

    class TermRowDataSource
    extends AbstractRowDataSource {
        TermRowDataSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObjectAtRow(int n) {
            Object var2_2 = null;
            List list = AbstractTermPane.this.tableData;
            synchronized (list) {
                var2_2 = AbstractTermPane.this.tableData.get(n);
            }
            return var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            int n = -1;
            List list = AbstractTermPane.this.tableData;
            synchronized (list) {
                n = AbstractTermPane.this.tableData.size();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection getAllObjects() {
            List list = AbstractTermPane.this.tableData;
            synchronized (list) {
                return AbstractTermPane.this.tableData;
            }
        }

        public Class getRowObjectClass() {
            return TermRowObject.class;
        }
    }

    protected class OhTermConfirmDialog {
        protected boolean ok = false;
        protected Object[] termsToDelete;

        public OhTermConfirmDialog(Object[] objectArray) {
            this.termsToDelete = objectArray;
        }

        public boolean isOk() {
            return this.ok;
        }

        public void show() {
            String string = "Do you really want to delete the selected " + AbstractTermPane.this.ohTermType + " " + PluralisationUtil.s("termination", this.termsToDelete.length) + "?";
            if (CerentDialog.yesNoDialog((Component)((Object)AbstractTermPane.this), (String)string, (String)("Delete " + AbstractTermPane.this.ohTermType + " " + PluralisationUtil.s("Termination", this.termsToDelete.length)))) {
                this.ok = true;
            }
        }
    }

    private static class OhTermEditDialog
    extends UDialog
    implements ActionListener {
        private AbstractTermPane _atp;
        private AbstractTermCreationDialog atcd;
        private OhTermModel ohTerm;
        private PortModel ohPort;
        private boolean ospfDirty;
        private boolean farEndForeignDirty;
        private boolean farEndIpAddrDirty;
        private JButton okButton;
        private JButton cancelButton;
        private JComboBox gccRateComboBox;
        private JCheckBox donotAdvertiseOspfButton;
        private JCheckBox farEndForeign;
        private JTextField farEndIpAddr;
        private JLabel farEndIpLb;
        private JLabel layer2Protocol;
        private JCheckBox osiCB;
        private JCheckBox ipCB;

        protected OhTermEditDialog(AbstractTermPane abstractTermPane, Frame frame, OhTermModel ohTermModel) {
            super(frame, "", true);
            this._atp = abstractTermPane;
            this.atcd = abstractTermPane.getOhTermCreationDialog();
            this.ohTerm = ohTermModel;
            this.ospfDirty = false;
            this.farEndForeignDirty = false;
            this.farEndIpAddrDirty = false;
            this.ohPort = (PortModel)ohTermModel.getOpticalPortModel();
            Container container = this.getContentPane();
            if (container instanceof JPanel) {
                this.initContentPane((JPanel)container);
                this.pack();
            }
        }

        protected void initContentPane(JPanel jPanel, Object object) {
        }

        protected void initContentPane(JPanel jPanel) {
            Object object;
            this.setSize(new Dimension(300, 300));
            if (this.ohPort.getNodeModel().isMultishelf()) {
                this.setTitle(TermColumnRenderer.ecr.getString(this.ohPort, "shelf ") + " - Edit " + this._atp.ohTermType + " Termination");
            } else {
                this.setTitle(TermColumnRenderer.ecr.getString(this.ohPort, "slot ") + " - Edit " + this._atp.ohTermType + " Termination");
            }
            PortModel portModel = AbstractTermPane.getProtectPort(this.ohPort, this._atp.db);
            if (portModel != null) {
                object = portModel.getNodeModel().isMultishelf() ? "Protect Port: " + TermColumnRenderer.ecr.getString(portModel, "shelf ") : "Protect Port: " + TermColumnRenderer.ecr.getString(portModel, "slot ");
                jPanel.add((Component)new JLabel((String)object), "North");
            }
            object = new JPanel();
            ((Container)object).setLayout(new BoxLayout((Container)object, 1));
            ((JComponent)object).setBorder(BorderFactory.createTitledBorder(this._atp.ohTermType));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            JPanel jPanel3 = this.atcd.getLapdPane(this._atp);
            jPanel3.setBorder(BorderFactory.createTitledBorder("LAPD"));
            JPanel jPanel4 = this.atcd.getSubnetPane(this._atp);
            jPanel4.setBorder(BorderFactory.createTitledBorder("Subnet"));
            JPanel jPanel5 = null;
            if (this._atp.getOhTermType().equals(AbstractTermPane.GCC_TERM)) {
                jPanel5 = new JPanel(new FlowLayout(0, 5, 5));
                jPanel5.add(new JLabel("  GCC Rate:"));
                this.gccRateComboBox = new JComboBox<Attribute>(this.getGccRateAttributes());
                jPanel5.add(this.gccRateComboBox);
                this.gccRateComboBox.setEnabled(false);
                ((Container)object).add(jPanel5);
            }
            jPanel5 = new JPanel(new FlowLayout(0, 5, 0));
            this.donotAdvertiseOspfButton = new JCheckBox("Disable OSPF on Link");
            jPanel5.add(this.donotAdvertiseOspfButton);
            this.donotAdvertiseOspfButton.addActionListener(this);
            ((Container)object).add(jPanel5);
            jPanel5 = new JPanel(new FlowLayout(0, 5, 0));
            this.farEndForeign = new JCheckBox("Far End is Foreign");
            jPanel5.add(this.farEndForeign);
            this.farEndForeign.addActionListener(this);
            if (this._atp.getOhTermType().equals(AbstractTermPane.OSC_TERM)) {
                this.donotAdvertiseOspfButton.setEnabled(false);
                this.farEndForeign.setEnabled(false);
            }
            this.farEndIpLb = new JLabel("Far End IP:");
            jPanel5.add(this.farEndIpLb);
            this.farEndIpAddr = new JTextField(16);
            jPanel5.add(this.farEndIpAddr);
            this.farEndIpAddr.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    OhTermEditDialog.this.farEndIpAddrDirty = true;
                    OhTermEditDialog.this.okButton.setEnabled(true);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    OhTermEditDialog.this.farEndIpAddrDirty = true;
                    OhTermEditDialog.this.okButton.setEnabled(true);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    OhTermEditDialog.this.farEndIpAddrDirty = true;
                    OhTermEditDialog.this.okButton.setEnabled(true);
                }
            });
            ((Container)object).add(jPanel5);
            JPanel jPanel6 = new JPanel(new GridLayout(0, 2));
            JPanel jPanel7 = new JPanel(new FlowLayout(0, 5, 5));
            JPanel jPanel8 = new JPanel(new FlowLayout(0, 5, 5));
            this.layer2Protocol = new JLabel("PPP");
            this.osiCB = new JCheckBox("OSI");
            this.osiCB.addActionListener(this);
            this.ipCB = new JCheckBox("IP");
            this.ipCB.addActionListener(this);
            sLapdTerm sLapdTerm2 = null;
            sLapdTerm2 = this._atp.connTableModel.getNodeModelDelegate().getLapdModel().getLapdByIndex(this.ohPort.getEntityIndex());
            if (sLapdTerm2 == null) {
                this._atp.db.info("No Lapd term for: " + this.ohPort.getEntityIndex());
            }
            sSubnet sSubnet2 = null;
            try {
                sSubnet2 = this._atp.connTableModel.getNodeModelDelegate().getSubnetModel().getSubnetByIndex(this.ohPort.getEntityIndex());
            }
            catch (Exception exception) {
                this._atp.db.info("Unexpected error when getting Subnet: " + exception);
            }
            if (sSubnet2 == null && sLapdTerm2 == null) {
                this.ipCB.setSelected(true);
                this.ipCB.setEnabled(false);
                this.osiCB.setSelected(false);
                this.layer2Protocol.setText("PPP");
                this.atcd.setEnableLapdPane(false);
            } else if (sLapdTerm2 == null) {
                this.ipCB.setSelected(true);
                this.ipCB.setEnabled(false);
                this.layer2Protocol.setText("PPP");
                this.osiCB.setSelected(true);
                this.atcd.setEnableLapdPane(false);
                this.atcd.fillSubnetPane(sSubnet2);
            } else {
                this.atcd.fillLapdPane(sLapdTerm2);
                this.atcd.fillSubnetPane(sSubnet2);
                this.ipCB.setSelected(false);
                this.ipCB.setEnabled(false);
                this.donotAdvertiseOspfButton.setSelected(true);
                this.donotAdvertiseOspfButton.setEnabled(false);
                this.farEndForeign.setEnabled(false);
                this.farEndIpLb.setEnabled(false);
                this.farEndIpAddr.setEnabled(false);
                this.layer2Protocol.setText("LAPD");
                this.osiCB.setSelected(true);
                this.osiCB.setEnabled(false);
            }
            this.ipCB.setEnabled(false);
            this.atcd.setEnableSubnetPane(this.osiCB.isSelected(), this.ohPort.getEntityIndex());
            jPanel8.add(this.osiCB);
            jPanel8.add(this.ipCB);
            jPanel8.setBorder(BorderFactory.createTitledBorder("Layer 3"));
            jPanel7.add(this.layer2Protocol);
            jPanel7.setBorder(BorderFactory.createTitledBorder("Layer 2"));
            jPanel6.add(jPanel8);
            jPanel6.add(jPanel7);
            JPanel jPanel9 = new JPanel(new GridLayout(0, 2));
            jPanel9.add(jPanel4);
            jPanel9.add(jPanel3);
            jPanel2.add((Component)object);
            jPanel2.add(jPanel6);
            jPanel2.add(jPanel9);
            jPanel.add((Component)jPanel2, "Center");
            jPanel5 = new JPanel(new FlowLayout(1, 5, 5));
            this.okButton = this.makeActionButton("OK");
            jPanel5.add(this.okButton);
            this.cancelButton = this.makeActionButton("Cancel");
            jPanel5.add(this.cancelButton);
            jPanel.add((Component)jPanel5, "South");
            this.okButton.setEnabled(false);
            try {
                this.donotAdvertiseOspfButton.setSelected(!this.ohTerm.isOspfEnable());
            }
            catch (Exception exception) {
                this._atp.db.fine("ohTerm.isOspfEnable() failed" + exception);
            }
            try {
                this.farEndForeign.setSelected(this.ohTerm.isFarEndForeign());
                this.farEndForeignDirty = false;
            }
            catch (Exception exception) {
                this._atp.db.fine("ohTerm.isFarEndForeign() failed " + exception);
            }
            this.farEndIpAddr.setEnabled(this.farEndForeign.isSelected());
            this.farEndIpAddr.setText(this.farEndIpAddr(this.ohTerm));
            this.farEndIpLb.setEnabled(this.farEndIpAddr.isEnabled());
            this.farEndIpAddrDirty = false;
            if (this.gccRateComboBox != null) {
                try {
                    if (this.ohTerm.getChannelType() == 4) {
                        this.gccRateComboBox.setSelectedItem(this.getGccRateAttributes()[1]);
                    } else {
                        this.gccRateComboBox.setSelectedItem(this.getGccRateAttributes()[0]);
                    }
                }
                catch (Exception exception) {
                    this._atp.db.fine("ohPort.getChannelType() failed" + exception);
                }
            }
        }

        private String farEndIpAddr(OhTermModel ohTermModel) {
            String string = "";
            if (this.farEndForeign.isSelected() && (string = TermColumnRenderer.getFarEndIpAddress(ohTermModel)).equals("")) {
                string = "0.0.0.0";
            }
            return string;
        }

        public void dispose() {
            this.ohTerm = null;
            this.ohPort = null;
            this._atp = null;
            this.atcd = null;
            super.dispose();
        }

        protected JButton makeActionButton(String string) {
            JButton jButton = new JButton(string);
            jButton.addActionListener(this);
            return jButton;
        }

        public void enableOk() {
            this.okButton.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.donotAdvertiseOspfButton) {
                this.ospfDirty = true;
                this.okButton.setEnabled(true);
            } else if (object == this.farEndForeign) {
                this.farEndForeignDirty = true;
                this.farEndIpAddr.setEnabled(this.farEndForeign.isSelected());
                this.farEndIpAddr.setText(this.farEndIpAddr(this.ohTerm));
                this.farEndIpLb.setEnabled(this.farEndIpAddr.isEnabled());
                this.okButton.setEnabled(true);
            } else if (object == this.ipCB || object == this.osiCB) {
                if (object == this.ipCB && !this.ipCB.isSelected()) {
                    this.osiCB.setSelected(true);
                }
                if (object == this.osiCB && !this.osiCB.isSelected()) {
                    this.ipCB.setSelected(true);
                }
                this.okButton.setEnabled(true);
                if (this.osiCB.isSelected() && !this.ipCB.isSelected()) {
                    this.donotAdvertiseOspfButton.setSelected(false);
                }
                this.donotAdvertiseOspfButton.setEnabled(this.ipCB.isSelected());
                this.atcd.setEnableLapdPane(this.osiCB.isSelected() && !this.ipCB.isSelected());
                this.atcd.setEnableSubnetPane(this.osiCB.isSelected(), this.ohPort.getEntityIndex());
            } else if (object == this.okButton) {
                this.ok();
            } else if (object == this.cancelButton) {
                this.dispose();
            }
        }

        private String formatInternalSubnets() {
            String string;
            try {
                StringBuffer stringBuffer = new StringBuffer();
                NodeModelDelegate nodeModelDelegate = this._atp.connTableModel.getNodeModelDelegate();
                IpSubnet[] ipSubnetArray = nodeModelDelegate.getPlatform().getInternalSubnets(nodeModelDelegate);
                if (ipSubnetArray != null && ipSubnetArray.length > 0) {
                    stringBuffer.append(" (");
                    stringBuffer.append(ipSubnetArray[0]);
                    for (int i = 1; i < ipSubnetArray.length; ++i) {
                        stringBuffer.append(", ");
                        stringBuffer.append(ipSubnetArray[i]);
                    }
                    stringBuffer.append(")");
                }
                string = stringBuffer.toString();
            }
            catch (Exception exception) {
                string = "";
            }
            return string;
        }

        protected void ok() {
            Object object;
            try {
                Integer n = new Integer(0);
                if (this.gccRateComboBox != null) {
                    n = ((Attribute)this.gccRateComboBox.getSelectedItem()).getValue();
                }
                object = new Object[]{new Integer(0), new Integer(0), n};
                this.atcd.editLapdInfo(!this.ipCB.isSelected(), this.ohPort.getEntityIndex(), object);
                this.atcd.editSubnetInfo(this.osiCB.isSelected(), this.ohPort.getEntityIndex(), object);
            }
            catch (Exception exception) {
                object = AnnotatedException.getString((Exception)exception);
                if (exception instanceof CTCUserException) {
                    object = ((CTCUserException)exception).getPrettyMessage();
                }
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_TERM_TYPE_EDIT_FAIL_PARAM_1, this._atp.ohTermType, (String)object);
                SDebug.printStackTrace((Throwable)exception);
            }
            try {
                if (this.ospfDirty) {
                    this.ohTerm.setOspfEnable(!this.donotAdvertiseOspfButton.isSelected());
                }
                if (this.farEndForeignDirty) {
                    this.ohTerm.setFarEndIsForeign(this.farEndForeign.isSelected());
                }
                if (this.farEndIpAddrDirty && this.farEndForeign.isSelected()) {
                    this.ohTerm.setFarEndIpAddress(this._atp.asIp(this.farEndIpAddr.getText()));
                }
                this.dispose();
            }
            catch (ConfigError configError) {
                ErrorMsg.displayError((Component)((Object)this), EMC.EID_TERM_FAR_END_IP_FAIL_PARAM_2, this._atp.ohTermType, this.formatInternalSubnets());
                SDebug.printStackTrace((Throwable)configError);
            }
            catch (Exception exception) {
                object = AnnotatedException.getString((Exception)exception);
                if (exception instanceof CTCUserException) {
                    object = ((CTCUserException)exception).getPrettyMessage();
                }
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_TERM_TYPE_EDIT_FAIL_PARAM_1, this._atp.ohTermType, (String)object);
                SDebug.printStackTrace((Throwable)exception);
            }
        }

        private Attribute[] getGccRateAttributes() {
            return ElementDefaults.getAttributeMap(this.ohTerm).getAttributeArray("declDwdmGccRate");
        }
    }
}

