/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.GfpPortModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.MrSlot;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.PortModel;
import cerent.cms.ui.AbstractCardViewPanel;
import cerent.cms.ui.ppm.PpmSlotView;
import cerent.cms.ui.shelf.AbstractPortGraphic;
import cerent.cms.ui.shelf.CardView;
import cerent.cms.ui.shelf.DwdmGenericPortGraphic;
import cerent.cms.ui.shelf.GenericPortGraphic;
import cerent.cms.ui.shelf.TrunkPortGraphic;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DwdmCardView
extends CardView {
    private static final int MAX_NUM_GFP = 10;
    protected static final SDebug db = new SDebug("DwdmCardView");
    protected PpmSlotView[] ppmSlotViews;
    protected ObservableManager _obsMgr;
    protected DwdmModuleModel moduleM;
    protected GridBagConstraints gbc;

    public DwdmCardView(EntityModel entityModel, AbstractCardViewPanel abstractCardViewPanel) {
        super(entityModel);
        int n;
        for (n = 0; n < this.ports.length; ++n) {
            if (!(this.ports[n] instanceof DwdmGenericPortGraphic)) continue;
            ((DwdmGenericPortGraphic)this.ports[n]).addCardViewPane(abstractCardViewPanel);
        }
        this.moduleM = (DwdmModuleModel)entityModel;
        if (this.ppmSlotViews != null && this.moduleM.getEqType() == 293) {
            for (n = 0; n < this.ppmSlotViews.length; ++n) {
                if (this.ppmSlotViews[n] == null) continue;
                this.ppmSlotViews[n].addCardViewPaneToPort(abstractCardViewPanel);
            }
        }
        this._obsMgr = new ObservableManager(this, false);
        this.registerForLocalUpdates();
    }

    protected void addPorts(boolean bl) {
        this.moduleM = (DwdmModuleModel)this.model;
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.insets = new Insets(2, 3, 2, 2);
        if (this.moduleM.supportsGfpPort()) {
            this.ports = new GenericPortGraphic[this.numPorts + 10];
            this.add((Component)new JLabel("FAC"), this.gbc);
            this.addDwdmPortsToCard();
            this.addFiller();
            this.add((Component)new JLabel("GFP"), this.gbc);
            this.updateGfpPorts();
        } else {
            this.addDwdmPortsToCard();
        }
        this.invalidate();
    }

    private void addDwdmPortsToCard() {
        if (this.moduleM.supportSfpPort()) {
            this.addPpmPorts();
        } else {
            this.addMrPorts();
        }
        if (this.moduleM.getEqType() != 293) {
            for (int i = 0; i < this.numPorts; ++i) {
                PortModel portModel = (PortModel)this.portModels.get(i);
                if (portModel.getEqType() != 123) continue;
                this.ports[i] = new TrunkPortGraphic((CardView)this, portModel, portModel.getPort(), portModel.isSpecial(), this.cardViewPanel);
                if (this.pci.positionPortsVertically()) {
                    ++this.gbc.gridy;
                } else {
                    ++this.gbc.gridx;
                }
                this.add((Component)this.ports[i], this.gbc);
            }
        }
    }

    protected void addPpmPorts() {
        PluggableSlotModel[] pluggableSlotModelArray = this.moduleM.getPpmSlots();
        this.ppmSlotViews = new PpmSlotView[pluggableSlotModelArray.length];
        for (int i = 0; i < pluggableSlotModelArray.length; ++i) {
            this.ppmSlotViews[i] = new PpmSlotView(pluggableSlotModelArray[i]);
            if (this.pci.positionPortsVertically()) {
                ++this.gbc.gridy;
            } else {
                ++this.gbc.gridx;
            }
            this.add((Component)this.ppmSlotViews[i], this.gbc);
        }
    }

    protected void addMrPorts() {
        int n;
        MrSlot mrSlot = this.moduleM.getMrSlot();
        if (mrSlot == null) {
            db.println("Cannot find MultiRate port slot for this card");
            return;
        }
        JPanel[] jPanelArray = new JPanel[mrSlot.getMaxPorts()];
        List list = mrSlot.getDescendantsOfClassType(7);
        db.info("Found " + list.size() + " multi-rate client ports");
        for (n = 0; n < this.numPorts; ++n) {
            EntityModel entityModel = (EntityModel)this.portModels.get(n);
            if (!list.contains(entityModel)) continue;
            this.ports[n] = new GenericPortGraphic(this, entityModel, entityModel.getPort());
            jPanelArray[entityModel.getPositionInParent() - 1] = this.ports[n];
        }
        for (n = 0; n < mrSlot.getMaxPorts(); ++n) {
            if (jPanelArray[n] == null) {
                jPanelArray[n] = this.getPortSlotGraphic();
            }
            if (this.pci.positionPortsVertically()) {
                ++this.gbc.gridy;
            } else {
                ++this.gbc.gridx;
            }
            this.add((Component)jPanelArray[n], this.gbc);
        }
    }

    protected JPanel getPortSlotGraphic() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        jPanel.setBackground(Color.lightGray);
        jPanel.setPreferredSize(new Dimension(16, 16));
        return jPanel;
    }

    private void addFiller() {
        JPanel jPanel = new JPanel();
        if (this.pci.positionPortsVertically()) {
            jPanel.setPreferredSize(new Dimension(20, 0));
            ++this.gbc.gridx;
            this.gbc.gridy = 0;
            this.add((Component)jPanel, this.gbc);
            ++this.gbc.gridx;
        } else {
            jPanel.setPreferredSize(new Dimension(0, 20));
            this.gbc.gridx = 0;
            ++this.gbc.gridy;
            this.add((Component)jPanel, this.gbc);
            ++this.gbc.gridy;
        }
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (observable instanceof EntityModel && this.model != null && this.model.getNodeModel().isInited() && object instanceof Integer) {
            Integer n = (Integer)object;
            if (db.on()) {
                db.println("update(): DwdmCardView, From=" + observable + ", arg=" + n);
            }
            if (n.equals(ModelUpdateType.ADDED)) {
                SwingUtilities.invokeLater(new ReplacePort());
                if (db.on()) {
                    db.println("Port ADDED");
                }
            } else if (n.equals(ModelUpdateType.DELETED)) {
                SwingUtilities.invokeLater(new ReplacePort());
                if (db.on()) {
                    db.println("Port DELETED");
                }
            } else if (n.equals(ModelUpdateType.CHANGED) && db.on()) {
                db.println("Port CHANGED");
            }
        }
    }

    public void dispose() {
        this.localDispose();
        super.dispose();
    }

    protected void localDispose() {
        int n;
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        if (this.ppmSlotViews != null) {
            for (n = 0; n < this.ppmSlotViews.length; ++n) {
                this.ppmSlotViews[n].dispose();
            }
        }
        if (this.ports != null) {
            for (n = 0; n < this.ports.length; ++n) {
                if (this.ports[n] == null) continue;
                this.ports[n].dispose();
                this.ports[n] = null;
            }
            this.ports = null;
        }
        this.removeAll();
    }

    protected List getPorts() {
        ArrayList arrayList = new ArrayList();
        MrSlot mrSlot = ((DwdmModuleModel)this.model).getMrSlot();
        if (mrSlot != null) {
            arrayList.addAll(mrSlot.getDescendantsOfClassType(7));
        }
        List list = this.model.getDescendantsOfType(eEqType.DWDM_TRUNK_PORT);
        arrayList.addAll(list);
        return arrayList;
    }

    private void updateGfpPorts() {
        GfpPortModel[] gfpPortModelArray = this.moduleM.getGfpPorts();
        if (db.on()) {
            db.println("updageGfpPorts: length= " + gfpPortModelArray.length);
        }
        for (int i = 0; i < gfpPortModelArray.length; ++i) {
            int n = this.portModels.indexOf(gfpPortModelArray[i]);
            if (n != -1) continue;
            int n2 = gfpPortModelArray[i].getGraphPortPosition();
            if (db.on()) {
                db.println("updageGfpPorts Add Gfp port= " + n2);
            }
            if (this.pci.positionPortsVertically()) {
                this.gbc.gridy = n2;
            } else {
                this.gbc.gridx = n2;
            }
            this.portModels.add(gfpPortModelArray[i]);
            this.ports[this.numPorts] = new GenericPortGraphic(this, gfpPortModelArray[i], n2);
            this.add((Component)this.ports[this.numPorts], this.gbc);
            ++this.numPorts;
        }
    }

    protected void registerForLocalUpdates() {
        MrSlot mrSlot;
        this._obsMgr.reset();
        this._obsMgr.addObservable((Observable)((Object)this.moduleM));
        if (this.moduleM.supportsGfpPort()) {
            this._obsMgr.addObservable((Observable[])this.moduleM.getGfpPorts());
        }
        if ((mrSlot = this.moduleM.getMrSlot()) != null) {
            this._obsMgr.addObservable((Observable)((Object)mrSlot));
            this._obsMgr.addObservable((Observable[])mrSlot.getDescendantsOfClassType(7).toArray(new PortModel[0]));
        }
        this._obsMgr.setActive(true);
        this._obsMgr.setPassing(true);
    }

    protected class ReplacePort
    implements Runnable {
        protected ReplacePort() {
        }

        public void run() {
            block4: {
                try {
                    DwdmCardView.this.localDispose();
                    if (DwdmCardView.this.model != null) {
                        DwdmCardView.this.portModels = DwdmCardView.this.getPorts();
                        DwdmCardView.this.numPorts = DwdmCardView.this.portModels.size();
                        DwdmCardView.this.ports = new AbstractPortGraphic[DwdmCardView.this.numPorts];
                        DwdmCardView.this.addPorts(DwdmCardView.this.pci.positionPortsVertically());
                        DwdmCardView.this.refreshAlarmInfo();
                        DwdmCardView.this.registerForLocalUpdates();
                    }
                }
                catch (CmsObjectNotExistException cmsObjectNotExistException) {
                }
                catch (Exception exception) {
                    if (!db.on()) break block4;
                    db.println("Error replacing port: " + exception);
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            DwdmCardView.this.validate();
            DwdmCardView.this.repaint();
        }
    }
}

