/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.PortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.shelf.AbstractPortGraphic;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.G1000CardView;
import cerent.cms.ui.shelf.ICardPainter;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.CubicCurve2D;
import java.util.Observable;
import java.util.Observer;

public class FcmrPortGraphic
extends Rectangle
implements Observer {
    public int portNo;
    public int slotNo;
    private PortModel portModel;
    private InterfaceModel ifModel;
    private CardGraphic parent;
    private String statusString = "";
    private String alarmProfileString = "";
    private Color currentColor = Color.gray;
    protected EntityCellRenderer myPortRenderer = new EntityCellRenderer();
    private int currentSeverity = 0;
    private int currentAdminState = -1;
    private int currentServiceStateType = -1;
    private int connector1XOffset;
    private int connector2XOffset;
    private int connector1YOffset;
    private int connector2YOffset;
    private Rectangle connector1;
    private Rectangle connector2;
    private int distance;
    private TDMTerminology terms;
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfLayout.db, "FcmrPortGraphic");

    public FcmrPortGraphic(CardGraphic cardGraphic, int n, int n2, PortModel portModel) {
        super(n, n2, 1, 1);
        IPlatform iPlatform = portModel.getNodeModelDelegate().getPlatform();
        this.terms = portModel.getNodeModel().getTDMTerminology();
        ICardPainter iCardPainter = cardGraphic.getCardPainter();
        this.resize(iCardPainter.getPortWidth(), iCardPainter.getPortHeight());
        this.connector1XOffset = n + iCardPainter.getPortConn1X();
        this.connector2XOffset = n + iCardPainter.getPortConn2X();
        this.connector1YOffset = n2 + iCardPainter.getPortConn1Y();
        this.connector2YOffset = n2 + iCardPainter.getPortConn2Y();
        this.connector1 = new Rectangle(this.connector1XOffset, this.connector1YOffset, 2, 2);
        this.connector2 = new Rectangle(this.connector2XOffset, this.connector2YOffset, 2, 2);
        this.distance = iCardPainter.getPortLoopbackDist();
        this.parent = cardGraphic;
        this.portModel = portModel;
        this.slotNo = this.portModel.getSlot();
        this.portNo = this.portModel.getPort();
        Thread thread = new Thread("FcmrPort Init:" + this.slotNo + ":" + this.portNo){

            public void run() {
                FcmrPortGraphic.this.setIfModel((InterfaceModel)FcmrPortGraphic.this.portModel.getInterfaceModel());
                FcmrPortGraphic.this.registerWithModel();
                FcmrPortGraphic.this.updateCurrentState();
            }
        };
        thread.start();
    }

    private void setIfModel(InterfaceModel interfaceModel) {
        if (FcmrPortGraphic.db.on) {
            db.println("ifModel being set is: " + interfaceModel);
        }
        this.ifModel = interfaceModel;
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got state changed message ");
            }
            this.updateCurrentState();
        }
    }

    protected String getPortDescription() {
        StringBuffer stringBuffer = new StringBuffer("Port ");
        stringBuffer.append(this.myPortRenderer.getPortString(this.portModel, false));
        stringBuffer.append(", ");
        return stringBuffer.toString();
    }

    public String getTooltipText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getPortDescription());
        try {
            stringBuffer.append(this.statusString);
            stringBuffer.append(", Alarm Profile: ");
            stringBuffer.append(this.alarmProfileString);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Failed trying to generate tooltip string: " + exception.getMessage());
                SDebug.printStackTrace((Throwable)exception);
            }
            stringBuffer = new StringBuffer("");
        }
        return stringBuffer.toString();
    }

    public void dispose() {
        if (this.ifModel != null) {
            if (db.on()) {
                db.println("Deleting observer " + this.ifModel + " Slot " + this.slotNo);
            }
            this.ifModel.deleteObserver(this);
        }
        this.portModel.deleteObserver(this);
    }

    public boolean equals(Object object) {
        if (object instanceof FcmrPortGraphic) {
            return object == this;
        }
        return super.equals(object);
    }

    protected void setAlarmState(int n) {
        if (db.on()) {
            db.println("set alrm st=" + n);
        }
        if (this.currentSeverity != n) {
            this.currentSeverity = n;
            if (this.currentAdminState == 0) {
                this.currentColor = AbstractPortGraphic.getPortColorByAdminStateAndSeverity(this.currentAdminState, n);
                this.parent.repaint();
            }
        }
    }

    private void updateCurrentState() {
        try {
            this.alarmProfileString = this.portModel.getAlarmProfileName();
        }
        catch (Exception exception) {
            this.alarmProfileString = "(Error Retrieving)";
        }
        int n = -1;
        int n2 = -1;
        try {
            if (this.ifModel != null) {
                n = this.ifModel.getAdminState();
                n2 = this.ifModel.getServiceSt().getType();
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            db.println("Caught exception in updateCurrentState");
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        if (n2 != this.currentServiceStateType) {
            this.currentServiceStateType = n2;
            this.statusString = this.terms.getTermForServiceState(this.currentServiceStateType);
        }
        if (n != this.currentAdminState) {
            this.currentAdminState = n;
            this.currentColor = AbstractPortGraphic.getPortColorByAdminStateAndSeverity(this.currentAdminState, this.currentSeverity);
        }
        this.parent.repaint();
    }

    protected Color getCurrentColor() {
        return this.currentColor;
    }

    private void registerWithModel() {
        if (this.ifModel != null) {
            if (db.on()) {
                db.println("registering with " + this.ifModel);
            }
            this.ifModel.addObserver(this);
        }
        if (db.on()) {
            db.println("registering with " + this.portModel);
        }
        this.portModel.addObserver(this);
    }

    public void draw(Graphics2D graphics2D) {
        graphics2D.setColor(this.getCurrentColor());
        graphics2D.fill(this);
        graphics2D.setColor(Color.black);
        graphics2D.draw(this);
        graphics2D.fill(this.connector1);
        graphics2D.fill(this.connector2);
        double d = this.connector1XOffset;
        double d2 = this.connector1YOffset;
        double d3 = this.connector2XOffset;
        double d4 = this.connector2YOffset;
        double d5 = Math.min(d2, d4);
        double d6 = Math.max(d2, d4);
        double d7 = Math.min(d, d3);
        double d8 = Math.max(d, d3);
        CubicCurve2D.Double double_ = null;
        if (this.isFacilityLoopback()) {
            double_ = new CubicCurve2D.Double(d, d2, d - this.getWidth() / 2.25, Math.abs(d2 - d4) / 100.0 + d5, d3 - this.getWidth() / 2.25, d6 - Math.abs(d2 - d4) / 100.0, d3, d4);
            G1000CardView.drawArrow(graphics2D, this, true, true, false, Color.gray);
            Color color = graphics2D.getColor();
            graphics2D.setColor(Color.gray);
            graphics2D.draw(double_);
            graphics2D.setColor(color);
        } else if (this.isTerminalLoopback()) {
            double_ = new CubicCurve2D.Double(d, d2, d + this.getWidth() / 2.25, Math.abs(d2 - d4) / 100.0 + d5, d3 + this.getWidth() / 2.25, d6 - Math.abs(d2 - d4) / 100.0, d3, d4);
            Color color = graphics2D.getColor();
            graphics2D.setColor(Color.black);
            graphics2D.draw(double_);
            graphics2D.setColor(color);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoopback(int n) {
        boolean bl = false;
        Throwable throwable = null;
        if (this.ifModel instanceof FcmrLineModel) {
            FcmrLineModel fcmrLineModel = (FcmrLineModel)this.ifModel;
            try {
                bl = fcmrLineModel.getFcLineAdminInfo().portLoopback.value() == n;
            }
            catch (NoSuchInterface noSuchInterface) {
                throwable = noSuchInterface;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                throwable = wrongInterfaceType;
            }
            finally {
                if (throwable != null && db.on()) {
                    SDebug.printStackTrace((Throwable)throwable);
                }
            }
        }
        return bl;
    }

    public boolean isFacilityLoopback() {
        return this.isLoopback(2);
    }

    public boolean isTerminalLoopback() {
        return this.isLoopback(1);
    }
}

