/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OpticsTopology.eApcAdminStatus;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Busy;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.DwdmApcModel;
import cerent.cms.model.DwdmApcModels;
import cerent.cms.model.IAPCLastModification;
import cerent.cms.model.IDwdmApcModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;

public class MaintApcDataSource
extends AbstractRowDataSource
implements Observer {
    private DwdmApcModels dwdmApcModels;
    private int sideId = -1;
    private IAPCLastModification[] ApcList = new IAPCLastModification[0];
    private static final SDebug db = new SDebug("MaintApcDataSource");
    public static final int NO_SIDES = -1;
    public static final int ALL_SIDES = 9;

    public MaintApcDataSource(DwdmApcModels dwdmApcModels) {
        this.dwdmApcModels = dwdmApcModels;
        IDwdmApcModel[] iDwdmApcModelArray = this.dwdmApcModels.getAllDwdmApcModel();
        for (int i = 0; i < iDwdmApcModelArray.length; ++i) {
            DwdmApcModel dwdmApcModel = (DwdmApcModel)iDwdmApcModelArray[i];
            dwdmApcModel.addObserver(this);
        }
    }

    public void setCurrentSide(int n) {
        this.sideId = n;
    }

    public int getCurrentSide() {
        return this.sideId;
    }

    public void runApc() throws Busy, CannotPerform, WrongNodeSide {
        this.dwdmApcModels.runApc(this.sideId);
    }

    public void setApcAdminState(eApcAdminStatus eApcAdminStatus2) throws WrongNodeSide {
        this.dwdmApcModels.setApcAdminState(eApcAdminStatus2, this.sideId);
    }

    public int getApcAdminState() throws WrongNodeSide {
        return this.dwdmApcModels.getApcAdminState(this.sideId);
    }

    public int getApcProgressState() throws WrongNodeSide {
        return this.dwdmApcModels.getApcProgressState(this.sideId);
    }

    public int getApcState() throws WrongNodeSide {
        return this.getApcState(this.sideId);
    }

    public int getApcState(int n) throws WrongNodeSide {
        return this.dwdmApcModels.getApcState(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getApcList() {
        ArrayList<IAPCLastModification> arrayList = new ArrayList<IAPCLastModification>();
        try {
            IAPCLastModification[] iAPCLastModificationArray = null;
            if (this.sideId != -1) {
                iAPCLastModificationArray = this.sideId == 9 ? this.dwdmApcModels.getAllApcLastModif() : this.dwdmApcModels.getSideAPCLastModif(this.sideId);
                for (int i = 0; i < iAPCLastModificationArray.length; ++i) {
                    IAPCLastModification iAPCLastModification = iAPCLastModificationArray[i];
                    arrayList.add(iAPCLastModification);
                }
            }
            this.ApcList = arrayList.toArray(new IAPCLastModification[0]);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (db.on()) {
                db.finest("Exception in getApcList() " + (Object)((Object)abstractCmsIOException));
            }
        }
        catch (WrongNodeSide wrongNodeSide) {
            SDebug.printStackTrace((Throwable)wrongNodeSide);
        }
        finally {
            this.fireDataSourceChanged();
        }
    }

    public void dispose() {
        if (db.on()) {
            db.println("MainApcDataSource Dispose");
        }
    }

    public void update(Observable observable, Object object) {
        int n = object instanceof IObjectMessageInfo ? ((IObjectMessageInfo)object).getUpdateType() : ((Integer)object).intValue();
        if (n == 1) {
            this.getApcList();
        }
        this.fireDataSourceChanged();
    }

    public Object getObjectAtRow(int n) {
        return this.ApcList[n];
    }

    public int getRowCount() {
        return this.ApcList.length;
    }

    public Collection getAllObjects() {
        return Arrays.asList(this.ApcList);
    }

    public NodeModelDelegate getNodeModel() {
        return (NodeModelDelegate)this.dwdmApcModels.getNodeModel();
    }
}

