/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OSI.eOsiMode;
import cerent.cms.idl.OSI.sRouter;
import cerent.cms.model.RouterModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.helper.OsiHelper;
import cerent.cms.ui.shelf.AbstractShelfEditTablePane;
import cerent.cms.ui.shelf.OsiRouterEditDialog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.gui.WindowHelper;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;

public class OsiRouterAddrPane
extends AbstractShelfEditTablePane {
    public static final int ROUTER_ID = 0;
    public static final int ENABLED_ID = 1;
    public static final int ROUTER_ADDR_ID = 2;
    public static final int SYSTEM_ID = 3;
    public static final int MAA_ID = 4;
    protected RouterModel routerModel;

    public OsiRouterAddrPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
    }

    protected void localInit() {
        super.localInit();
    }

    protected JPanel getButtonBar() {
        this.createButton = this.makeActionButton("Create...");
        this.deleteButton = this.makeActionButton("Delete...");
        this.editButton = this.makeActionButton("Edit...");
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(this.getHelpID());
        cSHelpButtonPane.addLeft(this.editButton);
        return cSHelpButtonPane;
    }

    protected void initModels() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[]{new RouterColumnRenderer(), new StatusColumnRenderer(), new RouterAddressColumnRenderer(), new SystemColumnRenderer(), new MAAColumnRenderer()};
        this.routerModel = this.nodeModel.getRouterModel();
        RouterGeneralRowSource routerGeneralRowSource = new RouterGeneralRowSource();
        this.model = new SortableRowTableModel((RowDataSource)routerGeneralRowSource, columnRendererArray);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            WindowHelper.setEnabled((JComponent)this.editButton, (boolean)this.isUserAuthorized());
        } else {
            WindowHelper.setEnabled((JComponent)this.editButton, (boolean)false);
        }
    }

    public void setEditDeleteEnabled(boolean bl) {
        super.setEditDeleteEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateTableData() {
        List list = this.tableData;
        synchronized (list) {
            this.tableData = new ArrayList();
            try {
                sRouter[] sRouterArray = this.routerModel.getRouterList();
                int n = sRouterArray.length;
                for (int i = 0; i < n; ++i) {
                    db.fine("populateTableData(): router " + i);
                    this.tableData.add(sRouterArray[i]);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                db.println("Error in getting routers: " + exception);
            }
        }
    }

    public void destroy() {
        if (this.table != null) {
            this.table.removeMouseListener(this);
        }
        super.destroy();
    }

    protected void createTableEntry() {
    }

    protected void editSelectedTableEntry(int n) {
        if (!this.isUserAuthorized()) {
            return;
        }
        sRouter sRouter2 = (sRouter)this.model.getValueAt(n, 0);
        if (this.nodeModel.getOsiModel().getRoutingModeEnum() == eOsiMode.OSI_MODE_ES && sRouter2.routerNumber != 1) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CANT_EDIT_ROUTER_IN_ES_MODE);
        } else if (sRouter2 != null) {
            OsiRouterEditDialog osiRouterEditDialog = OsiRouterEditDialog.instance(this);
            osiRouterEditDialog.setSelectedRouter(sRouter2);
            osiRouterEditDialog.show();
            osiRouterEditDialog.dispose();
        } else {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NO_ROUTER_SELECTED);
        }
    }

    protected void deleteSelectedTableEntry(int n) {
    }

    protected void registerWithModels() {
        if (this.routerModel != null) {
            this.getObservableManager().addObservable((Observable)((Object)this.routerModel));
        }
    }

    protected void setDataSourceControl() {
        this.setDataSourceControl(new InnerDsc());
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.OsiRouterSetupPane;
    }

    class MAAColumnRenderer
    extends BaseColumnRenderer {
        MAAColumnRenderer() {
        }

        public int getWidth() {
            return 250;
        }

        public String getName() {
            return "Additional MAA";
        }
    }

    class RouterAddressColumnRenderer
    extends BaseColumnRenderer {
        RouterAddressColumnRenderer() {
        }

        public String getName() {
            return "Primary MAA";
        }

        public int getWidth() {
            return 250;
        }
    }

    class SystemColumnRenderer
    extends BaseColumnRenderer {
        SystemColumnRenderer() {
        }

        public String getName() {
            return "System ID";
        }

        public int getWidth() {
            return 125;
        }
    }

    class StatusColumnRenderer
    extends BaseColumnRenderer {
        StatusColumnRenderer() {
        }

        public String getName() {
            return "Status";
        }

        public int getWidth() {
            return 50;
        }
    }

    class RouterColumnRenderer
    extends BaseColumnRenderer {
        RouterColumnRenderer() {
        }

        public String getName() {
            return "Router#";
        }

        public int getWidth() {
            return 50;
        }
    }

    abstract class BaseColumnRenderer
    implements ColumnRenderer {
        protected BaseColumnRenderer() {
        }

        public boolean isResizable() {
            return true;
        }

        public int getAlignment() {
            return 2;
        }

        protected String getStringValue(sRouter sRouter2, int n) {
            String string = "???";
            switch (n) {
                case 0: {
                    Short s = new Short(sRouter2.routerNumber);
                    string = s.toString();
                    break;
                }
                case 1: {
                    string = "Disabled";
                    if (!sRouter2.enabled) break;
                    string = "Enabled";
                    break;
                }
                case 3: {
                    string = OsiHelper.getSystemIdString((byte[])sRouter2.sysId);
                    break;
                }
                case 2: {
                    String string2 = "";
                    if (sRouter2.addrList.length >= 1) {
                        string2 = OsiHelper.getAreaAddressString((byte[])sRouter2.addrList[0]);
                    }
                    string = string2;
                    break;
                }
                case 4: {
                    byte[][] byArray = sRouter2.addrList;
                    String string3 = "";
                    for (int i = 1; i < byArray.length; ++i) {
                        string3 = string3 + OsiHelper.getAreaAddressString((byte[])byArray[i]);
                        if (i >= byArray.length - 1) continue;
                        string3 = string3 + "\n";
                    }
                    string = string3;
                }
            }
            return string;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            sRouter sRouter2 = (sRouter)jTable.getValueAt(n, 0);
            String string = this.getStringValue(sRouter2, n2);
            if (n2 == 4) {
                JTextArea jTextArea = new JTextArea(string);
                jTextArea.setFont(OsiHelper.FIXED_WIDTH_FONT);
                int n3 = jTextArea.getPreferredSize().height;
                if (jTable.getRowHeight(n) != n3) {
                    jTable.setRowHeight(n, n3);
                }
                jTextArea.setOpaque(true);
                jTextArea.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
                jTextArea.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
                return jTextArea;
            }
            JLabel jLabel = new JLabel(string);
            if (n2 == 2) {
                jLabel.setFont(OsiHelper.FIXED_WIDTH_FONT);
            }
            jLabel.setOpaque(true);
            jLabel.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            jLabel.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            return jLabel;
        }

        public int compareColumn(Object object, Object object2, int n) {
            String string = this.getStringValue((sRouter)object, n);
            String string2 = this.getStringValue((sRouter)object2, n);
            return string.compareTo(string2);
        }
    }

    class RouterGeneralRowSource
    extends AbstractRowDataSource {
        RouterGeneralRowSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObjectAtRow(int n) {
            Object var2_2 = null;
            List list = OsiRouterAddrPane.this.tableData;
            synchronized (list) {
                var2_2 = OsiRouterAddrPane.this.tableData.get(n);
            }
            return var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            int n = -1;
            List list = OsiRouterAddrPane.this.tableData;
            synchronized (list) {
                n = OsiRouterAddrPane.this.tableData.size();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection getAllObjects() {
            List list = OsiRouterAddrPane.this.tableData;
            synchronized (list) {
                return OsiRouterAddrPane.this.tableData;
            }
        }

        public Class getRowObjectClass() {
            return sRouter.class;
        }
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        boolean initedOM = false;

        private void initObservableManager() {
            OsiRouterAddrPane.this.resetObservableManager();
            OsiRouterAddrPane.this.registerWithModels();
            OsiRouterAddrPane.this.setObservableManagerActive();
            this.initedOM = true;
            if (db.on()) {
                db.println("initObservabledManager() done");
            }
        }

        public void refreshFromModel() throws Exception {
            if (db.on()) {
                db.println("InnerDsc::refreshFromModel()");
            }
            if (!this.initedOM) {
                this.initObservableManager();
            } else if (db.on()) {
                db.println("did not call initObservableManager()");
            }
            OsiRouterAddrPane.this.repopulateTable();
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)OsiRouterAddrPane.this), true);
            }
            return this.dscObservableManager;
        }
    }
}

