/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IPortModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.SDebug;
import javax.swing.table.AbstractTableModel;

public class PassivePortsTableModel
extends AbstractTableModel {
    private OpticsPortModel[] _models;
    private int _cardEqType;
    private int _numLines;
    private SDebug _db;
    public static final int PORT_NAME_IDX = 0;
    public static final int PORT_WL_IDX = 1;
    public static final int MPO_IDX = 2;
    public static final String[] columnNames = new String[]{"Port", "Wavelength", "MPO"};

    public PassivePortsTableModel(OpticsPortModel[] opticsPortModelArray, SDebug sDebug) {
        this._models = opticsPortModelArray;
        this._db = sDebug;
        this.init();
    }

    protected void init() {
        this._numLines = this._models == null ? 0 : this._models.length;
    }

    public Class getColumnClass(int n) {
        return super.getColumnClass(n);
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public int getRowCount() {
        return this._numLines;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public Object getValueAt(int n, int n2) {
        String string;
        block8: {
            string = null;
            try {
                switch (n2) {
                    case 0: {
                        string = this.getPortDescription(n) + " " + this._models[n].getOptPortTypeString();
                        break;
                    }
                    case 1: {
                        if (this._models[n].isWavelengthSupported()) {
                            string = Wavelength.getWavelengthStringFromWavelength(this._models[n].getWaveLength());
                            break;
                        }
                        string = "";
                        break;
                    }
                    case 2: {
                        string = this._models[n].getMPO() == 0 ? "" : Integer.toString(this._models[n].getMPO());
                    }
                }
            }
            catch (Exception exception) {
                this._db.println("Caught Exception in getValueAt");
                if (!this._db.on()) break block8;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    public void refreshFromModel() {
        this.fireTableRowsUpdated(0, this._numLines - 1);
    }

    private String getPortDescription(int n) {
        OpticsPortModel opticsPortModel = this._models[n];
        String string = PortHelper.getPortNumString((IPortModel)opticsPortModel);
        string = String.valueOf(n + 1);
        return string;
    }

    protected void refreshMyLines(OpticsPortModel[] opticsPortModelArray) {
        this._models = opticsPortModelArray;
        this.init();
        this.fireTableDataChanged();
    }

    public void dispose() {
    }
}

