/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.INodeHelper;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SideInUse;
import cerent.cms.model.SideModel;
import cerent.cms.model.SideModels;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.FunctionalViewButton;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.shelf.SideCreationDialog;
import cerent.cms.ui.shelf.SideDataSource;
import cerent.cms.ui.shelf.SideEditDialog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.PluralisationUtil;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.omg.CORBA.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SidePane
extends AbstractPane
implements ActionListener,
ListSelectionListener {
    static final String OPEN = "(";
    static final String CLOSE = ")";
    static final String COMMA = ",";
    static final String SPACE = " ";
    public static final int SIDE_ID = 0;
    public static final int LINE_IN = 1;
    public static final int LINE_OUT = 2;
    public static final int CONNECTED_TO = 3;
    private static final SDebug db = new SDebug("SidePane");
    protected JButton createSB;
    protected JButton deleteSB;
    protected JButton editSB;
    private static final String ADD = "Create...";
    private static final String DELETE = "Delete...";
    private static final String EDIT = "Edit...";
    public static final String[] columnNames = new String[]{"Side", "Line In", "Line Out", "Connected To"};
    protected SideModels smod = null;
    private SideDataSource dataSource;
    private SortableRowTableModel tableModel;
    private boolean inited = false;
    private NodeModelDelegate nm = null;
    private INodeHelper nh;
    private boolean fvButtonDiable;

    public SidePane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        if (db.on()) {
            db.println(this.getClass() + "::SidePane");
        }
        this.nm = (NodeModelDelegate)tabbedView.getUiModel().getNodeModel();
        this.nh = this.nm.getNodeModel().getUiToolkit().getNodeHelper();
        this.smod = SideModels.getInstance(this.nm);
    }

    protected SideCreationDialog generateSideCreationDialog() {
        return SideCreationDialog.instance(JOptionPane.getFrameForComponent((Component)((Object)this)), this.parentTV.getUiModel());
    }

    protected void init() {
        if (db.on()) {
            db.println(this.getClass() + "::init");
        }
        this.setLayout(new BorderLayout());
        ColumnRenderer[] columnRendererArray = this.createColumnRenderers();
        this.dataSource = new SideDataSource(this.smod);
        this.tableModel = new SortableRowTableModel((RowDataSource)this.dataSource, columnRendererArray);
        this.table = new UTable((TableModel)((Object)this.tableModel));
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(2);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.tableModel.initTable(this.table);
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.add(this.getButtonBar(), "South");
        this.setButtonsEnabled(false);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.inited = true;
    }

    @Override
    public void dispose() {
        if (db.on()) {
            db.println(this.getClass() + "::dispose()");
        }
        if (this.inited) {
            this.dataSource.removeObserver();
        }
        super.dispose();
    }

    @Override
    public void destroy() {
        if (db.on()) {
            db.println(this.getClass() + "::destroy()");
        }
        if (this.inited) {
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        }
        super.destroy();
    }

    protected JPanel getButtonBar() {
        if (db.on()) {
            db.println(this.getClass() + "::getButtonBar()");
        }
        this.createSB = new JButton(ADD);
        this.createSB.addActionListener(this);
        this.editSB = new JButton(EDIT);
        this.editSB.addActionListener(this);
        this.deleteSB = new JButton(DELETE);
        this.deleteSB.addActionListener(this);
        JPanel jPanel = SidePane.createHorizontalPanel(null);
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(this.getHelpID());
        cSHelpButtonPane.addLeft(this.createSB);
        cSHelpButtonPane.addLeft(this.editSB);
        cSHelpButtonPane.addLeft(this.deleteSB);
        jPanel.add(cSHelpButtonPane);
        return jPanel;
    }

    protected void clearTableSelection() {
        if (db.on()) {
            db.println(this.getClass() + "::clearTableSelection()");
        }
        if (this.table != null && this.dataSource.getRowCount() != 0) {
            this.table.removeRowSelectionInterval(0, this.dataSource.getRowCount() - 1);
        }
    }

    protected void setButtonsEnabled(boolean bl) {
        if (db.on()) {
            db.println(this.getClass() + "::setButtonsEnabled");
        }
        boolean bl2 = this.isUserLevelSufficient();
        this.createSB.setEnabled(bl2);
        this.editSB.setEnabled(bl2 && bl && this.table.getSelectedRowCount() == 1);
        this.deleteSB.setEnabled(bl2 && bl && this.table.getSelectedRowCount() > 0);
    }

    private boolean isUserLevelSufficient() {
        boolean bl = AbstractPane.isUserAuthorized(this.smod, SecurityLevel.SUPERUSER);
        boolean bl2 = AbstractPane.isUserAuthorized(this.smod, SecurityLevel.PROVISIONING);
        boolean bl3 = AbstractPane.isUserAuthorized(this.smod, SecurityLevel.MAINTENANCE);
        return bl || bl2 || bl3;
    }

    @Override
    public void enteringPage() {
        block4: {
            if (db.on()) {
                db.println(this.getClass() + "::enteringPage");
            }
            try {
                if (!this.inited) {
                    this.init();
                }
                this.refresh();
            }
            catch (Exception exception) {
                if (!SidePane.db.on) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    @Override
    public void leavingPage() throws Exception {
        if (db.on()) {
            db.println(this.getClass() + "::leavingPage");
        }
    }

    @Override
    public void refresh() {
        if (db.on()) {
            db.println(this.getClass() + "::refresh()");
        }
        this.dataSource.refresh();
        int n = this.table.getSelectedRow();
        if (n < 0 || n > this.dataSource.getRowCount()) {
            this.setButtonsEnabled(false);
        }
        if (db.on()) {
            db.fine("refresh: " + this.dataSource.getRowCount() + " Side returned");
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel;
        if (db.on()) {
            db.println(this.getClass() + "::valueChanged()");
        }
        this.setButtonsEnabled(!(listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty());
    }

    private void deleteSides(ISideModel[] iSideModelArray) {
        if (db.on()) {
            db.println(this.getClass() + "::deleteSides()");
        }
        if (iSideModelArray == null || iSideModelArray.length == 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_SIDE_NOT_SELECTED, (Object)"Side");
            return;
        }
        db.info("Deleting " + iSideModelArray.length + " sides.");
        ArrayList<ISideModel> arrayList = new ArrayList<ISideModel>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < iSideModelArray.length; ++i) {
            ISideModel iSideModel = iSideModelArray[i];
            if (iSideModel == null) continue;
            db.info("Deleting " + iSideModel + " ...");
            try {
                this.smod.deleteSide(iSideModel.getId(), iSideModel.getLineIn());
                arrayList.add(iSideModel);
                continue;
            }
            catch (WrongNodeSide wrongNodeSide) {
                if (SidePane.db.on) {
                    SDebug.printStackTrace((Throwable)wrongNodeSide);
                }
                db.println("Deleting of side (" + iSideModel + ") failed:\n" + wrongNodeSide.getMessage());
                this.fvButtonDiable = false;
                SidePane.addFailureReason(EMC.EID_WRONG_NODE_SIDE, iSideModel, arrayList2);
                continue;
            }
            catch (SideInUse sideInUse) {
                if (SidePane.db.on) {
                    SDebug.printStackTrace((Throwable)sideInUse);
                }
                db.println("Deleting of side (" + iSideModel + ") failed:\n" + sideInUse.getMessage());
                this.fvButtonDiable = false;
                SidePane.addFailureReason(EMC.EID_SIDE_CARRYING_TRAFFIC, iSideModel, arrayList2);
                continue;
            }
            catch (UserException userException) {
                SDebug.printStackTrace((Throwable)userException);
                this.fvButtonDiable = false;
                CerentDialog.errorDialog((Component)((Object)this), (String)userException.getMessage(), (String)"Error");
            }
        }
        db.info("Handling " + arrayList2.size() + " side deletion failures (" + arrayList.size() + " successes)");
        SidePane.handleFailures((Component)((Object)this), arrayList, arrayList2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (db.on()) {
            db.println(this.getClass() + "::actionPerformed()");
        }
        if ((object = actionEvent.getSource()) == this.createSB) {
            this.generateSideCreationDialog();
        }
        if (object == this.editSB) {
            int n = this.table.getSelectedRow();
            this.generateSideEditDialog(n);
        } else if (object == this.deleteSB) {
            int[] nArray = this.table.getSelectedRows();
            this.fvButtonDiable = nArray.length == this.table.getRowCount();
            ISideModel[] iSideModelArray = new ISideModel[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n >= this.dataSource.getRowCount()) continue;
                iSideModelArray[i] = (ISideModel)this.tableModel.getValueAt(n, 0);
            }
            Object[] objectArray = this.filterPSMSide(iSideModelArray);
            SideDeletionConfirmDialog sideDeletionConfirmDialog = new SideDeletionConfirmDialog(objectArray);
            sideDeletionConfirmDialog.show();
            if (sideDeletionConfirmDialog.isOk()) {
                this.deleteSides((ISideModel[])objectArray);
                FunctionalViewButton functionalViewButton = FunctionalViewButton.getInstance((INodeModel)this.smod.getNodeModel());
                if (functionalViewButton != null) {
                    functionalViewButton.setVisible(!this.fvButtonDiable);
                }
            }
        }
    }

    private ISideModel[] filterPSMSide(ISideModel[] iSideModelArray) {
        int n;
        ISideModel[] iSideModelArray2 = new ISideModel[8];
        ArrayList<ISideModel> arrayList = new ArrayList<ISideModel>();
        for (n = 0; n < 8; ++n) {
            iSideModelArray2[n] = null;
        }
        if (iSideModelArray != null) {
            for (n = 0; n < iSideModelArray.length; ++n) {
                DwdmSide.SideEnum sideEnum = DwdmSide.getValue(iSideModelArray[n].getId());
                if (sideEnum != null) {
                    if (iSideModelArray2[sideEnum.toInt() - 1] != null) continue;
                    iSideModelArray2[sideEnum.toInt() - 1] = iSideModelArray[n];
                    arrayList.add(iSideModelArray[n]);
                    continue;
                }
                if (DwdmSide.getSideLabelFromOffset(iSideModelArray[n].getId()) != "Unknown") continue;
                arrayList.add(iSideModelArray[n]);
            }
        }
        return arrayList.toArray(new SideModel[0]);
    }

    private void generateSideEditDialog(int n) {
        if (db.on()) {
            db.println(this.getClass() + "::getSideEditDialog()");
        }
        SideEditDialog.instance(JOptionPane.getFrameForComponent((Component)((Object)this)), this.parentTV.getUiModel(), n, this.tableModel);
    }

    private ColumnRenderer[] createColumnRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[columnNames.length];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = this.createColumnRenderer(i);
        }
        return columnRendererArray;
    }

    private ColumnRenderer createColumnRenderer(int n) {
        SideColumnRenderer sideColumnRenderer = null;
        switch (n) {
            case 0: {
                sideColumnRenderer = new SideColumnRenderer(n, 20, true, 2);
                break;
            }
            case 1: {
                sideColumnRenderer = new SideColumnRenderer(n, 250, true, 2);
                break;
            }
            case 2: {
                sideColumnRenderer = new SideColumnRenderer(n, 250, true, 2);
                break;
            }
            case 3: {
                sideColumnRenderer = new SideColumnRenderer(n, 250, true, 2);
                break;
            }
        }
        return sideColumnRenderer;
    }

    protected static void addFailureReason(EID eID, ISideModel iSideModel, List<String> list) {
        if (list != null) {
            list.add("Side '" + iSideModel.getName() + "':\n" + "   " + eID.toString());
        }
    }

    protected static void handleFailures(Component component, List<ISideModel> list, List<String> list2) {
        if (list2.size() > 0) {
            int n;
            ImageIcon imageIcon = CerentDialog.WARNING_ICON;
            String string = "";
            String string2 = "";
            int n2 = list2.size();
            imageIcon = CerentDialog.FATAL_ICON;
            string = EMC.EID_SIDE_NOT_DELETED.getComposedMessage();
            string2 = string2 + n2 + SPACE + PluralisationUtil.s("side", n2) + SPACE + PluralisationUtil.s("was", n2) + " not deleted, as follows:\n";
            for (n = 0; n < list2.size(); ++n) {
                string2 = string2 + "" + list2.get(n) + "\n";
            }
            string2 = string2 + "\n";
            if (list.size() > 0) {
                n = list.size();
                string2 = string2 + "However, " + n + SPACE + PluralisationUtil.s("side", n) + SPACE + PluralisationUtil.s("was", n) + " deleted as follows:\n";
                for (int i = 0; i < list.size(); ++i) {
                    string2 = string2 + "Side '" + list.get(i).getName() + "'\n";
                }
            }
            DetailedDialog detailedDialog = DetailedDialog.instance((Frame)JOptionPane.getFrameForComponent(component), (String)"Error Processing Sides");
            detailedDialog.setText(string, imageIcon);
            detailedDialog.append(string2);
            detailedDialog.setSize(500, detailedDialog.getHeight());
            detailedDialog.show();
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.SidePane;
    }

    protected class SideDeletionConfirmDialog {
        protected boolean ok = false;
        protected Object[] sidesToDelete;

        public SideDeletionConfirmDialog(Object[] objectArray) {
            this.sidesToDelete = objectArray;
        }

        public boolean isOk() {
            return this.ok;
        }

        public void show() {
            String string = "Do you really want to delete the selected " + PluralisationUtil.s("side", this.sidesToDelete.length) + "?";
            Object[] objectArray = new Object[]{new JLabel(string)};
            JOptionPane jOptionPane = new JOptionPane(objectArray, 3, 0, CerentDialog.QUESTION_ICON);
            JDialog jDialog = jOptionPane.createDialog((Component)((Object)SidePane.this), "Delete " + PluralisationUtil.s("Side", this.sidesToDelete.length));
            jDialog.setVisible(true);
            if (jOptionPane.getValue() != null && (Integer)jOptionPane.getValue() == 0) {
                this.ok = true;
            }
        }
    }

    protected class SideColumnRenderer
    extends AbstractColumnRenderer {
        public SideColumnRenderer(int n, int n2, boolean bl, int n3) {
            super(columnNames[n], n2, bl, n3);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ISideModel iSideModel = (ISideModel)object;
            object = this.getColumnContents(iSideModel, n2);
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
            return defaultTableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        private String getColumnContents(ISideModel iSideModel, int n) {
            String string = null;
            switch (n) {
                case 0: {
                    string = iSideModel.getName();
                    break;
                }
                case 1: {
                    string = this.getPosition(iSideModel.getLineIn());
                    break;
                }
                case 2: {
                    string = this.getPosition(iSideModel.getLineOut());
                    break;
                }
                case 3: {
                    string = SidePane.this.nh.getSideConnectedToNodeName((INodeModel)SidePane.this.nm, iSideModel.getId());
                    break;
                }
            }
            return string;
        }

        private String getPosition(int n) {
            PortModel portModel = null;
            try {
                portModel = (PortModel)SidePane.this.nm.getEntityTableModel().getEntityModelByIndex(n);
                EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
                return entityCellRenderer.getFullPortString(portModel, false);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                return "N/A";
            }
        }

        public int compareColumn(Object object, Object object2, int n) {
            ISideModel iSideModel = (ISideModel)object;
            ISideModel iSideModel2 = (ISideModel)object2;
            String string = this.getColumnContents(iSideModel, n);
            String string2 = this.getColumnContents(iSideModel2, n);
            return string.compareTo(string2);
        }
    }
}

