/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IRouteEntry;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfMaintenancePane;
import cerent.cms.ui.shelf.AbstractShelfTablePane;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;

public class SmpRoutingPane
extends AbstractShelfTablePane
implements ActionListener {
    private static final SDebug db = new SDebug((KDebug)AbstractShelfMaintenancePane.db, "SmpRoutingPane");
    public static final int ROUTE_DESTINATION = 0;
    public static final int ROUTE_MASKLENGTH = 1;
    public static final int ROUTE_GATEWAY = 2;
    public static final int ROUTE_USAGE = 3;
    public static final int ROUTE_IFNAME = 4;
    public static final String MOT_FCC = "motfcc0";
    JButton updateRoutesButton = new JButton("Retrieve");
    JLabel updateRoutesLabel = new JLabel("");

    protected void initButtonPanel() {
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.SmpRoutingPane);
        cSHelpButtonPane.addLeft(this.updateRoutesButton);
        cSHelpButtonPane.addRight(this.updateRoutesLabel);
        this.add(cSHelpButtonPane, "South");
    }

    public void updateRoutes() {
        this.updateRoutesLabel.setText(this.getTimeStampString());
        this.repopulateTable();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.updateRoutesButton) {
            this.updateRoutes();
        }
    }

    public SmpRoutingPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.ENTRY_TYPE = "Routing";
    }

    protected void localInit() {
        this.setLayout(new BorderLayout());
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        this.initButtonPanel();
        this.updateRoutesButton.addActionListener(this);
    }

    protected void initModels() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[]{new DestinationColumnRenderer(), new MaskColumnRenderer(), new GatewayColumnRenderer(), new UsageColumnRenderer(), new IfNameColumnRenderer()};
        RoutingRowSource routingRowSource = new RoutingRowSource();
        this.model = new SortableRowTableModel((RowDataSource)routingRowSource, columnRendererArray);
        this.registerWithModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateTableData() {
        boolean bl = false;
        List list = this.tableData;
        synchronized (list) {
            this.tableData = new ArrayList();
            IRouteEntry[] iRouteEntryArray = this.nodeModel.getRoutingTable();
            boolean bl2 = this.isSecureMode(this.nodeModel);
            boolean bl3 = this.nodeModel.getSecurityLevel() == SecurityLevel.SUPERUSER;
            int n = iRouteEntryArray.length;
            for (int i = 0; i < n; ++i) {
                this.tableData.add(iRouteEntryArray[i]);
            }
        }
    }

    private boolean isSecureMode(NodeModelDelegate nodeModelDelegate) {
        return nodeModelDelegate != null && nodeModelDelegate.getPlatform().isSecureModeSupported() && nodeModelDelegate.isSecureMode();
    }

    class IfNameColumnRenderer
    extends BaseColumnRenderer {
        IfNameColumnRenderer() {
        }

        public String getName() {
            return "Interface";
        }
    }

    class UsageColumnRenderer
    extends BaseColumnRenderer {
        UsageColumnRenderer() {
        }

        public String getName() {
            return "Usage";
        }
    }

    class GatewayColumnRenderer
    extends BaseColumnRenderer {
        GatewayColumnRenderer() {
        }

        public String getName() {
            return "Gateway";
        }
    }

    class MaskColumnRenderer
    extends BaseColumnRenderer {
        MaskColumnRenderer() {
        }

        public String getName() {
            return "Mask";
        }
    }

    class DestinationColumnRenderer
    extends BaseColumnRenderer {
        DestinationColumnRenderer() {
        }

        public String getName() {
            return "Destination";
        }
    }

    abstract class BaseColumnRenderer
    implements ColumnRenderer {
        BaseColumnRenderer() {
        }

        public int getWidth() {
            return 150;
        }

        public boolean isResizable() {
            return true;
        }

        public int getAlignment() {
            return 2;
        }

        protected String getStringValue(IRouteEntry iRouteEntry, int n) {
            String string = "???";
            if (iRouteEntry != null) {
                switch (n) {
                    case 0: {
                        string = InetUtil.makeDottedString(iRouteEntry.getDestAddr());
                        break;
                    }
                    case 1: {
                        short s = iRouteEntry.getMaskLength();
                        string = InetUtil.makeDottedString(InetUtil.makeNetMask(s));
                        break;
                    }
                    case 2: {
                        string = InetUtil.makeDottedString(iRouteEntry.getGateway());
                        break;
                    }
                    case 3: {
                        string = new Long(iRouteEntry.getUsage()).toString();
                        break;
                    }
                    case 4: {
                        string = iRouteEntry.getIfName();
                    }
                }
            }
            return string;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            IRouteEntry iRouteEntry = (IRouteEntry)jTable.getValueAt(n, 0);
            String string = this.getStringValue(iRouteEntry, n2);
            JLabel jLabel = new JLabel(string);
            jLabel.setOpaque(true);
            jLabel.setForeground(Color.black);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(Color.white);
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(Color.black);
            }
            return jLabel;
        }

        public int compareColumn(Object object, Object object2, int n) {
            String string = this.getStringValue((IRouteEntry)object, n);
            String string2 = this.getStringValue((IRouteEntry)object2, n);
            return string.compareTo(string2);
        }
    }

    class RoutingRowSource
    extends AbstractRowDataSource {
        RoutingRowSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObjectAtRow(int n) {
            Object var2_2 = null;
            List list = SmpRoutingPane.this.tableData;
            synchronized (list) {
                var2_2 = SmpRoutingPane.this.tableData.get(n);
            }
            return var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            int n = -1;
            List list = SmpRoutingPane.this.tableData;
            synchronized (list) {
                n = SmpRoutingPane.this.tableData.size();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection getAllObjects() {
            List list = SmpRoutingPane.this.tableData;
            synchronized (list) {
                return SmpRoutingPane.this.tableData;
            }
        }

        public Class getRowObjectClass() {
            return IRouteEntry.class;
        }
    }
}

