/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Synchronization.eBits;
import cerent.cms.idl.Synchronization.eBitsFacility;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractBitsProvPane;
import cerent.cms.ui.shelf.AbstractSppTimingBitsPane;
import cerent.cms.ui.shelf.SonetBitsProvPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SonetSppTimingBitsPane
extends AbstractSppTimingBitsPane {
    public SonetSppTimingBitsPane(String string, TabbedView tabbedView, SynchronizationModel synchronizationModel) {
        super(string, tabbedView, synchronizationModel);
    }

    public AbstractBitsProvPane getBitsProvPane(String string, TabbedView tabbedView, AbstractSppTimingBitsPane abstractSppTimingBitsPane, eBits eBits2) {
        return new SonetBitsProvPane(string, tabbedView, abstractSppTimingBitsPane, eBits2, this.syncModel);
    }

    public JPanel createBitsInTimingBox() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("BITS In"));
        this.facilityIn = new JComboBox<String>(this.bits1.getBitsChoices(0));
        this.facilityIn.addActionListener(this);
        jPanel.add((Component)this.createFacilityType(this.facilityIn), "North");
        this.enableFacilityType(this.facilityIn);
        JPanel jPanel2 = new JPanel(null);
        JPanel jPanel3 = new JPanel(null);
        JPanel jPanel4 = new JPanel(null);
        JPanel jPanel5 = new JPanel(null);
        int n = 2;
        if (this.pci.supportsBits2()) {
            n = 3;
        }
        jPanel2.setLayout(new GridLayout(0, n, 5, 5));
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        jPanel3.setLayout(new GridLayout(0, 1, 5, 5));
        jPanel4.setLayout(new GridLayout(0, 1, 5, 5));
        jPanel5.setLayout(new GridLayout(0, 1, 5, 5));
        jPanel3.add(new JLabel(""));
        jPanel4.add(new JLabel("BITS-1"));
        jPanel3.add(new JLabel("BITS In State: "));
        jPanel4.add(this.bits1.createBitsInState());
        jPanel3.add(new JLabel("Coding: "));
        jPanel4.add(this.bits1.createBitsInCoding());
        jPanel3.add(new JLabel("Framing: "));
        jPanel4.add(this.bits1.createBitsInFraming());
        jPanel3.add(new JLabel("Sync. Messaging: "));
        jPanel4.add(this.bits1.createBitsInSsmToggle());
        if (this.pci.showAdminSSM()) {
            jPanel3.add(new JLabel("Admin. SSM: "));
            jPanel4.add(this.bits1.createBitsInAdminSsm());
        }
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        if (this.pci.supportsBits2()) {
            jPanel5.add(new JLabel("BITS-2"));
            jPanel5.add(this.bits2.createBitsInState());
            jPanel5.add(this.bits2.createBitsInCoding());
            jPanel5.add(this.bits2.createBitsInFraming());
            jPanel5.add(this.bits2.createBitsInSsmToggle());
            if (this.pci.showAdminSSM()) {
                jPanel5.add(this.bits2.createBitsInAdminSsm());
            }
            jPanel2.add(jPanel5);
        }
        jPanel.add(jPanel2);
        return jPanel;
    }

    public JPanel createBitsOutTimingBox() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("BITS Out"));
        this.facilityOut = new JComboBox<String>(this.bits1.getBitsChoices(1));
        this.facilityOut.addActionListener(this);
        jPanel.add((Component)this.createFacilityType(this.facilityOut), "North");
        this.enableFacilityType(this.facilityOut);
        JPanel jPanel2 = new JPanel(null);
        JPanel jPanel3 = new JPanel(null);
        JPanel jPanel4 = new JPanel(null);
        JPanel jPanel5 = new JPanel(null);
        int n = 2;
        if (this.pci.supportsBits2()) {
            n = 3;
        }
        jPanel2.setLayout(new GridLayout(0, n, 5, 5));
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        jPanel3.setLayout(new GridLayout(0, 1, 5, 5));
        jPanel4.setLayout(new GridLayout(0, 1, 5, 5));
        jPanel5.setLayout(new GridLayout(0, 1, 5, 5));
        jPanel3.add(new JLabel(""));
        jPanel4.add(new JLabel("BITS-1"));
        if (this.pci.isBitsOutStateProvisionable()) {
            jPanel3.add(new JLabel("BITS Out State: "));
            jPanel4.add(this.bits1.createBitsOutState());
        }
        jPanel3.add(new JLabel("Coding: "));
        jPanel4.add(this.bits1.createBitsOutCoding());
        jPanel3.add(new JLabel("Framing: "));
        jPanel4.add(this.bits1.createBitsOutFraming());
        if (this.pci.isAISThresholdProvisionable()) {
            jPanel3.add(new JLabel("AIS Threshold: "));
            jPanel4.add(this.bits1.createBitsOutAisTh());
        }
        jPanel3.add(new JLabel("LBO: "));
        jPanel4.add(((SonetBitsProvPane)this.bits1).createBitsOutLBO());
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        if (this.pci.supportsBits2()) {
            jPanel5.add(new JLabel("BITS-2"));
            if (this.pci.isBitsOutStateProvisionable()) {
                jPanel5.add(this.bits2.createBitsOutState());
            }
            jPanel5.add(this.bits2.createBitsOutCoding());
            jPanel5.add(this.bits2.createBitsOutFraming());
            if (this.pci.isAISThresholdProvisionable()) {
                jPanel5.add(this.bits2.createBitsOutAisTh());
            }
            jPanel5.add(((SonetBitsProvPane)this.bits2).createBitsOutLBO());
            jPanel2.add(jPanel5);
        }
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.facilityIn) {
            if (this.isBits64K(0) && !this.supports64KTiming()) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_CONTROLLER_CARD);
                this.facilityIn.setSelectedIndex(0);
                return;
            }
            this.bits1.updateBitsInValues();
            if (this.pci.supportsBits2()) {
                this.bits2.updateBitsInValues();
            }
            if (this.isBits64K(0)) {
                if (!this.facilityOut.isEnabled()) {
                    this.enableComponent(this.facilityOut);
                    ((SonetBitsProvPane)this.bits1).updateBitsOutValues();
                    if (this.pci.supportsBits2()) {
                        ((SonetBitsProvPane)this.bits2).updateBitsOutValues();
                    }
                }
            } else {
                this.facilityOut.setSelectedIndex(this.facilityIn.getSelectedIndex());
                this.facilityOut.setEnabled(false);
            }
        } else if (object == this.facilityOut) {
            if (this.isBits64K(1) && !this.supports64KTiming()) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_CONTROLLER_CARD);
                return;
            }
            ((SonetBitsProvPane)this.bits1).updateBitsOutValues();
            if (this.pci.supportsBits2()) {
                ((SonetBitsProvPane)this.bits2).updateBitsOutValues();
            }
        }
        this.setDirty();
    }

    protected void refreshBitsFacilities() throws Exception {
        super.refreshBitsFacilities();
        if (this.isLineMode()) {
            this.facilityIn.setEnabled(false);
            this.enableFacilityType(this.facilityOut);
        } else if (this.isBits64K(0)) {
            this.enableComponent(this.facilityIn);
            this.enableComponent(this.facilityOut);
        } else {
            this.enableFacilityType(this.facilityIn);
            this.facilityOut.setEnabled(false);
        }
    }

    private void enableFacilityType(JComboBox jComboBox) {
        if (jComboBox.getItemCount() == 1) {
            jComboBox.setEnabled(false);
        } else {
            this.enableComponent(jComboBox);
        }
    }

    public eBitsFacility getFacilityTypeSelection(int n) {
        return n == 0 ? eBitsFacility.BITS_T1 : eBitsFacility.BITS_64K;
    }

    public int getFacilityTypeIndex(eBitsFacility eBitsFacility2) {
        return eBitsFacility2 == eBitsFacility.BITS_T1 ? 0 : 1;
    }

    public boolean isBits64K(int n) {
        return n == 0 && this.getBitsInFacilityType() == 1 || n == 1 && this.getBitsOutFacilityType() == 1;
    }

    public boolean isBits2M(int n) {
        return false;
    }

    public boolean isBitsE1(int n) {
        return false;
    }

    public void destroy() {
        if (this.facilityIn != null) {
            this.facilityIn.removeActionListener(this);
            this.facilityIn = null;
        }
        if (this.facilityOut != null) {
            this.facilityOut.removeActionListener(this);
            this.facilityOut = null;
        }
        super.destroy();
    }

    public boolean isBitsT1(int n) {
        return n == 0 && this.getBitsInFacilityType() == 0 || n == 1 && this.getBitsOutFacilityType() == 0;
    }
}

