/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.ObserverProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.nedefaults.DefaultsController;
import cerent.cms.ui.nedefaults.DefaultsTableCellEditor;
import cerent.cms.ui.nedefaults.DefaultsTreeCellRenderer;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.WID;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeSelectionModel;

public class SppDefaultsEditorPane
extends ObserverProvPane
implements ActionListener,
TreeSelectionListener,
ComponentListener,
KeyListener,
Runnable {
    private static final String PROP_PREF = "ctc.defaults";
    private static final String PROP_DIVIDER = "divider";
    private static final int OPER_RESET = 0;
    private static final int OPER_IMPORT = 1;
    private static final int OPER_EXPORT = 2;
    private boolean inited = false;
    private JButton importButton;
    private JButton exportButton;
    private JButton findButton;
    private JButton findNextButton;
    private JButton findClearButton;
    private JTextField findTF;
    private DefaultsController dfc;
    private TreeSelectionModel tsm;
    private JSplitPane split;
    private JLabel labelSource;
    private JLabel labelDate;
    private String labelText;
    private int operationMode = 0;
    private static final SDebug dbg = new SDebug((KDebug)AbstractShelfProvPane.db, "SppDefaultsEditorPane");

    public SppDefaultsEditorPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        dbg.fine("<SppDefaultsEditorPane>");
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
    }

    public void enteringPage() throws Exception {
        dbg.fine("enteringPage()");
        if (!this.inited) {
            try {
                this.init();
                this.inited = true;
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        dbg.fine("leavingPage()");
        int n = this.split.getDividerLocation() * 100 / (this.split.getWidth() - this.split.getDividerSize()) + 1;
        Preferences.instance().setInt(PROP_PREF, PROP_DIVIDER, n);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    private void init() {
        dbg.fine("init()");
        this.dfc = new DefaultsController(this, (NodeModelDelegate)this.getUiModel().getNodeModel(), dbg);
        this.setDataSourceControl(this.dfc);
        this.split = new JSplitPane(1);
        JTree jTree = new JTree(this.dfc.getTreeModel());
        jTree.setCellRenderer(new DefaultsTreeCellRenderer());
        jTree.setShowsRootHandles(true);
        jTree.setScrollsOnExpand(true);
        jTree.putClientProperty("JTree.lineStyle", "Angled");
        this.tsm = jTree.getSelectionModel();
        this.tsm.setSelectionMode(1);
        this.tsm.addTreeSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(jTree);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Defaults Selector"));
        this.split.setLeftComponent(jScrollPane);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(3));
        jPanel2.add(new JLabel("Look for NE Default:"));
        this.findTF = new JTextField(20);
        jPanel2.add(this.findTF);
        this.findTF.addKeyListener(this);
        this.findButton = new JButton("Find Now");
        jPanel2.add(this.findButton);
        this.findButton.addActionListener(this);
        this.findButton.setEnabled(false);
        this.findNextButton = new JButton("Next");
        jPanel2.add(this.findNextButton);
        this.findNextButton.addActionListener(this);
        this.findNextButton.setEnabled(this.dfc.enableNext());
        this.findClearButton = new JButton("Clear");
        jPanel2.add(this.findClearButton);
        this.findClearButton.addActionListener(this);
        jPanel.add((Component)jPanel2, "North");
        this.table = new UTable((TableModel)((Object)this.dfc.getTableModel()));
        this.dfc.init(this.table);
        jScrollPane = new JScrollPane(this.table);
        jPanel.add((Component)jScrollPane, "Center");
        this.split.setRightComponent(jPanel);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add(this.split);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.labelSource = new JLabel();
        this.labelDate = new JLabel();
        this.labelSource.setHorizontalAlignment(2);
        jPanel4.add(this.labelSource);
        jPanel4.add((Component)this.labelDate, "East");
        Color color = this.getAlphaColor(Color.white, this.labelSource.getBackground(), 0.65f);
        this.labelSource.setBackground(color);
        this.labelDate.setBackground(color);
        this.labelSource.setOpaque(true);
        this.labelDate.setOpaque(true);
        Font font = this.labelSource.getFont();
        float f = font.getSize() + 2;
        font = font.deriveFont(1).deriveFont(f);
        this.labelSource.setFont(font);
        this.labelSource.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 0));
        this.labelDate.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 5));
        jPanel4.add(Box.createVerticalStrut(5), "South");
        jPanel3.add((Component)jPanel4, "North");
        this.add(jPanel3);
        DefaultsTableCellEditor defaultsTableCellEditor = new DefaultsTableCellEditor(this);
        this.table.getColumnModel().getColumn(1).setCellEditor(defaultsTableCellEditor);
        this.split.addComponentListener(this);
    }

    private Color getAlphaColor(Color color, Color color2, float f) {
        float f2 = 1.0f - f;
        int n = (int)((float)color.getRed() * f + (float)color2.getRed() * f2);
        int n2 = (int)((float)color.getGreen() * f + (float)color2.getGreen() * f2);
        int n3 = (int)((float)color.getBlue() * f + (float)color2.getBlue() * f2);
        return new Color(n, n2, n3);
    }

    public TreeSelectionModel getTreeSelectionModel() {
        return this.tsm;
    }

    protected AbstractButton[] getExtraButtons() {
        this.importButton = new JButton("Import...");
        this.importButton.addActionListener(this);
        this.exportButton = new JButton("Export...");
        this.exportButton.addActionListener(this);
        AbstractButton[] abstractButtonArray = new AbstractButton[]{this.importButton, this.exportButton};
        this.enableComponent(this.importButton);
        return abstractButtonArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.importButton) {
            this.operationMode = 1;
            this.stopTableCellEditing();
            this.dfc.importDefaults();
        } else if (object == this.exportButton) {
            this.operationMode = 2;
            this.stopTableCellEditing();
            this.dfc.exportDefaults();
        } else if (object == this.findButton) {
            if (!this.dfc.findDefault(this.findTF.getText())) {
                ErrorMsg.displayWarning((Component)((Object)this), (WID)EMC.WID_NE_DEFAULTS_NOT_FOUND, (Object)this.findTF.getText());
            }
            this.findNextButton.setEnabled(this.dfc.enableNext());
            this.findButton.setEnabled(!this.dfc.enableNext());
        } else if (object == this.findNextButton) {
            if (!this.dfc.findNextDefault(this.findTF.getText())) {
                ErrorMsg.displayWarning((Component)((Object)this), (WID)EMC.WID_NEXT_NE_DEFAULTS_NOT_FOUND, (Object)this.findTF.getText());
            }
        } else if (object == this.findClearButton) {
            this.findTF.setText("");
            this.findButton.setEnabled(false);
            this.findNextButton.setEnabled(false);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.findNextButton.setEnabled(false);
        if (this.findTF.getText().length() <= 0 && (keyEvent.getKeyChar() == '\b' || keyEvent.getKeyChar() == '\u007f')) {
            this.findButton.setEnabled(false);
        } else {
            this.findButton.setEnabled(true);
        }
    }

    protected void applyToModelOk() {
        IgnorableDialog.infoDialog((Component)((Object)this), (String)"Defaults were successfully applied to the node.", (String)"Apply", (String)"defaultsApplyAck", (String)"Acknowledge Successful Defaults Application");
    }

    public void updateLabel(String string) {
        this.setLabel(string);
    }

    public void clearLabel() {
        this.setLabel(null);
    }

    private void setLabel(String string) {
        this.labelText = string;
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    public void enableButtons(boolean bl) {
        if (bl) {
            this.enableComponent(this.importButton);
        } else {
            this.importButton.setEnabled(false);
        }
        this.exportButton.setEnabled(bl);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.getNewLeadSelectionPath() != null) {
            this.stopTableCellEditing();
            this.dfc.setTableContent(treeSelectionEvent.getNewLeadSelectionPath());
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        int n = Preferences.instance().getInt(PROP_PREF, PROP_DIVIDER, 0);
        if (n == 0) {
            this.split.setDividerLocation(-1);
        } else {
            this.split.setDividerLocation((double)n / 100.0);
        }
        this.split.removeComponentListener(this);
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void run() {
        if (this.labelText == null) {
            this.labelSource.setText("Loading Defaults...");
            this.labelDate.setText("");
        } else {
            this.labelSource.setText(this.labelText);
            String string = "Retrieved on ";
            if (this.operationMode == 1) {
                string = "Imported on ";
            } else if (this.operationMode == 2) {
                string = "Exported on ";
            }
            this.labelDate.setText(string + SppDefaultsEditorPane.getFormattedDateTime());
        }
        this.labelSource.revalidate();
        this.labelDate.revalidate();
        this.operationMode = 0;
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SppDefaultsEditorPane;
    }
}

