/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractProvTablePane;
import cerent.cms.ui.AlarmProfileListCellRenderer;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ms.NppMultishelfProvAlarmsTableModel;
import cerent.cms.ui.shelf.ShelfAlarmProfileTableCellRenderer;
import cerent.cms.ui.shelf.ShelfProvAlarmsTableModel;
import cerent.util.SDebug;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class SppProvAlarmsPane
extends AbstractProvTablePane {
    private static SDebug db = new SDebug("SppProvAlarmsPane");
    protected String[] profileNames;
    protected JComboBox profileComboBox = new JComboBox();
    protected JComboBox shelfProfileComboBox = new JComboBox();
    protected JLabel shelfProfileLabel = new JLabel();
    protected JCheckBox shelfSuppressBox = new JCheckBox("");
    protected ShelfProfileItemListener shelfListener;
    protected ShelfProfileItemListener suppressListener;
    protected ShelfComboBoxListener comboBoxListener;
    private boolean inited = false;
    private boolean isShelfProfileEditable = false;

    protected synchronized void initializeCombobox() {
        if (this.dataModel == null || this.table == null || this.profileComboBox == null || this.shelfProfileComboBox == null) {
            db.println("NPE/s in initializeCombobox; the following are null:");
            db.println("\tdataModel? " + (this.dataModel == null) + "\t" + "table? " + (this.dataModel == null));
            db.println("\tprofileCB? " + (this.profileComboBox == null) + "\t" + "shelfProfileCB? " + (this.shelfProfileComboBox == null));
            return;
        }
        this.profileNames = ((ShelfProvAlarmsTableModel)this.dataModel).getProfileNames();
        this.table.editingCanceled(new ChangeEvent(this.table));
        this.profileComboBox.removeAllItems();
        this.removeListeners();
        this.shelfProfileComboBox.removeAllItems();
        for (int i = 0; i < this.profileNames.length; ++i) {
            this.profileComboBox.addItem(this.profileNames[i]);
            if (this.profileNames[i].equals("None") || this.profileNames[i].equals("Inherited")) continue;
            this.shelfProfileComboBox.addItem(this.profileNames[i]);
        }
        AlarmProfileListCellRenderer alarmProfileListCellRenderer = new AlarmProfileListCellRenderer("Node");
        this.profileComboBox.setRenderer(alarmProfileListCellRenderer);
        String string = ((ShelfProvAlarmsTableModel)this.dataModel).getShelfProfileName();
        if (db.on()) {
            db.println("setting selected profile to " + string);
        }
        if (string != null) {
            this.shelfProfileComboBox.setSelectedItem(string);
        }
        this.shelfProfileLabel.setText(string);
        this.updateSuppressFlag();
        this.initializeListeners();
    }

    protected void removeListeners() {
        if (this.shelfListener != null) {
            this.shelfProfileComboBox.removeItemListener(this.shelfListener);
        }
        if (this.suppressListener != null) {
            this.shelfSuppressBox.removeItemListener(this.suppressListener);
        }
    }

    protected void initializeListeners() {
        this.shelfListener = new ShelfProfileItemListener();
        this.suppressListener = new ShelfProfileItemListener();
        this.shelfProfileComboBox.addItemListener(this.shelfListener);
        this.shelfSuppressBox.addItemListener(this.suppressListener);
    }

    public void updateSuppressFlag() {
        Boolean bl = ((ShelfProvAlarmsTableModel)this.dataModel).getShelfSuppressFlag();
        if (db.on()) {
            db.println("updateSuppressFlag: " + bl);
        }
        if (bl != null) {
            this.shelfSuppressBox.setSelected(bl);
        }
    }

    protected Attribute[] getAttributes(String string) {
        return ElementDefaults.getAttributeMap((IModel)this.getUiModel().getNodeModel()).getAttributeArray(string);
    }

    private void initShelfProfileEditor() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
        jPanel.add(new JLabel("Node Profile: "));
        if (this.isShelfProfileEditable) {
            jPanel.add(this.shelfProfileComboBox);
        } else {
            jPanel.add(this.shelfProfileLabel);
        }
        jPanel.add(this.shelfSuppressBox);
        jPanel.add(new JLabel("Suppress Alarms"));
        this.add(jPanel, "South");
    }

    SppProvAlarmsPane(String string, TabbedView tabbedView, IChassisModel iChassisModel) {
        super(string, tabbedView, new ShelfProvAlarmsTableModel(true, iChassisModel), true);
        this.isShelfProfileEditable = !iChassisModel.isMultishelf();
    }

    SppProvAlarmsPane(String string, TabbedView tabbedView, IChassisModel iChassisModel, IChassisModel[] iChassisModelArray) {
        super(string, tabbedView, new NppMultishelfProvAlarmsTableModel(true, iChassisModel, iChassisModelArray), true);
        this.isShelfProfileEditable = true;
    }

    private void init() {
        ((ShelfProvAlarmsTableModel)this.dataModel).init();
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.enableComponent(this.shelfProfileComboBox);
        this.enableComponent(this.shelfSuppressBox);
        this.initializeCombobox();
        for (int i = 0; i < this.dataModel.getColumnCount(); ++i) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(i);
            if (i == 3) {
                tableColumn.setPreferredWidth(120);
                continue;
            }
            if (i != 2) continue;
            ShelfAlarmProfileTableCellRenderer shelfAlarmProfileTableCellRenderer = new ShelfAlarmProfileTableCellRenderer("Node");
            tableColumn.setCellRenderer(shelfAlarmProfileTableCellRenderer);
            tableColumn.setCellEditor(new DefaultCellEditor(this.profileComboBox));
            tableColumn.setPreferredWidth(175);
        }
        this.initShelfProfileEditor();
        this.comboBoxListener = new ShelfComboBoxListener();
        this.dataModel.addTableModelListener(this.comboBoxListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (!this.inited) {
                if (db.on()) {
                    db.println("enteringPage for the first time, calling init");
                }
                this.init();
                this.inited = true;
            }
            super.enteringPage();
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    public void destroy() {
        this.removeListeners();
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this.comboBoxListener);
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SppProvAlarmsPane;
    }

    public void enableComponent(JComponent jComponent) {
        if (!this.isShelfProfileEditable) {
            jComponent.setEnabled(false);
        } else {
            super.enableComponent(jComponent);
        }
    }

    class ShelfProfileItemListener
    implements ItemListener {
        ShelfProfileItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Boolean bl;
            if (db.on()) {
                db.println("ShelfProfileItemListener.itemStateChanged");
            }
            String string = ((ShelfProvAlarmsTableModel)SppProvAlarmsPane.this.dataModel).getShelfProfileName();
            Boolean bl2 = ((ShelfProvAlarmsTableModel)SppProvAlarmsPane.this.dataModel).getShelfSuppressFlag();
            if (itemEvent.getSource() == SppProvAlarmsPane.this.shelfProfileComboBox) {
                String string2 = (String)SppProvAlarmsPane.this.shelfProfileComboBox.getSelectedItem();
                if (string2 != null && !string2.equals(string)) {
                    SppProvAlarmsPane.this.setDirty(true);
                    ((ShelfProvAlarmsTableModel)SppProvAlarmsPane.this.dataModel).triggerShelfProfileChanged(SppProvAlarmsPane.this.shelfProfileComboBox.getSelectedItem());
                }
            } else if (itemEvent.getSource() == SppProvAlarmsPane.this.shelfSuppressBox && !(bl = new Boolean(SppProvAlarmsPane.this.shelfSuppressBox.isSelected())).equals(bl2)) {
                SppProvAlarmsPane.this.setDirty(true);
                ((ShelfProvAlarmsTableModel)SppProvAlarmsPane.this.dataModel).triggerSuppressChanged(bl);
            }
        }
    }

    class ShelfComboBoxListener
    implements TableModelListener {
        ShelfComboBoxListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (db.on()) {
                db.println("ShelfComboBoxListener.tableChanged");
            }
            SppProvAlarmsPane.this.shelfProfileComboBox.setSelectedItem(((ShelfProvAlarmsTableModel)SppProvAlarmsPane.this.dataModel).getShelfProfileName());
            SppProvAlarmsPane.this.initializeCombobox();
        }
    }
}

