/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AlarmModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.IModel;
import cerent.cms.model.InvalidData;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UserDefinedAlarmPane
extends NodeProvPane
implements ActionListener,
ListSelectionListener {
    public static final String ADD = "Add...";
    public static final String DELETE = "Delete...";
    protected static final SDebug db = new SDebug((KDebug)NodeProvPane.db, "UserDefinedAlarmsPane");
    private DefaultListModel alarmListModel;
    public JList alarmList;
    private JButton addButton;
    private JButton deleteButton;
    private boolean isSecure = false;

    public UserDefinedAlarmPane(TabbedView tabbedView) {
        this("User Defined Alarms", tabbedView, (IModel)tabbedView.getUiModel().getNodeModel().getAlarmModel());
    }

    public UserDefinedAlarmPane(String string, TabbedView tabbedView, IModel iModel) {
        super(string, iModel, tabbedView);
        ((Observable)this.uiModel).addObserver((Observer)((Object)this));
        this.registerWithModel();
        this.init();
    }

    private void init() {
        if (db.on()) {
            db.println("<init>: start");
        }
        NodeModelDelegate nodeModelDelegate = this.getNMD();
        this.initComponents();
        if (nodeModelDelegate.getPlatform().isSecureModeSupported()) {
            this.isSecure = nodeModelDelegate.isSecureMode();
        }
        if (db.on()) {
            db.println("<init>: finish");
        }
    }

    public boolean hasSubTabs() {
        return true;
    }

    private void initComponents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("User Defined Alarm Types"));
        JPanel jPanel2 = UserDefinedAlarmPane.createHorizontalPanel(null);
        jPanel2.setLayout(new FlowLayout());
        this.alarmListModel = new DefaultListModel();
        this.alarmList = new JList(this.alarmListModel);
        this.alarmList.setSelectionMode(0);
        this.alarmList.addListSelectionListener(this);
        this.alarmList.setAlignmentX(0.0f);
        UScrollPane uScrollPane = new UScrollPane((Component)this.alarmList);
        uScrollPane.setPreferredSize(new Dimension(250, 100));
        jPanel2.add((Component)uScrollPane);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)this.getButtonBar(), "South");
        this.add(jPanel);
    }

    private JPanel getButtonBar() {
        this.addButton = new JButton(ADD);
        this.deleteButton = new JButton(DELETE);
        JPanel jPanel = UserDefinedAlarmPane.createHorizontalPanel(null);
        this.addButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.deleteButton.setEnabled(false);
        jPanel.setLayout(new FlowLayout(0, 5, 5));
        jPanel.add(this.addButton);
        jPanel.add(this.deleteButton);
        jPanel.add(new CSHelpButton(this.getHelpID()));
        if (!this.isUserAuthorized(SecurityLevel.PROVISIONING)) {
            this.deleteButton.setEnabled(false);
            this.addButton.setEnabled(false);
        }
        return jPanel;
    }

    private void enableDelete(int n) {
        this.deleteButton.setEnabled(n >= 0 && this.isUserAuthorized(SecurityLevel.PROVISIONING));
    }

    private void enableDelete() {
        this.enableDelete(this.alarmList.getSelectedIndex());
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.enableDelete();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block7: {
            Object object = actionEvent.getSource();
            if (object == this.addButton) {
                CreateDialog createDialog = new CreateDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), true, this.parentTV.getUiModel());
                createDialog.setVisible(true);
                createDialog.setModal(true);
                createDialog.setPreferredSize(new Dimension(50, 30));
            } else if (object == this.deleteButton) {
                String string = (String)this.alarmList.getSelectedValue();
                if (CerentDialog.yesNoDialog((Component)((Object)this), (String)("Do you really want to delete \"" + string + "\"?"), (String)"Delete Alarm Type")) {
                    try {
                        this.getDataModel().deleteUserDefEnvAlrm(string);
                    }
                    catch (EMCProvisionError eMCProvisionError) {
                        ErrorMsg.displayError((Component)((Object)this), (EID)eMCProvisionError.getEID());
                    }
                    catch (Exception exception) {
                        if (!db.on()) break block7;
                        db.println("User Defined Alarms Pane::Exception in Add Alarm type");
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() throws Exception {
        String[] stringArray = null;
        try {
            this.setCursor(3);
            if (this.addButton == null && this.deleteButton == null) {
                this.init();
            }
            stringArray = this.getDataModel().getUserdefEnvAlrmList();
            DefaultListModel defaultListModel = this.alarmListModel;
            defaultListModel.clear();
            this.alarmList.setListData(stringArray);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("User Defined Alarms Pane: Exception in Get User Defined Alarm List");
            }
        }
        finally {
            this.setCursor(0);
        }
        super.enteringPage();
    }

    public void refreshFromModel() throws InvalidData {
        NodeModelDelegate nodeModelDelegate = this.getNMD();
        if (nodeModelDelegate == null) {
            if (db.on()) {
                db.println("Node Model is null in User Defined Alarms Pane::refresh()");
            }
            return;
        }
        if (!nodeModelDelegate.getConnectionState()) {
            if (db.on()) {
                db.println("User Defined Alarms Pane::refresh(): node is disconnected");
            }
            return;
        }
        Object[] objectArray = null;
        try {
            objectArray = this.getDataModel().getUserdefEnvAlrmList();
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("User Defined Alarms Pane: Exception in Get User Defined Alarm List");
            }
            objectArray = new Object[]{""};
        }
        if (this.alarmList == null) {
            this.init();
        }
        this.alarmList.setListData(objectArray);
        this.enableDelete();
        this.resetDirty();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.UserDefinedAlarmPane;
    }

    public NodeModelDelegate getNMD() {
        return (NodeModelDelegate)this.getUiModel().getNodeModel();
    }

    public AlarmModel getDataModel() {
        return (AlarmModel)this.getUiModel();
    }

    class CreateDialog
    extends JDialog
    implements ActionListener {
        JButton okButton;
        JButton cancelButton;
        JTextField almTypeVal;

        public CreateDialog(Frame frame, boolean bl, IModel iModel) {
            super(frame, "Add Alarm Type", true);
            this.okButton = null;
            this.cancelButton = null;
            this.almTypeVal = null;
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    CreateDialog.this.dispose();
                }
            });
            JPanel jPanel = AbstractPane.createVerticalPanel(null);
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JPanel jPanel2 = AbstractPane.createHorizontalPanel(null);
            jPanel2.setAlignmentX(0.0f);
            JLabel jLabel = new JLabel("Enter New Alarm Type :");
            jLabel.setAlignmentX(0.0f);
            jLabel.setHorizontalAlignment(2);
            jPanel2.add(jLabel);
            jPanel2.add(Box.createHorizontalStrut(20));
            this.almTypeVal = new JTextField();
            this.almTypeVal.setAlignmentX(0.0f);
            this.almTypeVal.addActionListener(this);
            this.almTypeVal.setPreferredSize(new Dimension(100, 20));
            jPanel2.setAlignmentX(0.0f);
            jPanel2.add(this.almTypeVal);
            jPanel.add(jPanel2);
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)jPanel, "Center");
            JPanel jPanel3 = new JPanel(new FlowLayout());
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(this);
            jPanel3.add(this.okButton);
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(this);
            jPanel3.add(this.cancelButton);
            container.add((Component)jPanel3, "South");
            this.pack();
            this.setLocationRelativeTo(frame);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.okButton) {
                String string = this.almTypeVal.getText();
                if (this.validateAlarmType(string)) {
                    block7: {
                        string = string.toUpperCase();
                        try {
                            UserDefinedAlarmPane.this.getDataModel().addUserDefEnvAlrm(string);
                        }
                        catch (EMCProvisionError eMCProvisionError) {
                            ErrorMsg.displayError((Component)this, (EID)eMCProvisionError.getEID());
                        }
                        catch (Exception exception) {
                            if (!db.on()) break block7;
                            db.println("User Defined Alarms Pane::Exception in Add Alarm type");
                        }
                    }
                    this.almTypeVal.setText("");
                    this.dispose();
                }
            } else if (actionEvent.getSource() == this.cancelButton) {
                this.dispose();
            }
        }

        public boolean validateAlarmType(String string) {
            boolean bl = false;
            if (string.length() > 20) {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_ALM_TYPE_NAME_TOO_LONG);
            } else if (string.length() < 1) {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_ALM_TYPE_NAME_EMPTY);
            } else if (!string.matches("[A-Za-z0-9-]+")) {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_ALM_TYPE_NAME_INVALID);
            } else {
                bl = true;
            }
            return bl;
        }
    }
}

