/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.lmp;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Lmp.eLmpError;
import cerent.cms.idl.Lmp.eMuxCap;
import cerent.cms.idl.Lmp.eTELinkOperationalState;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.LmpConstants;
import cerent.cms.model.LmpCtrlChannelModel;
import cerent.cms.model.LmpCtrlChannelModels;
import cerent.cms.model.LmpException;
import cerent.cms.model.LmpTeLinkModel;
import cerent.cms.model.LmpTeLinkModels;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchDefault;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.shelf.lmp.RemoteNodeIdWrapper;
import cerent.util.ComparisonUtil;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTable;

class TeLinkDataSource
extends AbstractRowDataSource
implements LmpConstants {
    private LmpTeLinkModels _model;
    private ArrayList _data;
    private Observer _observer;
    private SortableRowTableModel _tm;
    private Column[] _columns;
    private HashMap _columnMap;
    private static final SDebug db = new SDebug("TeLinkDataSource");
    private ArrayList _nodeIds = new ArrayList();

    TeLinkDataSource(LmpTeLinkModels lmpTeLinkModels) {
        this._model = lmpTeLinkModels;
        this._data = new ArrayList();
        this._observer = new Observer(){

            public void update(Observable observable, Object object) {
                EventQueue.invokeLater(new Refresher(observable, object));
            }
        };
        this._tm = null;
        this._columns = this.newColumns();
        this._columnMap = new HashMap();
        for (int i = 0; i < this._columns.length; ++i) {
            this._columnMap.put(this._columns[i].getName(), this._columns[i]);
        }
        this.trace("<init>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        ArrayList arrayList = this._data;
        synchronized (arrayList) {
            Iterator iterator = this._data.iterator();
            while (iterator.hasNext()) {
                ((Info)iterator.next()).dispose(this._observer);
            }
            this._data.clear();
        }
        this.trace("dispose");
    }

    private Column[] newColumns() {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        arrayList.add(new Column(){

            public String getName() {
                return "Admin State";
            }

            String getDefaultsPath() {
                return "NODE.lmp.teLink.AdminState";
            }

            String getDefaultValue() {
                return LmpConstants.ADMIN_STATE_DEFAULT;
            }

            Class getColumnClass() {
                return String.class;
            }

            Object getColumnValue(Info info) {
                return info._adminState;
            }

            void setColumnValue(Info info, Object object) {
                info.setAdminState(((AdminState)object).getAdminStateEnum(), TeLinkDataSource.this.getTdmTerminology());
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vAdminState.value(), (int)info2._vAdminState.value());
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "Operational State";
            }

            Class getColumnClass() {
                return String.class;
            }

            Object getColumnValue(Info info) {
                return info._operationalState;
            }

            void setColumnValue(Info info, Object object) {
                info.setOperationalState(TeLinkDataSource.this.getOperationalStateChoice((Attribute)object));
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vOperationalState.value(), (int)info2._vOperationalState.value());
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "Local TE Link Id";
            }

            Class getColumnClass() {
                return Integer.class;
            }

            Object getColumnValue(Info info) {
                return info._localTeLinkId;
            }

            void setColumnValue(Info info, Object object) throws Exception {
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vLocalTeLinkId, (int)info2._vLocalTeLinkId);
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "Remote Node Id";
            }

            Class getColumnClass() {
                return Integer.class;
            }

            Object getColumnValue(Info info) {
                return info._remoteNodeId;
            }

            void setColumnValue(Info info, Object object) throws Exception {
                sIpAddr sIpAddr2 = ((RemoteNodeIdWrapper)object).getRemoteNodeId();
                if (ComparisonUtil.compare((byte[])sIpAddr2.addr, (byte[])IpAddrFactory.getIpAddr((IIpAddr)InetUtil.makeIpAddr((String)"0.0.0.0")).addr) == 0) {
                    throw new Exception("No remote node ID was chosen.");
                }
                info.setRemoteNodeId(sIpAddr2);
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((byte[])info._vRemoteNodeId.addr, (byte[])info2._vRemoteNodeId.addr);
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "Remote TE Link Id";
            }

            Class getColumnClass() {
                return Integer.class;
            }

            Object getColumnValue(Info info) {
                return info._remoteTeLinkId;
            }

            void setColumnValue(Info info, Object object) throws Exception {
                info.setRemoteTeLinkId(this.getLong((String)object, 1L, Integer.MAX_VALUE));
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vRemoteTeLinkId, (int)info2._vRemoteTeLinkId);
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "DWDM?";
            }

            Class getColumnClass() {
                return Boolean.class;
            }

            Object getColumnValue(Info info) {
                return info._dwdm;
            }

            void setColumnValue(Info info, Object object) {
                info.setDwdm((Boolean)object);
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((boolean)info._vDwdm, (boolean)info2._vDwdm);
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "MUX Capability";
            }

            String getDefaultsPath() {
                return "NODE.lmp.teLink.MuxCapability";
            }

            String getDefaultValue() {
                return LmpConstants.MUX_CAPABILITY_DEFAULT;
            }

            Class getColumnClass() {
                return String.class;
            }

            Object getColumnValue(Info info) {
                return info._muxCap;
            }

            void setColumnValue(Info info, Object object) throws Exception {
                info.setMuxCap(TeLinkDataSource.this.getMuxCapChoice((Attribute)object));
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vMuxCap.value(), (int)info2._vMuxCap.value());
            }
        });
        return arrayList.toArray(new Column[arrayList.size()]);
    }

    void setTableModel(SortableRowTableModel sortableRowTableModel) {
        this._tm = sortableRowTableModel;
    }

    TDMTerminology getTdmTerminology() {
        return this._model.getNodeModel().getTDMTerminology();
    }

    boolean isSonet() {
        return AdminState.isANSI(this.getTdmTerminology());
    }

    private String asString(int n, char c, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        long l = (long)n & 0xFFFFFFFFL;
        stringBuffer.append(Long.toHexString(l));
        while (stringBuffer.length() < n2) {
            stringBuffer.insert(0, c);
        }
        stringBuffer.insert(0, "0x");
        return stringBuffer.toString();
    }

    private String asString(sIpAddr sIpAddr2) {
        return InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(sIpAddr2));
    }

    AdminState[] getAdminStateChoices() {
        AdminState[] adminStateArray = this.isSonet() ? new AdminState[]{AdminState.OOS_DSBLD, AdminState.IS} : new AdminState[]{AdminState.OOS_DSBLD_ETSI, AdminState.IS_ETSI};
        return adminStateArray;
    }

    AdminState getAdminStateChoice(eAdminState eAdminState2) {
        return AdminState.enumToAdminState(eAdminState2, this.isSonet());
    }

    AdminState getAdminStateChoice(int n) {
        return this.getAdminStateChoice(eAdminState.from_int(n));
    }

    AdminState getAdminStateChoice(Info info) {
        return this.getAdminStateChoice(info.getAdminState());
    }

    AdminState getAdminStateChoice(String string) {
        return this.getAdminStateChoice(Integer.parseInt(string));
    }

    Attribute[] getOperationalStateChoices() {
        return ElementDefaults.getAttributeMap(this._model).getAttributeArray("LMP-TE-Link-Operational-State");
    }

    Attribute getOperationalStateChoice(eTELinkOperationalState eTELinkOperationalState2) {
        Attribute[] attributeArray = this.getOperationalStateChoices();
        int n = eTELinkOperationalState2.value();
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i].getIntValue() != n) continue;
            return attributeArray[i];
        }
        return null;
    }

    Attribute getOperationalStateChoice(Info info) {
        return this.getOperationalStateChoice(info.getOperationalState());
    }

    eTELinkOperationalState getOperationalStateChoice(Attribute attribute) {
        return eTELinkOperationalState.from_int(attribute.getIntValue());
    }

    private LmpCtrlChannelModels getCtrlChannelModels() {
        return LmpCtrlChannelModels.getInstance((NodeModelDelegate)this._model.getNodeModel());
    }

    RemoteNodeIdWrapper[] getFilteredRemoteNodeIdChoices(Info info) throws LmpException {
        this._nodeIds.clear();
        HashSet<RemoteNodeIdWrapper> hashSet = new HashSet<RemoteNodeIdWrapper>();
        HashSet<RemoteNodeIdWrapper> hashSet2 = new HashSet<RemoteNodeIdWrapper>();
        HashSet<RemoteNodeIdWrapper> hashSet3 = null;
        LmpCtrlChannelModel[] lmpCtrlChannelModelArray = this.getCtrlChannelModels().getCtrlChannels();
        for (int i = 0; i < lmpCtrlChannelModelArray.length; ++i) {
            if (IpAddrFactory.getIIpAddr(lmpCtrlChannelModelArray[i].getRemoteNodeId()).compareTo((Object)IpAddrFactory.getIIpAddr(info.getRemoteNodeId())) == 0) {
                HashSet<RemoteNodeIdWrapper> hashSet4 = hashSet3 = lmpCtrlChannelModelArray[i].isRemoteCrs() ? hashSet : hashSet2;
            }
            if (lmpCtrlChannelModelArray[i].isRemoteCrs()) {
                hashSet.add(new RemoteNodeIdWrapper(lmpCtrlChannelModelArray[i]));
                continue;
            }
            hashSet2.add(new RemoteNodeIdWrapper(lmpCtrlChannelModelArray[i]));
        }
        this._nodeIds.addAll(hashSet3);
        Collections.sort(this._nodeIds);
        return this._nodeIds.toArray(new RemoteNodeIdWrapper[this._nodeIds.size()]);
    }

    RemoteNodeIdWrapper[] getRemoteNodeIdChoices() throws LmpException {
        this._nodeIds.clear();
        this._nodeIds.add(new RemoteNodeIdWrapper());
        HashSet<RemoteNodeIdWrapper> hashSet = new HashSet<RemoteNodeIdWrapper>();
        LmpCtrlChannelModel[] lmpCtrlChannelModelArray = this.getCtrlChannelModels().getCtrlChannels();
        for (int i = 0; i < lmpCtrlChannelModelArray.length; ++i) {
            hashSet.add(new RemoteNodeIdWrapper(lmpCtrlChannelModelArray[i]));
        }
        this._nodeIds.addAll(hashSet);
        Collections.sort(this._nodeIds);
        return this._nodeIds.toArray(new RemoteNodeIdWrapper[this._nodeIds.size()]);
    }

    RemoteNodeIdWrapper getRemoteNodeIdChoice(sIpAddr sIpAddr2) {
        for (RemoteNodeIdWrapper remoteNodeIdWrapper : this._nodeIds) {
            if (ComparisonUtil.compare((byte[])remoteNodeIdWrapper.getRemoteNodeId().addr, (byte[])sIpAddr2.addr) != 0) continue;
            return remoteNodeIdWrapper;
        }
        return null;
    }

    RemoteNodeIdWrapper getRemoteNodeIdChoice(Info info) {
        return this.getRemoteNodeIdChoice(info.getRemoteNodeId());
    }

    Attribute[] getMuxCapChoices() {
        return ElementDefaults.getAttributeMap(this._model).getAttributeArray("LMP-MUX-Capability");
    }

    Attribute[] getCrsMuxCapChoices() {
        Attribute[] attributeArray = this.getMuxCapChoices();
        Attribute[] attributeArray2 = new Attribute[1];
        for (Attribute attribute : attributeArray) {
            eMuxCap eMuxCap2 = this.getMuxCapChoice(attribute);
            if (eMuxCap2 != eMuxCap.MUX_CAP_FIBER_SWCH) continue;
            attributeArray2[0] = attribute;
            break;
        }
        return attributeArray2;
    }

    Attribute getMuxCapChoice(int n) {
        Attribute[] attributeArray = this.getMuxCapChoices();
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i].getIntValue() != n) continue;
            return attributeArray[i];
        }
        return null;
    }

    Attribute getMuxCapChoice(eMuxCap eMuxCap2) {
        return this.getMuxCapChoice(eMuxCap2.value());
    }

    Attribute getMuxCapChoice(Info info) {
        return this.getMuxCapChoice(info.getMuxCap());
    }

    Attribute getMuxCapChoice(String string) {
        return this.getMuxCapChoice(Integer.parseInt(string));
    }

    eMuxCap getMuxCapChoice(Attribute attribute) {
        return eMuxCap.from_int(attribute.getIntValue());
    }

    boolean getDwdmChoice(String string) {
        return string.equals("1");
    }

    String getDefaultValue(String string) {
        Column column = this.getColumn(string);
        String string2 = column.getDefaultValue();
        try {
            String string3 = column.getDefaultsPath();
            String string4 = null;
            if (string3 != null) {
                string4 = this._model.getNodeModel().getDefaultValue(string3);
            }
            if (string4 != null && !string4.equals("UNKNOWN")) {
                string2 = string4;
            }
        }
        catch (NoSuchDefault noSuchDefault) {
            db.println("Cannot find default for " + string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Info find(ArrayList arrayList, int n) {
        ArrayList arrayList2 = arrayList;
        synchronized (arrayList2) {
            for (Info info : arrayList) {
                if (info.getLocalTeLinkId() != n) continue;
                return info;
            }
        }
        return null;
    }

    private static boolean isInvalidIndex(LmpException lmpException) {
        return eLmpError.INVALID_TE_LINK_INDEX.equals(lmpException.getLmpError());
    }

    void refreshFromModel() {
        block7: {
            this.trace("refreshFromModel");
            try {
                ArrayList<LmpException> arrayList = new ArrayList<LmpException>();
                LmpTeLinkModel[] lmpTeLinkModelArray = this._model.getTeLinks();
                ArrayList<Info> arrayList2 = new ArrayList<Info>(lmpTeLinkModelArray.length);
                for (int i = 0; i < lmpTeLinkModelArray.length; ++i) {
                    try {
                        Info info = this.find(this._data, lmpTeLinkModelArray[i].getIndex());
                        if (info == null) {
                            info = new Info(lmpTeLinkModelArray[i]);
                        }
                        arrayList2.add(info);
                        continue;
                    }
                    catch (LmpException lmpException) {
                        if (TeLinkDataSource.isInvalidIndex(lmpException)) continue;
                        arrayList.add(lmpException);
                    }
                }
                EventQueue.invokeLater(new Refresher(arrayList2));
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ErrorMsg.displayError(null, (EID)((LmpException)((Object)iterator.next())).getEid());
                }
            }
            catch (Exception exception) {
                db.println("exception: " + exception);
                if (!db.on()) break block7;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    ColumnRenderer[] getRenderers() {
        return this._columns;
    }

    Column getColumn(String string) {
        return (Column)this._columnMap.get(string);
    }

    String getColumnName(int n) {
        return this._columns[n].getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectAtRow(int n) {
        ArrayList arrayList = this._data;
        synchronized (arrayList) {
            return this._data.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        ArrayList arrayList = this._data;
        synchronized (arrayList) {
            return this._data.size();
        }
    }

    public Class getRowObjectClass() {
        return Info.class;
    }

    void println(String string) {
        db.println(string);
    }

    private void trace(String string) {
        if (db.on()) {
            db.println(string + "(" + this._model.getNodeModel().getHostName() + ")");
        }
    }

    abstract class Column
    implements ColumnRenderer {
        Column() {
        }

        public abstract String getName();

        String getDefaultsPath() {
            return null;
        }

        String getDefaultValue() {
            return null;
        }

        abstract Class getColumnClass();

        abstract Object getColumnValue(Info var1);

        abstract void setColumnValue(Info var1, Object var2) throws Exception;

        abstract int cmpValue(Info var1, Info var2);

        public int getWidth() {
            return 96;
        }

        public int getAlignment() {
            return 2;
        }

        public boolean isResizable() {
            return true;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return jTable.getDefaultRenderer(this.getColumnClass()).getTableCellRendererComponent(jTable, this.getColumnValue((Info)object), bl, bl2, n, n2);
        }

        public int compareColumn(Object object, Object object2, int n) {
            if (object instanceof Info) {
                if (object2 instanceof Info) {
                    return this.cmpValue((Info)object, (Info)object2);
                }
                return -1;
            }
            return 1;
        }

        int rangeCheck(long l, long l2, long l3) throws Exception {
            if (l2 <= l3 && (l < l2 || l > l3)) {
                throw new Exception("The value (" + l + ") must be between " + l2 + " and " + l3 + ".");
            }
            return (int)l;
        }

        int getLong(String string) throws Exception {
            return this.getLong(string, 0L, 0xFFFFFFFFL);
        }

        int getLong(String string, long l, long l2) throws Exception {
            return this.rangeCheck(Long.decode(string.trim()), l, l2);
        }
    }

    private class Refresher
    implements Runnable {
        private ArrayList _newModels;
        private ArrayList _oldModels;
        private ArrayList _updModels;

        Refresher(ArrayList arrayList) {
            this._newModels = arrayList;
            this._oldModels = null;
            this._updModels = null;
        }

        Refresher(Object object, Object object2) {
            this._newModels = null;
            if (ModelUpdateType.DELETED.equals(object2)) {
                this._oldModels = new ArrayList();
                this._oldModels.add(object);
                this._updModels = null;
            } else {
                this._oldModels = null;
                this._updModels = new ArrayList();
                this._updModels.add(object);
            }
        }

        private int findAndRemove(ArrayList arrayList, Info info) {
            int n = arrayList.indexOf(info);
            if (n != -1) {
                arrayList.remove(n);
            }
            return n;
        }

        private void removeOldModels(ArrayList arrayList, ArrayList arrayList2) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n = TeLinkDataSource.this._data.indexOf((Info)iterator.next());
                if (n == -1) continue;
                arrayList2.add(new Integer(n));
            }
            for (Info info : arrayList) {
                int n = this.findAndRemove(TeLinkDataSource.this._data, info);
                if (n == -1) continue;
                info.dispose(TeLinkDataSource.this._observer);
            }
        }

        private void notifyDeletedRows(ArrayList arrayList) {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((Integer)object2).compareTo((Integer)object);
                }
            });
            int n = -1;
            int n2 = -1;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (n2 == -1) {
                    n = n2 = ((Integer)iterator.next()).intValue();
                    continue;
                }
                int n3 = (Integer)iterator.next();
                if (n3 == n - 1) {
                    n = n3;
                    continue;
                }
                TeLinkDataSource.this._tm.rowsDeleted(n, n2);
                n = n2 = n3;
            }
            if (n2 != -1) {
                TeLinkDataSource.this._tm.rowsDeleted(n, n2);
            }
        }

        private void findUpdModels(ArrayList arrayList, ArrayList arrayList2) {
            for (Info info : arrayList) {
                int n = TeLinkDataSource.this._data.indexOf(info);
                if (n == -1) continue;
                arrayList2.add(new Integer(n));
            }
        }

        private void notifyUpdatedRows(ArrayList arrayList) {
            int n = -1;
            int n2 = -1;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (n == -1) {
                    n = n2 = ((Integer)iterator.next()).intValue();
                    continue;
                }
                int n3 = (Integer)iterator.next();
                if (n3 == n2 + 1) {
                    n2 = n3;
                    continue;
                }
                TeLinkDataSource.this._tm.rowsUpdated(n, n2);
                n = n2 = n3;
            }
            if (n != -1) {
                TeLinkDataSource.this._tm.rowsUpdated(n, n2);
            }
        }

        private void addNewModels(ArrayList arrayList) {
            for (Info info : arrayList) {
                info.init(TeLinkDataSource.this._observer);
                TeLinkDataSource.this._data.add(info);
            }
        }

        private void notifyAddedRows(int n, int n2) {
            if (n2 >= n) {
                TeLinkDataSource.this._tm.rowsAdded(n, n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList arrayList = TeLinkDataSource.this._data;
            synchronized (arrayList) {
                ArrayList arrayList2;
                ArrayList<Info> arrayList3 = new ArrayList<Info>();
                ArrayList arrayList4 = new ArrayList();
                if (this._newModels != null && !this._newModels.isEmpty()) {
                    arrayList4.addAll(TeLinkDataSource.this._data);
                    for (Info info : this._newModels) {
                        if (this.findAndRemove(arrayList4, info) != -1) continue;
                        arrayList3.add(info);
                    }
                }
                if (this._oldModels != null) {
                    this._oldModels.addAll(arrayList4);
                } else {
                    this._oldModels = arrayList4;
                }
                if (this._oldModels != null && !this._oldModels.isEmpty()) {
                    arrayList2 = new ArrayList();
                    this.removeOldModels(this._oldModels, arrayList2);
                    this.notifyDeletedRows(arrayList2);
                }
                if (this._updModels != null && !this._updModels.isEmpty()) {
                    arrayList2 = new ArrayList();
                    this.findUpdModels(this._updModels, arrayList2);
                    this.notifyUpdatedRows(arrayList2);
                }
                if (arrayList3 != null && !arrayList3.isEmpty()) {
                    int n = TeLinkDataSource.this._data.size();
                    this.addNewModels(arrayList3);
                    this.notifyAddedRows(n, TeLinkDataSource.this._data.size() - 1);
                }
            }
            this._updModels = null;
            this._oldModels = null;
            this._newModels = null;
        }
    }

    class Info
    extends Observable
    implements Comparable,
    Observer {
        LmpTeLinkModel _vModel;
        eAdminState _vAdminState;
        eTELinkOperationalState _vOperationalState;
        int _vLocalTeLinkId;
        sIpAddr _vRemoteNodeId;
        int _vRemoteTeLinkId;
        boolean _vDwdm;
        eMuxCap _vMuxCap;
        String _adminState;
        String _operationalState;
        String _localTeLinkId;
        String _remoteNodeId;
        String _remoteTeLinkId;
        Boolean _dwdm;
        String _muxCap;

        Info() {
            this.setLocalTeLinkId(0);
        }

        Info(Info info) {
            this._vModel = info._vModel;
            this._vAdminState = info._vAdminState;
            this._vOperationalState = info._vOperationalState;
            this._vLocalTeLinkId = info._vLocalTeLinkId;
            this._vRemoteNodeId = this.duplicate(info._vRemoteNodeId);
            this._vRemoteTeLinkId = info._vRemoteTeLinkId;
            this._vDwdm = info._vDwdm;
            this._vMuxCap = info._vMuxCap;
            this._adminState = info._adminState;
            this._operationalState = info._operationalState;
            this._localTeLinkId = info._localTeLinkId;
            this._remoteNodeId = info._remoteNodeId;
            this._remoteTeLinkId = info._remoteTeLinkId;
            this._dwdm = info._dwdm;
            this._muxCap = info._muxCap;
        }

        private sIpAddr duplicate(sIpAddr sIpAddr2) {
            sIpAddr sIpAddr3 = null;
            if (sIpAddr2 != null) {
                sIpAddr3 = new sIpAddr();
                if (sIpAddr2.addr != null) {
                    sIpAddr3.addr = new byte[sIpAddr2.addr.length];
                    System.arraycopy(sIpAddr2.addr, 0, sIpAddr3.addr, 0, sIpAddr2.addr.length);
                }
            }
            return sIpAddr3;
        }

        Info(LmpTeLinkModel lmpTeLinkModel) throws LmpException {
            this._vModel = lmpTeLinkModel;
            this.refresh();
        }

        private void refresh() throws LmpException {
            this.setLocalTeLinkId(this._vModel.getLocalTeLinkId());
            TeLinkDataSource.this.trace("refresh-" + this);
            this.setAdminState(this._vModel.getAdminState(), this._vModel.getNodeModel().getTDMTerminology());
            this.setOperationalState(this._vModel.getOperationalState());
            this.setRemoteNodeId(this._vModel.getRemoteNodeId());
            this.setRemoteTeLinkId(this._vModel.getRemoteTeLinkId());
            this.setDwdm(this._vModel.getDwdm());
            this.setMuxCap(this._vModel.getMuxCap());
        }

        public void update(Observable observable, Object object) {
            if (ModelUpdateType.CHANGED.equals(object)) {
                TeLinkDataSource.this.trace("changed-" + this);
                try {
                    this.refresh();
                    this.setChanged();
                    this.notifyObservers(object);
                }
                catch (LmpException lmpException) {
                    if (!TeLinkDataSource.isInvalidIndex(lmpException)) {
                        ErrorMsg.displayError(null, (EID)lmpException.getEid());
                    }
                }
            } else if (ModelUpdateType.DELETED.equals(object)) {
                TeLinkDataSource.this.trace("deleted-" + this);
                this.setChanged();
                this.notifyObservers(object);
            } else {
                TeLinkDataSource.this.trace("update-" + object + "-" + this);
            }
        }

        void init(Observer observer) {
            TeLinkDataSource.this.trace("init-" + this);
            if (this._vModel != null) {
                this._vModel.addObserver(this);
            }
            this.addObserver(observer);
        }

        void dispose(Observer observer) {
            TeLinkDataSource.this.trace("dispose-" + this);
            this.deleteObserver(observer);
            if (this._vModel != null) {
                this._vModel.deleteObserver(this);
            }
        }

        LmpTeLinkModel getModel() {
            return this._vModel;
        }

        void setAdminState(eAdminState eAdminState2, TDMTerminology tDMTerminology) {
            this._vAdminState = eAdminState2;
            this._adminState = AdminState.enumAdminStateToStr(this._vAdminState, tDMTerminology);
        }

        eAdminState getAdminState() {
            return this._vAdminState;
        }

        void setOperationalState(eTELinkOperationalState eTELinkOperationalState2) {
            this._vOperationalState = eTELinkOperationalState2;
            this._operationalState = TeLinkDataSource.this.getOperationalStateChoice(this._vOperationalState).toString();
        }

        eTELinkOperationalState getOperationalState() {
            return this._vOperationalState;
        }

        void setLocalTeLinkId(int n) {
            this._vLocalTeLinkId = n;
            this._localTeLinkId = this._vLocalTeLinkId == 0 ? "None" : TeLinkDataSource.this.asString(this._vLocalTeLinkId, '0', 8);
        }

        int getLocalTeLinkId() {
            return this._vLocalTeLinkId;
        }

        void setRemoteNodeId(sIpAddr sIpAddr2) {
            this._vRemoteNodeId = sIpAddr2;
            this._remoteNodeId = TeLinkDataSource.this.asString(this._vRemoteNodeId);
        }

        sIpAddr getRemoteNodeId() {
            return this._vRemoteNodeId;
        }

        void setRemoteTeLinkId(int n) {
            this._vRemoteTeLinkId = n;
            this._remoteTeLinkId = TeLinkDataSource.this.asString(this._vRemoteTeLinkId, '0', 8);
        }

        int getRemoteTeLinkId() {
            return this._vRemoteTeLinkId;
        }

        void setDwdm(boolean bl) {
            this._vDwdm = bl;
            this._dwdm = this._vDwdm;
        }

        boolean getDwdm() {
            return this._vDwdm;
        }

        void setMuxCap(eMuxCap eMuxCap2) {
            this._vMuxCap = eMuxCap2;
            this._muxCap = TeLinkDataSource.this.getMuxCapChoice(this._vMuxCap).toString();
        }

        eMuxCap getMuxCap() {
            return this._vMuxCap;
        }

        public String toString() {
            return this._localTeLinkId;
        }

        public int compareTo(Object object) {
            return TeLinkDataSource.this.getColumn("Local TE Link Id").cmpValue(this, (Info)object);
        }

        public int hashCode() {
            return this._vLocalTeLinkId;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof Info) {
                bl = this._vLocalTeLinkId == ((Info)object)._vLocalTeLinkId;
            }
            return bl;
        }
    }
}

