/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.sdh;

import cerent.cms.idl.Common.sRevertiveBehavior;
import cerent.cms.idl.Synchronization.eBits;
import cerent.cms.idl.Synchronization.eBitsFacility;
import cerent.cms.idl.Synchronization.eRef;
import cerent.cms.idl.Synchronization.eResQualityLevel;
import cerent.cms.idl.Synchronization.eSsmGen;
import cerent.cms.idl.Synchronization.eTimingMode;
import cerent.cms.idl.Synchronization.sBitsConfig;
import cerent.cms.idl.Synchronization.sSyncConfig;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.RevertiveBehaviorFactory;
import cerent.cms.model.SyncProvBusy;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.ui.RevertiveBehaviorPanel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractSppTimingPane;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class SdhSppTimingPane
extends AbstractSppTimingPane
implements ActionListener {
    JPanel ssmAttrBox;

    public SdhSppTimingPane(String string, TabbedView tabbedView, SynchronizationModel synchronizationModel, ElementModelsDelegate elementModelsDelegate) {
        super(string, tabbedView, synchronizationModel, elementModelsDelegate);
    }

    protected void init() {
        this.neRef = new AbstractSppTimingPane.SyncRefs(eRef.NE);
        super.init();
    }

    public void refreshFromModel() throws Exception {
        block6: {
            if (db.on()) {
                db.println("enter refreshFromModel");
            }
            sSyncConfig sSyncConfig2 = new sSyncConfig();
            sSyncConfig2 = this.syncModel.getConfig();
            if (db.on()) {
                db.println("config.timingMode = " + sSyncConfig2.timingMode.value() + "\n" + "config.reversion.reversionMode = " + sSyncConfig2.reversion.reversionMode.value() + "\n" + "config.reversion.reversionTime = " + sSyncConfig2.reversion.reversionTime + "\n" + "config.ssmGeneration = " + sSyncConfig2.ssmGeneration.value() + "\n" + "config.interpretResAs = " + sSyncConfig2.interpretResAs.value());
            }
            this.modeCB.setSelectedItem(this.timingModeAttributeMap.get(new Integer(sSyncConfig2.timingMode.value())));
            this.syncRBP.setRevertiveBehavior(RevertiveBehaviorFactory.getIRevertiveBehavior(sSyncConfig2.reversion));
            try {
                if (this.pci.is600SDH()) {
                    sBitsConfig sBitsConfig2 = new sBitsConfig();
                    sBitsConfig2 = this.syncModel.getBitsConfig(eBits.BITS_1);
                    this.updateFromConfig(sSyncConfig2, sBitsConfig2);
                }
                this.neRef.refreshFromModel();
                this.ext1Ref.refreshFromModel();
                this.ext2Ref.refreshFromModel();
            }
            catch (NullPointerException nullPointerException) {
                if (!db.on()) break block6;
                db.println("Caught exception when refresh timing reference");
            }
        }
        if (db.on()) {
            db.println("leave refreshFromModel");
        }
    }

    public JPanel createGeneralTimingBox() {
        JPanel jPanel = SdhSppTimingPane.createVerticalPanel("General Timing");
        JPanel jPanel2 = new JPanel(null);
        jPanel2.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel2.add(new JLabel("Timing Mode: "));
        Attribute[] attributeArray = this.timingModeAttributeMap.values().toArray(new Attribute[0]);
        this.modeCB = new JComboBox<Attribute>(attributeArray);
        jPanel2.add(this.modeCB);
        this.modeCB.setName("Mode");
        this.enableComponent(this.modeCB);
        this.modeCB.addActionListener(this);
        jPanel.add(jPanel2);
        if (this.pci.is600SDH()) {
            this.ssmAttrBox = new JPanel();
            this.ssmAttrBox.setLayout(new GridLayout(0, 2, 5, 5));
            this.ssmAttrBox.add(new JLabel("SSM Message Set: "));
            this.generationCB = new JComboBox<String>(generationChoices);
            this.ssmAttrBox.add(this.generationCB);
            this.generationCB.setName("Generation");
            this.enableComponent(this.generationCB);
            this.generationCB.addActionListener(this);
            this.ssmAttrBox.add(new JLabel("Quality of RES: "));
            this.resAsCB = new JComboBox<String>(g1ResAsChoices);
            this.ssmAttrBox.add(this.resAsCB);
            this.resAsCB.setName("RES");
            this.enableComponent(this.resAsCB);
            this.resAsCB.addActionListener(this);
            jPanel.add(this.ssmAttrBox);
            this.syncRBP = new RevertiveBehaviorPanel(this, true);
            jPanel.add(this.syncRBP);
        } else {
            this.syncRBP = new RevertiveBehaviorPanel(this);
            jPanel.add(this.syncRBP);
        }
        this.enableComponent(this.syncRBP);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.modeCB) {
            this.timingMode = eTimingMode.from_int(((Attribute)this.modeCB.getSelectedItem()).getIntValue());
            try {
                this.neRef.updateRefCBs();
                this.ext1Ref.updateRefCBs();
                this.ext2Ref.updateRefCBs();
            }
            catch (NullPointerException nullPointerException) {
                if (db.on()) {
                    db.println("Caught exception when update timing reference");
                }
            }
        } else if (object == this.generationCB) {
            if (this.generationCB.getSelectedIndex() == 0) {
                generation = 1;
                this.resAsCB.removeAllItems();
                for (int i = 0; i < g1ResAsChoices.length; ++i) {
                    this.resAsCB.addItem(g1ResAsChoices[i]);
                }
                this.resAsCB.setSelectedIndex(g1ResAsChoices.length - 1);
            } else {
                generation = 2;
                this.resAsCB.removeAllItems();
                for (int i = 0; i < g2ResAsChoices.length; ++i) {
                    this.resAsCB.addItem(g2ResAsChoices[i]);
                }
                this.resAsCB.setSelectedIndex(g2ResAsChoices.length - 1);
            }
        }
        this.setDirty();
    }

    public void applyChangesToModel() throws Exception {
        if (db.on()) {
            db.println("enter applyChangesToModel");
        }
        sSyncConfig sSyncConfig2 = new sSyncConfig();
        sSyncConfig sSyncConfig3 = new sSyncConfig();
        sSyncConfig2.timingMode = this.timingMode;
        if (sSyncConfig2.reversion == null) {
            sSyncConfig2.reversion = new sRevertiveBehavior();
        }
        sSyncConfig3 = this.syncModel.getConfig();
        if (sSyncConfig3.reversion.reversionTime == 0 && this.syncRBP.getRevertiveBehavior().getReversionTime() != 0 && !this.syncRBP.RevertiveDialog()) {
            throw new Exception("The apply operation was canceled by the user.");
        }
        sSyncConfig2.reversion = RevertiveBehaviorFactory.getRevertiveBehavior(this.syncRBP.getRevertiveBehavior());
        if (this.pci.is600SDH()) {
            int n = this.resAsCB.getSelectedIndex();
            if (this.generationCB.getSelectedIndex() == 0) {
                generation = 1;
                sSyncConfig2.ssmGeneration = eSsmGen.GENERATION_1;
                sSyncConfig2.interpretResAs = eResQualityLevel.sameAsDUS_SDH;
            } else {
                generation = 2;
                sSyncConfig2.ssmGeneration = eSsmGen.GENERATION_2;
                sSyncConfig2.interpretResAs = eResQualityLevel.sameAsDUS_SDH;
            }
        } else {
            generation = 1;
            sSyncConfig2.ssmGeneration = eSsmGen.GENERATION_1;
            sSyncConfig2.interpretResAs = eResQualityLevel.aboveG811;
        }
        if (db.on()) {
            db.println("config.timingMode = " + sSyncConfig2.timingMode.value() + "\n" + "config.reversion.reversionMode = " + sSyncConfig2.reversion.reversionMode.value() + "\n" + "config.reversion.reversionTime = " + sSyncConfig2.reversion.reversionTime + "\n" + "config.ssmGeneration = " + sSyncConfig2.ssmGeneration.value() + "\n" + "config.interpretResAs = " + sSyncConfig2.interpretResAs.value());
        }
        try {
            this.syncModel.setConfig(sSyncConfig2);
            this.neRef.setRefSources();
            this.ext1Ref.setRefSources();
            this.ext2Ref.setRefSources();
        }
        catch (SyncProvBusy syncProvBusy) {
            this.displayErrorDialog();
        }
        if (db.on()) {
            db.println("leave applyChangesToModel");
        }
    }

    private void updateFromConfig(sSyncConfig sSyncConfig2, sBitsConfig sBitsConfig2) {
        if (sBitsConfig2.facilityType == eBitsFacility.BITS_T1) {
            this.generationCB.setEnabled(true);
            this.resAsCB.setEnabled(false);
            this.ssmAttrBox.setVisible(true);
        } else {
            this.generationCB.setSelectedIndex(1);
            this.ssmAttrBox.setVisible(false);
        }
        if (this.generationCB != null) {
            int n = eResQualityLevel.sameAsDUS.value();
            if (sSyncConfig2.ssmGeneration == eSsmGen.GENERATION_1) {
                this.generationCB.setSelectedIndex(0);
                generation = 1;
                this.resAsCB.setSelectedIndex(n - 2);
            } else {
                this.generationCB.setSelectedIndex(1);
                generation = 2;
                this.resAsCB.setSelectedIndex(n);
            }
        }
    }
}

