/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.snmp;

import cerent.cms.idl.Node.sSnmpOID;
import cerent.cms.idl.Node.sSnmpV3NotifyFilter;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SnmpModel;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfEditTablePane;
import cerent.cms.ui.shelf.snmp.NotifyFilterCreateDialog;
import cerent.cms.ui.shelf.snmp.SnmpV3Util;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.WindowHelper;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;

public class NotifyFilterPane
extends AbstractShelfEditTablePane {
    public static final int PROFILE_NAME_IDX = 0;
    public static final int TREE_OID_IDX = 1;
    public static final int MASK_IDX = 2;
    public static final int FILTER_TYPE_IDX = 3;
    SnmpModel snmpModel = this.getSnmpModel();

    public NotifyFilterPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
    }

    protected void localInit() {
        super.localInit();
        ListSelectionModel listSelectionModel = this.getTable().getSelectionModel();
        listSelectionModel.setSelectionMode(2);
    }

    protected void initModels() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[]{new FilterProfileNameColumnRenderer(), new SubTreeOIDColumnRenderer(), new MaskColumnRenderer(), new TypeColumnRenderer()};
        UserTableRowSource userTableRowSource = new UserTableRowSource();
        this.model = new SortableRowTableModel((RowDataSource)userTableRowSource, columnRendererArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        super.actionPerformed(actionEvent);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        if (this.getTable().getSelectedRowCount() > 1) {
            WindowHelper.setEnabled((JComponent)this.editButton, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateTableData() {
        List list = this.tableData;
        synchronized (list) {
            this.tableData = new ArrayList();
            try {
                sSnmpV3NotifyFilter[] sSnmpV3NotifyFilterArray = this.snmpModel.getSnmpV3NotifyFilter();
                for (int i = 0; i < sSnmpV3NotifyFilterArray.length; ++i) {
                    this.tableData.add(sSnmpV3NotifyFilterArray[i]);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                db.println("Error in getting GRE Table: " + exception);
            }
        }
    }

    public SnmpModel getSnmpModel() {
        return (SnmpModel)this.getUiModel().getNodeModel().getSnmpModel();
    }

    public void destroy() {
        if (this.table != null) {
            this.table.removeMouseListener(this);
        }
        super.destroy();
    }

    protected void createTableEntry() {
        NotifyFilterCreateDialog notifyFilterCreateDialog = NotifyFilterCreateDialog.instance(this, this.getSnmpModel());
        notifyFilterCreateDialog.show();
        notifyFilterCreateDialog.dispose();
    }

    protected void editSelectedTableEntry(int n) {
        sSnmpV3NotifyFilter sSnmpV3NotifyFilter2 = (sSnmpV3NotifyFilter)this.model.getValueAt(n, 0);
        NotifyFilterCreateDialog notifyFilterCreateDialog = NotifyFilterCreateDialog.instance(this, this.getSnmpModel());
        if (sSnmpV3NotifyFilter2 != null) {
            notifyFilterCreateDialog.setSelectedTrap(sSnmpV3NotifyFilter2);
        }
        notifyFilterCreateDialog.show();
        notifyFilterCreateDialog.dispose();
    }

    protected void deleteSelectedTableEntry(int n) {
        int n2;
        int[] nArray = this.getTable().getSelectedRows();
        if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)("Do you really want to delete the selected Notify Filter" + (nArray.length > 1 ? "s?" : "?")), (String)"Delete Notify Filter")) {
            return;
        }
        this.setEditDeleteEnabled(false);
        sSnmpV3NotifyFilter[] sSnmpV3NotifyFilterArray = new sSnmpV3NotifyFilter[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] >= 0 && nArray[n2] < this.model.getRowCount()) {
                sSnmpV3NotifyFilterArray[n2] = (sSnmpV3NotifyFilter)this.model.getValueAt(nArray[n2], 0);
                continue;
            }
            db.severe("Selected entry does not exist, index: " + nArray[n2]);
            sSnmpV3NotifyFilterArray[n2] = null;
        }
        for (n2 = 0; n2 < sSnmpV3NotifyFilterArray.length; ++n2) {
            if (sSnmpV3NotifyFilterArray[n2] == null) continue;
            try {
                this.getSnmpModel().deleteSnmpV3NotifyFilter(sSnmpV3NotifyFilterArray[n2].profileName, sSnmpV3NotifyFilterArray[n2].filterSubtree);
                continue;
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_GRE_TUNNEL_DELETE_FAIL);
            }
        }
    }

    protected void registerWithModels() {
        if (this.snmpModel != null) {
            this.getObservableManager().addObservable((Observable)((Object)this.snmpModel));
        }
    }

    protected void setDataSourceControl() {
        this.setDataSourceControl(new InnerDsc());
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.NotifyFilterConfigurationPane;
    }

    class MaskColumnRenderer
    extends BaseColumnRenderer {
        MaskColumnRenderer() {
        }

        public String getName() {
            return "Bit Mask";
        }
    }

    class TypeColumnRenderer
    extends BaseColumnRenderer {
        TypeColumnRenderer() {
        }

        public String getName() {
            return "Filter Type";
        }
    }

    class SubTreeOIDColumnRenderer
    extends BaseColumnRenderer {
        SubTreeOIDColumnRenderer() {
        }

        public String getName() {
            return "Sub Tree OID";
        }
    }

    class FilterProfileNameColumnRenderer
    extends BaseColumnRenderer {
        FilterProfileNameColumnRenderer() {
        }

        public String getName() {
            return "Filter Profile Name ";
        }
    }

    abstract class BaseColumnRenderer
    implements ColumnRenderer {
        BaseColumnRenderer() {
        }

        public int getWidth() {
            return 200;
        }

        public boolean isResizable() {
            return true;
        }

        public int getAlignment() {
            return 2;
        }

        protected String getStringValue(sSnmpV3NotifyFilter sSnmpV3NotifyFilter2, int n) {
            String string = "???";
            switch (n) {
                case 0: {
                    string = sSnmpV3NotifyFilter2.profileName;
                    break;
                }
                case 1: {
                    string = this.getOID(sSnmpV3NotifyFilter2.filterSubtree);
                    break;
                }
                case 2: {
                    string = this.getMask(sSnmpV3NotifyFilter2.filterSubtree, sSnmpV3NotifyFilter2.mask);
                    break;
                }
                case 3: {
                    string = SnmpV3Util.getFilterTypeString(sSnmpV3NotifyFilter2.filterType.value());
                }
            }
            return " " + string;
        }

        public String getMask(sSnmpOID sSnmpOID2, String string) {
            return string.substring(0, sSnmpOID2.oidlen);
        }

        public String getOID(sSnmpOID sSnmpOID2) {
            int n;
            String string = "";
            for (n = 0; n < sSnmpOID2.oidlen - 1; ++n) {
                string = string + sSnmpOID2.oidarray[n] + ".";
            }
            string = string + sSnmpOID2.oidarray[n];
            return string;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            sSnmpV3NotifyFilter sSnmpV3NotifyFilter2 = (sSnmpV3NotifyFilter)jTable.getValueAt(n, 0);
            String string = this.getStringValue(sSnmpV3NotifyFilter2, n2);
            JLabel jLabel = new JLabel(string);
            jLabel.setOpaque(true);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(jTable.getSelectionForeground());
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(jTable.getForeground());
            }
            return jLabel;
        }

        public int compareColumn(Object object, Object object2, int n) {
            String string = this.getStringValue((sSnmpV3NotifyFilter)object, n);
            String string2 = this.getStringValue((sSnmpV3NotifyFilter)object2, n);
            return string.compareTo(string2);
        }
    }

    class UserTableRowSource
    extends AbstractRowDataSource {
        UserTableRowSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObjectAtRow(int n) {
            Object var2_2 = null;
            List list = NotifyFilterPane.this.tableData;
            synchronized (list) {
                var2_2 = NotifyFilterPane.this.tableData.get(n);
            }
            return var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            int n = -1;
            List list = NotifyFilterPane.this.tableData;
            synchronized (list) {
                n = NotifyFilterPane.this.tableData.size();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection getAllObjects() {
            List list = NotifyFilterPane.this.tableData;
            synchronized (list) {
                return NotifyFilterPane.this.tableData;
            }
        }

        public Class getRowObjectClass() {
            return sSnmpV3NotifyFilter.class;
        }
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        boolean initedOM = false;

        private void initObservableManager() {
            NotifyFilterPane.this.resetObservableManager();
            NotifyFilterPane.this.registerWithModels();
            NotifyFilterPane.this.setObservableManagerActive();
            this.initedOM = true;
            if (db.on()) {
                db.println("initObservabledManager() done");
            }
        }

        public void refreshFromModel() throws Exception {
            if (db.on()) {
                db.println("InnerDsc::refreshFromModel()");
            }
            if (!this.initedOM) {
                this.initObservableManager();
            } else if (db.on()) {
                db.println("did not call initObservableManager()");
            }
            NotifyFilterPane.this.repopulateTable();
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)NotifyFilterPane.this), true);
            }
            return this.dscObservableManager;
        }
    }
}

