/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.snmp;

import cerent.cms.idl.Node.sSnmpTrapDestination;
import cerent.cms.model.ConfigError;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.InvalidData;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.MaxSnmpDestinations;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SnmpModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.cms.ui.shelf.snmp.SnmpComparator;
import cerent.cms.ui.shelf.snmp.SnmpCreationDialog;
import cerent.cms.ui.shelf.snmp.SnmpEditPane;
import cerent.cms.ui.shelf.snmp.SnmpListCellRenderer;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SnmpTrapPane
extends NodeProvPane
implements ActionListener,
ListSelectionListener {
    public static final String CREATE = "Create...";
    public static final String DELETE = "Delete...";
    public static final String ALLOW_SNMP_PROXY = "Allow SNMP Proxy";
    public static final String ALLOW_SNMP_SETS = "Allow SNMP Sets";
    public static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "SnmpTrapPane");
    NodeModelDelegate nodeModel = this.getNMD();
    SnmpModel snmpModel = this.getSnmpModel();
    private DefaultListModel tdListModel;
    private JList tdList;
    private JButton createPB;
    private JButton deletePB;
    private JCheckBox allowProxyCB;
    private JCheckBox allowSetsCB;
    private boolean remainDirty;
    private boolean allowProxyDirty;
    private boolean allowSetsDirty;
    private boolean isSecure = false;
    SnmpEditPane editPane;

    public SnmpTrapPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    private void init() {
        NodeModelDelegate nodeModelDelegate;
        if (db.on()) {
            db.println("<init>: start");
        }
        if ((nodeModelDelegate = this.getNMD()).getPlatform().isSecureModeSupported()) {
            this.isSecure = nodeModelDelegate.isSecureMode();
        }
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagPanel.fillBoth();
        gridBagPanel.add((Component)this.createTrapDestPane(), 0, 1);
        gridBagPanel.fillBoth();
        gridBagPanel.add((Component)this.createEditPane(), 1, 1);
        gridBagPanel.fillHorizontal();
        gridBagPanel.anchorCenter();
        GridBagPanel gridBagPanel2 = new GridBagPanel();
        gridBagPanel2.inset(30, 0);
        gridBagPanel2.add((Component)this.createSNMPSetPane(), 0, 1);
        gridBagPanel2.add((Component)this.createSNMPProxyPane(), 1, 1);
        gridBagPanel.addRemainder(gridBagPanel2, 0, 2);
        this.add((Component)new UScrollPane((Component)gridBagPanel));
        this.registerWithModel();
        if (db.on()) {
            db.println("<init>: finish");
        }
    }

    private JPanel createTrapDestPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Trap Destinations"));
        this.tdListModel = new DefaultListModel();
        this.tdList = new JList(this.tdListModel);
        this.tdList.setCellRenderer(new SnmpListCellRenderer());
        this.tdList.setSelectionMode(0);
        this.tdList.setVisibleRowCount(6);
        this.tdList.setMinimumSize(new Dimension(100, 10));
        this.tdList.addListSelectionListener(this);
        jPanel.add((Component)new UScrollPane((Component)this.tdList), "Center");
        jPanel.add((Component)this.getButtonBar(), "South");
        return jPanel;
    }

    private JPanel createEditPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.editPane = new SnmpEditPane(this);
        jPanel.add((Component)this.editPane, "Center");
        jPanel.setBorder(BorderFactory.createTitledBorder("Selected Destination"));
        return jPanel;
    }

    private JPanel createSNMPProxyPane() {
        this.allowProxyCB = new JCheckBox(ALLOW_SNMP_PROXY);
        this.allowProxyCB.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.allowProxyCB, "Center");
        if (!this.canEdit()) {
            this.allowProxyCB.setEnabled(false);
        }
        return jPanel;
    }

    private JPanel createSNMPSetPane() {
        this.allowSetsCB = new JCheckBox(ALLOW_SNMP_SETS);
        this.allowSetsCB.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.allowSetsCB, "Center");
        if (!this.canEdit()) {
            this.allowSetsCB.setEnabled(false);
        }
        return jPanel;
    }

    private JPanel getButtonBar() {
        this.createPB = new JButton(CREATE);
        this.deletePB = new JButton(DELETE);
        JPanel jPanel = SnmpTrapPane.createHorizontalPanel(null);
        if (this.canEdit()) {
            this.createPB.addActionListener(this);
            this.deletePB.addActionListener(this);
            this.deletePB.setEnabled(false);
            jPanel.setLayout(new FlowLayout(1, 5, 5));
            jPanel.add(this.createPB);
            jPanel.add(this.deletePB);
        }
        return jPanel;
    }

    private void enableDelete(int n) {
        this.deletePB.setEnabled(n >= 0 && this.canDisplay());
    }

    private void enableDelete() {
        this.enableDelete(this.tdList.getSelectedIndex());
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.enableDelete();
            try {
                this.editPane.setTrapDest((sSnmpTrapDestination)this.tdList.getSelectedValue());
            }
            catch (Exception exception) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                this.tdList.setSelectedValue(this.editPane.getTrapDest(), true);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.createPB) {
            SnmpCreationDialog.instance(this).show();
        } else if (object == this.deletePB) {
            sSnmpTrapDestination sSnmpTrapDestination2 = (sSnmpTrapDestination)this.tdList.getSelectedValue();
            IIpAddr iIpAddr = IpAddrFactory.getIIpAddr(sSnmpTrapDestination2.ipAddress);
            String string = InetUtil.makeDottedString(iIpAddr);
            if (CerentDialog.yesNoDialog((Component)((Object)this), (String)("Do you really want to delete \"" + string + "\"?"), (String)"Delete Trap Destination?")) {
                try {
                    this.editPane.setTrapDest(null);
                    this.getSnmpModel().deleteSnmpTrapDestination(IpAddrFactory.getIpAddr(iIpAddr));
                    this.tdListModel.removeElement(sSnmpTrapDestination2);
                }
                catch (Exception exception) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_DELETE_TRAP);
                }
            }
        } else if (object == this.allowProxyCB) {
            this.allowProxyDirty = true;
            this.setDirty();
        } else if (object == this.allowSetsCB) {
            this.allowSetsDirty = true;
            this.setDirty();
        }
    }

    public boolean onValidate() {
        try {
            this.validateFields();
            return true;
        }
        catch (InvalidData invalidData) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_SNMP_DESTINATION_PARAM_1, (Object)invalidData.getMessage());
            return false;
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_VALIDATION_ERROR);
            return false;
        }
    }

    public void applyChangesToModel() throws MaxSnmpDestinations, UnsupportedOperation, ConfigError {
        if (db.on()) {
            db.println("applyChangesToModel");
        }
        boolean bl = this.allowProxyCB.isSelected();
        boolean bl2 = false;
        if (this.allowProxyDirty) {
            this.getSnmpModel().allowSnmpProxy(bl);
            this.allowProxyDirty = false;
        }
        if (this.allowSetsDirty) {
            db.fine("applyChangesToModel: setting Allow Snmp set");
            this.snmpModel.allowSnmpSets(this.allowSetsCB.isSelected());
            this.allowSetsDirty = true;
        }
        this.remainDirty = this.allowProxyDirty || this.allowSetsDirty;
        this.editPane.applyChangesToModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() throws Exception {
        try {
            this.setCursor(3);
            if (this.createPB == null && this.deletePB == null) {
                this.init();
            }
        }
        finally {
            this.setCursor(0);
        }
        super.enteringPage();
    }

    public void refreshFromModel() throws InvalidData {
        NodeModelDelegate nodeModelDelegate = this.getNMD();
        if (nodeModelDelegate == null) {
            if (db.on()) {
                db.println("Node Model is null in SppSnmpPane::refresh()");
            }
            return;
        }
        if (!nodeModelDelegate.getConnectionState()) {
            if (db.on()) {
                db.println("SppSnmpPane::refresh(): node is disconnected");
            }
            return;
        }
        if (this.canDisplay()) {
            ArrayList arrayList = new ArrayList(this.getSnmpModel().getSnmpTrapDestinations());
            Collections.sort(arrayList, new SnmpComparator());
            this.tdListModel.setSize(arrayList.size());
            int n = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.tdListModel.setElementAt(iterator.next(), n++);
            }
            n = this.tdList.getSelectedIndex();
            this.enableDelete(n);
            try {
                this.editPane.setTrapDest(n >= 0 ? (sSnmpTrapDestination)arrayList.get(n) : null);
            }
            catch (Exception exception) {
                this.tdList.setSelectedValue(this.editPane.getTrapDest(), true);
            }
            this.editPane.refreshFromModel();
            this.allowSetsCB.setSelected(this.getSnmpModel().allowSnmpSets());
            this.allowProxyCB.setSelected(this.getSnmpModel().allowSnmpProxy());
        }
        this.resetDirty();
    }

    private boolean canDisplay() {
        if (this.isUserAuthorized(SecurityLevel.SUPERUSER)) {
            return true;
        }
        if (this.isSecure) {
            return false;
        }
        return this.isUserAuthorized(SecurityLevel.PROVISIONING) || this.isUserAuthorized(SecurityLevel.MAINTENANCE) || this.isUserAuthorized(SecurityLevel.RETRIEVE);
    }

    private boolean canEdit() {
        if (this.isUserAuthorized(SecurityLevel.SUPERUSER)) {
            return true;
        }
        if (this.isSecure) {
            return false;
        }
        return this.isUserAuthorized(SecurityLevel.PROVISIONING);
    }

    public boolean canCreateRelays() {
        return this.canEdit();
    }

    protected boolean queryRemainDirty() {
        return this.remainDirty;
    }

    protected void validateFields() throws InvalidData {
        this.editPane.validateFields();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SppSnmpPane;
    }

    public SnmpModel getSnmpModel() {
        return (SnmpModel)this.getUiModel().getNodeModel().getSnmpModel();
    }

    public NodeModelDelegate getNMD() {
        return (NodeModelDelegate)this.getUiModel().getNodeModel();
    }
}

