/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.SonetMedia.sSectionThresholds;
import cerent.cms.idl.SonetMedia.sSectionThresholds600;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.ResettablePmThresholdsTableModel;
import cerent.cms.ui.sonet.TdmTableModel;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;

public class CxcTdmSectionPmThresholdsTableModel
extends TdmTableModel
implements ResettablePmThresholdsTableModel {
    protected boolean[] rowDirty = null;
    protected sSectionThresholds600[] statsVal;
    protected eIntervalType intervalType;
    protected boolean nearEnd;
    protected EntityCellRenderer myPortRenderer;
    public static final int LINENUMBER_INDEX = 0;
    public static final int CV_INDEX = 1;
    public static final int ES_INDEX = 2;
    public static final int SES_INDEX = 3;
    public static final int SEFS_INDEX = 4;
    public String[] columnNames;
    public static final int SONET_INDEX_LEN = 5;
    public static final int BBE_INDEX = 5;
    public static final int SDH_INDEX_LEN = 6;
    private static final SDebug db = new SDebug("CxcTdmSectionPmThresholdsTableModel");

    public CxcTdmSectionPmThresholdsTableModel(INodeModel iNodeModel, TdmLineModel[] tdmLineModelArray, eIntervalType eIntervalType2, boolean bl) {
        this(iNodeModel, tdmLineModelArray, eIntervalType2, bl, iNodeModel.getTDMTerminology());
    }

    public CxcTdmSectionPmThresholdsTableModel(INodeModel iNodeModel, TdmLineModel[] tdmLineModelArray, eIntervalType eIntervalType2, boolean bl, TDMTerminology tDMTerminology) {
        super(iNodeModel, tDMTerminology);
        this.model = tdmLineModelArray;
        this.nearEnd = bl;
        this.intervalType = eIntervalType2;
        this.myPortRenderer = new EntityCellRenderer();
        this.init();
    }

    private void init() {
        this.numLines = this.model.length;
        this.rowDirty = new boolean[this.numLines];
        this.statsVal = new sSectionThresholds600[this.numLines];
        this.initColumnNames();
    }

    private void refreshPmStats(int n) {
        if (this.statsVal[n] == null) {
            try {
                this.statsVal[n] = new sSectionThresholds600();
                this.model[n].getSectionThresholds(this.nearEnd, this.intervalType, this.statsVal[n]);
                if (db.on()) {
                    db.println("Stats val got for line " + n);
                }
                this.printStats(this.statsVal[n]);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return String.class;
        }
        return Integer.class;
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            if (db.on()) {
                db.println("Change in value " + n + " " + n2);
            }
            int n3 = -1;
            TDMTerminology tDMTerminology = this.getTerms();
            if (object instanceof Integer) {
                n3 = (Integer)object;
            } else if (object instanceof String) {
                n3 = Integer.parseInt((String)object);
            }
            if (n3 < 0) {
                throw new Exception();
            }
            switch (n2) {
                case 1: {
                    if (this.statsVal[n].cv == n3) {
                        return;
                    }
                    this.validatePmThresholds(0, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(1), object.toString());
                    this.statsVal[n].cv = n3;
                    break;
                }
                case 2: {
                    if (this.statsVal[n].es == n3) {
                        return;
                    }
                    this.validatePmThresholds(0, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(2), object.toString());
                    this.statsVal[n].es = n3;
                    break;
                }
                case 3: {
                    if (this.statsVal[n].ses == n3) {
                        return;
                    }
                    this.validatePmThresholds(0, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(3), object.toString());
                    this.statsVal[n].ses = n3;
                    break;
                }
                case 4: {
                    if (this.statsVal[n].sefs == n3) {
                        return;
                    }
                    this.validatePmThresholds(0, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(4), object.toString());
                    this.statsVal[n].sefs = n3;
                    break;
                }
                case 5: {
                    if (this.statsVal[n].bbe == n3) {
                        return;
                    }
                    this.validatePmThresholds(0, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(5), object.toString());
                    this.statsVal[n].bbe = n3;
                    break;
                }
            }
            this.rowDirty[n] = true;
            this.fireTableCellUpdated(n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            if (db.on()) {
                db.println("NumberFormatException caught in CxcTdmSectionPmThresholdsTableModel::setValueAt() " + numberFormatException);
                SDebug.printStackTrace((Throwable)numberFormatException);
            }
        }
        catch (ProvisionError provisionError) {
            this.presentProvisionError(this.getColumnName(n2), provisionError);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in setting value " + exception);
            }
            System.err.println("Error in setting value " + exception);
            exception.printStackTrace(System.err);
        }
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public sSectionThresholds600 getStatsVal(int n) {
        if (n >= this.numLines) {
            return null;
        }
        return this.statsVal[n];
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.model[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].cv);
                }
                case 2: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].es);
                }
                case 3: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].ses);
                }
                case 4: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].sefs);
                }
                case 5: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].bbe);
                }
            }
            return null;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in getValueAt " + exception);
            }
            return null;
        }
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0) {
            try {
                if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.model[0].getModuleModel().isProtectModule()) {
                    return n2 > 0 && !this.model[n].isProtectLine();
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                return false;
            }
        }
        return false;
    }

    public void refreshMyLines(TdmLineModel[] tdmLineModelArray) {
        this.model = tdmLineModelArray;
        this.init();
        this.fireTableDataChanged();
    }

    public void markRowDirty(int n) {
        this.rowDirty[n] = true;
    }

    public Object getThresholdNeDefault(NeDefaultsModel neDefaultsModel, int n) throws Exception {
        eEqType eEqType2 = this.model[n].getModuleModel().getEqTypeEnum();
        IPortModel iPortModel = this.model[n].getPortModel();
        eEqType eEqType3 = ((EntityModel)iPortModel).getEqTypeEnum();
        return neDefaultsModel.getDefSectionThr(eEqType2, eEqType3, this.nearEnd, this.intervalType);
    }

    public void setThresholdValue(int n, Object object) {
        if (object instanceof sSectionThresholds) {
            sSectionThresholds sSectionThresholds2 = (sSectionThresholds)object;
            this.statsVal[n] = new sSectionThresholds600();
            this.statsVal[n].es = sSectionThresholds2.es;
            this.statsVal[n].ses = sSectionThresholds2.ses;
            this.statsVal[n].sefs = sSectionThresholds2.sefs;
            this.statsVal[n].cv = sSectionThresholds2.cv;
            if (this.getTdmProtocolTypeObj().isSdh()) {
                this.statsVal[n].bbe = sSectionThresholds2.bbe;
            }
        }
    }

    public void refreshLineFromModel(int n) {
        this.statsVal[n] = null;
        this.rowDirty[n] = false;
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshFromModel() {
        int n;
        if (db.on()) {
            db.println("refreshing in model");
        }
        for (n = 0; n < this.numLines; ++n) {
            this.statsVal[n] = null;
        }
        for (n = 0; n < this.numLines; ++n) {
            this.rowDirty[n] = false;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
        }
    }

    private void printStats(sSectionThresholds600 sSectionThresholds6002) {
        if (db.on()) {
            db.println("Near End = " + this.nearEnd + " Interval Type = " + EnumStrings.getString((Object)this.intervalType, (int)this.intervalType.value()));
            db.println("===============================================");
            db.println("CV " + sSectionThresholds6002.cv);
            db.println("ES " + sSectionThresholds6002.es);
            db.println("SES " + sSectionThresholds6002.ses);
            db.println("SEFS " + sSectionThresholds6002.sefs);
            db.println("===============================================");
        }
    }

    private void initColumnNames() {
        boolean bl = this.getTdmProtocolTypeObj().isSdh();
        int n = bl ? 6 : 5;
        try {
            TDMTerminology tDMTerminology = this.getTerms();
            this.columnNames = new String[n];
            this.columnNames[0] = "Port ";
            this.columnNames[1] = tDMTerminology.getPmStat(1);
            this.columnNames[2] = tDMTerminology.getPmStat(2);
            this.columnNames[3] = tDMTerminology.getPmStat(3);
            this.columnNames[4] = tDMTerminology.getPmStat(4);
            if (bl) {
                this.columnNames[5] = tDMTerminology.getPmStat(5);
            }
        }
        catch (Exception exception) {
            db.finer("Exception in initColumnNames() " + exception);
        }
    }
}

