/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.sonet.TdmHoMaintenancePane;
import cerent.cms.ui.sonet.TdmLineMaintenancePane;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Component;

public class TdmLoopbackPane
extends AbstractSubTabbedPane
implements ITabName {
    protected InterfaceModel[] lines;
    private static final SDebug dbg = new SDebug("TdmLoopbackPane");

    public TdmLoopbackPane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray) {
        super(string, tabbedView);
        this.lines = interfaceModelArray;
        super.registerWithModel();
    }

    protected void createSubTabs() {
        this.subTabs.setTabPlacement(1);
        this.subTabs.add("Port", (Component)this.getLineMaintPane("Port", this.subTabs, this.lines));
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        TDMTerminology tDMTerminology = nodeModelDelegate.getTDMTerminology();
        int n = 0;
        String string = tDMTerminology.getTdmHoTerm(n);
        if (nodeModelDelegate.isSdhAu3Supported()) {
            string = tDMTerminology.getTdmHoTerm(2);
            this.subTabs.add(string, (Component)this.getHoMaintPane(string, this.subTabs, this.lines, 1, 2));
        }
        if (nodeModelDelegate.getTdmProtocolTypeObj().isSdh()) {
            n = 1;
            string = tDMTerminology.getTdmHoTerm(n);
        }
        this.subTabs.add(string, (Component)this.getHoMaintPane(string, this.subTabs, this.lines, 1, n));
    }

    protected Pane getLineMaintPane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray) {
        return new TdmLineMaintenancePane(string, tabbedView, (TdmLineModel[])interfaceModelArray);
    }

    protected Pane getHoMaintPane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray, int n, int n2) {
        return new TdmHoMaintenancePane(string, tabbedView, interfaceModelArray, n, n2);
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof OcnLineUpdate) {
            if (dbg.on()) {
                dbg.println("Received OcnLineUpdate...");
            }
            this.lines = (TdmLineModel[])((OcnLineUpdate)object).getModels();
        } else if (dbg.on()) {
            dbg.println("refreshMyLines received " + object);
        }
    }
}

