/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.wbe;

import cerent.cms.idl.Ds123Media.eBertMode;
import cerent.cms.idl.Ds123Media.eTrafficPattern;
import cerent.cms.idl.Ds123Media.portBertConfig;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BERTModel;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.SDebug;
import javax.swing.table.AbstractTableModel;

public class WbeDs1BertTableModel
extends AbstractTableModel {
    protected Ds123LineModel[] model;
    protected boolean[][] isDirty;
    protected INodeModel node;
    protected int numLines;
    private EntityCellRenderer portRenderer = null;
    public static final int LINENUMBER_INDEX = 0;
    public static final int TPGM_INDEX = 1;
    public static final String[] columnNames = new String[]{"Port", "TPGM-Selection", "Pattern"};
    protected String[] portNums;
    protected String[] tpgmArray;
    protected String[] pattern;
    BERTModel bm = null;
    protected static final SDebug db = new SDebug("WbeDs1BertTableModel");

    public WbeDs1BertTableModel(INodeModel iNodeModel, Ds123LineModel[] ds123LineModelArray, BERTModel bERTModel) {
        this.model = ds123LineModelArray;
        this.node = iNodeModel;
        this.bm = bERTModel;
        this.portRenderer = new EntityCellRenderer(true);
        this.init();
    }

    protected void init() {
        if (this.model != null) {
            this.numLines = this.model.length;
        }
        this.portNums = new String[this.numLines];
        this.tpgmArray = new String[this.numLines];
        this.pattern = new String[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.resetDirtyBits();
    }

    public Class getColumnClass(int n) {
        return super.getColumnClass(n);
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 1: {
                this.tpgmArray[n] = (String)object;
                break;
            }
            case 2: {
                this.pattern[n] = (String)object;
                break;
            }
        }
        this.isDirty[n][n2] = true;
        this.fireTableRowsUpdated(n, n);
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 1: 
            case 2: {
                if (!this.isPhysicalPort(n)) break;
                return true;
            }
        }
        return false;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getLineNumber(n);
                }
                case 1: {
                    if (this.isPhysicalPort(n)) {
                        portBertConfig portBertConfig2 = this.getPortConfig(n);
                        return this.getMode(n, portBertConfig2);
                    }
                    this.tpgmArray[n] = "NA";
                    return "NA";
                }
                case 2: {
                    if (this.isPhysicalPort(n)) {
                        portBertConfig portBertConfig3 = this.getPortConfig(n);
                        return this.getPattern(n, portBertConfig3);
                    }
                    this.pattern[n] = "NA";
                    return "NA";
                }
            }
            return null;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in getValueAt in WbeDs1BertTableModel" + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    boolean isPhysicalPort(int n) {
        int n2;
        int n3 = 0;
        if (n / 28 > 12) {
            n3 = n / 28 - 12;
        }
        return (n2 = n / 28 + 1 + n3) <= 12;
    }

    portBertConfig getPortConfig(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, EMCProvisionError {
        portBertConfig portBertConfig2 = null;
        portBertConfig2 = this.model[n].getBERTConfig();
        return portBertConfig2;
    }

    String getMode(int n, portBertConfig portBertConfig2) {
        if (this.tpgmArray[n] == null) {
            eBertMode eBertMode2 = null;
            if (portBertConfig2 != null) {
                eBertMode2 = portBertConfig2.mode;
            }
            if (eBertMode2 != null) {
                if (eBertMode2.value() == eBertMode.MODE_NONE.value()) {
                    this.tpgmArray[n] = "None";
                } else if (eBertMode2.value() == 2) {
                    this.tpgmArray[n] = "TPGM-B";
                } else if (eBertMode2.value() == 1) {
                    this.tpgmArray[n] = "TPGM-L";
                }
            }
        }
        return this.tpgmArray[n];
    }

    String getPattern(int n, portBertConfig portBertConfig2) {
        if (this.pattern[n] == null) {
            eTrafficPattern eTrafficPattern2 = null;
            if (portBertConfig2 != null) {
                eTrafficPattern2 = portBertConfig2.pattern;
            }
            if (eTrafficPattern2 != null) {
                if (eTrafficPattern2.value() == eTrafficPattern.PRBS15.value()) {
                    this.pattern[n] = "PRBS15";
                } else if (eTrafficPattern2.value() == eTrafficPattern.PRBS20.value()) {
                    this.pattern[n] = "PRBS20";
                } else if (eTrafficPattern2.value() == eTrafficPattern.PRBS23.value()) {
                    this.pattern[n] = "PRBS23";
                } else if (eTrafficPattern2.value() == eTrafficPattern.QRSS.value()) {
                    this.pattern[n] = "QRSS";
                } else if (eTrafficPattern2.value() == eTrafficPattern.ALT_ONE_AND_ZERO.value()) {
                    this.pattern[n] = "Alt1s0s";
                } else if (eTrafficPattern2.value() == eTrafficPattern.PATTERN_NONE.value()) {
                    this.pattern[n] = "None";
                }
            }
        }
        return this.pattern[n];
    }

    public eBertMode getModeFromRow(int n) {
        eBertMode eBertMode2 = null;
        if (this.tpgmArray[n] != null) {
            int n2 = this.getIntMode(this.tpgmArray[n]);
            eBertMode2 = eBertMode.from_int(n2);
        }
        return eBertMode2;
    }

    public eTrafficPattern getPatternFromRow(int n) {
        eTrafficPattern eTrafficPattern2 = null;
        if (this.pattern[n] != null) {
            int n2 = this.getIntPattern(this.pattern[n]);
            eTrafficPattern2 = eTrafficPattern.from_int(n2);
        }
        return eTrafficPattern2;
    }

    int getIntMode(String string) {
        int n = 0;
        if (string.equals("TPGM-B")) {
            n = 2;
        } else if (string.equals("None")) {
            n = 0;
        } else if (string.equals("TPGM-L")) {
            n = 1;
        }
        return n;
    }

    int getIntPattern(String string) {
        int n = 0;
        if (string.equals("PRBS15")) {
            n = 1;
        } else if (string.equals("PRBS20")) {
            n = 2;
        } else if (string.equals("PRBS23")) {
            n = 3;
        } else if (string.equals("QRSS")) {
            n = 4;
        } else if (string.equals("Alt1s0s")) {
            n = 5;
        }
        return n;
    }

    protected String getLineNumber(int n) throws AbstractCmsNoSuchEntityException {
        return this.getPortDescriptionFor(n);
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.model[n].getPortModel();
        this.portRenderer.showPortAlias(false);
        return this.portRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    protected String getPortNum(int n) {
        if (this.portNums[n] == null) {
            try {
                this.portNums[n] = PortHelper.getPortNumAndTypeString((IPortModel)this.model[n].getPortModel(), (boolean)true, (boolean)true);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return this.portNums[n];
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.portNums[i] = null;
            this.tpgmArray[i] = null;
            this.pattern[i] = null;
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) {
        this.portNums[n] = null;
        this.tpgmArray[n] = null;
        this.pattern[n] = null;
        Ds123LineModel ds123LineModel = this.bm.getBERTPortModel();
        try {
            portBertConfig portBertConfig2;
            if (ds123LineModel != null) {
                portBertConfig2 = ds123LineModel.getBERTConfig();
                if (portBertConfig2.mode.value() == 0) {
                    this.bm.setBERTPortModel(null);
                }
            } else {
                portBertConfig2 = this.model[n].getBERTConfig();
                if (portBertConfig2.mode.value() != 0) {
                    this.bm.setBERTPortModel(this.model[n]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshMyLines(Ds123LineModel[] ds123LineModelArray) {
        this.model = ds123LineModelArray;
        this.init();
        for (int i = 0; i < ds123LineModelArray.length; ++i) {
            this.portNums[i] = null;
            this.tpgmArray[i] = null;
            this.pattern[i] = null;
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
        this.fireTableDataChanged();
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }
}

