/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.wxc;

import cerent.cms.model.DwdmOpticalSetupModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.cms.ui.wxc.WxcMeshppTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class WxcMeshppPanel
extends AbstractPane
implements Observer,
ActionListener {
    private static final String REFRESH = "Refresh";
    private JButton refreshTableButton = new JButton("Refresh");
    private WxcMeshppTableModel dataModel;
    private boolean initialized = false;
    private static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "WxcMeshppPanel");

    public WxcMeshppPanel(String string, TabbedView tabbedView, DwdmOpticalSetupModel dwdmOpticalSetupModel) {
        super(string, tabbedView);
        this.dataModel = new WxcMeshppTableModel((NodeModelDelegate)dwdmOpticalSetupModel.getNodeModel(), this.getUiModel());
    }

    private void init() {
        if (db.on()) {
            db.println("init");
        }
        this.setDefaultPrivilegeLevel(SecurityLevel.MAINTENANCE);
        this.setLayout(new BorderLayout());
        this.table = new UTable((TableModel)this.dataModel);
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){
            boolean flag = true;

            public void mouseReleased(MouseEvent mouseEvent) {
                WxcMeshppPanel.this.sortAllRowsBy(WxcMeshppPanel.this.dataModel, 0, this.flag);
                this.flag = !this.flag;
            }
        });
        this.table.setColumnSelectionAllowed(true);
        this.table.setCellSelectionEnabled(true);
        this.table.setAutoResizeMode(4);
        this.add(this.makeControlPanel(), "South");
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        this.initialized = true;
    }

    private JPanel makeControlPanel() {
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.WxcMeshppPanel);
        this.refreshTableButton.addActionListener(this);
        cSHelpButtonPane.addLeft(this.refreshTableButton);
        return cSHelpButtonPane;
    }

    public void sortAllRowsBy(WxcMeshppTableModel wxcMeshppTableModel, int n, boolean bl) {
        ArrayList<WxcMeshppTableModel.TableData> arrayList = wxcMeshppTableModel.getSourceData();
        Collections.sort(arrayList, new ColumnSorter(n, bl));
        wxcMeshppTableModel.fireTableDataChanged();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshTableButton) {
            try {
                this.refresh();
            }
            catch (Exception exception) {
                KDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_ANS);
            }
        }
    }

    public void enteringPage() throws Exception {
        this.dataModel.refresh();
        if (!this.initialized) {
            this.init();
        }
    }

    public void leavingPage() throws Exception {
    }

    public void refresh() {
        this.dataModel.refresh();
    }

    public void destroy() {
    }

    public void update(Observable observable, Object object) {
        this.refresh();
    }

    class ColumnSorter
    implements Comparator {
        int colIndex;
        boolean ascending;

        ColumnSorter(int n, boolean bl) {
            this.colIndex = n;
            this.ascending = bl;
        }

        public int compare(Object object, Object object2) {
            WxcMeshppTableModel.TableData tableData = (WxcMeshppTableModel.TableData)object;
            WxcMeshppTableModel.TableData tableData2 = (WxcMeshppTableModel.TableData)object2;
            if (tableData == null && tableData2 == null) {
                return 0;
            }
            if (tableData == null) {
                return 1;
            }
            if (tableData2 == null) {
                return -1;
            }
            if (tableData instanceof Comparable) {
                if (this.ascending) {
                    return ((Comparable)((Object)tableData)).compareTo(tableData2);
                }
                return ((Comparable)((Object)tableData2)).compareTo(tableData);
            }
            if (this.ascending) {
                if (this.colIndex == 0) {
                    return tableData.getFrom().compareTo(tableData2.getFrom());
                }
                if (this.colIndex == 1) {
                    return tableData.getTo().compareTo(tableData2.getTo());
                }
                return tableData.toString().compareTo(tableData2.toString());
            }
            if (this.colIndex == 0) {
                return tableData2.getFrom().compareTo(tableData.getFrom());
            }
            if (this.colIndex == 1) {
                return tableData2.getTo().compareTo(tableData.getTo());
            }
            return tableData2.toString().compareTo(tableData.toString());
        }
    }
}

