/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.Common.sEtherMacAddr;
import cerent.cms.idl.EtherL2Media.sMacInfo;
import cerent.cms.model.ModelUpdateType;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class XPL2MacFilterTableModel
extends AbstractTableModel
implements Observer {
    public static final int MAC_INDEX = 0;
    public static final int NUMBER_OF_BYTE_MAC = 6;
    public static final int CONTROL_OF_BYTE_MAC = 5;
    static final String[] columnNames = new String[]{"MAC Address Port "};
    private sMacInfo macInfo;
    private boolean[][] isDirty = null;
    private int numLines = 0;
    private Vector macAddressList = new Vector();
    private static final SDebug db = new SDebug("XPL2MacFilterTableModel");

    public XPL2MacFilterTableModel(sEtherMacAddr[] sEtherMacAddrArray) {
        this.macAddressList.addAll(Arrays.asList(sEtherMacAddrArray));
        this.numLines = this.macAddressList.size();
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.resetDirty();
    }

    protected void addRow() {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0};
        this.macAddressList.add(new sEtherMacAddr(byArray));
        this.numLines = this.macAddressList.size();
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.resetDirty();
        this.fireTableDataChanged();
    }

    protected void removeRows(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.macAddressList.remove(nArray[i] - i);
        }
        this.numLines = this.macAddressList.size();
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.resetDirty();
        this.fireTableDataChanged();
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public boolean flowControlChanged() {
        return false;
    }

    public boolean isCellDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public String getColumnName(int n) {
        if (n >= 0 && n < columnNames.length) {
            return columnNames[n];
        }
        return null;
    }

    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return Object.class;
    }

    public static String convertMacToString(byte[] byArray) {
        String string = "";
        for (int i = 0; i < 6; ++i) {
            String string2 = Integer.toHexString(byArray[i] & 0xFF);
            if (string2.length() == 1) {
                if (i < 5) {
                    string = string + "0";
                    string = string + string2 + "-";
                    continue;
                }
                string = string + "0";
                string = string + string2;
                continue;
            }
            string = i < 5 ? string + string2 + "-" : string + string2;
        }
        return string;
    }

    public Object getValueAt(int n, int n2) {
        block5: {
            try {
                switch (n2) {
                    case 0: {
                        sEtherMacAddr sEtherMacAddr2 = (sEtherMacAddr)this.macAddressList.get(n);
                        if (sEtherMacAddr2 == null) break;
                        return XPL2MacFilterTableModel.convertMacToString(sEtherMacAddr2.addr);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                db.println("Error in getValueAt in XPL2MacFilterTableModel " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                String[] stringArray = ((String)object).split("-");
                byte[] byArray = new byte[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    byArray[i] = (byte)Short.parseShort(string, 16);
                }
                sEtherMacAddr sEtherMacAddr2 = (sEtherMacAddr)this.macAddressList.get(n);
                sEtherMacAddr2.addr = byArray;
                this.isDirty[n][n2] = true;
                this.fireTableCellUpdated(n, n2);
                break;
            }
            default: {
                return;
            }
        }
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public sEtherMacAddr[] getMacTable() {
        return this.macAddressList.toArray(new sEtherMacAddr[0]);
    }

    public void applyToModel() {
    }

    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    protected void resetLineCache(int n) throws Exception {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            try {
                this.refreshFromModel();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void dispose() {
    }
}

