/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.AlsPane;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SoakMaintenancePane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.DwdmInfoMaintenancePane;
import cerent.cms.ui.dwdm.DwdmLineMaintenancePane;
import cerent.cms.ui.xpl2.XPL2CardMacAddrListPane;
import cerent.cms.ui.xpl2.XPL2MacAddrLearningListPane;
import cerent.cms.ui.xpl2.XPL2MaintAffectedVlanPane;
import cerent.cms.ui.xpl2.XPL2MaintMulticastPane;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;

public class XPL2MaintenancePane
extends NodeProvPane {
    private XPL2ModuleModel eqpmtModel;
    private static final SDebug db = new SDebug("XPL2MaintenancePane");

    public XPL2MaintenancePane(String string, CardTabbedView cardTabbedView, XPL2ModuleModel xPL2ModuleModel) {
        super(string, cardTabbedView);
        this.eqpmtModel = xPL2ModuleModel;
        this.subTabs = new SubTabbedView(xPL2ModuleModel, cardTabbedView);
        this.subTabs.addTab("SVLAN AIS", (Component)this.getAffectedVlanTab());
        this.subTabs.addTab("Loopback", (Component)this.getLoopbackTab());
        this.subTabs.addTab("ALS", (Component)this.getAlsTab());
        this.subTabs.addTab("Info", (Component)this.getInfoTab());
        this.subTabs.addTab("AINS Soak", (Component)this.getSoakTab());
        this.subTabs.addTab("Protection", (Component)CardTabbedView.getProtectionPane(this.subTabs));
        this.subTabs.addTab("MAC Addresses", (Component)this.getMACAddressesTabs(this.subTabs));
        this.subTabs.setTabPlacement(2);
        this.add((Component)this.subTabs);
    }

    public void enteringPage() throws Exception {
        this.eqpmtModel.addObserver((Observer)((Object)this));
        this.disableL2Tabs();
    }

    public void leavingPage() throws Exception {
        this.eqpmtModel.deleteObserver((Observer)((Object)this));
    }

    protected Pane getInfoTab() {
        return new DwdmInfoMaintenancePane("Info", this.subTabs);
    }

    protected Pane getAlsTab() {
        return new AlsPane("ALS", this.getParentView(), this.eqpmtModel.getAllDwdmLineModels());
    }

    private Pane getLoopbackTab() {
        return new DwdmLineMaintenancePane("XPL2LineMaintPane", this.getParentView(), this.eqpmtModel.getAllDwdmLineModels());
    }

    private Pane getSoakTab() {
        return new SoakMaintenancePane("AINS Soak", this.subTabs, this.eqpmtModel.getAllDwdmLineModels(), true);
    }

    protected Pane getAffectedVlanTab() {
        return new XPL2MaintAffectedVlanPane("SVLAN AIS", this.getParentView());
    }

    private Pane getMACAddressesTabs(TabbedView tabbedView) {
        return new AbstractSubTabbedPane("MAC Addresses", tabbedView){

            public void createSubTabs() {
                this.subTabs.addTab("Multicast ", (Component)((Object)new XPL2MaintMulticastPane("Multicast ", this.getParentView())));
                this.subTabs.addTab("Learned", (Component)((Object)new XPL2MacAddrLearningListPane("Learned", this.getParentView())));
                this.subTabs.addTab("Card", (Component)((Object)new XPL2CardMacAddrListPane("Card", this.getParentView())));
            }
        };
    }

    public boolean hasSubTabs() {
        return true;
    }

    public void disableL2Tabs() {
        if (this.eqpmtModel.isL2Switch()) {
            this.setTabEnabled(true);
        } else {
            this.setTabEnabled(false);
            int n = this.subTabs.getSelectedIndex();
            if (n == 6) {
                this.subTabs.setSelectedIndex(this.subTabs.indexOfTab("SVLAN AIS"));
            }
        }
    }

    public void setTabEnabled(boolean bl) {
        this.subTabs.setEnabledAt(this.subTabs.indexOfTab("MAC Addresses"), bl);
    }

    public void update(Observable observable, Object object) {
        Integer n;
        super.update(observable, object);
        if (observable instanceof XPL2ModuleModel && (n = (Integer)object).equals(ModelUpdateType.CHANGED)) {
            this.disableL2Tabs();
        }
    }
}

