/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.sEgressInfo;
import cerent.cms.model.InvalidOperation;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.PortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.xpl2.XPL2QoSTableModel;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class XPL2QoSProvPane
extends NodeProvPane
implements PropertyChangeListener,
TableModelListener {
    protected XPL2QoSTableModel dataModel = null;
    protected XPL2ModuleModel eqpmtModel = null;
    protected XPL2LineModel[] lineModels = null;
    protected PortModel[] portModels = null;
    private UComboBox portCB;
    private boolean applyChanges = false;
    private ObservableManager _obsMgr;
    private static final SDebug db = new SDebug("XPL2QoSProvPane");

    public XPL2QoSProvPane(String string, TabbedView tabbedView, XPL2ModuleModel xPL2ModuleModel) {
        super(string, tabbedView);
        this.eqpmtModel = xPL2ModuleModel;
        this.portModels = this.getQosPorts();
        this.lineModels = this.getQosLines();
        if (xPL2ModuleModel == null || this.portModels == null || this.lineModels == null || this.portModels.length != this.lineModels.length) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + xPL2ModuleModel + " portModels=" + this.portModels + " lineModels=" + this.lineModels);
            }
            return;
        }
        try {
            this.dataModel = new XPL2QoSTableModel(xPL2ModuleModel, this.getEgressInfoFromModel(0));
        }
        catch (NoSuchInterface noSuchInterface) {
            noSuchInterface.printStackTrace();
        }
        catch (InvalidOperation invalidOperation) {
            invalidOperation.printStackTrace();
        }
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.customizedProvPane();
        JPanel jPanel = XPL2QoSProvPane.createVerticalPanel(null);
        jPanel.add(this.makeControlPanel());
        this.add(jPanel, "South");
        this.add((Component)uScrollPane, "Center");
        this.registerWithModel();
    }

    public void refreshMyLines(Object object) {
        this.portModels = this.getQosPorts();
        this.lineModels = this.getQosLines();
        PortModel portModel = (PortModel)this.portCB.getSelectedItem();
        this.portCB.removeAllItems();
        for (int i = 0; i < this.portModels.length; ++i) {
            ((DefaultComboBoxModel)this.portCB.getModel()).addElement(this.portModels[i]);
        }
        if (((DefaultComboBoxModel)this.portCB.getModel()).getIndexOf(portModel) != -1) {
            this.portCB.setSelectedItem((Object)portModel);
        }
        if (this.portModels.length == 0) {
            this.portCB.setEnabled(false);
            this.dataModel.updateEgressInfo(null);
        } else {
            this.portCB.setEnabled(true);
        }
        this.refreshNow();
    }

    public PortModel[] getQosPorts() {
        PortModel[] portModelArray = this.eqpmtModel.getXPL2EtherPorts();
        XPL2LineModel[] xPL2LineModelArray = this.eqpmtModel.getXPL2EtherLines();
        Vector<PortModel> vector = new Vector<PortModel>();
        for (int i = 0; i < xPL2LineModelArray.length; ++i) {
            try {
                if (xPL2LineModelArray[i] == null || xPL2LineModelArray[i].getEgressQOS() == null || !xPL2LineModelArray[i].getEgressQOS().booleanValue()) continue;
                vector.add(portModelArray[i]);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
                continue;
            }
            catch (InvalidOperation invalidOperation) {
                SDebug.printStackTrace((Throwable)invalidOperation);
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return vector.toArray(new PortModel[0]);
    }

    public XPL2LineModel[] getQosLines() {
        XPL2LineModel[] xPL2LineModelArray = this.eqpmtModel.getXPL2EtherLines();
        Vector<XPL2LineModel> vector = new Vector<XPL2LineModel>();
        for (int i = 0; i < xPL2LineModelArray.length; ++i) {
            try {
                if (xPL2LineModelArray[i] == null || xPL2LineModelArray[i].getEgressQOS() == null || !xPL2LineModelArray[i].getEgressQOS().booleanValue()) continue;
                vector.add(xPL2LineModelArray[i]);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
                continue;
            }
            catch (InvalidOperation invalidOperation) {
                SDebug.printStackTrace((Throwable)invalidOperation);
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return vector.toArray(new XPL2LineModel[0]);
    }

    private sEgressInfo getEgressInfoFromModel(int n) throws NoSuchInterface, InvalidOperation {
        sEgressInfo sEgressInfo2 = null;
        if (this.lineModels.length > n && this.lineModels[n].getLayer2LineModel() != null) {
            sEgressInfo2 = this.lineModels[n].getLayer2LineModel().getEgressInfo();
        }
        return sEgressInfo2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshNow() {
        try {
            this.setCursor(3);
            if (this.portCB.getSelectedIndex() != -1) {
                int n = this.portCB.getSelectedIndex();
                this.dataModel.updateEgressInfo(this.getEgressInfoFromModel(n));
            }
        }
        catch (Exception exception) {
            db.println("Caught exception in RmonPmHistPane.refreshNow: " + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            this.setCursor(0);
        }
    }

    private JPanel makeControlPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = XPL2QoSProvPane.createHorizontalPanel(null);
        VetoableComboBoxModel vetoableComboBoxModel = new VetoableComboBoxModel(this.portModels);
        vetoableComboBoxModel.addVetoableSelectionListener(new VetoableComboBoxSelectionListener(){

            public boolean selectionChanged(VetoableChangeEvent vetoableChangeEvent) {
                if (XPL2QoSProvPane.this.isProvPaneDirty()) {
                    switch (CerentDialog.cancelableQuestionDialog((Component)((Object)XPL2QoSProvPane.this), (String)"Is it OK to apply these changes?", (String)"Changes Not Applied")) {
                        case 0: {
                            XPL2QoSProvPane.this.applyChanges = true;
                            return true;
                        }
                        case 1: {
                            return true;
                        }
                    }
                    return false;
                }
                return true;
            }
        });
        this.portCB = new UComboBox((ComboBoxModel)vetoableComboBoxModel);
        this.portCB.setRenderer((ListCellRenderer)new CardPortRenderer());
        this.portCB.setPreferredSize(new Dimension(150, 50));
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(new JLabel("Port:"));
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)this.portCB);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(new JLabel("Egress QOS is enabled for this port!"));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 50, 5, 50));
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)new JLabel(), "East");
        return jPanel;
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        if (db.on()) {
            db.println("calling enteringPage");
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.refreshMyLines(null);
        this.getObsMgr().setPassing(true);
        this.registerWithModel();
    }

    public void leavingPage() throws Exception {
        this.getObsMgr().setPassing(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("calling leavingPage");
        }
        super.leavingPage();
        this.unRegisterWithModel();
    }

    protected void registerWithModel() {
        int n;
        super.registerWithModel();
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.lineModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.lineModels[n].getLayer2LineModel()));
        }
    }

    protected void unRegisterWithModel() {
        int n;
        super.registerWithModel();
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.lineModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.lineModels[n].getLayer2LineModel()));
        }
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    public void dispose() {
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        super.dispose();
    }

    protected void customizedProvPane() {
        TableColumn tableColumn = null;
        Object var2_2 = null;
        Object var3_3 = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(120);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(1));
        tableColumn.setPreferredWidth(105);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
        tableColumn.setPreferredWidth(155);
        this.table.sizeColumnsToFit(-1);
    }

    public void destroy() {
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    public void applyChangesToModel() throws Exception {
        this.lineModels[this.portCB.getSelectedIndex()].getLayer2LineModel().setEgressInfo(this.dataModel.getEgressInfo());
        this.resetDirty();
    }

    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
        this.refreshMyLines(null);
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2QoSProvPane;
    }

    class CardPortRenderer
    extends JLabel
    implements ListCellRenderer {
        public CardPortRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            try {
                if (object instanceof String) {
                    this.setText((String)object);
                } else if (object instanceof PortModel) {
                    PortModel portModel = (PortModel)object;
                    EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
                    this.setText(entityCellRenderer.getPortString(portModel, false));
                }
            }
            catch (Exception exception) {
                db.println("RmonCardPortRenderer caught Exception: " + exception);
            }
            this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }

    class VetoableComboBoxModel
    extends DefaultComboBoxModel {
        private ArrayList selectionListeners;

        public VetoableComboBoxModel() {
            this.selectionListeners = new ArrayList();
        }

        public VetoableComboBoxModel(Object[] objectArray) {
            super(objectArray);
            this.selectionListeners = new ArrayList();
        }

        public VetoableComboBoxModel(Vector vector) {
            super(vector);
            this.selectionListeners = new ArrayList();
        }

        public void addVetoableSelectionListener(VetoableComboBoxSelectionListener vetoableComboBoxSelectionListener) {
            this.selectionListeners.add(vetoableComboBoxSelectionListener);
        }

        public void removeVetoableSelectionListener(VetoableComboBoxSelectionListener vetoableComboBoxSelectionListener) {
            this.selectionListeners.remove(vetoableComboBoxSelectionListener);
        }

        protected boolean fireVetoableSelectionChange(Object object) {
            boolean bl = true;
            VetoableChangeEvent vetoableChangeEvent = new VetoableChangeEvent(this, object);
            for (VetoableComboBoxSelectionListener vetoableComboBoxSelectionListener : this.selectionListeners) {
                bl &= vetoableComboBoxSelectionListener.selectionChanged(vetoableChangeEvent);
            }
            return bl;
        }

        public void setSelectedItem(Object object) {
            Object object2 = this.getSelectedItem();
            if (this.fireVetoableSelectionChange(object)) {
                if (XPL2QoSProvPane.this.applyChanges) {
                    XPL2QoSProvPane.this.apply();
                    XPL2QoSProvPane.this.applyChanges = false;
                }
                super.setSelectedItem(object);
                try {
                    XPL2QoSProvPane.this.refreshNow();
                }
                catch (Exception exception) {
                    if (db.on()) {
                        KDebug.printStackTrace((Throwable)exception);
                    }
                }
            } else {
                super.setSelectedItem(object2);
            }
        }
    }

    static interface VetoableComboBoxSelectionListener
    extends EventListener {
        public boolean selectionChanged(VetoableChangeEvent var1);
    }

    class VetoableChangeEvent
    extends ChangeEvent {
        private Object newValue;

        public VetoableChangeEvent(Object object, Object object2) {
            super(object);
            this.newValue = object2;
        }

        public Object getNewValue() {
            return this.newValue;
        }
    }
}

