/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.EntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.ML2EtherLineModel;
import cerent.cms.model.ML2PosLineModel;
import cerent.cms.model.PortModel;
import cerent.cms.ui.shelf.CardView;
import cerent.cms.ui.shelf.GenericPortGraphic;
import cerent.util.SDebug;

public class XPLPortGraphic
extends GenericPortGraphic {
    private static final String UP = "Up";
    private static final String DOWN = "Down";
    private static final SDebug db = new SDebug("XPLPortGraphic");

    public XPLPortGraphic(CardView cardView, EntityModel entityModel, int n) {
        super(cardView, entityModel, n);
    }

    protected String getStatusLabel() {
        return "Link State: ";
    }

    protected synchronized void showState() {
        db.fine("MLPortGraphic.showState() for Port " + this.portNo);
        int n = this.model.getModuleModel().getEqType();
        if (n == 163 || n == 187) {
            super.showState();
        } else {
            String string = this.getPortStateString();
            this.updateToolTip();
            int n2 = 1;
            try {
                n2 = ((PortModel)this.model).getAdminState();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            this.setCurrentState(n2);
            this.setCurrentColor(XPLPortGraphic.getPortColorByAdminStateAndSeverity(n2, this.currentSeverity));
            if (db.isInfoEnabled()) {
                db.info("Admin state: " + n2 + " Service state " + string);
            }
            this.repaint();
        }
    }

    private String getPortStateString() {
        String string = "Unknown";
        try {
            IInterfaceModel iInterfaceModel = ((PortModel)this.model).getInterfaceModel();
            if (iInterfaceModel instanceof ML2EtherLineModel) {
                ML2EtherLineModel mL2EtherLineModel = (ML2EtherLineModel)iInterfaceModel;
                boolean bl = mL2EtherLineModel.getLinkStatus();
                string = bl ? UP : DOWN;
            } else if (iInterfaceModel instanceof ML2PosLineModel) {
                ML2PosLineModel mL2PosLineModel = (ML2PosLineModel)iInterfaceModel;
                boolean bl = mL2PosLineModel.getML2PosPortInfo().linkUp;
                string = bl ? UP : DOWN;
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }
}

