/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml.helper;

import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.FramingType;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.IFramingType;
import cerent.cms.xml.ReflectionUtil;
import cerent.cms.xml.SchemaTagFactory;
import cerent.cms.xml.XmlNodeFactory;
import cerent.cms.xml.helper.BaseObjectHelper;
import cerent.cms.xml.helper.EnumHelper;
import cerent.cms.xml.helper.IImplementDecode;
import cerent.cms.xml.helper.IntegerHelper;
import cerent.util.HoLoFactory;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ILoNumHelper
extends BaseObjectHelper
implements IImplementDecode {
    public static final String TYPE = "ILoNum";
    public static final String ME = "ILoNumHelper";
    public static final String FT_TAG = "FramingType";
    public static final String CIRCUIT_SIZE_TAG = "CircuitSize";
    public static final String VC3_TAG = "Vc3OrSts1";
    public static final String TUG2_TAG = "Tug2OrVtGroupNum";
    public static final String NUM_IN_GROUP_TAG = "IdlNumInGroup";
    public static final String FRAMING_TYPE_CLASS = FramingType.class.getName();
    public static final String CIRCUIT_SIZE_CLASS = CircuitSize.class.getName();
    public static final String INTEGER_CLASS = Integer.class.getName();
    public static final String ENUM_METHOD = "getEnum";
    protected static SDebug db = new SDebug("ILoNum");

    public static Node objectToXml(Object object, String string, Node node) throws CTCUserException {
        if (db.on()) {
            db.println("[ILoNumHelper] objectToXml(" + object + ", " + string + ") ");
        }
        if (!(object instanceof ILoNum)) {
            throw new CTCUserException("o (" + object.getClass() + ") is not an instance of " + TYPE);
        }
        ILoNum iLoNum = (ILoNum)object;
        boolean bl = true;
        Node node2 = XmlNodeFactory.makeElement(node, string);
        short s = 0;
        short s2 = 0;
        short s3 = 0;
        if (iLoNum != null) {
            int n = iLoNum.getFramingType();
            IFramingType iFramingType = FramingType.getFramingType((int)n);
            int n2 = iLoNum.getCircuitSize();
            ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)n2);
            s = iLoNum.getVc3OrSts1();
            s2 = iLoNum.getTug2OrVtGroupNum();
            s3 = iLoNum.getIdlNumInGroup();
            Node node3 = EnumHelper.objectToXml(iFramingType, FT_TAG, ENUM_METHOD, node);
            node2.appendChild(node3);
            node3 = EnumHelper.objectToXml(iCircuitSize, CIRCUIT_SIZE_TAG, ENUM_METHOD, node);
            node2.appendChild(node3);
            node3 = IntegerHelper.objectToXml(new Integer(s), VC3_TAG, node);
            node2.appendChild(node3);
            node3 = IntegerHelper.objectToXml(new Integer(s2), TUG2_TAG, node);
            node2.appendChild(node3);
            node2 = IntegerHelper.objectToXml(new Integer(s3), NUM_IN_GROUP_TAG, node);
            node2.appendChild(node3);
        }
        return node2;
    }

    public static Object nodeToObject(Node node, String string, Object object) throws CTCUserException {
        if (db.on()) {
            db.print("[ILoNumHelper] nodeToObject(" + node.getNodeName() + ", " + string + ") ");
        }
        Class clazz = null;
        try {
            clazz = ReflectionUtil.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Element element = (Element)node;
        NodeList nodeList = element.getElementsByTagName(FT_TAG);
        int n = nodeList.getLength();
        if (n == 0) {
            return null;
        }
        Element element2 = (Element)nodeList.item(0);
        IFramingType iFramingType = (IFramingType)EnumHelper.nodeToObject(element2, FRAMING_TYPE_CLASS);
        nodeList = element.getElementsByTagName(CIRCUIT_SIZE_TAG);
        n = nodeList.getLength();
        if (n == 0) {
            throw new CTCUserException("required tag: CircuitSize is missing");
        }
        element2 = (Element)nodeList.item(0);
        ICircuitSize iCircuitSize = (ICircuitSize)EnumHelper.nodeToObject(element2, CIRCUIT_SIZE_CLASS);
        nodeList = element.getElementsByTagName(VC3_TAG);
        n = nodeList.getLength();
        if (n == 0) {
            throw new CTCUserException("required tag: Vc3OrSts1 is missing");
        }
        element2 = (Element)nodeList.item(0);
        Integer n2 = (Integer)IntegerHelper.nodeToObject(element2, INTEGER_CLASS);
        nodeList = element.getElementsByTagName(TUG2_TAG);
        n = nodeList.getLength();
        if (n == 0) {
            throw new CTCUserException("required tag: Tug2OrVtGroupNum is missing");
        }
        element2 = (Element)nodeList.item(0);
        Integer n3 = (Integer)IntegerHelper.nodeToObject(element2, INTEGER_CLASS);
        nodeList = element.getElementsByTagName(NUM_IN_GROUP_TAG);
        n = nodeList.getLength();
        if (n == 0) {
            throw new CTCUserException("required tag: IdlNumInGroup is missing");
        }
        element2 = (Element)nodeList.item(0);
        Integer n4 = (Integer)IntegerHelper.nodeToObject(element2, INTEGER_CLASS);
        ILoNum iLoNum = null;
        iLoNum = HoLoFactory.idlVtStruct2LoNum(iFramingType.getEnum(), iCircuitSize.getEnum(), n2, n3, n4);
        return iLoNum;
    }

    public static Object toSchema(String string, String string2) throws CTCUserException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SchemaTagFactory.createElementTag(string));
        stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.COMPLEX_TAG));
        stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.ALL_TAG));
        stringBuilder.append(EnumHelper.toSchema(FT_TAG, FRAMING_TYPE_CLASS));
        stringBuilder.append(EnumHelper.toSchema(CIRCUIT_SIZE_TAG, CIRCUIT_SIZE_CLASS));
        stringBuilder.append(IntegerHelper.toSchema(VC3_TAG, "integer"));
        stringBuilder.append(IntegerHelper.toSchema(TUG2_TAG, "integer"));
        stringBuilder.append(IntegerHelper.toSchema(NUM_IN_GROUP_TAG, "integer"));
        stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.ALL_TAG));
        stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.COMPLEX_TAG));
        stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.ELEMENT_TAG));
        return stringBuilder.toString();
    }
}

