/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.HoLoComparator;
import cerent.util.HoLoNum;
import cerent.util.IHoLoNum;
import cerent.util.IHoLoRange;
import cerent.util.IHoNum;
import cerent.util.ILoNum;

public class HoLoRange
implements IHoLoRange {
    static final HoLoComparator comp = HoLoComparator.instance();
    protected IHoLoNum first;
    protected IHoLoNum last;

    public HoLoRange(IHoLoNum iHoLoNum, IHoLoNum iHoLoNum2) {
        this.first = iHoLoNum;
        this.last = iHoLoNum2;
    }

    public HoLoRange(IHoNum iHoNum, IHoNum iHoNum2) {
        this.first = new HoLoNum(iHoNum, null);
        this.last = new HoLoNum(iHoNum2, null);
    }

    public HoLoRange(ILoNum iLoNum, ILoNum iLoNum2) {
        this.first = new HoLoNum(null, iLoNum);
        this.last = new HoLoNum(null, iLoNum2);
    }

    public boolean equals(Object object) {
        if (object instanceof IHoLoRange) {
            IHoLoRange iHoLoRange = (IHoLoRange)object;
            return this.first.equals(iHoLoRange.getFirst()) && this.last.equals(iHoLoRange.getLast());
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.first.hashCode();
        n = 37 * n + this.last.hashCode();
        return n;
    }

    public IHoLoNum getFirst() {
        return this.first;
    }

    public IHoLoNum getLast() {
        return this.last;
    }

    public boolean isEmpty() {
        return comp.compare(this.first, this.last) > 0;
    }

    public boolean doesIntersect(IHoLoRange iHoLoRange) {
        boolean bl = false;
        if (iHoLoRange != null) {
            bl = !this.isEmpty() && !iHoLoRange.isEmpty() && (HoLoRange.doesContain(this, iHoLoRange.getFirst()) || HoLoRange.doesContain(iHoLoRange, this.getFirst()));
        }
        return bl;
    }

    static boolean doesContain(IHoLoRange iHoLoRange, IHoLoNum iHoLoNum) {
        boolean bl = false;
        if (iHoLoNum != null) {
            IHoNum iHoNum = iHoLoNum.getHoNum();
            bl = iHoLoRange.doesContain(iHoNum);
        }
        return bl;
    }

    public boolean doesContain(IHoNum iHoNum) {
        return comp.compare(this.first, iHoNum) <= 0 && comp.compare(iHoNum, this.last) <= 0;
    }

    public String prettyString() {
        return "first=" + this.getFirst().prettyString("-") + ", last=" + this.getLast().prettyString("-");
    }
}

